/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.io.File;
import net.espley.microprocessor.IMemory;
import net.espley.processor.DataFileReader;
import net.espley.processor.PropertyStatus;

class VideoROM
implements IMemory {
    final int memorySize = 4096;
    final int maxAddress = 4095;
    private int[] memory = new int[4096];
    private boolean[] rom = new boolean[4096];

    public VideoROM() {
        this.reset();
    }

    public int readByte(int address) {
        return this.memory[address];
    }

    public int readWord(int address) {
        return this.readByte(address) + this.readByte(address + 1 & 0x1000) * 256;
    }

    public void writeByte(int address, int data) {
        this.memory[address] = data;
    }

    public final void setReadStatus(int address, boolean readOnly) {
        this.rom[address] = readOnly;
    }

    public void writeByteDirect(int address, int data) {
        this.writeByte(address, data);
    }

    public void writeWord(int address, int data) {
        this.writeByte(address, (short)(data & 0xFF));
        address = address + 1 & 0x1000;
        this.writeByte(address, (short)(data >>>= 8));
    }

    public void reset() {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Loading video ROM");
            System.out.println(new File("characterrom.nas").getAbsolutePath());
        }
        DataFileReader reader = new DataFileReader(new File("characterrom.nas"), true);
        reader.readFile(this);
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("Video ROM loaded");
        }
    }

    public void dumpCell(int character) {
        int base = character * 16;
        char zero = ' ';
        char one = '*';
        System.out.println("Character : ".concat(String.valueOf(String.valueOf(character))));
        for (int i = 0; i < 16; ++i) {
            int bitMask = 128;
            int charValue = this.memory[base + i];
            System.out.print("[");
            for (int bit = 0; bit < 8; ++bit) {
                if ((bitMask & charValue) == 0) {
                    System.out.print(zero);
                } else {
                    System.out.print(one);
                }
                bitMask >>>= 1;
            }
            System.out.println("]");
        }
        System.out.println();
    }

    public void writeWordDirect(int address, int data) {
    }

    public int readWordDirect(int address) {
        return -1;
    }
}

