/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.awt.Color;
import net.espley.processor.devices.AVCDrawing;

public class PaintAVCControl
implements Runnable {
    private static Color[][] colourImageSmall;
    private static Color[][] colourImageLarge;
    private static AVCDrawing drawing;
    private static boolean highResMode;
    private boolean modeChange = false;
    private boolean selectHighRes = false;

    public PaintAVCControl(AVCDrawing drawing) {
        PaintAVCControl.drawing = drawing;
    }

    public void run() {
        drawing.setImageSmall(colourImageSmall);
        drawing.setImageLarge(colourImageLarge);
        if (this.modeChange && this.selectHighRes != highResMode) {
            this.modeChange = false;
            highResMode = this.selectHighRes;
            if (highResMode) {
                drawing.setHighResMode();
            } else {
                drawing.setLowResMode();
            }
        } else {
            drawing.repaint();
        }
    }

    public void resetMode(boolean highResMode) {
        this.modeChange = true;
        this.selectHighRes = highResMode;
    }

    public void setColourImageSmall(Color[][] localColourImage) {
        colourImageSmall = localColourImage;
    }

    public void setColourImageLarge(Color[][] localColourImage) {
        colourImageLarge = localColourImage;
    }

    static {
        highResMode = false;
    }
}

