/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import java.awt.Color;
import java.awt.Image;
import net.espley.processor.devices.AVCDrawing;

public class PaintAVCWord
implements Runnable {
    private Image image;
    private Image smallImage;
    private Image byteImage;
    private Color[][] colourImageSmall;
    private Color[][] colourImageLarge;
    private AVCDrawing drawing;
    private boolean byteDrawMode;
    private boolean highResMode = false;
    private boolean modeChange = false;
    private boolean selectHighRes = false;
    private int x;
    private int y;

    public PaintAVCWord(AVCDrawing drawing) {
        this.drawing = drawing;
        this.byteDrawMode = false;
    }

    public void run() {
        this.drawing.setImageSmall(this.colourImageSmall);
        this.drawing.setImageLarge(this.colourImageLarge);
        if (this.modeChange) {
            this.modeChange = false;
            this.highResMode = this.selectHighRes;
            if (this.highResMode) {
                this.drawing.setHighResMode();
            } else {
                this.drawing.setLowResMode();
            }
        } else if (this.byteDrawMode) {
            this.drawing.repaint(this.x, this.y, 16, 1);
            this.byteDrawMode = false;
        } else {
            this.drawing.repaint();
        }
    }

    public void setXY(int x, int y) {
        if (this.byteDrawMode) {
            System.out.println("-- DRAWING DATA LOST --");
        }
        this.x = x;
        this.y = y;
        this.byteDrawMode = true;
    }

    public void resetMode(boolean highResMode) {
        this.modeChange = true;
        this.selectHighRes = highResMode;
    }

    public void setColourImageSmall(Color[][] localColourImage) {
        this.colourImageSmall = localColourImage;
    }

    public void setColourImageLarge(Color[][] localColourImage) {
        this.colourImageLarge = localColourImage;
    }
}

