/*
 * Decompiled with CFR 0.152.
 */
package net.espley.microprocessor;

import net.espley.microprocessor.ComputerException;
import net.espley.microprocessor.IBaseDevice;
import net.espley.microprocessor.IMemory;

class Z80RegisterFile {
    int reg_BC;
    int reg_DE;
    int reg_HL;
    int reg_BC_ALT;
    int reg_DE_ALT;
    int reg_HL_ALT;
    int reg_IX;
    int reg_IY;
    int reg_PC;
    int reg_SP;
    int reg_Instruction;
    int reg_A;
    int reg_A_ALT;
    int reg_F;
    int reg_F_ALT;
    int reg_I;
    int reg_R;
    int reg_index;
    int interruptMode;
    boolean EIDIFlag;
    boolean IFF1;
    boolean IFF2;
    boolean NMI_FF;
    boolean INT_FF;
    private boolean blockMove;
    final int regCodeB = 0;
    final int regCodeC = 1;
    final int regCodeD = 2;
    final int regCodeE = 3;
    final int regCodeH = 4;
    final int regCodeL = 5;
    final int regCodeM = 6;
    final int regCodeA = 7;
    final int regCodeBC = 0;
    final int regCodeDE = 1;
    final int regCodeHL = 2;
    final int regCodeIX = 2;
    final int regCodeIY = 2;
    final int regCodeSP = 3;
    final int regCodeAF = 3;
    private final int setBit0 = 1;
    private final int setBit1 = 2;
    private final int setBit2 = 4;
    private final int setBit3 = 8;
    private final int setBit4 = 16;
    private final int setBit5 = 32;
    private final int setBit6 = 64;
    private final int setBit7 = 128;
    private final int resetBit0 = 254;
    private final int resetBit1 = 253;
    private final int resetBit2 = 251;
    private final int resetBit3 = 247;
    private final int resetBit4 = 239;
    private final int resetBit5 = 223;
    private final int resetBit6 = 191;
    private final int resetBit7 = 127;
    private final int flag_S = 128;
    private final int flag_Z = 64;
    private final int flag_5 = 32;
    private final int flag_H = 16;
    private final int flag_3 = 8;
    private final int flag_PV = 4;
    private final int flag_N = 2;
    private final int flag_C = 1;
    private final int flag_S_N = 127;
    private final int flag_Z_N = 191;
    private final int flag_5_N = 223;
    private final int flag_H_N = 239;
    private final int flag_3_N = 247;
    private final int flag_PV_N = 251;
    private final int flag_N_N = 253;
    private final int flag_C_N = 254;
    private final int lsb = 255;
    private final int msb = 65280;
    private final int lsw = 65535;
    private final int msw = -65536;
    private final int byteSize = 8;
    private IMemory ram;
    private IBaseDevice io;
    int maxAddress;
    private boolean[] parity = new boolean[256];

    Z80RegisterFile(IMemory ram, IBaseDevice io) {
        this.ram = ram;
        this.io = io;
        this.reset();
        this.maxAddress = 65535;
        this.blockMove = false;
        this.parity[0] = true;
        int position = 1;
        for (int bit = 0; bit < 8; ++bit) {
            for (int fill = 0; fill < position; ++fill) {
                this.parity[position + fill] = !this.parity[fill];
            }
            position *= 2;
        }
    }

    void reset() {
        this.reg_HL = 0;
        this.reg_DE = 0;
        this.reg_BC = 0;
        this.reg_HL_ALT = 0;
        this.reg_DE_ALT = 0;
        this.reg_BC_ALT = 0;
        this.reg_SP = 0;
        this.reg_PC = 0;
        this.reg_IY = 0;
        this.reg_IX = 0;
        this.reg_R = 0;
        this.reg_I = 0;
        this.reg_F_ALT = 0;
        this.reg_F = 0;
        this.reg_A_ALT = 0;
        this.reg_A = 0;
        this.IFF2 = false;
        this.IFF1 = false;
        this.interruptMode = 0;
        this.EIDIFlag = false;
        this.NMI_FF = false;
        this.INT_FF = false;
    }

    boolean blockMoveInProgress() {
        return this.blockMove;
    }

    void setNMI() {
        this.NMI_FF = true;
    }

    void updateRefreshRegister() {
        ++this.reg_R;
    }

    int get8BitRegister(int reg) {
        switch (reg) {
            case 0: {
                return (this.reg_BC & 0xFF00) >> 8;
            }
            case 1: {
                return this.reg_BC & 0xFF;
            }
            case 2: {
                return (this.reg_DE & 0xFF00) >> 8;
            }
            case 3: {
                return this.reg_DE & 0xFF;
            }
            case 4: {
                return (this.reg_HL & 0xFF00) >> 8;
            }
            case 5: {
                return this.reg_HL & 0xFF;
            }
            case 7: {
                return this.reg_A;
            }
            case 6: {
                this.updateRefreshRegister();
                return this.ram.readByte(this.reg_HL);
            }
        }
        return 0;
    }

    int get8BitRegisterIXIY(int reg) {
        switch (reg) {
            case 0: {
                return (this.reg_BC & 0xFF00) >> 8;
            }
            case 1: {
                return this.reg_BC & 0xFF;
            }
            case 2: {
                return (this.reg_DE & 0xFF00) >> 8;
            }
            case 3: {
                return this.reg_DE & 0xFF;
            }
            case 4: {
                return (this.reg_index & 0xFF00) >> 8;
            }
            case 5: {
                return this.reg_index & 0xFF;
            }
            case 7: {
                return this.reg_A;
            }
            case 6: {
                this.updateRefreshRegister();
                return this.ram.readByte(this.reg_index);
            }
        }
        return 0;
    }

    void set8BitRegister(int value, int reg) {
        switch (reg) {
            case 0: {
                this.reg_BC = this.reg_BC & 0xFF | value << 8;
                break;
            }
            case 1: {
                this.reg_BC = this.reg_BC & 0xFF00 | value;
                break;
            }
            case 2: {
                this.reg_DE = this.reg_DE & 0xFF | value << 8;
                break;
            }
            case 3: {
                this.reg_DE = this.reg_DE & 0xFF00 | value;
                break;
            }
            case 4: {
                this.reg_HL = this.reg_HL & 0xFF | value << 8;
                break;
            }
            case 5: {
                this.reg_HL = this.reg_HL & 0xFF00 | value;
                break;
            }
            case 7: {
                this.reg_A = value;
                break;
            }
            case 6: {
                this.ram.writeByte(this.reg_HL, value);
            }
        }
    }

    void set8BitRegisterIXIY(int value, int reg) {
        switch (reg) {
            case 0: {
                this.reg_BC = this.reg_BC & 0xFF | value << 8;
                break;
            }
            case 1: {
                this.reg_BC = this.reg_BC & 0xFF00 | value;
                break;
            }
            case 2: {
                this.reg_DE = this.reg_DE & 0xFF | value << 8;
                break;
            }
            case 3: {
                this.reg_DE = this.reg_DE & 0xFF00 | value;
                break;
            }
            case 4: {
                this.reg_index = this.reg_index & 0xFF | value << 8;
                break;
            }
            case 5: {
                this.reg_index = this.reg_index & 0xFF00 | value;
                break;
            }
            case 7: {
                this.reg_A = value;
                break;
            }
            case 6: {
                this.ram.writeByte(this.reg_index, value);
            }
        }
    }

    int get16BitRegister(int reg) {
        switch (reg) {
            case 0: {
                return this.reg_BC;
            }
            case 1: {
                return this.reg_DE;
            }
            case 2: {
                return this.reg_HL;
            }
            case 3: {
                return this.reg_SP;
            }
        }
        System.out.println("get 16 bit register");
        return 0;
    }

    int get16BitRegisterIndexed(int reg) {
        switch (reg) {
            case 0: {
                return this.reg_BC;
            }
            case 1: {
                return this.reg_DE;
            }
            case 2: {
                return this.reg_index;
            }
            case 3: {
                return this.reg_SP;
            }
        }
        return 0;
    }

    void set16BitRegister(int value, int reg) {
        switch (reg) {
            case 0: {
                this.reg_BC = value;
                break;
            }
            case 1: {
                this.reg_DE = value;
                break;
            }
            case 2: {
                this.reg_HL = value;
                break;
            }
            case 3: {
                this.reg_SP = value;
            }
        }
    }

    void set16BitRegisterIndexed(int value, int reg) {
        switch (reg) {
            case 0: {
                this.reg_BC = value;
                break;
            }
            case 1: {
                this.reg_DE = value;
                break;
            }
            case 2: {
                this.reg_index = value;
                break;
            }
            case 3: {
                this.reg_SP = value;
            }
        }
    }

    final void incPC() {
        ++this.reg_PC;
        this.reg_PC &= this.maxAddress;
    }

    final void decPC() {
        --this.reg_PC;
        this.reg_PC &= this.maxAddress;
    }

    final void inc2PC() {
        this.reg_PC += 2;
        this.reg_PC &= this.maxAddress;
    }

    final void dec2PC() {
        this.reg_PC -= 2;
        this.reg_PC &= this.maxAddress;
    }

    final void incSP() {
        ++this.reg_SP;
        this.reg_SP &= this.maxAddress;
    }

    final void decSP() {
        --this.reg_SP;
        this.reg_SP &= this.maxAddress;
    }

    final void inc2SP() {
        this.reg_SP += 2;
        this.reg_SP &= this.maxAddress;
    }

    final void dec2SP() {
        this.reg_SP -= 2;
        this.reg_SP &= this.maxAddress;
    }

    private final void setHalfCarryFlagAdd(int left, int right, int carry) {
        this.setH((right &= 0xF) + (left &= 0xF) + carry > 15);
    }

    private final void setHalfCarryFlagAdd16(int left, int right, int carry) {
        this.setH((right &= 0xFFF) + (left &= 0xFFF) + carry > 4095);
    }

    private final void setHalfCarryFlagAdd(int left, int right) {
        this.setH((right &= 0xF) + (left &= 0xF) > 15);
    }

    private final void setHalfCarryFlagSub(int left, int right) {
        this.setH((left &= 0xF) < (right &= 0xF));
    }

    private final void setHalfCarryFlagSub(int left, int right, int carry) {
        this.setH((left &= 0xF) < (right &= 0xF) + carry);
    }

    private final void setHalfCarryFlagSub16(int left, int right, int carry) {
        this.setH((left &= 0xFFF) < (right &= 0xFFF) + carry);
    }

    void setOverflowFlagAdd(int left, int right, int carry) {
        if (left > 127) {
            left -= 256;
        }
        if (right > 127) {
            right -= 256;
        }
        this.setPV((left = left + right + carry) < -128 || left > 127);
    }

    void setOverflowFlagAdd(int left, int right) {
        if (left > 127) {
            left -= 256;
        }
        if (right > 127) {
            right -= 256;
        }
        this.setPV((left += right) < -128 || left > 127);
    }

    void setOverflowFlagAdd16(int left, int right, int carry) {
        if (left > Short.MAX_VALUE) {
            left -= 65536;
        }
        if (right > Short.MAX_VALUE) {
            right -= 65536;
        }
        this.setPV((left = left + right + carry) < Short.MIN_VALUE || left > Short.MAX_VALUE);
    }

    void setOverflowFlagSub(int left, int right, int carry) {
        if (left > 127) {
            left -= 256;
        }
        if (right > 127) {
            right -= 256;
        }
        this.setPV((left = left - right - carry) < -128 || left > 127);
    }

    void setOverflowFlagSub(int left, int right) {
        if (left > 127) {
            left -= 256;
        }
        if (right > 127) {
            right -= 256;
        }
        this.setPV((left -= right) < -128 || left > 127);
    }

    void setOverflowFlagSub16(int left, int right, int carry) {
        if (left > Short.MAX_VALUE) {
            left -= 65536;
        }
        if (right > Short.MAX_VALUE) {
            right -= 65536;
        }
        this.setPV((left = left - right - carry) < Short.MIN_VALUE || left > Short.MAX_VALUE);
    }

    void ALU8BitAdd(int value) {
        int local_reg_A = this.reg_A;
        this.setHalfCarryFlagAdd(local_reg_A, value);
        this.setOverflowFlagAdd(local_reg_A, value);
        this.setS(((local_reg_A += value) & 0x80) != 0);
        this.setC((local_reg_A & 0xFF00) != 0);
        this.setZ((local_reg_A &= 0xFF) == 0);
        this.resetN();
        this.reg_A = local_reg_A;
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitAdc(int value) {
        int local_reg_A = this.reg_A;
        int carry = this.getC() ? 1 : 0;
        this.setHalfCarryFlagAdd(local_reg_A, value, carry);
        this.setOverflowFlagAdd(local_reg_A, value, carry);
        local_reg_A = local_reg_A + value + carry;
        this.setS((local_reg_A & 0x80) != 0);
        this.setC((local_reg_A & 0xFF00) != 0);
        this.setZ((local_reg_A &= 0xFF) == 0);
        this.resetN();
        this.reg_A = local_reg_A;
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitSub(int value) {
        int local_reg_A = this.reg_A;
        this.setHalfCarryFlagSub(local_reg_A, value);
        this.setOverflowFlagSub(local_reg_A, value);
        this.setS(((local_reg_A -= value) & 0x80) != 0);
        this.setC((local_reg_A & 0xFF00) != 0);
        this.setZ((local_reg_A &= 0xFF) == 0);
        this.setN();
        this.reg_A = local_reg_A;
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitSbc(int value) {
        int local_reg_A = this.reg_A;
        int carry = this.getC() ? 1 : 0;
        this.setHalfCarryFlagSub(local_reg_A, value, carry);
        this.setOverflowFlagSub(local_reg_A, value, carry);
        local_reg_A = local_reg_A - value - carry;
        this.setS((local_reg_A & 0x80) != 0);
        this.setC((local_reg_A & 0xFF00) != 0);
        this.setZ((local_reg_A &= 0xFF) == 0);
        this.setN();
        this.reg_A = local_reg_A;
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitAnd(int value) {
        this.reg_F = 16;
        this.reg_A &= value;
        this.setS((this.reg_A & 0x80) != 0);
        this.setZ(this.reg_A == 0);
        this.setPV(this.parity[this.reg_A]);
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitOr(int value) {
        this.reg_F = 0;
        this.reg_A |= value;
        this.setS((this.reg_A & 0x80) != 0);
        this.setZ(this.reg_A == 0);
        this.setPV(this.parity[this.reg_A]);
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitXor(int value) {
        this.reg_F = 0;
        this.reg_A ^= value;
        this.setS((this.reg_A & 0x80) != 0);
        this.setZ(this.reg_A == 0);
        this.setPV(this.parity[this.reg_A]);
        this.setUnusedFlags(this.reg_A);
    }

    void ALU8BitCp(int b) {
        int a = this.reg_A;
        int wans = a - b;
        int ans = wans & 0xFF;
        this.reg_F = 2;
        this.setS((ans & 0x80) != 0);
        this.set3((b & 8) != 0);
        this.set5((b & 0x20) != 0);
        this.setZ(ans == 0);
        this.setC((wans & 0x100) != 0);
        this.setH(((a & 0xF) - (b & 0xF) & 0x10) != 0);
        this.setPV(((a ^ b) & (a ^ ans) & 0x80) != 0);
    }

    int ALU8BitInc(int value) {
        this.reg_F = this.getC() ? 1 : 0;
        this.setHalfCarryFlagAdd(value, 1);
        this.setPV(value == 127);
        this.setS((++value & 0x80) != 0);
        this.setZ((value &= 0xFF) == 0);
        this.setUnusedFlags(value);
        return value;
    }

    int ALU8BitDec(int value) {
        this.reg_F = this.getC() ? 1 : 0;
        this.setHalfCarryFlagSub(value, 1);
        this.setPV(value == 128);
        this.setS((--value & 0x80) != 0);
        this.setZ((value &= 0xFF) == 0);
        this.setN();
        this.setUnusedFlags(value);
        return value;
    }

    int ALU16BitInc(int value) {
        return ++value & 0xFFFF;
    }

    int ALU16BitDec(int value) {
        return --value & 0xFFFF;
    }

    int ALU16BitAdd(int value) {
        int operand = value;
        value = this.reg_HL + value;
        this.resetN();
        if ((value & 0xFFFF0000) != 0) {
            this.setC();
        } else {
            this.resetC();
        }
        int temp = (this.reg_HL & 0xFFF) + (operand & 0xFFF);
        if ((temp & 0xF000) != 0) {
            this.setH();
        } else {
            this.resetH();
        }
        temp = value >> 8;
        if ((temp & 8) != 0) {
            this.set3();
        } else {
            this.reset3();
        }
        if ((temp & 0x20) != 0) {
            this.set5();
        } else {
            this.reset5();
        }
        return value & 0xFFFF;
    }

    int ALU16BitAddIndexed(int value) {
        int operand = value;
        value = this.reg_index + value;
        this.resetN();
        if ((value & 0xFFFF0000) != 0) {
            this.setC();
        } else {
            this.resetC();
        }
        int temp = (this.reg_index & 0xFFF) + (operand & 0xFFF);
        if ((temp & 0xF000) != 0) {
            this.setH();
        } else {
            this.resetH();
        }
        temp = value >> 8;
        if ((temp & 8) != 0) {
            this.set3();
        } else {
            this.reset3();
        }
        if ((temp & 0x20) != 0) {
            this.set5();
        } else {
            this.reset5();
        }
        return value & 0xFFFF;
    }

    void ALU16BitADC(int regCode) {
        int a = this.reg_HL;
        int b = this.get16BitRegister((byte)regCode);
        int c = this.getC() ? 1 : 0;
        int lans = a + b + c;
        int ans = lans & 0xFFFF;
        this.setS((ans & 0x8000) != 0);
        this.set3((ans & 0x800) != 0);
        this.set5((ans & 0x2000) != 0);
        this.setZ(ans == 0);
        this.setC(lans > 65535);
        this.setOverflowFlagAdd16(a, b, c);
        if (((a & 0xFFF) + (b & 0xFFF) + c & 0x1000) != 0) {
            this.setH();
        } else {
            this.resetH();
        }
        this.resetN();
        this.reg_HL = ans;
    }

    void ALU16BitSBC(int regCode) {
        int a = this.reg_HL;
        int b = this.get16BitRegister((byte)regCode);
        int c = this.getC() ? 1 : 0;
        int lans = a - b - c;
        int ans = lans & 0xFFFF;
        this.setS((ans & 0x8000) != 0);
        this.set3((ans & 0x800) != 0);
        this.set5((ans & 0x2000) != 0);
        this.setZ(ans == 0);
        this.setC(lans < 0);
        this.setOverflowFlagSub16(a, b, c);
        if (((a & 0xFFF) - (b & 0xFFF) - c & 0x1000) != 0) {
            this.setH();
        } else {
            this.resetH();
        }
        this.setN();
        this.reg_HL = ans;
    }

    void EXAFAF() {
        int temp = this.reg_A;
        this.reg_A = this.reg_A_ALT;
        this.reg_A_ALT = temp;
        temp = this.reg_F;
        this.reg_F = this.reg_F_ALT;
        this.reg_F_ALT = temp;
    }

    void EXDEHL() {
        int temp = this.reg_HL;
        this.reg_HL = this.reg_DE;
        this.reg_DE = temp;
    }

    void EXSPHL() {
        int temp = this.reg_HL;
        this.reg_HL = this.pop();
        this.push(temp);
    }

    void EXX() {
        int temp = this.reg_BC;
        this.reg_BC = this.reg_BC_ALT;
        this.reg_BC_ALT = temp;
        temp = this.reg_DE;
        this.reg_DE = this.reg_DE_ALT;
        this.reg_DE_ALT = temp;
        temp = this.reg_HL;
        this.reg_HL = this.reg_HL_ALT;
        this.reg_HL_ALT = temp;
    }

    final boolean getS() {
        return (this.reg_F & 0x80) != 0;
    }

    final boolean getZ() {
        return (this.reg_F & 0x40) != 0;
    }

    final boolean getH() {
        return (this.reg_F & 0x10) != 0;
    }

    final boolean getPV() {
        return (this.reg_F & 4) != 0;
    }

    final boolean getN() {
        return (this.reg_F & 2) != 0;
    }

    final boolean getC() {
        return (this.reg_F & 1) != 0;
    }

    final void setS() {
        this.reg_F |= 0x80;
    }

    final void setZ() {
        this.reg_F |= 0x40;
    }

    final void set5() {
        this.reg_F |= 0x20;
    }

    final void setH() {
        this.reg_F |= 0x10;
    }

    final void set3() {
        this.reg_F |= 8;
    }

    final void setPV() {
        this.reg_F |= 4;
    }

    final void setN() {
        this.reg_F |= 2;
    }

    final void setC() {
        this.reg_F |= 1;
    }

    final void setS(boolean b) {
        if (b) {
            this.setS();
        } else {
            this.resetS();
        }
    }

    final void setZ(boolean b) {
        if (b) {
            this.setZ();
        } else {
            this.resetZ();
        }
    }

    final void set5(boolean b) {
        if (b) {
            this.set5();
        } else {
            this.reset5();
        }
    }

    final void setH(boolean b) {
        if (b) {
            this.setH();
        } else {
            this.resetH();
        }
    }

    final void set3(boolean b) {
        if (b) {
            this.set3();
        } else {
            this.reset3();
        }
    }

    final void setPV(boolean b) {
        if (b) {
            this.setPV();
        } else {
            this.resetPV();
        }
    }

    final void setN(boolean b) {
        if (b) {
            this.setN();
        } else {
            this.resetN();
        }
    }

    final void setC(boolean b) {
        if (b) {
            this.setC();
        } else {
            this.resetC();
        }
    }

    private final void setUnusedFlags(int value) {
        this.reg_F &= 0xD7;
        this.reg_F |= (value &= 0x28);
    }

    private final void flipS() {
        this.reg_F ^= 0x80;
    }

    private final void flipZ() {
        this.reg_F ^= 0x40;
    }

    private final void flip5() {
        this.reg_F ^= 0x20;
    }

    private final void flipH() {
        this.reg_F ^= 0x10;
    }

    private final void flip3() {
        this.reg_F ^= 8;
    }

    private final void flipPV() {
        this.reg_F ^= 4;
    }

    private final void flipN() {
        this.reg_F ^= 2;
    }

    private final void flipC() {
        this.reg_F ^= 1;
    }

    private final void resetS() {
        this.reg_F &= 0x7F;
    }

    private final void resetZ() {
        this.reg_F &= 0xBF;
    }

    private final void reset5() {
        this.reg_F &= 0xDF;
    }

    private final void resetH() {
        this.reg_F &= 0xEF;
    }

    private final void reset3() {
        this.reg_F &= 0xF7;
    }

    private final void resetPV() {
        this.reg_F &= 0xFB;
    }

    private final void resetN() {
        this.reg_F &= 0xFD;
    }

    private final void resetC() {
        this.reg_F &= 0xFE;
    }

    boolean getParity16(int value) {
        return !(this.parity[value & 0xFF] ^ this.parity[(value & 0xFF00) >> 8]);
    }

    void RLCA() {
        boolean carry = (this.reg_A & 0x80) != 0;
        this.reg_A = this.reg_A << 1 & 0xFF;
        if (carry) {
            this.setC();
            this.reg_A |= 1;
        } else {
            this.resetC();
        }
        this.resetH();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void RLA() {
        boolean carry = (this.reg_A & 0x80) != 0;
        this.reg_A = this.reg_A << 1 & 0xFF;
        if (this.getC()) {
            this.reg_A |= 1;
        }
        if (carry) {
            this.setC();
        } else {
            this.resetC();
        }
        this.resetH();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void RRCA() {
        boolean carry = (this.reg_A & 1) != 0;
        this.reg_A >>= 1;
        if (carry) {
            this.setC();
            this.reg_A |= 0x80;
        } else {
            this.resetC();
        }
        this.resetH();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void RRA() {
        boolean carry = (this.reg_A & 1) != 0;
        this.reg_A >>= 1;
        if (this.getC()) {
            this.reg_A |= 0x80;
        }
        if (carry) {
            this.setC();
        } else {
            this.resetC();
        }
        this.resetH();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void CPL() {
        this.reg_A = (this.reg_A ^ 0xFF) & 0xFF;
        this.setH();
        this.setN();
        this.setUnusedFlags(this.reg_A);
    }

    void NEG() {
        this.setHalfCarryFlagSub(0, this.reg_A, 0);
        this.setOverflowFlagSub(0, this.reg_A, 0);
        this.reg_A = 0 - this.reg_A;
        if ((this.reg_A & 0xFF00) != 0) {
            this.setC();
        } else {
            this.resetC();
        }
        this.setN();
        this.reg_A &= 0xFF;
        if (this.reg_A == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        if ((this.reg_A & 0x80) != 0) {
            this.setS();
        } else {
            this.resetS();
        }
        this.setUnusedFlags(this.reg_A);
    }

    void SCF() {
        this.setC();
        this.resetH();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void CCF() {
        if (this.getC()) {
            this.setH();
        } else {
            this.resetH();
        }
        this.flipC();
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void DAA() throws ComputerException {
        int ans = this.reg_A;
        int incr = 0;
        boolean carry = this.getC();
        if (this.getH() || (ans & 0xF) > 9) {
            incr |= 6;
        }
        if (carry || ans > 159 || ans > 143 && (ans & 0xF) > 9) {
            incr |= 0x60;
        }
        if (ans > 153) {
            carry = true;
        }
        if (this.getN()) {
            this.ALU8BitSub(incr);
        } else {
            this.ALU8BitAdd(incr);
        }
        ans = this.reg_A;
        if (carry) {
            this.setC();
        } else {
            this.resetC();
        }
        this.setPV(this.parity[ans]);
    }

    void shiftRLC(int register) {
        this.set8BitRegister(this.shiftGenericRLC(this.get8BitRegister(register)), register);
    }

    int shiftGenericRLC(int temp) {
        if (((temp <<= 1) & 0xFF00) != 0) {
            this.setC();
            temp |= 1;
        } else {
            this.resetC();
        }
        if ((temp & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        if ((temp & 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        this.resetN();
        this.setPV(this.parity[temp &= 0xFF]);
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftRLCIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericRLC(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftRL(int register) {
        this.set8BitRegister(this.shiftGenericRL(this.get8BitRegister(register)), register);
    }

    int shiftGenericRL(int temp) {
        temp <<= 1;
        if (this.getC()) {
            temp |= 1;
        }
        this.setS((temp & 0x80) != 0);
        this.resetH();
        if ((temp & 0xFF00) == 0) {
            this.resetC();
        } else {
            this.setC();
        }
        if (((temp &= 0xFF) & 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.setPV(this.parity[temp]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftRLIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericRL(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftRRC(int register) {
        this.set8BitRegister(this.shiftGenericRRC(this.get8BitRegister(register)), register);
    }

    int shiftGenericRRC(int temp) {
        this.setC((temp & 1) != 0);
        temp >>= 1;
        if (this.getC()) {
            temp |= 0x80;
        }
        this.setS((temp & 0x80) != 0);
        if (temp == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        this.setPV(this.parity[temp]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftRRCIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericRRC(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftRR(int register) {
        this.set8BitRegister(this.shiftGenericRR(this.get8BitRegister(register)), register);
    }

    int shiftGenericRR(int temp) {
        boolean tempC = this.getC();
        this.setC((temp & 1) != 0);
        temp >>= 1;
        if (tempC) {
            temp |= 0x80;
        }
        this.setS((temp & 0x80) != 0);
        if (temp == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        this.setPV(this.parity[temp]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftRRIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericRR(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftSLA(int register) {
        this.set8BitRegister(this.shiftGenericSLA(this.get8BitRegister(register)), register);
    }

    int shiftGenericSLA(int temp) {
        this.setS(((temp <<= 1) & 0x80) != 0);
        if ((temp & 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        if ((temp & 0xFF00) != 0) {
            this.setC();
        } else {
            this.resetC();
        }
        this.setPV(this.parity[temp &= 0xFF]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftSLAIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericSLA(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftSLL(int register) {
        this.set8BitRegister(this.shiftGenericSLL(this.get8BitRegister(register)), register);
    }

    int shiftGenericSLL(int temp) {
        this.setS(((temp = temp << 1 | 1) & 0x80) != 0);
        if ((temp & 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        if ((temp & 0xFF00) != 0) {
            this.setC();
        } else {
            this.resetC();
        }
        this.setPV(this.parity[temp &= 0xFF]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftSLLIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericSLL(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftSRA(int register) {
        this.set8BitRegister(this.shiftGenericSRA(this.get8BitRegister(register)), register);
    }

    int shiftGenericSRA(int temp) {
        this.setC((temp & 1) != 0);
        if ((temp & 0x80) == 0) {
            temp >>= 1;
            this.resetS();
        } else {
            temp = temp >> 1 | 0x80;
            this.setS();
        }
        if (temp == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        this.setPV(this.parity[temp]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftSRAIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericSRA(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void shiftSRL(int register) {
        this.set8BitRegister(this.shiftGenericSRL(this.get8BitRegister(register)), register);
    }

    int shiftGenericSRL(int temp) {
        this.setC((temp & 1) != 0);
        this.setS(((temp >>= 1) & 0x80) != 0);
        this.setZ(temp == 0);
        this.resetH();
        this.setPV(this.parity[temp]);
        this.resetN();
        this.setUnusedFlags(temp);
        return temp;
    }

    void shiftSRLIndexed() {
        int address = this.getIndexAddress();
        this.ram.writeByte(address, this.shiftGenericSRL(this.ram.readByte(address)));
        this.updateRefreshRegister();
    }

    void RRD() {
        this.updateRefreshRegister();
        int temp = this.ram.readByte(this.reg_HL);
        int nibble1 = (this.reg_A & 0xF0) >> 4;
        int nibble2 = this.reg_A & 0xF;
        int nibble3 = (temp & 0xF0) >> 4;
        int nibble4 = temp & 0xF;
        this.reg_A = nibble1 << 4 | nibble4;
        temp = nibble2 << 4 | nibble3;
        this.ram.writeByte(this.reg_HL, temp);
        if ((this.reg_A & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        this.setZ(this.reg_A == 0);
        this.resetH();
        this.setPV(this.parity[this.reg_A]);
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void RLD() {
        this.updateRefreshRegister();
        int temp = this.ram.readByte(this.reg_HL);
        int nibble1 = (this.reg_A & 0xF0) >> 4;
        int nibble2 = this.reg_A & 0xF;
        int nibble3 = (temp & 0xF0) >> 4;
        int nibble4 = temp & 0xF;
        this.reg_A = nibble1 << 4 | nibble3;
        temp = nibble4 << 4 | nibble2;
        this.ram.writeByte(this.reg_HL, temp);
        if ((this.reg_A & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        if (this.reg_A == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.resetH();
        this.setPV(this.parity[this.reg_A]);
        this.resetN();
        this.setUnusedFlags(this.reg_A);
    }

    void relativeJump() {
        this.updateRefreshRegister();
        int offset = this.ram.readByte(this.reg_PC);
        if (offset > 127) {
            offset -= 256;
        }
        ++this.reg_PC;
        this.reg_PC = this.reg_PC + offset & this.maxAddress;
    }

    void absoluteJump() {
        this.reg_PC = this.ram.readWordDirect(this.reg_PC);
    }

    void djnz() {
        int local_B = this.reg_BC & 0xFF00;
        this.reg_BC = this.reg_BC & 0xFF | (local_B -= 256) & 0xFF00;
        if (local_B != 0) {
            this.relativeJump();
        } else {
            this.incPC();
        }
    }

    void JPHL() {
        this.reg_PC = this.reg_HL;
    }

    void push(int value) {
        this.dec2SP();
        this.ram.writeWordDirect(this.reg_SP, value);
    }

    int pop() {
        int value = this.ram.readWordDirect(this.reg_SP);
        this.inc2SP();
        return value;
    }

    void push(byte regCode) {
        switch (regCode) {
            case 0: {
                this.push(this.reg_BC);
                break;
            }
            case 1: {
                this.push(this.reg_DE);
                break;
            }
            case 2: {
                this.push(this.reg_HL);
                break;
            }
            case 3: {
                this.push(this.reg_A << 8 | this.reg_F);
            }
        }
    }

    void pop(byte regCode) {
        int temp = this.pop();
        switch (regCode) {
            case 0: {
                this.reg_BC = temp;
                break;
            }
            case 1: {
                this.reg_DE = temp;
                break;
            }
            case 2: {
                this.reg_HL = temp;
                break;
            }
            case 3: {
                this.reg_F = temp & 0xFF;
                this.reg_A = (temp & 0xFF00) >> 8;
                break;
            }
            default: {
                System.out.println("pop");
            }
        }
    }

    void jp(boolean cc) {
        if (cc) {
            this.jp();
        } else {
            this.inc2PC();
        }
    }

    void jp() {
        this.reg_PC = this.ram.readWordDirect(this.reg_PC);
    }

    void ret(boolean cc) {
        if (cc) {
            this.ret();
        }
    }

    void ret() {
        this.reg_PC = this.ram.readWordDirect(this.reg_SP);
        this.inc2SP();
    }

    void retn() {
        this.reg_PC = this.ram.readWordDirect(this.reg_SP);
        this.inc2SP();
        this.IFF1 = this.IFF2;
    }

    void reti() {
        this.reg_PC = this.ram.readWordDirect(this.reg_SP);
        this.inc2SP();
    }

    void call(boolean cc) {
        if (cc) {
            this.call();
        } else {
            this.inc2PC();
        }
    }

    void call() {
        int destination = this.ram.readWordDirect(this.reg_PC);
        this.inc2PC();
        this.push(this.reg_PC);
        this.reg_PC = destination;
    }

    void rst(int code) {
        this.push(this.reg_PC);
        switch (code) {
            case 0: {
                this.reg_PC = 0;
                break;
            }
            case 1: {
                this.reg_PC = 8;
                break;
            }
            case 2: {
                this.reg_PC = 16;
                break;
            }
            case 3: {
                this.reg_PC = 24;
                break;
            }
            case 4: {
                this.reg_PC = 32;
                break;
            }
            case 5: {
                this.reg_PC = 40;
                break;
            }
            case 6: {
                this.reg_PC = 48;
                break;
            }
            case 7: {
                this.reg_PC = 56;
            }
        }
    }

    void DI() {
        this.IFF1 = false;
        this.EIDIFlag = true;
    }

    void EI() {
        this.IFF1 = true;
        this.EIDIFlag = true;
    }

    void inAN() {
        this.reg_A = this.io.IORead(this.ram.readByte(this.reg_PC));
        this.incPC();
        this.updateRefreshRegister();
    }

    void outNA() {
        this.io.IOWrite(this.ram.readByte(this.reg_PC), this.reg_A);
        this.incPC();
        this.updateRefreshRegister();
    }

    void inC(int reg) {
        int temp = this.io.IORead(this.reg_BC & 0xFF);
        this.set8BitRegister(temp, reg);
        if ((temp & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        if (temp == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        if (this.parity[temp]) {
            this.setPV();
        } else {
            this.resetPV();
        }
        this.resetN();
        this.resetH();
    }

    void outC(int reg) {
        this.io.IOWrite(this.reg_BC & 0xFF, this.get8BitRegister(reg));
    }

    void setBit(int register, int bit) {
        int temp = this.get8BitRegister(register);
        switch (bit) {
            case 0: {
                temp |= 1;
                break;
            }
            case 1: {
                temp |= 2;
                break;
            }
            case 2: {
                temp |= 4;
                break;
            }
            case 3: {
                temp |= 8;
                break;
            }
            case 4: {
                temp |= 0x10;
                break;
            }
            case 5: {
                temp |= 0x20;
                break;
            }
            case 6: {
                temp |= 0x40;
                break;
            }
            case 7: {
                temp |= 0x80;
                break;
            }
            default: {
                System.out.println("set bit");
            }
        }
        this.set8BitRegister(temp, register);
    }

    void resetBit(int register, int bit) {
        int temp = this.get8BitRegister(register);
        switch (bit) {
            case 0: {
                temp &= 0xFE;
                break;
            }
            case 1: {
                temp &= 0xFD;
                break;
            }
            case 2: {
                temp &= 0xFB;
                break;
            }
            case 3: {
                temp &= 0xF7;
                break;
            }
            case 4: {
                temp &= 0xEF;
                break;
            }
            case 5: {
                temp &= 0xDF;
                break;
            }
            case 6: {
                temp &= 0xBF;
                break;
            }
            case 7: {
                temp &= 0x7F;
            }
        }
        this.set8BitRegister(temp, register);
    }

    void testBit(int register, int bit) {
        int temp = this.get8BitRegister(register);
        this.resetS();
        if (6 != register) {
            this.set3((temp & 8) != 0);
            this.set5((temp & 0x20) != 0);
        }
        switch (bit) {
            case 0: {
                temp &= 1;
                break;
            }
            case 1: {
                temp &= 2;
                break;
            }
            case 2: {
                temp &= 4;
                break;
            }
            case 3: {
                temp &= 8;
                break;
            }
            case 4: {
                temp &= 0x10;
                break;
            }
            case 5: {
                temp &= 0x20;
                break;
            }
            case 6: {
                temp &= 0x40;
                break;
            }
            case 7: {
                this.setS((temp &= 0x80) != 0);
                break;
            }
            default: {
                System.out.println("bit test rr");
            }
        }
        this.setZ(temp == 0);
        this.setPV(temp == 0);
        this.resetN();
        this.setH();
    }

    private void testBitGeneric(int bit, int temp) {
        this.resetS();
        switch (bit) {
            case 0: {
                temp &= 1;
                break;
            }
            case 1: {
                temp &= 2;
                break;
            }
            case 2: {
                temp &= 4;
                break;
            }
            case 3: {
                temp &= 8;
                break;
            }
            case 4: {
                temp &= 0x10;
                break;
            }
            case 5: {
                temp &= 0x20;
                break;
            }
            case 6: {
                temp &= 0x40;
                break;
            }
            case 7: {
                this.setS((temp &= 0x80) != 0);
                break;
            }
            default: {
                System.out.println("bit test rr");
            }
        }
        this.setZ(temp == 0);
        this.setPV(temp == 0);
        this.resetN();
        this.setH();
    }

    void LDI() {
        this.updateRefreshRegister();
        int flags = this.reg_F;
        int value = this.ram.readByte(this.reg_HL);
        this.ram.writeByte(this.reg_DE, value);
        this.reg_DE = this.ALU16BitInc(this.reg_DE);
        this.reg_HL = this.ALU16BitInc(this.reg_HL);
        this.reg_BC = this.ALU16BitDec(this.reg_BC);
        this.reg_F = flags;
        this.resetH();
        this.resetN();
        this.setPV(this.reg_BC != 0);
        int temp = value + this.reg_A;
        if ((temp & 2) == 0) {
            this.reset5();
        } else {
            this.set5();
        }
        if ((temp & 8) == 0) {
            this.reset3();
        } else {
            this.set3();
        }
    }

    void LDIR() {
        this.blockMove = true;
        this.LDI();
        if (this.reg_BC != 0) {
            this.dec2PC();
        } else {
            this.blockMove = false;
        }
    }

    void LDD() {
        this.updateRefreshRegister();
        this.blockMove = true;
        int value = this.ram.readByte(this.reg_HL);
        this.ram.writeByte(this.reg_DE, value);
        this.reg_DE = this.ALU16BitDec(this.reg_DE);
        this.reg_HL = this.ALU16BitDec(this.reg_HL);
        this.reg_BC = this.ALU16BitDec(this.reg_BC);
        this.resetH();
        this.resetN();
        this.setPV(this.reg_BC != 0);
        int temp = this.reg_A + value;
        if ((temp & 2) == 0) {
            this.reset5();
        } else {
            this.set5();
        }
        if ((temp & 8) == 0) {
            this.reset3();
        } else {
            this.set3();
        }
    }

    void LDDR() {
        this.blockMove = true;
        this.LDD();
        if (this.reg_BC != 0) {
            this.dec2PC();
        } else {
            this.blockMove = false;
        }
    }

    void CPI() {
        this.updateRefreshRegister();
        int value = this.ram.readByte(this.reg_HL);
        int result = this.reg_A - value;
        this.reg_HL = this.ALU16BitInc(this.reg_HL);
        this.reg_BC = this.ALU16BitDec(this.reg_BC);
        if ((result & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        if ((result &= 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.setHalfCarryFlagSub(this.reg_A, value);
        this.setPV(this.reg_BC != 0);
        this.setN();
        if (this.getH()) {
            --result;
        }
        if ((result & 2) == 0) {
            this.reset5();
        } else {
            this.set5();
        }
        if ((result & 8) == 0) {
            this.reset3();
        } else {
            this.set3();
        }
    }

    void CPIR() {
        this.CPI();
        if (!this.getZ() && this.reg_BC != 0) {
            this.dec2PC();
        }
    }

    void CPD() {
        this.updateRefreshRegister();
        int value = this.ram.readByte(this.reg_HL);
        int result = this.reg_A - value;
        this.reg_HL = this.ALU16BitDec(this.reg_HL);
        this.reg_BC = this.ALU16BitDec(this.reg_BC);
        if ((result & 0x80) == 0) {
            this.resetS();
        } else {
            this.setS();
        }
        if ((result &= 0xFF) == 0) {
            this.setZ();
        } else {
            this.resetZ();
        }
        this.setHalfCarryFlagSub(this.reg_A, value);
        this.setPV(this.reg_BC != 0);
        this.setN();
        if (this.getH()) {
            --result;
        }
        if ((result & 2) == 0) {
            this.reset5();
        } else {
            this.set5();
        }
        if ((result & 8) == 0) {
            this.reset3();
        } else {
            this.set3();
        }
    }

    void CPDR() {
        this.CPD();
        if (!this.getZ() && this.reg_BC != 0) {
            this.dec2PC();
        }
    }

    void INI() {
        int reg_B = this.get8BitRegister(0);
        this.ram.writeByte(this.reg_HL, this.io.IORead(this.get8BitRegister(1)));
        reg_B = reg_B-- & 0xFF;
        this.reg_HL = this.ALU16BitInc(this.reg_HL);
        this.setZ(reg_B == 0);
        this.setN();
        this.set8BitRegister(reg_B, 0);
    }

    void INIR() {
        this.INI();
        if (!this.getZ()) {
            this.dec2PC();
        }
    }

    void IND() {
        int reg_B = this.get8BitRegister(0);
        this.ram.writeByte(this.reg_HL, this.io.IORead(this.get8BitRegister(1)));
        reg_B = reg_B-- & 0xFF;
        this.reg_HL = this.ALU16BitDec(this.reg_HL);
        this.setZ(reg_B == 0);
        this.setN();
        this.set8BitRegister(reg_B, 0);
    }

    void INDR() {
        this.IND();
        if (!this.getZ()) {
            this.dec2PC();
        }
    }

    void OUTI() {
        int reg_B = this.get8BitRegister(0);
        this.io.IOWrite(this.get8BitRegister(1), this.ram.readByte(this.reg_HL));
        this.updateRefreshRegister();
        reg_B = reg_B-- & 0xFF;
        this.reg_HL = this.ALU16BitInc(this.reg_HL);
        this.setZ(reg_B == 0);
        this.setN();
        this.set8BitRegister(reg_B, 0);
    }

    void OTIR() {
        this.OUTI();
        if (!this.getZ()) {
            this.dec2PC();
        }
    }

    void OUTD() {
        int reg_B = this.get8BitRegister(0);
        this.io.IOWrite(this.get8BitRegister(1), this.ram.readByte(this.reg_HL));
        this.updateRefreshRegister();
        reg_B = reg_B-- & 0xFF;
        this.reg_HL = this.ALU16BitDec(this.reg_HL);
        this.setZ(reg_B == 0);
        this.setN();
        this.set8BitRegister(reg_B, 0);
    }

    void OTDR() {
        this.OUTD();
        if (!this.getZ()) {
            this.dec2PC();
        }
    }

    void LDRegnnnnInd16Bit(byte regCode) {
        int address = this.ram.readWord(this.reg_PC);
        int data = this.ram.readWord(address);
        this.set16BitRegister(data, regCode);
        this.inc2PC();
    }

    void LDnnnnRegInd16Bit(byte regCode) {
        int address = this.ram.readWord(this.reg_PC);
        this.ram.writeWord(address, this.get16BitRegister(regCode));
        this.inc2PC();
    }

    void LDSPHL() {
        this.reg_SP = this.reg_HL;
    }

    void IM(int mode) {
        this.interruptMode = mode;
    }

    void LDAI() {
        this.reg_A = this.reg_I;
        this.setS((this.reg_A & 0x80) != 0);
        this.setZ(this.reg_A == 0);
        this.resetH();
        this.resetN();
        this.setPV(this.IFF2);
        this.setUnusedFlags(this.reg_A);
    }

    void LDIA() {
        this.reg_I = this.reg_A;
    }

    void LDAR() {
        this.reg_A = this.reg_R & 0x7F;
        this.setS((this.reg_A & 0x80) != 0);
        this.setZ(this.reg_A == 0);
        this.resetH();
        this.resetN();
        this.setPV(this.IFF2);
        this.setUnusedFlags(this.reg_A);
    }

    void LDRA() {
        this.reg_R = this.reg_A;
    }

    int getIndexOffset() {
        this.updateRefreshRegister();
        int index = this.ram.readByte(this.reg_PC);
        this.incPC();
        if (index > 127) {
            return index - 256;
        }
        return index;
    }

    int getIndexAddress() {
        return this.reg_index + this.getIndexOffset() & 0xFFFF;
    }

    int getIndexAddressUndocumented(int reg) {
        switch (reg) {
            case 0: {
                return (this.reg_BC & 0xFF00) >> 8;
            }
            case 1: {
                return this.reg_BC & 0xFF;
            }
            case 2: {
                return (this.reg_DE & 0xFF00) >> 8;
            }
            case 3: {
                return this.reg_DE & 0xFF;
            }
            case 4: {
                return (this.reg_index & 0xFF00) >> 8;
            }
            case 5: {
                return this.reg_index & 0xFF;
            }
            case 7: {
                return this.reg_A;
            }
            case 6: {
                this.updateRefreshRegister();
                return this.ram.readByte(this.reg_index + this.getIndexOffset() & 0xFFFF);
            }
        }
        System.out.println("get 8 bit IX");
        return 0;
    }

    int get8BitRegisterIndexed(int reg) {
        switch (reg) {
            case 0: {
                return (this.reg_BC & 0xFF00) >> 8;
            }
            case 1: {
                return this.reg_BC & 0xFF;
            }
            case 2: {
                return (this.reg_DE & 0xFF00) >> 8;
            }
            case 3: {
                return this.reg_DE & 0xFF;
            }
            case 4: {
                return (this.reg_HL & 0xFF00) >> 8;
            }
            case 5: {
                return this.reg_HL & 0xFF;
            }
            case 7: {
                return this.reg_A;
            }
            case 6: {
                this.updateRefreshRegister();
                return this.ram.readByte(this.getIndexAddress());
            }
        }
        System.out.println("get 8 bit IX");
        return 0;
    }

    void set8BitRegisterIndexed(int value, int reg) {
        switch (reg) {
            case 0: {
                this.reg_BC = this.reg_BC & 0xFF | value << 8;
                break;
            }
            case 1: {
                this.reg_BC = this.reg_BC & 0xFF00 | value;
                break;
            }
            case 2: {
                this.reg_DE = this.reg_DE & 0xFF | value << 8;
                break;
            }
            case 3: {
                this.reg_DE = this.reg_DE & 0xFF00 | value;
                break;
            }
            case 4: {
                this.reg_HL = this.reg_HL & 0xFF | value << 8;
                break;
            }
            case 5: {
                this.reg_HL = this.reg_HL & 0xFF00 | value;
                break;
            }
            case 7: {
                this.reg_A = value;
                break;
            }
            case 6: {
                this.ram.writeByte(this.getIndexAddress(), value);
                break;
            }
            default: {
                System.out.println("set 8 bit IX");
            }
        }
    }

    void JPINDEX() {
        this.reg_PC = this.reg_index;
    }

    void LDSPINDEX() {
        this.reg_SP = this.reg_index;
    }

    void incIndex() {
        int address = this.getIndexAddress();
        int data = this.ALU8BitInc(this.ram.readByte(address));
        this.updateRefreshRegister();
        this.ram.writeByte(address, data);
    }

    void decIndex() {
        int address = this.getIndexAddress();
        int data = this.ALU8BitDec(this.ram.readByte(address));
        this.updateRefreshRegister();
        this.ram.writeByte(address, data);
    }

    void addIndex8Bit(int partC) {
        this.ALU8BitAdd(this.getIndexAddressUndocumented(partC));
    }

    void adcIndex8Bit(int partC) {
        this.ALU8BitAdc(this.getIndexAddressUndocumented(partC));
    }

    void subIndex8Bit(int partC) {
        this.ALU8BitSub(this.getIndexAddressUndocumented(partC));
    }

    void sbcIndex8Bit(int partC) {
        this.ALU8BitSbc(this.getIndexAddressUndocumented(partC));
    }

    void andIndex8Bit(int partC) {
        this.ALU8BitAnd(this.getIndexAddressUndocumented(partC));
    }

    void xorIndex8Bit(int partC) {
        this.ALU8BitXor(this.getIndexAddressUndocumented(partC));
    }

    void orIndex8Bit(int partC) {
        this.ALU8BitOr(this.getIndexAddressUndocumented(partC));
    }

    void cpIndex8Bit(int partC) {
        this.ALU8BitCp(this.getIndexAddressUndocumented(partC));
    }

    void EXSPIndex() {
        int temp = this.reg_index;
        this.reg_index = this.pop();
        this.push(temp);
    }

    void testIndexBit(int bit) {
        this.updateRefreshRegister();
        int address = this.getIndexAddress();
        int temp = this.ram.readByte(address);
        this.testBitGeneric(bit, temp);
    }

    void bitIndexSet(int bit) {
        this.updateRefreshRegister();
        int address = this.getIndexAddress();
        int temp = this.ram.readByte(address);
        switch (bit) {
            case 0: {
                temp |= 1;
                break;
            }
            case 1: {
                temp |= 2;
                break;
            }
            case 2: {
                temp |= 4;
                break;
            }
            case 3: {
                temp |= 8;
                break;
            }
            case 4: {
                temp |= 0x10;
                break;
            }
            case 5: {
                temp |= 0x20;
                break;
            }
            case 6: {
                temp |= 0x40;
                break;
            }
            case 7: {
                temp |= 0x80;
                break;
            }
            default: {
                System.out.println("bit set IX");
            }
        }
        this.ram.writeByte(address, temp);
    }

    void bitIndexReset(int bit) {
        this.updateRefreshRegister();
        int address = this.getIndexAddress();
        int temp = this.ram.readByte(address);
        switch (bit) {
            case 0: {
                temp &= 0xFE;
                break;
            }
            case 1: {
                temp &= 0xFD;
                break;
            }
            case 2: {
                temp &= 0xFB;
                break;
            }
            case 3: {
                temp &= 0xF7;
                break;
            }
            case 4: {
                temp &= 0xEF;
                break;
            }
            case 5: {
                temp &= 0xDF;
                break;
            }
            case 6: {
                temp &= 0xBF;
                break;
            }
            case 7: {
                temp &= 0x7F;
                break;
            }
            default: {
                System.out.println("bit reset IX");
            }
        }
        this.ram.writeByte(address, temp);
    }

    void loadIndex8BitImmediate() throws ComputerException {
        this.updateRefreshRegister();
        int address = this.getIndexAddress();
        int data = this.ram.readByte(this.reg_PC);
        this.incPC();
        this.ram.writeByte(address, data);
    }
}

