/*
 * Decompiled with CFR 0.152.
 */
package net.espley.microprocessor;

import net.espley.microprocessor.ComputerException;
import net.espley.microprocessor.IBaseDevice;
import net.espley.microprocessor.IMemory;
import net.espley.microprocessor.Z80RegisterFile;

public final class Z80 {
    private Z80RegisterFile registers;
    private IMemory ram;
    private IBaseDevice io;
    private int instruction;
    private int partA;
    private int partB;
    private int partC;
    private boolean halt;
    private int tStates;
    private int[] instA = new int[256];
    private int[] instB = new int[256];
    private int[] instC = new int[256];
    private static final long timeSlice = 100L;
    private static final long oneMHz = 1000000L;
    private static final long sampleMS = 10L;
    private long time;
    private long tStatesPerTimeSlice;
    private long tStatesPerMS;
    private boolean maxSpeed;
    private final int regCodeB = 0;
    private final int regCodeC = 1;
    private final int regCodeD = 2;
    private final int regCodeE = 3;
    private final int regCodeH = 4;
    private final int regCodeL = 5;
    private final int regCodeM = 6;
    private final int regCodeA = 7;
    private final int regCodeBC = 0;
    private final int regCodeDE = 1;
    private final int regCodeHL = 2;
    private final int regCodeIX = 2;
    private final int regCodeIY = 2;
    private final int regCodeSP = 3;
    private final int regCodeAF = 3;
    private static final int HALT = 118;

    public Z80(IMemory ram, IBaseDevice io) {
        this.ram = ram;
        this.io = io;
        this.registers = new Z80RegisterFile(ram, io);
        for (int i = 0; i < 256; ++i) {
            this.decode(i);
            this.instA[i] = this.partA;
            this.instB[i] = this.partB;
            this.instC[i] = this.partC;
        }
        this.time = System.currentTimeMillis();
        this.tStates = 0;
        this.setMHz(4);
    }

    public boolean blockMoveInProgress() {
        return this.registers.blockMoveInProgress();
    }

    public void reset() {
        this.halt = false;
        this.registers.reset();
    }

    public void setNMI() {
        this.registers.setNMI();
    }

    public boolean getHalt() {
        return this.halt;
    }

    public int getTStates() {
        return this.tStates;
    }

    public void setTStates(int t) {
        this.tStates = t;
    }

    public void setMHz(int mhz) {
        if (mhz <= 0) {
            mhz = 4;
            this.maxSpeed = true;
        } else {
            this.tStatesPerMS = (long)mhz * 1000000L / (long)1000;
            this.tStatesPerTimeSlice = this.tStatesPerMS * 10L;
            this.maxSpeed = false;
        }
    }

    public int getProgramCounter() {
        return this.registers.reg_PC;
    }

    public void setProgramCounter(int pc) {
        this.registers.reg_PC = pc;
    }

    public void updateRefreshRegister() {
        this.registers.updateRefreshRegister();
    }

    public int getRegisterValue(String name) {
        if (name.equals("BC")) {
            return this.registers.reg_BC;
        }
        if (name.equals("DE")) {
            return this.registers.reg_DE;
        }
        if (name.equals("HL")) {
            return this.registers.reg_HL;
        }
        if (name.equals("BC_ALT")) {
            return this.registers.reg_BC_ALT;
        }
        if (name.equals("DE_ALT")) {
            return this.registers.reg_DE_ALT;
        }
        if (name.equals("HL_ALT")) {
            return this.registers.reg_HL_ALT;
        }
        if (name.equals("IX")) {
            return this.registers.reg_IX;
        }
        if (name.equals("IY")) {
            return this.registers.reg_IY;
        }
        if (name.equals("SP")) {
            return this.registers.reg_SP;
        }
        if (name.equals("PC")) {
            return this.registers.reg_PC;
        }
        if (name.equals("A")) {
            return this.registers.reg_A;
        }
        if (name.equals("F")) {
            return this.registers.reg_F;
        }
        if (name.equals("A_ALT")) {
            return this.registers.reg_A_ALT;
        }
        if (name.equals("F_ALT")) {
            return this.registers.reg_F_ALT;
        }
        return -1;
    }

    private final void decode(int instruction) {
        this.partC = instruction & 7;
        instruction = (short)(instruction >>> 3);
        this.partB = instruction & 7;
        instruction = (short)(instruction >>> 3);
        this.partA = instruction & 3;
    }

    public void execute() throws ComputerException {
        if (!this.maxSpeed) {
            this.tStates += 4;
            long t1 = System.currentTimeMillis();
            if (t1 - this.time > 10L) {
                this.time = t1;
                if ((long)this.tStates > this.tStatesPerTimeSlice) {
                    long waste = (long)this.tStates - this.tStatesPerTimeSlice;
                    long delay = waste / this.tStatesPerMS;
                    try {
                        Thread.currentThread();
                        Thread.sleep(delay);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.tStates = 0;
            }
        }
        this.halt = false;
        if (this.registers.NMI_FF) {
            if (this.registers.EIDIFlag) {
                this.registers.EIDIFlag = false;
            } else {
                this.registers.NMI_FF = false;
                this.registers.IFF2 = this.registers.IFF1;
                this.registers.push(this.registers.reg_PC);
                this.registers.reg_PC = 102;
            }
        }
        this.instruction = this.ram.readByte(this.registers.reg_PC);
        this.registers.incPC();
        try {
            if (this.instruction < 128) {
                if (this.instruction < 64) {
                    this.partB = this.instB[this.instruction];
                    this.partC = this.instC[this.instruction];
                    this.decodeLowerInstructions();
                } else {
                    this.decode8BitLoadFast();
                }
            } else if (this.instruction < 192) {
                this.partB = this.instB[this.instruction];
                this.partC = this.instC[this.instruction];
                this.decode8BitMaths();
            } else {
                this.partB = this.instB[this.instruction];
                this.partC = this.instC[this.instruction];
                this.decodeUpperInstructions();
            }
        }
        catch (ComputerException e) {
            this.registers.decPC();
            throw e;
        }
    }

    private void decodeLowerInstructions() throws ComputerException {
        switch (this.partC) {
            case 0: {
                this.specialBlock1();
                break;
            }
            case 1: {
                this.decode16BitLdAdd();
                break;
            }
            case 2: {
                this.decodeIndirectLoads();
                break;
            }
            case 3: {
                this.decode16BitIncDec();
                break;
            }
            case 4: {
                this.registers.set8BitRegister(this.registers.ALU8BitInc(this.registers.get8BitRegister(this.partB)), this.partB);
                break;
            }
            case 5: {
                this.registers.set8BitRegister(this.registers.ALU8BitDec(this.registers.get8BitRegister(this.partB)), this.partB);
                break;
            }
            case 6: {
                this.load8BitImmediate();
                break;
            }
            case 7: {
                this.logicBlock1();
            }
        }
    }

    private void logicBlock1() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.RLCA();
                break;
            }
            case 1: {
                this.registers.RRCA();
                break;
            }
            case 2: {
                this.registers.RLA();
                break;
            }
            case 3: {
                this.registers.RRA();
                break;
            }
            case 4: {
                this.registers.DAA();
                break;
            }
            case 5: {
                this.registers.CPL();
                break;
            }
            case 6: {
                this.registers.SCF();
                break;
            }
            case 7: {
                this.registers.CCF();
            }
        }
    }

    private void specialBlock1() {
        switch (this.partB) {
            case 0: {
                break;
            }
            case 1: {
                this.registers.EXAFAF();
                break;
            }
            case 2: {
                this.registers.djnz();
                break;
            }
            case 3: {
                this.registers.relativeJump();
                break;
            }
            case 4: {
                if (!this.registers.getZ()) {
                    this.registers.relativeJump();
                    break;
                }
                this.registers.incPC();
                break;
            }
            case 5: {
                if (this.registers.getZ()) {
                    this.registers.relativeJump();
                    break;
                }
                this.registers.incPC();
                break;
            }
            case 6: {
                if (!this.registers.getC()) {
                    this.registers.relativeJump();
                    break;
                }
                this.registers.incPC();
                break;
            }
            case 7: {
                if (this.registers.getC()) {
                    this.registers.relativeJump();
                    break;
                }
                this.registers.incPC();
            }
        }
    }

    private void load8BitImmediate() {
        this.registers.set8BitRegister(this.ram.readByte(this.registers.reg_PC), this.partB);
        this.registers.incPC();
    }

    private void decode16BitIncDec() {
        int reg = (this.partB & 6) >>> 1;
        switch (this.partB & 1) {
            case 0: {
                this.registers.set16BitRegister(this.registers.ALU16BitInc(this.registers.get16BitRegister(reg)), reg);
                break;
            }
            case 1: {
                this.registers.set16BitRegister(this.registers.ALU16BitDec(this.registers.get16BitRegister(reg)), reg);
            }
        }
    }

    private void decode16BitLdAdd() {
        int reg = (this.partB & 6) >>> 1;
        switch (this.partB & 1) {
            case 0: {
                this.registers.set16BitRegister(this.ram.readWord(this.registers.reg_PC), reg);
                this.registers.inc2PC();
                break;
            }
            case 1: {
                this.registers.set16BitRegister(this.registers.ALU16BitAdd(this.registers.get16BitRegister(reg)), 2);
            }
        }
    }

    private void decodeIndirectLoads() {
        switch (this.partB) {
            case 0: {
                this.ram.writeByte(this.registers.reg_BC, this.registers.reg_A);
                break;
            }
            case 1: {
                this.registers.reg_A = this.ram.readByte(this.registers.reg_BC);
                break;
            }
            case 2: {
                this.ram.writeByte(this.registers.reg_DE, this.registers.reg_A);
                break;
            }
            case 3: {
                this.registers.reg_A = this.ram.readByte(this.registers.reg_DE);
                break;
            }
            case 4: {
                this.ram.writeWord(this.ram.readWord(this.registers.reg_PC), this.registers.reg_HL);
                this.registers.inc2PC();
                break;
            }
            case 5: {
                this.registers.reg_HL = this.ram.readWord(this.ram.readWord(this.registers.reg_PC));
                this.registers.inc2PC();
                break;
            }
            case 6: {
                this.ram.writeByte(this.ram.readWord(this.registers.reg_PC), this.registers.reg_A);
                this.registers.inc2PC();
                break;
            }
            case 7: {
                this.registers.reg_A = this.ram.readByte(this.ram.readWord(this.registers.reg_PC));
                this.registers.inc2PC();
            }
        }
    }

    private void decode8BitLoad() {
        if (this.instruction == 118) {
            System.out.println("Program HALT");
            this.registers.decPC();
            this.halt = true;
        } else {
            this.registers.set8BitRegister(this.registers.get8BitRegister(this.partC), this.partB);
        }
    }

    private void decode8BitLoadFast() {
        switch (this.instruction) {
            case 64: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | this.registers.reg_BC & 0xFF00;
                break;
            }
            case 65: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | (this.registers.reg_BC & 0xFF) << 8;
                break;
            }
            case 66: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | this.registers.reg_DE & 0xFF00;
                break;
            }
            case 67: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | (this.registers.reg_DE & 0xFF) << 8;
                break;
            }
            case 68: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | this.registers.reg_HL & 0xFF00;
                break;
            }
            case 69: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | (this.registers.reg_HL & 0xFF) << 8;
                break;
            }
            case 70: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | this.ram.readByte(this.registers.reg_HL) << 8;
                break;
            }
            case 71: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF | this.registers.reg_A << 8;
                break;
            }
            case 72: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | (this.registers.reg_BC & 0xFF00) >> 8;
                break;
            }
            case 73: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | this.registers.reg_BC & 0xFF;
                break;
            }
            case 74: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | (this.registers.reg_DE & 0xFF00) >> 8;
                break;
            }
            case 75: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | this.registers.reg_DE & 0xFF;
                break;
            }
            case 76: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | (this.registers.reg_HL & 0xFF00) >> 8;
                break;
            }
            case 77: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | this.registers.reg_HL & 0xFF;
                break;
            }
            case 78: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | this.ram.readByte(this.registers.reg_HL);
                break;
            }
            case 79: {
                this.registers.reg_BC = this.registers.reg_BC & 0xFF00 | this.registers.reg_A;
                break;
            }
            case 80: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | this.registers.reg_BC & 0xFF00;
                break;
            }
            case 81: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | (this.registers.reg_BC & 0xFF) << 8;
                break;
            }
            case 82: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | this.registers.reg_DE & 0xFF00;
                break;
            }
            case 83: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | (this.registers.reg_DE & 0xFF) << 8;
                break;
            }
            case 84: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | this.registers.reg_HL & 0xFF00;
                break;
            }
            case 85: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | (this.registers.reg_HL & 0xFF) << 8;
                break;
            }
            case 86: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | this.ram.readByte(this.registers.reg_HL) << 8;
                break;
            }
            case 87: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF | this.registers.reg_A << 8;
                break;
            }
            case 88: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | (this.registers.reg_BC & 0xFF00) >> 8;
                break;
            }
            case 89: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | this.registers.reg_BC & 0xFF;
                break;
            }
            case 90: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | (this.registers.reg_DE & 0xFF00) >> 8;
                break;
            }
            case 91: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | this.registers.reg_DE & 0xFF;
                break;
            }
            case 92: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | (this.registers.reg_HL & 0xFF00) >> 8;
                break;
            }
            case 93: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | this.registers.reg_HL & 0xFF;
                break;
            }
            case 94: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | this.ram.readByte(this.registers.reg_HL);
                break;
            }
            case 95: {
                this.registers.reg_DE = this.registers.reg_DE & 0xFF00 | this.registers.reg_A;
                break;
            }
            case 96: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | this.registers.reg_BC & 0xFF00;
                break;
            }
            case 97: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | (this.registers.reg_BC & 0xFF) << 8;
                break;
            }
            case 98: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | this.registers.reg_DE & 0xFF00;
                break;
            }
            case 99: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | (this.registers.reg_DE & 0xFF) << 8;
                break;
            }
            case 100: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | this.registers.reg_HL & 0xFF00;
                break;
            }
            case 101: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | (this.registers.reg_HL & 0xFF) << 8;
                break;
            }
            case 102: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | this.ram.readByte(this.registers.reg_HL) << 8;
                break;
            }
            case 103: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF | this.registers.reg_A << 8;
                break;
            }
            case 104: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | (this.registers.reg_BC & 0xFF00) >> 8;
                break;
            }
            case 105: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | this.registers.reg_BC & 0xFF;
                break;
            }
            case 106: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | (this.registers.reg_DE & 0xFF00) >> 8;
                break;
            }
            case 107: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | this.registers.reg_DE & 0xFF;
                break;
            }
            case 108: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | (this.registers.reg_HL & 0xFF00) >> 8;
                break;
            }
            case 109: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | this.registers.reg_HL & 0xFF;
                break;
            }
            case 110: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | this.ram.readByte(this.registers.reg_HL);
                break;
            }
            case 111: {
                this.registers.reg_HL = this.registers.reg_HL & 0xFF00 | this.registers.reg_A;
                break;
            }
            case 112: {
                this.ram.writeByte(this.registers.reg_HL, (this.registers.reg_BC & 0xFF00) >> 8);
                break;
            }
            case 113: {
                this.ram.writeByte(this.registers.reg_HL, this.registers.reg_BC & 0xFF);
                break;
            }
            case 114: {
                this.ram.writeByte(this.registers.reg_HL, (this.registers.reg_DE & 0xFF00) >> 8);
                break;
            }
            case 115: {
                this.ram.writeByte(this.registers.reg_HL, this.registers.reg_DE & 0xFF);
                break;
            }
            case 116: {
                this.ram.writeByte(this.registers.reg_HL, (this.registers.reg_HL & 0xFF00) >> 8);
                break;
            }
            case 117: {
                this.ram.writeByte(this.registers.reg_HL, this.registers.reg_HL & 0xFF);
                break;
            }
            case 118: {
                System.out.println("Program HALT");
                this.registers.decPC();
                this.halt = true;
                break;
            }
            case 119: {
                this.ram.writeByte(this.registers.reg_HL, this.registers.reg_A);
                break;
            }
            case 120: {
                this.registers.reg_A = (this.registers.reg_BC & 0xFF00) >> 8;
                break;
            }
            case 121: {
                this.registers.reg_A = this.registers.reg_BC & 0xFF;
                break;
            }
            case 122: {
                this.registers.reg_A = (this.registers.reg_DE & 0xFF00) >> 8;
                break;
            }
            case 123: {
                this.registers.reg_A = this.registers.reg_DE & 0xFF;
                break;
            }
            case 124: {
                this.registers.reg_A = (this.registers.reg_HL & 0xFF00) >> 8;
                break;
            }
            case 125: {
                this.registers.reg_A = this.registers.reg_HL & 0xFF;
                break;
            }
            case 126: {
                this.registers.reg_A = this.ram.readByte(this.registers.reg_HL);
                break;
            }
            case 127: {
                this.registers.reg_A = this.registers.reg_A;
            }
        }
    }

    private void add8Bit() {
        this.registers.ALU8BitAdd(this.registers.get8BitRegister(this.partC));
    }

    private void adc8Bit() {
        this.registers.ALU8BitAdc(this.registers.get8BitRegister(this.partC));
    }

    private void sub8Bit() {
        this.registers.ALU8BitSub(this.registers.get8BitRegister(this.partC));
    }

    private void sbc8Bit() {
        this.registers.ALU8BitSbc(this.registers.get8BitRegister(this.partC));
    }

    private void and8Bit() {
        this.registers.ALU8BitAnd(this.registers.get8BitRegister(this.partC));
    }

    private void or8Bit() {
        this.registers.ALU8BitOr(this.registers.get8BitRegister(this.partC));
    }

    private void xor8Bit() {
        this.registers.ALU8BitXor(this.registers.get8BitRegister(this.partC));
    }

    private void cp8Bit() {
        this.registers.ALU8BitCp(this.registers.get8BitRegister(this.partC));
    }

    private void decode8BitMaths() {
        switch (this.partB) {
            case 0: {
                this.add8Bit();
                break;
            }
            case 1: {
                this.adc8Bit();
                break;
            }
            case 2: {
                this.sub8Bit();
                break;
            }
            case 3: {
                this.sbc8Bit();
                break;
            }
            case 4: {
                this.and8Bit();
                break;
            }
            case 5: {
                this.xor8Bit();
                break;
            }
            case 6: {
                this.or8Bit();
                break;
            }
            case 7: {
                this.cp8Bit();
            }
        }
    }

    private void decodeUpperInstructions() throws ComputerException {
        switch (this.partC) {
            case 0: {
                this.decodeRET();
                break;
            }
            case 1: {
                this.decodeGeneralBlock1();
                break;
            }
            case 2: {
                this.decodeJP();
                break;
            }
            case 3: {
                this.decodeGeneralBlock3();
                break;
            }
            case 4: {
                this.decodeCALL();
                break;
            }
            case 5: {
                this.decodeGeneralBlock5();
                break;
            }
            case 6: {
                this.decodeImmediate8BitMath();
                break;
            }
            case 7: {
                this.registers.rst(this.partB);
            }
        }
    }

    private void decodeImmediate8BitMath() {
        switch (this.partB) {
            case 0: {
                this.registers.ALU8BitAdd(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 1: {
                this.registers.ALU8BitAdc(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 2: {
                this.registers.ALU8BitSub(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 3: {
                this.registers.ALU8BitSbc(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 4: {
                this.registers.ALU8BitAnd(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 5: {
                this.registers.ALU8BitXor(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 6: {
                this.registers.ALU8BitOr(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
                break;
            }
            case 7: {
                this.registers.ALU8BitCp(this.ram.readByte(this.registers.reg_PC));
                this.registers.incPC();
            }
        }
    }

    private void decodeGeneralBlock1() {
        switch (this.partB) {
            case 0: {
                this.registers.pop((byte)0);
                break;
            }
            case 1: {
                this.registers.ret();
                break;
            }
            case 2: {
                this.registers.pop((byte)1);
                break;
            }
            case 3: {
                this.registers.EXX();
                break;
            }
            case 4: {
                this.registers.pop((byte)2);
                break;
            }
            case 5: {
                this.registers.JPHL();
                break;
            }
            case 6: {
                this.registers.pop((byte)3);
                break;
            }
            case 7: {
                this.registers.LDSPHL();
            }
        }
    }

    private void decodeGeneralBlock3() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.jp();
                break;
            }
            case 1: {
                this.extendedCB();
                break;
            }
            case 2: {
                this.registers.outNA();
                break;
            }
            case 3: {
                this.registers.inAN();
                break;
            }
            case 4: {
                this.registers.EXSPHL();
                break;
            }
            case 5: {
                this.registers.EXDEHL();
                break;
            }
            case 6: {
                this.registers.DI();
                break;
            }
            case 7: {
                this.registers.EI();
            }
        }
    }

    private void decodeGeneralBlock5() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.push((byte)0);
                break;
            }
            case 1: {
                this.registers.call();
                break;
            }
            case 2: {
                this.registers.push((byte)1);
                break;
            }
            case 3: {
                this.extendedDD();
                break;
            }
            case 4: {
                this.registers.push((byte)2);
                break;
            }
            case 5: {
                this.extendedED();
                break;
            }
            case 6: {
                this.registers.push((byte)3);
                break;
            }
            case 7: {
                this.extendedFD();
            }
        }
    }

    private void decodeRET() {
        switch (this.partB) {
            case 0: {
                this.registers.ret(!this.registers.getZ());
                break;
            }
            case 1: {
                this.registers.ret(this.registers.getZ());
                break;
            }
            case 2: {
                this.registers.ret(!this.registers.getC());
                break;
            }
            case 3: {
                this.registers.ret(this.registers.getC());
                break;
            }
            case 4: {
                this.registers.ret(!this.registers.getPV());
                break;
            }
            case 5: {
                this.registers.ret(this.registers.getPV());
                break;
            }
            case 6: {
                this.registers.ret(!this.registers.getS());
                break;
            }
            case 7: {
                this.registers.ret(this.registers.getS());
            }
        }
    }

    private void decodeCALL() {
        switch (this.partB) {
            case 0: {
                this.registers.call(!this.registers.getZ());
                break;
            }
            case 1: {
                this.registers.call(this.registers.getZ());
                break;
            }
            case 2: {
                this.registers.call(!this.registers.getC());
                break;
            }
            case 3: {
                this.registers.call(this.registers.getC());
                break;
            }
            case 4: {
                this.registers.call(!this.registers.getPV());
                break;
            }
            case 5: {
                this.registers.call(this.registers.getPV());
                break;
            }
            case 6: {
                this.registers.call(!this.registers.getS());
                break;
            }
            case 7: {
                this.registers.call(this.registers.getS());
            }
        }
    }

    private void decodeJP() {
        switch (this.partB) {
            case 0: {
                this.registers.jp(!this.registers.getZ());
                break;
            }
            case 1: {
                this.registers.jp(this.registers.getZ());
                break;
            }
            case 2: {
                this.registers.jp(!this.registers.getC());
                break;
            }
            case 3: {
                this.registers.jp(this.registers.getC());
                break;
            }
            case 4: {
                this.registers.jp(!this.registers.getPV());
                break;
            }
            case 5: {
                this.registers.jp(this.registers.getPV());
                break;
            }
            case 6: {
                this.registers.jp(!this.registers.getS());
                break;
            }
            case 7: {
                this.registers.jp(this.registers.getS());
            }
        }
    }

    private void extendedCB() throws ComputerException {
        this.tStates += 4;
        this.instruction = this.ram.readByte(this.registers.reg_PC);
        this.registers.incPC();
        this.partA = this.instA[this.instruction];
        this.partB = this.instB[this.instruction];
        this.partC = this.instC[this.instruction];
        switch (this.partA) {
            case 0: {
                this.decodeCBShifts();
                break;
            }
            case 1: {
                this.decodeCBBitTest();
                break;
            }
            case 2: {
                this.decodeCBBitReset();
                break;
            }
            case 3: {
                this.decodeCBBitSet();
            }
        }
    }

    private void decodeCBShifts() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.shiftRLC(this.partC);
                break;
            }
            case 1: {
                this.registers.shiftRRC(this.partC);
                break;
            }
            case 2: {
                this.registers.shiftRL(this.partC);
                break;
            }
            case 3: {
                this.registers.shiftRR(this.partC);
                break;
            }
            case 4: {
                this.registers.shiftSLA(this.partC);
                break;
            }
            case 5: {
                this.registers.shiftSRA(this.partC);
                break;
            }
            case 6: {
                this.registers.shiftSLL(this.partC);
                break;
            }
            case 7: {
                this.registers.shiftSRL(this.partC);
            }
        }
    }

    private void decodeCBBitTest() {
        this.registers.testBit(this.partC, this.partB);
    }

    private void decodeCBBitReset() {
        this.registers.resetBit(this.partC, this.partB);
    }

    private void decodeCBBitSet() {
        this.registers.setBit(this.partC, this.partB);
    }

    private void extendedED() throws ComputerException {
        this.tStates += 4;
        this.instruction = this.ram.readByte(this.registers.reg_PC);
        this.registers.incPC();
        this.partA = this.instA[this.instruction];
        this.partB = this.instB[this.instruction];
        this.partC = this.instC[this.instruction];
        switch (this.partA) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                this.decodeEDMiddleLower();
                break;
            }
            case 2: {
                this.decodeEDMiddleUpper();
                break;
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeEDMiddleLower() throws ComputerException {
        switch (this.partC) {
            case 0: {
                this.decodeInC();
                break;
            }
            case 1: {
                this.decodeOutC();
                break;
            }
            case 2: {
                this.decode16BitADCSBC();
                break;
            }
            case 3: {
                this.decode16BitIndirectLoad();
                break;
            }
            case 4: {
                this.decodeEDVarious4();
                break;
            }
            case 5: {
                this.decodeEDVarious5();
                break;
            }
            case 6: {
                this.decodeEDVarious6();
                break;
            }
            case 7: {
                this.decodeEDVarious7();
            }
        }
    }

    private void decodeEDMiddleUpper() throws ComputerException {
        switch (this.partC) {
            case 0: {
                this.decodeEDBlockMove();
                break;
            }
            case 1: {
                this.decodeEDBlockCompare();
                break;
            }
            case 2: {
                this.decodeEDBlockIN();
                break;
            }
            case 3: {
                this.decodeEDBlockOUT();
                break;
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeInC() throws ComputerException {
        if (this.partB == 6) {
            throw new ComputerException("Unimplemented opcode detected");
        }
        this.registers.inC(this.partB);
    }

    private void decodeOutC() throws ComputerException {
        if (this.partB == 6) {
            throw new ComputerException("Unimplemented opcode detected");
        }
        this.registers.outC(this.partB);
    }

    private void decode16BitADCSBC() {
        switch (this.partB) {
            case 0: {
                this.registers.ALU16BitSBC(0);
                break;
            }
            case 1: {
                this.registers.ALU16BitADC(0);
                break;
            }
            case 2: {
                this.registers.ALU16BitSBC(1);
                break;
            }
            case 3: {
                this.registers.ALU16BitADC(1);
                break;
            }
            case 4: {
                this.registers.ALU16BitSBC(2);
                break;
            }
            case 5: {
                this.registers.ALU16BitADC(2);
                break;
            }
            case 6: {
                this.registers.ALU16BitSBC(3);
                break;
            }
            case 7: {
                this.registers.ALU16BitADC(3);
            }
        }
    }

    private void decode16BitIndirectLoad() {
        byte reg = (byte)((this.partB & 6) >>> 1);
        switch (this.partB & 1) {
            case 0: {
                this.registers.LDnnnnRegInd16Bit(reg);
                break;
            }
            case 1: {
                this.registers.LDRegnnnnInd16Bit(reg);
            }
        }
    }

    private void decodeEDBlockMove() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.LDI();
                break;
            }
            case 5: {
                this.registers.LDD();
                break;
            }
            case 6: {
                this.registers.LDIR();
                break;
            }
            case 7: {
                this.registers.LDDR();
            }
        }
    }

    private void decodeEDBlockCompare() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.CPI();
                break;
            }
            case 5: {
                this.registers.CPD();
                break;
            }
            case 6: {
                this.registers.CPIR();
                break;
            }
            case 7: {
                this.registers.CPDR();
            }
        }
    }

    private void decodeEDBlockIN() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.INI();
                break;
            }
            case 5: {
                this.registers.IND();
                break;
            }
            case 6: {
                this.registers.INIR();
                break;
            }
            case 7: {
                this.registers.INDR();
            }
        }
    }

    private void decodeEDBlockOUT() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.OUTI();
                break;
            }
            case 5: {
                this.registers.OUTD();
                break;
            }
            case 6: {
                this.registers.OTIR();
                break;
            }
            case 7: {
                this.registers.OTDR();
            }
        }
    }

    private void decodeEDVarious4() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.NEG();
                break;
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeEDVarious5() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.retn();
                break;
            }
            case 1: {
                this.registers.reti();
                break;
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeEDVarious6() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.IM(0);
                break;
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                this.registers.IM(1);
                break;
            }
            case 3: {
                this.registers.IM(3);
                break;
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeEDVarious7() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.registers.LDIA();
                break;
            }
            case 1: {
                this.registers.LDRA();
                break;
            }
            case 2: {
                this.registers.LDAI();
                break;
            }
            case 3: {
                this.registers.LDAR();
                break;
            }
            case 4: {
                this.registers.RRD();
                break;
            }
            case 5: {
                this.registers.RLD();
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void extendedDD() throws ComputerException {
        this.registers.reg_index = this.registers.reg_IX;
        this.extendedDDFD();
        this.registers.reg_IX = this.registers.reg_index;
    }

    private void extendedFD() throws ComputerException {
        this.registers.reg_index = this.registers.reg_IY;
        this.extendedDDFD();
        this.registers.reg_IY = this.registers.reg_index;
    }

    private void extendedDDFD() throws ComputerException {
        this.tStates += 4;
        this.instruction = this.ram.readByte(this.registers.reg_PC);
        this.registers.incPC();
        this.partA = this.instA[this.instruction];
        this.partB = this.instB[this.instruction];
        this.partC = this.instC[this.instruction];
        try {
            switch (this.partA) {
                case 0: {
                    this.decodeIndexLowerInstructions();
                    break;
                }
                case 1: {
                    this.decode8BitLoadIndexed();
                    break;
                }
                case 2: {
                    this.decodeIndex8BitMaths();
                    break;
                }
                case 3: {
                    this.decodeUpperIndexInstructions();
                }
            }
        }
        catch (ComputerException e) {
            this.registers.decPC();
            throw e;
        }
    }

    private void decodeIndexLowerInstructions() throws ComputerException {
        switch (this.partC) {
            case 0: {
                this.specialIndexBlock1();
                break;
            }
            case 1: {
                this.decodeIndex16BitLdAdd();
                break;
            }
            case 2: {
                this.decodeIndexIndirectLoads();
                break;
            }
            case 3: {
                this.decodeIndex16BitIncDec();
                break;
            }
            case 4: {
                this.decodeIndexInc();
                break;
            }
            case 5: {
                this.decodeIndexDec();
                break;
            }
            case 6: {
                this.loadIndex8BitImmediate();
                break;
            }
            case 7: {
                this.logicIndexBlock1();
            }
        }
    }

    private void specialIndexBlock1() throws ComputerException {
        throw new ComputerException("Unimplemented opcode detected");
    }

    private void decodeIndex16BitLdAdd() throws ComputerException {
        int reg = (this.partB & 6) >>> 1;
        switch (this.partB & 1) {
            case 0: {
                this.registers.set16BitRegisterIndexed(this.ram.readWord(this.registers.reg_PC), reg);
                this.registers.inc2PC();
                break;
            }
            case 1: {
                this.registers.reg_index = this.registers.ALU16BitAddIndexed(this.registers.get16BitRegisterIndexed(reg));
            }
        }
    }

    private void decodeIndexIndirectLoads() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.ram.writeWord(this.ram.readWord(this.registers.reg_PC), this.registers.reg_index);
                this.registers.inc2PC();
                break;
            }
            case 5: {
                this.registers.reg_index = this.ram.readWord(this.ram.readWord(this.registers.reg_PC));
                this.registers.inc2PC();
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndex16BitIncDec() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.reg_index = this.registers.ALU16BitInc(this.registers.reg_index);
                break;
            }
            case 5: {
                this.registers.reg_index = this.registers.ALU16BitDec(this.registers.reg_index);
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexInc() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                int temp = this.registers.reg_index >>> 8;
                temp = this.registers.ALU8BitInc(temp);
                this.registers.reg_index = this.registers.reg_index & 0xFF | temp << 8;
                break;
            }
            case 5: {
                int temp = this.registers.reg_index & 0xFF;
                temp = this.registers.ALU8BitInc(temp);
                this.registers.reg_index = this.registers.reg_index & 0xFF00 | temp;
                break;
            }
            case 6: {
                this.registers.incIndex();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexDec() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                int temp = this.registers.reg_index >>> 8;
                temp = this.registers.ALU8BitDec(temp);
                this.registers.reg_index = this.registers.reg_index & 0xFF | temp << 8;
                break;
            }
            case 5: {
                int temp = this.registers.reg_index & 0xFF;
                temp = this.registers.ALU8BitDec(temp);
                this.registers.reg_index = this.registers.reg_index & 0xFF00 | temp;
                break;
            }
            case 6: {
                this.registers.decIndex();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void loadIndex8BitImmediate() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                int temp = this.ram.readByte(this.registers.reg_PC) << 8;
                this.registers.reg_index = this.registers.reg_index & 0xFF | temp;
                this.registers.incPC();
                break;
            }
            case 5: {
                int temp = this.ram.readByte(this.registers.reg_PC);
                this.registers.reg_index = this.registers.reg_index & 0xFF00 | temp;
                this.registers.incPC();
                break;
            }
            case 6: {
                this.registers.loadIndex8BitImmediate();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void logicIndexBlock1() throws ComputerException {
        throw new ComputerException("Unimplemented opcode detected");
    }

    private void decodeIndex8BitMaths() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.decodeAddIndex();
                break;
            }
            case 1: {
                this.decodeAdcIndex();
                break;
            }
            case 2: {
                this.decodeSubIndex();
                break;
            }
            case 3: {
                this.decodeSbcIndex();
                break;
            }
            case 4: {
                this.decodeAndIndex();
                break;
            }
            case 5: {
                this.decodeXorIndex();
                break;
            }
            case 6: {
                this.decodeOrIndex();
                break;
            }
            case 7: {
                this.decodeCpIndex();
            }
        }
    }

    private void decodeAddIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitAdd((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitAdd(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.addIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeAdcIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitAdc((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitAdc(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.adcIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeSubIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitSub((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitSub(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.subIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeSbcIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitSbc((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitSbc(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.sbcIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeAndIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitAnd((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitAnd(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.andIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeXorIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitXor((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitXor(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.xorIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeOrIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitOr((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitOr(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.orIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeCpIndex() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.ALU8BitCp((this.registers.reg_index & 0xFF00) >>> 8);
                break;
            }
            case 5: {
                this.registers.ALU8BitCp(this.registers.reg_index & 0xFF);
                break;
            }
            case 6: {
                this.registers.cpIndex8Bit(this.partC);
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeUpperIndexInstructions() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                this.decodeIndexGeneralBlock1();
                break;
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                this.decodeIndexGeneralBlock3();
                break;
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                this.decodeIndexGeneralBlock5();
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decode8BitLoadIndexed() throws ComputerException {
        if (this.partC == 6) {
            if (this.partB == 6) {
                throw new ComputerException("Unimplemented opcode detected");
            }
            this.registers.set8BitRegisterIndexed(this.registers.get8BitRegisterIndexed(this.partC), this.partB);
        } else if (this.partB == 6) {
            this.registers.set8BitRegisterIndexed(this.registers.get8BitRegisterIndexed(this.partC), this.partB);
        } else {
            this.decode8BitLoadIXIY();
        }
    }

    private void decode8BitLoadIXIY() {
        if (this.instruction == 118) {
            System.out.println("Program HALT");
            this.registers.decPC();
            this.halt = true;
        } else {
            this.registers.set8BitRegisterIXIY(this.registers.get8BitRegisterIXIY(this.partC), this.partB);
        }
    }

    private void decodeIndexGeneralBlock1() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.reg_index = this.registers.pop();
                break;
            }
            case 5: {
                this.registers.JPINDEX();
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                this.registers.LDSPINDEX();
            }
        }
    }

    private void decodeIndexGeneralBlock3() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                this.extendedIndexCB();
                break;
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                this.registers.EXSPIndex();
                break;
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexGeneralBlock5() throws ComputerException {
        switch (this.partB) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                this.extendedDD();
                break;
            }
            case 4: {
                this.registers.push(this.registers.reg_index);
                break;
            }
            case 5: {
                this.extendedED();
                break;
            }
            case 6: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 7: {
                this.extendedFD();
            }
        }
    }

    private void extendedIndexCB() throws ComputerException {
        this.tStates += 4;
        this.instruction = this.ram.readByte(this.registers.reg_PC + 1);
        this.partA = this.instA[this.instruction];
        this.partB = this.instB[this.instruction];
        this.partC = this.instC[this.instruction];
        switch (this.partA) {
            case 0: {
                this.decodeIndexCBShifts();
                break;
            }
            case 1: {
                this.decodeIndexCBBitTest();
                break;
            }
            case 2: {
                this.decodeIndexCBBitReset();
                break;
            }
            case 3: {
                this.decodeIndexCBBitSet();
            }
        }
        this.registers.incPC();
    }

    private void decodeIndexCBShifts() throws ComputerException {
        switch (this.partB) {
            case 0: {
                this.decodeShiftIndexed0();
                break;
            }
            case 1: {
                this.decodeShiftIndexed1();
                break;
            }
            case 2: {
                this.decodeShiftIndexed2();
                break;
            }
            case 3: {
                this.decodeShiftIndexed3();
                break;
            }
            case 4: {
                this.decodeShiftIndexed4();
                break;
            }
            case 5: {
                this.decodeShiftIndexed5();
                break;
            }
            case 6: {
                this.decodeShiftIndexed6();
                break;
            }
            case 7: {
                this.decodeShiftIndexed7();
                break;
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed0() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftRLCIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed1() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftRRCIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed2() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftRLIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed3() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftRRIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed4() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftSLAIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed5() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftSRAIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed6() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftSLLIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeShiftIndexed7() throws ComputerException {
        switch (this.partC) {
            case 0: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 1: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 2: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 3: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 4: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 5: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            case 6: {
                this.registers.shiftSRLIndexed();
                break;
            }
            case 7: {
                throw new ComputerException("Unimplemented opcode detected");
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexCBBitTest() throws ComputerException {
        switch (this.instruction) {
            case 70: {
                this.registers.testIndexBit(0);
                break;
            }
            case 78: {
                this.registers.testIndexBit(1);
                break;
            }
            case 86: {
                this.registers.testIndexBit(2);
                break;
            }
            case 94: {
                this.registers.testIndexBit(3);
                break;
            }
            case 102: {
                this.registers.testIndexBit(4);
                break;
            }
            case 110: {
                this.registers.testIndexBit(5);
                break;
            }
            case 118: {
                this.registers.testIndexBit(6);
                break;
            }
            case 126: {
                this.registers.testIndexBit(7);
                break;
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexCBBitReset() throws ComputerException {
        switch (this.instruction) {
            case 134: {
                this.registers.bitIndexReset(0);
                break;
            }
            case 142: {
                this.registers.bitIndexReset(1);
                break;
            }
            case 150: {
                this.registers.bitIndexReset(2);
                break;
            }
            case 158: {
                this.registers.bitIndexReset(3);
                break;
            }
            case 166: {
                this.registers.bitIndexReset(4);
                break;
            }
            case 174: {
                this.registers.bitIndexReset(5);
                break;
            }
            case 182: {
                this.registers.bitIndexReset(6);
                break;
            }
            case 190: {
                this.registers.bitIndexReset(7);
                break;
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    private void decodeIndexCBBitSet() throws ComputerException {
        switch (this.instruction) {
            case 198: {
                this.registers.bitIndexSet(0);
                break;
            }
            case 206: {
                this.registers.bitIndexSet(1);
                break;
            }
            case 214: {
                this.registers.bitIndexSet(2);
                break;
            }
            case 222: {
                this.registers.bitIndexSet(3);
                break;
            }
            case 230: {
                this.registers.bitIndexSet(4);
                break;
            }
            case 238: {
                this.registers.bitIndexSet(5);
                break;
            }
            case 246: {
                this.registers.bitIndexSet(6);
                break;
            }
            case 254: {
                this.registers.bitIndexSet(7);
                break;
            }
            default: {
                throw new ComputerException("Unimplemented opcode detected");
            }
        }
    }

    static {
        timeSlice = 100L;
        oneMHz = 1000000L;
        sampleMS = 10L;
        HALT = 118;
    }
}

