/*
 * Decompiled with CFR 0.152.
 */
package net.espley.processor;

import net.espley.microprocessor.IBaseDevice;
import net.espley.processor.Computer;
import net.espley.processor.PropertyStatus;

public class NMI
implements IBaseDevice {
    private Computer computer;
    private static final int NMIFlag = 8;

    public NMI(Computer computer) {
        this.computer = computer;
        this.reset();
    }

    public boolean supportsMemoryReads() {
        return false;
    }

    public boolean supportsMemoryWrites() {
        return false;
    }

    public boolean supportsIOReads() {
        return false;
    }

    public boolean supportsIOWrites() {
        return true;
    }

    public int memoryRead(int address) {
        return 0;
    }

    public void memoryWrite(int address, int data) {
    }

    public int IORead(int address) {
        return 0;
    }

    public void IOWrite(int address, int data) {
        if (address == 0 && (data & 8) != 0) {
            if (PropertyStatus.getInstance().getLogging()) {
                System.out.println("NMI requested");
            }
            this.computer.setNMI();
        }
    }

    public void reset() {
        if (PropertyStatus.getInstance().getLogging()) {
            System.out.println("NMI Reset");
        }
    }

    static {
        NMIFlag = 8;
    }
}

