;   
; SYSTEM FUNCTIONS MODULE
; COPYRIGHT 1976 D. KRUGLINSKI
; SYSTEM CALL, MOVE, ACCELERATION, RANDOM
;
MSTRT	EQU	0C00H	;LOAD ADDRESS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MACROS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; COMPLEMENT HL
COMHL	MACRO
	MOV	A,H
	CMA
	MOV	H,A
	MOV	A,L
	CMA
	MOV	L,A
	INX	H
	ENDM
; LOAD HL INDEXED (BC=BASE)
LDBLX	MACRO	OFSET
	PUSH	D
	LXI	H,OFSET
	DAD	B
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	POP	D
	ENDM
; STORE HL INDEXED (BC=BASE)
SDBLX	MACRO	OFSET
	PUSH	D
	XCHG
	LXI	H,OFSET
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	POP	D
	ENDM
; LOAD REG INDEXED (BC=BASE)
;  HL DESTROYED
LOADX	MACRO	REG,OFSET
	LXI	H,OFSET
	DAD	B
	MOV	REG,M
	ENDM
; STORE REG INDEXED (BC=BASE)
;  HL DESTROYED
STORX	MACRO	REG,OFSET
	LXI	H,OFSET
	DAD	B
	MOV	M,REG
	ENDM
;
	ORG	38H	;RST 7 ADDRESS
	JMP	SYSCL
	ORG	MSTRT	;LOAD ADDRESS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SYSTEM CALL FUNCTION
;	ENTERED ON RST 7 FOLLOWED BY FUNCTION #
;      DESTROYS HL ONLY
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SYSCL:	POP	H	;GET CALL # ADDR
	INX	H
	PUSH	H	;RETURN ADDRESS
	DCX	H	;CALL # ADDRESS
	PUSH	D	;SAVE DE
	MOV	E,M
	MVI	D,0	;CALL # IN DE
	LXI	H,CALTB	;CALL TABLE BASE
	DAD	D
	DAD	D	;ADD #
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG		;ADDR IN HL
	POP	D	;RESTORE DE
	PCHL		;JUMP TO SUBROUTINE
CALTB:	DW	MOVE
	DW	ACCEL
	DW	RAND
	DW	0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GENERAL PURPOSE MOVE FUNCTION
; ASSUMES FIRST OBJECT BLOCK LOCATIONS AS FOLLOWS:
;	0	X(N)
;	1
;	2	X(N-1)
;	3
;	4	X ACCELERATION
;	5
;	6	Y(N)
;	7
;	8	Y(N-1)
;	9
;	A	Y ACCELERATION
;	B
;	C	POINTER TO 'MBEAM' INSTR
;	D
; CALL: SCALL 0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MOVE:	PUSH	B	;SAVE BC
	CALL	MOV1	;UPDATE X
	CALL	MOV1	;UPDATE Y
	LDAX	B	;INST PNTR IN DE
	MOV	E,A
	INX	B
	LDAX	B
	MOV	D,A
	INX	D	;X COORD ADDRESS
	POP	B	;ORIG BC (TOP OF LIST)
	LOADX	A,1	;X(N) H.O.
	ADI	80H	;ZERO AT SCREEN CENTER
	STAX	D	;X COORD
	INX	D	;Y COORD ADDR
	LOADX	A,7	;Y(N) H.O.
	ADI	80H	;ZERO AT SCREEN CENTER
	STAX	D	;Y COORD
	RET
; UPDATE EITHER X OR Y
MOV1:	PUSH	B	;SAVE BC FOR X(N)
	LDAX	B	;X(N) TO DE
	MOV	E,A
	INX	B
	LDAX	B
	MOV	D,A
	INX	B	;-X(N-1) TO HL
	LDAX	B	; AND DE TO NEW X(N-1)
	CMA
	MOV	L,A
	MOV	A,E
	STAX	B
	INX	B
	LDAX	B
	CMA
	MOV	H,A
	MOV	A,D
	STAX	B
	INX	H
	DAD	D	;HL+DE+DE TO HL
	DAD	D
	INX	B	;XACC TO DE
	LDAX	B
	MOV	E,A
	INX	B
	LDAX	B
	MOV	D,A
	DAD	D	;HL+XACC TO HL
	POP	D	;BC FOR X(N)
	MOV	A,L	;HL TO NEW X(N) 
	STAX	D
	INX	D
	MOV	A,H
	STAX	D
	INX	B	;SETUP FOR NEXT BYTE
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ORBITAL ACCELERATION LOOKUP FUNCTION
;	1024-VALUE VERSION (2 BYTES/VALUE)
;	CALL:	SCALL	1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
ATAB	EQU	0E00H	;LOCATION OF ACC TABLE
XN	SET	0
XACC	SET	4
YN	SET	6
YACC	SET	0AH
;   ADJUST X & Y FOR TABLE LOOKUP & SET SHIFT COUNT
ACCEL:	MVI	A,3
	STA	SHCNT	;SET SHIFT COUNT (6 SHIFTS)
	LDBLX	XN	;X VALUE
	MOV	A,H
	STA	HOXN	;SAVE H.O. X
	CPI	0
	JP	POSX	;ABS VALUE X
	COMHL
POSX:	XCHG		;IN DE
	LDBLX	YN	;Y VALUE
	MOV	A,H
	STA	HOYN	;SAVE H.O. Y
	CPI	0
	JP	POSY	;ABS VALUE OF Y
	COMHL
POSY:	MOV	A,H	;IN HL
	ORA	D	;COMBINE H.O. X & Y
	CPI	40H
	JP	GETAD	;JUMP IF > OR = 40H
	DAD	H	;DOUBLE Y IN HL
	XCHG
	DAD	H	;DOUBLE X IN DE
	XCHG
	LDA	SHCNT
	DCR	A
	STA	SHCNT	;DECREMENT SHIFT COUNT
	JNZ	POSY	;LOOP IF > 0
;   COMPUTE XACC TABLE OFFSET FROM X & Y (IN DE)
GETAD:	MOV	A,D	;H.O. X
	RRC
	RRC
	RRC
	RRC		;ROTATE RIGHT 4
	MOV	E,A
	ANI	7H
	MOV	D,A	;H.O. TABLE OFFSET
	MOV	A,E
	ANI	0C0H
	MOV	E,A
	MOV	A,H	;H.O. Y
	RRC
	ANI	3EH
	ORA	E
	MOV	E,A	;L.O. TABLE OFFSET
	PUSH	D	;SAVE OFFSET FOR LATER
	CALL	RETRV	;GET ACC VAULE
;   MAKE XACC SIGN AGREE WITH -X COORD
	LDA	HOXN	;H.O. X VALUE
	CPI	0	;TEST SIGN
	JM	XMINS
	COMHL		;POS - COMP XACC
XMINS:	SDBLX	XACC	;STORE IN OBJ BLK
;   COMPUTE YACC TABLE OFFSET FROM XACC OFFSET
	POP	H	;XACC OFFSET IN HL
	MOV	A,L
	RRC
	RRC
	RRC
	MOV	E,A
	ANI	7H
	MOV	D,A	;H.O. TABLE OFFSET
	MOV	A,E
	ANI	0C0H
	MOV	E,A
	MOV	A,L
	ANI	0C0H
	ORA	H
	RLC
	RLC
	RLC
	ORA	E
	MOV	E,A	;L.O. OFFSET
	CALL	RETRV	;GET YACC VALUE
;   MAKE YACC SIGN AGREE WITH -Y COORD
	LDA	HOYN
	CPI	0
	JM	YMINS
	COMHL
YMINS:	SDBLX	YACC	;STORE YACC IN OBJ BLK
	RET		;RETURN TO CALLING PROGRAM
;
; SUBROUTINE TO RESTORE ACC VALUE FROM TABLE TO HL
;  AND ADJUST ACC BY SHIFT COUNT
;  INPUT: OFFSET IN DE
RETRV:	LXI	H,ATAB	;TABLE BASE
	DAD	D	;ADD OFFSET
	MOV	E,M
	INX	H
	MOV	D,M	;DATA IN DE
	PUSH	B
	LDA	SHCNT	;SAVE SHIFT COUNT IN B
	MOV	B,A
	CPI	0
	JZ	EXIT	;SHIFT COUNT=0
;   SHIFT DE RIGHT 2 (DE < 1000)
	MOV	A,D
	RRC
	RRC
	MOV	D,A
	MOV	A,E
	RRC
	RRC
	PUSH	PSW	;SAVE CARRY FOR ROUNDING
	ANI	3FH
	ORA	D
	MOV	E,A
	MVI	D,0
;   DECREMENT & TEST SHIFT COUNT
LOOP:	DCR	B
	JZ	ROUND	;DONE SHIFTING
;   SHIFT E RIGHT 2 (D=0)
	POP	PSW	;SANE STACK
	MOV	A,E
	RRC
	RRC
	PUSH	PSW	;SAVE CARRY
	ANI	3FH
	MOV	E,A
	JMP	LOOP
ROUND:	POP	PSW	;RESTORE CARRY FROM LAST SFT
	MOV	A,E	;L.O. ACC
	ACI	0	;ROUND
	MOV	E,A	;RESTORE E
EXIT:	XCHG		;ACC IN HL
	POP	B	;RESTORE INDEX REG
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; RANDOM NUMBER FUNCTION
;   GENERATES A NEW RANDOM NUMBER IN A AND 'RND'
;   CALL:	SCALL 	2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
RAND:	LXI	H,RND
	MOV	A,M
	CPI	0
	JNZ	RANSKP
	INR	A
RANSKP:
	MOV	M,A
	STC
	ANI	8EH	;FEEDBACK MASK,CLEAR CARRY
	JPE	CLEAR	;XOR FEEDBACK BITS
	CMC		;SET CARRY IF XOR TRUE
CLEAR:	MOV	A,M	;RESTORE RND
	RAL		;SHIFT IN CARRY
	MOV	M,A	;IN MEMORY
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; WORKING STORAGE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
RND:	DB	23H	;RANDOM NUMBER
HOXN:	DB	0	;H.O. X VALUE
HOYN:	DB	0	;H.O. Y VALUE
SHCNT:	DB	0	;ACC SHIFT COUNT
	END
