;    
;INTERRUPT HANDLERS & EXECUTIVE MODULE
; COPYRIGHT 1976 D. KRUGLINSKI
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SYSTEM LINKAGES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ESTRT	EQU	300H	;LOAD ADDRESS
TADR	EQU	42H	;ADDRESS OF # TASKS
;			 FOLLOWED BY DISPATCH TABLE
KINTA	EQU	10H	;KBRD INT ADDR
CINTA	EQU	18H	;RTC INT ADDR
KINTC	EQU	0FFC1H	;KBRD INT CONROL ADDR
KDCOD	EQU	44H	;KEYBOARD DECODER ADDR
TIME	EQU	3FH
	ORG	KINTA	;KEYBOARD INTERRUPT
	JMP	KBENT	;HANDLER ADDR
	ORG	CINTA	;RTC INTERRUPT
	JMP	CENT	;CLOCK HANDLER
	ORG	TIME
	DB	0
	ORG	KDCOD
	DW	KBDCD	;DUMMY KB DECODER
	ORG	ESTRT
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; HANDLER FOR REAL-TIME CLOCK OR 'EXEC' COMMAND
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CENT:	PUSH	PSW
	PUSH	H	;SAVE ALL REGS
	LXI	H,TIME
	INR	M	;INCREMENT TIME
	LXI	H,TIME-1
	MVI	A,1
	CMP	M
	JZ	CENTX
	MOV	M,A
	PUSH	B
	PUSH	D
	EI		;ENABLE INTERRUPT
	JMP	EXECU	;GO TO EXECUTIVE
CENTX:
	POP	H	;RESTORE REGS
	POP	PSW
	EI
	RET		;RETURN TO GRAPHICS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; HANDLER FOR KEYBOARD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
KBENT:	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	LDA	KINTC	;REAC CHAR/CLEAR
	EI
	LXI	H,HRTN
	PUSH	H	;SAVE RETURN ADDR
	LHLD	KDCOD	;KEYBOARD DECODER
	PCHL		;SIMULATED 'CALL'
HRTN:	POP	H
	POP	D
	POP	B
	POP	PSW
	RET		;RTNNTERRUPTED PGM
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; EXECUTIVE -- SCANS DISPATCH TABLE, DISPATCHES
;  PROGRAM WITH OBJECT BLOCK WHEN TIMES MATCH
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
EXECU:	LXI	H,TIME
	MOV	B,M	;SAVE TIME IN B
	LHLD	TADR	;# OF TASKS
	MOV	C,M
	INX	H	;TOP OF DISPATCH TABLE
	LXI	D,5
ELOOP:	MOV	A,M
	ANA	B	;MASK TIME FOR TASK
	INX	H
	CMP	M	;COMPARE OBJECT TIME
	JNZ	NOTEQ	;DISPATCH IF EQUAL
	PUSH	B	;SAVE BC (TIME & #)
	INX	H
	MOV	C,M
	INX	H
	MOV	B,M	;OBJECT BLOCK ADDR IN BC
	INX	H
	MOV	E,M
	INX	H
	MOV	D,M	;PROGRAM ADDR IN DE
	INX	H
	PUSH	H	;SAVE HL (POINTER IN LIST)
	LXI	H,ERTN
	PUSH	H	;SAVE RETURN ADDRESS
	XCHG		;PROGRAM ADDRESS IN HL
	PCHL		;JUMP TO PROGRAM (CALL)
ERTN:	POP	H	;RESTORE POINTER
	POP	B	;RESTORE BC
	LXI	D,5
	JMP	ENDL	;CONTINUE SCANNING TABLE
NOTEQ:	DAD	D	;HL=HL+5
ENDL:	DCR	C	;DECREMENT TASK CNT
	JNZ	ELOOP	;TEST NEXT TASK
	LXI	H,TIME-1
	MVI	M,0
	POP	D
	POP	B
	POP	H
	POP	PSW
	RET		;RETURN TO HANDLER
;   
;SPACE WAR APPLICATIONS MODULE
; COPYRIGHT 1976 D. KRUGLINSKI
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; IMPORTANT CONSTANTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ASTRT	EQU	500H	;LOAD ADDRESS
BADR1	EQU	0FFFEH	;BUTTON READ ADDRESS
SUN	EQU	7	;COLLISION RAD OF SUN
INTVL	EQU	18H	;DURATION OF EXPLOSION
EPSLN	EQU	8H	;COLLSIION RAD OF TORPEDOS
ACON	EQU	8	;ACCELERATION CONSTANT
RMAX	EQU	12	;TORPEDO TIMEOUT
VCON	EQU	300H	;TORPEDO RELATIVE VELOCITY
HDLY	EQU	20H	;HYPERSPACE EXIT DELAY
LIMIT	EQU	7AH	;SCREEN EDGE
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; MACROS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; GRAPHICS MACROS
MBEAM	MACRO	X,Y
	DB	0
	DB	X
	DB	Y
	ENDM
;
MDISP	MACRO	X,Y
	DB	2
	DB	X
	DB	Y
	ENDM
;
LVEC	MACRO	X,Y
	DB	4
	DB	X
	DB	Y
	ENDM
;
SVEC	MACRO
	DB 	6
	ENDM
SV	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4)
	ENDM
SVF	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 8H
	ENDM
SVE	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 80H
	ENDM
SVEF	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 88H
	ENDM
;
PARAM	MACRO	SCL,ORN
	DB	8
	DB	ORN OR (SCL SHL 4)
	ENDM
;
JUMP	MACRO	ADDR
	DB	0AH
	DW	ADDR
	ENDM
;
JUMPS	MACRO	ADDR
	DB	0CH
	DW	ADDR
	ENDM
;
RETS	MACRO
	DB	0EH
	ENDM
;
EXEC	MACRO
	DB	10H
	ENDM
;
; ENTRY MACRO FOR DISPATCH TABLE
ENTRY	MACRO	MASK,TIME,OBJ,PROG
	DB	MASK
	DB	TIME
	DW	OBJ
	DW	PROG
	ENDM
;
; SYSTEM CALL MACRO
SCALL	MACRO	MODN
	RST	7
	DB	MODN
	ENDM
;
; MACRO TO CREATE 12-BYTE COORDINATE BLK
COORD	MACRO	XN,XM,XAC,YN,YM,YAC
	DW	XN
	DW	XM
	DW	XAC
	DW	YN
	DW	YM
	DW	YAC
	ENDM
;
; MACRO TO LOAD REG INDEXED (BC=BASE)
;  DESTROYS HL
LOADX	MACRO	REG,OFSET
	LXI	H,OFSET
	DAD	B
	MOV	REG,M
	ENDM
;
; MACRO TO STORE REG INDEXED (BC=BASE)
;  DESTROYS HL
STORX	MACRO	REG,OFSET
	LXI	H,OFSET
	DAD	B
	MOV	M,REG
	ENDM
;
; MACRO TO LOAD 2 BYTES FROM OFSET
; INTO HL (BC=BASE ADDR)
LDBLX	MACRO	OFSET
	PUSH	D
	LXI	H,OFSET
	DAD	B
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	POP	D
	ENDM
;
; MACRO TO STORE 2 BYTES IN OFSET
; FROM HL (BC=BASE ADDR)
SDBLX	MACRO	OFSET
	PUSH	D
	XCHG
	LXI	H,OFSET
	DAD	B
	MOV	M,E
	INX	H
	MOV	M,D
	POP	D
	ENDM
;
;MACRO TO TAKE ABSOLUTE VALUE OF A
ABS	MACRO
	CPI	0
	JP	POS	;JUMP IF A POS
	CMA		;COMPLEMENT A
POS:
	ENDM
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; LINKAGE BETWEEN SYSTEM AND APPLICATION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
TIME	EQU	3FH
NUMS	EQU	46H
	ORG	40H
	DW	START	;DISPLAY FILE
	ORG	42H
	DW	NTSK	;# TASKS + LIST
	ORG	44H
	DW	KBDCD	;KEYBOARD DECODE
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DISPATCH TABLE + NUMBER OF OBJECTS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ORG	ASTRT
NTSK:	DB	14	;# TASKS
; DISPATCH TABLE
IENT1:	ENTRY	0,0,SH1,INIT
IENT2:	ENTRY	0,0,SH2,INIT
PENT1:	ENTRY	0,1,SH1,SSTRT
PENT2:	ENTRY	0,1,SH2,SSTRT
	ENTRY	0,0,SH1,SFLY
	ENTRY	0,0,SH2,SFLY
	ENTRY	0,0,BU1,BFLY
	ENTRY	0,0,BU2,BFLY
GENT1:	ENTRY	0,1,SH1,FIRE
GENT2:	ENTRY	0,1,SH2,FIRE
	ENTRY	0FH,0,SC1,SCORE
	ENTRY	0FH,8,SC2,SCORE
	ENTRY	7H,2,SH1,ROT
	ENTRY	7H,6,SH2,ROT
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; OBJECT BLOCKS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   SHIP OBJECT BLOCKS
SH1:	COORD	0,0,0,0,0,0	;DYNAMIC COORDS
	DW	PPOS1	;PNTR TO MBEAM INSTR
;  START POSTN
	COORD	-6F00H,-7000H,0,6000H,6000H,0
	DW	BU1	;PNTR TO TORPEDO
	DW	PEXH1+1	;CALL EXHAUST/ZERO
	DW	SHIP1	;SHIP SUB
	DW	PSUB1+1	;CALL SHIP/EXPLO
	DW	PDIR1+1	;SHIP ORENT
	DW	PENT1	;BACK POINTER
	DW	GENT1	;FIRE ENTRY
	DW	SC1	;SCORE
	DB	01H	;ACC BUTTON MASK
	DB	02H	;FIRE MASK
	DB	04H	;CW MASK
	DB	08H	;CCW MASK
	DB	0	;INHIBIT FIRE
	DB	0	;ORIENTATION
	DW	BADR1	;BUTTON ADDRESS
	DB	0CH	;HYPERSPACE MASK
	DB	0	;HYPERSPACE FLAG
	DB	0	;INITIAL ORIENTATION
	DW	IENT1	;BACK PNTR TO INIT PGM
SH2:	COORD	0,0,0,0,0,0
	DW	PPOS2
	COORD	6F00H,7000H,0,-6000H,-6000H,0
	DW	BU2
	DW	PEXH2+1
	DW	SHIP2
	DW	PSUB2+1
	DW	PDIR2+1
	DW	PENT2
	DW	GENT2
	DW	SC2
	DB	10H
	DB	20H
	DB	40H
	DB	80H
	DB	0
	DB	0
	DW	BADR1
	DB	0C0H
	DB	0
	DB	4
	DW	IENT2
;   TORPEDO OBJECT BLOCKS
BU1:	COORD	0,0,0,0,0,0	;DYN COORDS
	DW	BPOS1	;PNTR TO MDISP INSTR
	DW	BU2	;PNTR TO NEXT TORPEDO
	DB	0	;COUNTDOWN SINCE FIRING
BU2:	COORD	0,0,0,0,0,0
	DW	BPOS2
	DW	0
	DB	0
;   SCORE OBJECT BLOCKS
SC1:	DB	0	;BINARY SCORE VAL
	DW	SC11+1	;1ST DIGIT
	DW	SC12+1	;2ND DIGIT
SC2:	DB	0
	DW	SC21+1
	DW	SC22+1
; WORKING STORAGE LOCATION
ORSAV:	DW	0
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DISPLAY FILE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
START:	EXEC
	MBEAM	80H,80H	;SUN
	PARAM	0,0
	JUMPS	SUNSB
PPOS1:	MBEAM	0,0E0H
PDIR1:	PARAM	1,0
PEXH1:	JUMPS	NULL
PSUB1:	JUMPS	SHIP1
PPOS2:	MBEAM	0,0C0H
PDIR2:	PARAM	1,0
PEXH2:	JUMPS	NULL
PSUB2:	JUMPS	SHIP2
BPOS1:	MBEAM	0,0
BPOS2:	MBEAM	0,0
	PARAM	1,0
	MBEAM	1,1
SC11:	JUMPS	NULL
SC12:	JUMPS	NULL
	MBEAM	0D0H,1
SC21:	JUMPS	NULL
SC22:	JUMPS	NULL
	JUMP	START
;
SUNSB:	SVEC
	SVF	6,0
	SV	3,2
	SV	3,3
	SV	6,4
	SV	3,5
	SV	6,6
	SV	3,7
	SV	6,0
	SV	3,1
	SVE	3,2
	RETS
;
SHIP1:	SVEC
	SVF	3,0
	SV	2,5
	SV	4,4
	SV	2,2
	SVF	2,6
	SVF	4,0
	SVF	2,1
	SV	2,3
	SV	4,4
	SVE	2,6
	RETS
SHIP2:	SVEC
	SV	3,0
	SV	2,5
	SV	4,4
	SV	2,2
	SVF	2,6
	SVF	4,0
	SVF	2,1
	SV	2,3
	SV	4,4
	SVE	2,6
	RETS
EXPLO:	PARAM	2,0
	SVEC
	SVF	3,0
	SV	6,4
	SVF	3,2
	SV	6,7
	SVF	3,4
	SV	6,2
	SVF	3,0
	SVE	6,5
	RETS
NULL:	RETS
EXHST:	SVEC
	SV	7,4
	SVEF	7,0
	RETS
;
; *********** PROGRAMS *************
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   INITIALIZATION PROGRAM
;  SCHEDULED AT START & BY CTL C
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SCPNT	SET	28H
IEPNT	SET	35H
PEPNT	SET	24H
INIT:	LDBLX	SCPNT	;GET SCORE ADDR
	MVI	M,0	;ZERO SCORE
	LDBLX	PEPNT	;GET ADDR OF SHIP ST
	INX	H	;TIME
	MVI	M,0	;SCHED SHIP START
	LDBLX	IEPNT	;ADDR OF INIT ENTRY
	INX	H
	MVI	M,1	;DESCHED SELF
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   SHIP START PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DC	SET	0
STCRD	SET	0EH
FBPNT	SET	1AH
EXPNT	SET	1CH
PLPNT	SET	1EH
PCPNT	SET	20H
PDPNT	SET	22H
ORENT	SET	2FH
HFLAG	SET	33H	;HYPERSPACE FLAG
IORNT	SET	34H	;INITIAL ORIENTATION
; SELECT ACCORDING TO HFLAG
SSTRT:	LOADX	A,HFLAG
	CPI	0
	JNZ	HYPR
;  CASE--H=0--NORMAL START--NOT HYPERSPACE
	CALL	STRT	;SHIP INST, DESCHED
	CALL	BEGIN	;ORENT=0,START POS
	RET
HYPR:	JM	HDEST
;  CASE--H=1--HYPERSPACE RETURN--NO DESTROY
	CALL	STRT
	CALL	HCORD	;RANDOM COORDINATES
	RET
;  CASE--H=-1--HYPERSPACE RETURN--DESTROY
HDEST:	CALL	DSTRY
	CALL	HCORD	;RAND COORDS
	RET
; ENDSELECT
;
STRT:	LDBLX	PLPNT	;NORMAL START
	XCHG		;SHIP SUB ADDR IN DE
	LDBLX	PCPNT	;CALL ADDR IN HL
	MOV	M,E	;SHIP SUB -> CALL
	INX	H
	MOV	M,D
	LDBLX	PEPNT	;ENTRY ADDR
	MVI	M,0	;MASK
	INX	H
	MVI	M,1	;DESCHED SELF
	RET
;
BEGIN:	LOADX	A,IORNT	;SET ORIENTATION
	STORX	A,ORENT
	LXI	H,STCRD	;START COORD
	DAD	B	;  ADDR IN HL
	MVI	D,12	;12 BYTES TO MOVE
PXLOP:	MOV	A,M	; FROM START COORDS
	STAX	B	; TO DYN COORDS
	INX	H
	INX	B
	DCR	D
	JNZ	PXLOP
	RET
;
HCORD:	SCALL	2	;RANDOM BYTE IN A
	STORX	A,XN+1	;H.O. X COORD
	STORX	A,XNM+1
	SCALL	2
	STORX	A,YN+1	;H.O. Y COORD
	STORX	A,YNM+1
	SCALL	2
	STORX	A,XN	;L.O. X (VELOCITY)
	SCALL	2
	STORX	A,XNM
	SCALL	2
	STORX	A,YN	;L.O. Y
	SCALL	2
	STORX	A,YNM
	MVI	A,0	;ZERO HYPERSPACE FLAG
	STORX	A,HFLAG
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   SHIP FLY PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
XN	SET	0H
YN	SET	6H
XNM	SET	2H
YNM	SET	8H
XACC	SET	04H
YACC	SET	0AH
INPNT	SET	0CH
NBPNT	SET	0EH
RCNT	SET	10H	;TORPEDO TIMEOUT
FIPNT	SET	26H
ACCM	SET	2AH
FIREM	SET	2BH
CWM	SET	2CH
CCWM	SET	2DH
HYPM	SET	32H	;HYPERSPACE MASK
FINH	SET	2EH
BAPNT	SET	30H
ACON1	EQU	(5*ACON)/7
SFLY:	SCALL	0	;MOVE SHIP/EXPLO
	SCALL	1	;ACCELERATE
; TEST BUTTONS ONLY IF NOT IN HYPERSPACE
	LOADX	A,HFLAG
	CPI	0
	RNZ
;  CHECK IF ACC BUTTON ON
	LDBLX	BAPNT	;BUTTON ADDR
	MOV	D,M	;BUTTON WORD
	LOADX	A,ACCM	;ACC MASK
	ANA	D
	LXI	D,NULL	;NO EXHAUST
	JZ	XHST	;NO ACCELERATION
	MVI	D,0
	LOADX	E,ORENT
	LXI	H,XATAB
	DAD	D
	DAD	D	;X ACC ADDR FOR ORENT
	MOV	E,M	;XACC L.O.
	INX	H
	MOV	D,M	;XACC H.O.
	LDBLX	XACC	;ADD TO ORIGINAL
	DAD	D
	SDBLX	XACC
;  SAME LOGIC FOR YACC
	MVI	D,0
	LOADX	E,ORENT
	LXI	H,YATAB
	DAD	D
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	LDBLX	YACC
	DAD	D
	SDBLX	YACC
	LXI	D,EXHST	;EXHAUST
XHST:	LDBLX	EXPNT	;INSERT EXHAUST/ZERO
	MOV	M,E	;IN DISPLAY FILE
	INX	H
	MOV	M,D
;  TEST IF X NEAR EDGE
ETST:	LOADX	A,XN+1
	ABS
	CPI	LIMIT
	CP	SWAPX	;YES
;  TEST IF Y NEAR EDGE
	LOADX	A,YN+1
	ABS
	CPI	LIMIT
	CP	SWAPY	;YES
;  SHIP HIT SUN?
	LOADX	A,XN+1
	ABS
	CPI	SUN	;H.O. X < SUN RADIUS
	JP	BTST
	LOADX	A,YN+1
	ABS
	CPI	SUN	;H.O. Y < SUN RADIUS
	JP	BTST
	CALL	DSTRY
	RET
;  TEST FOR CLOSE TORPEDOS
BTST:	LOADX	D,DC+1	;HO X POS OF SHIP
	LOADX	E,DC+7	;HO Y POS OF SHIP
	PUSH	B	;SAVE SHIP BLK PNTR
	LXI	H,BU1	;FIRST TORPEDO BLK PNTR
FLOOP:	MOV	B,H	;HL ->BC
	MOV	C,L
	LOADX	A,RCNT	;TORPEDO CLAIMED?
	CPI	0	;TEST FOR ZERO
	JZ	NXBUL	;NEXT TORPEDO
NRTST:	LOADX	A,DC+1	;HO X POS OF TORPEDO
	SUB	D
	ABS
	CPI	EPSLN
	JP	NXBUL	;NOT CLOSE ENOUGH
	LOADX	A,DC+7	;HO Y POS OF TORPEDO
	SUB	E	;SUBT SHIP POS
	ABS
	CPI	EPSLN
	JM	HIT	;BOTH CLOSE ENOUGH
NXBUL:	LDBLX	NBPNT	;NEXT TORPEDO PNTR
	SUB	A	;ZERO A
	CMP	H	;CHECK OF H 0
	JNZ	FLOOP	;NO
	CMP	L
	JNZ	FLOOP	;L NOT 0
	POP	B	;SANE STACK
	RET		;BOTH H&L ZERO
HIT:	LDBLX	INPNT	;TORPEDO POSTION
	MVI	M,0	;MBEAM INSTR (BLANK)
	MVI	A,0	;RELEASE TORPEDO
	STORX	A,RCNT
	POP	B	;RESTORE SHIP BLK
	CALL	DSTRY
	RET
;  SUBROUTINE TO INCREMENT SCORE, SCHED
;  SHIP START AND REPLACE SHIP WITH EXPLOSION
;  ALSO USED IN HYPERSPACE PROCESSING
DSTRY:	LDBLX	SCPNT	;RESTORE SCORE ADDR
	MOV	A,M	;INCREMENT SCORE
	INR	A
	DAA
	MOV	M,A
;  SCHED SHIP START
	LDBLX	PEPNT	;SHIP ENTRY ADDR
	MVI	M,-1	;MASK = -1
	LDA	TIME
	ADI	INTVL
	INX	H
	MOV	M,A	;TIME+INTVAL TO PL ST
;  REPLACE SHIP WITH EXPLOSION
	LXI	D,EXPLO	;EXPLO SUB
	LDBLX	PCPNT	;SUB CALL
	MOV	M,E
	INX	H
	MOV	M,D
	RET
;
SWAPX:	LDBLX	XN	;SWAP X COORDS
	XCHG
	LDBLX	XNM
	SDBLX	XN
	XCHG
	SDBLX	XNM
	RET
;
SWAPY:	LDBLX	YN	;SWAP Y COORDS
	XCHG
	LDBLX	YNM
	SDBLX	YN
	XCHG
	SDBLX	YNM
	RET
;
;  ACCELERATION TABLE
XATAB:	DW	0
	DW	ACON1
YATAB:	DW	ACON
	DW	ACON1
	DW	0
	DW	-ACON1
	DW	-ACON
	DW	-ACON1
	DW	0
	DW	ACON1
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   TORPEDO FLY PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BFLY:	SCALL	1	;ACCELERATION LOOKUP
	SCALL	0	;MOVE TORPEDO
;  TEST IF X NEAR SCREEN EDGE
	LOADX	A,DC+1	;HO X POS OF TORPEDO
	ABS		;ABS VALUE OF X
	CPI	LIMIT	;SUBTRCT LIMIT
	JP	BLANK	;NEAR EDGE IF + OR 0
;  TEST IF Y NEAR EDGE
	LOADX	A,DC+7	;HO Y POS OF TORPEDO
	ABS
	CPI	LIMIT
	JP	BLANK	;NOT NEAR EDGE
;  TORPEDO HIT SUN
	LOADX	A,XN+1
	ABS
	CPI	SUN
	RP		;RETN IF NOT
	LOADX	A,YN+1
	ABS
	CPI	SUN
	RP	;RETURN IF NOT
BLANK:	LDBLX	INPNT	;MBEAM/MDISP INST
	MVI	M,0	;MBEAM
	MVI	A,0
	STORX	A,RCNT	;RELEASE TORPEDO
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   TORPEDO FIRE PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GEPNT	SET	26H
RCON	EQU	EPSLN*140H
VCON1	EQU	(5*VCON)/7
FIRE:	LDBLX	GEPNT	;DISPATCH TABLE ENTRY FOR SHIP
	INX	H
	MVI	M,1	;DESCHEDULE SELF
	LOADX	A,ORENT
	ADD	A	;DOUBLE ORIENTATION
	MOV	L,A	;SAVE FOR LATER
	MVI	H,0
	SHLD	ORSAV
	LDBLX	FBPNT	;PNTR TO 1ST TORPEDO ->HL
	PUSH	B	;SAVE SHIP BLOCK BASE
;  FIND FREE TORPEDO
	MOV	B,H	;HL -> BC
	MOV	C,L
	LOADX	A,RCNT	;TEST FOR CLAIMED TORPEDO
	CPI	0
	JZ	SHOOT	;NOT CLAIMED
	POP	B	;SANE STACK
	RET		;NO FREE TORPEDOS
;  SHOOT A TORPEDO
SHOOT:	LDBLX	INPNT	;UNBLANK TORPEDO
	MVI	M,2	; 'MDISP'
	MVI	A,RMAX	;SET TIMEOUT COUNTER
	STORX	A,RCNT	; TO CLAIM TORPEDO
	POP	H	;SHIP OBJ BLK IN HL
	MVI	D,10	;10 BYTES TO MOVE
XLOOP:	MOV	A,M	;BYTE FROM SHIP COORDS
	STAX	B	;  INTO TORPEDO COORDS
	INX	H	;NEXT BYTE
	INX	B
	DCR	D	;DECREMENT CNTR
	JNZ	XLOOP	;NOT DONE YET
	LXI	H,-10
	DAD	B	;RESTORE TORPEDO BLK
	MOV	B,H
	MOV	C,L
;  COMPUTE INITIAL TORPEDO COORDINATES
;  X(N-1) & Y(N-1) ARE SHIP'S + COLLISION RAD
;  X(N) & Y(N) ARE SHIP'S + VELOCITY + COLL RAD
	LHLD	ORSAV
	LXI	D,XVTAB	;X VELOCITY TABLE
	DAD	D
	MOV	E,M	;XVEL IN DE
	INX	H
	MOV	D,M
	LDBLX	XN
	DAD	D	;ADD VEL+COLL TO X(N)
	SDBLX	XN
;
	LHLD	ORSAV
	LXI	D,XRTAB	;COLL RAD TABLE
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	LDBLX	XNM
	DAD	D	;ADD COLL TO X(N-1)
	SDBLX	XNM
;
	LHLD	ORSAV
	LXI	D,YVTAB
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	LDBLX	YN
	DAD	D	;ADD VEL+COLL TO Y(N)
	SDBLX	YN
;
	LHLD	ORSAV
	LXI	D,YRTAB
	DAD	D
	MOV	E,M
	INX	H
	MOV	D,M
	LDBLX	YNM
	DAD	D	;ADD COLL TO Y(N-1)
	SDBLX	YNM
	RET
;  COLLISION RADIUS TABLES
XRTAB:	DW	0
	DW	RCON
YRTAB:	DW	RCON
	DW	RCON
	DW	0
	DW	-RCON
	DW	-RCON
	DW	-RCON
	DW	0
	DW	RCON
;  H.O. VELOCITY + COLL RAD TABLES
XVTAB:	DW	0
	DW	VCON1+RCON
YVTAB:	DW	VCON+RCON
	DW	VCON1+RCON
	DW	0
	DW	-VCON1-RCON
	DW	-VCON-RCON
	DW	-VCON1-RCON
	DW	0
	DW	VCON1+RCON
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   SCORE PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SCRE	SET	0
SDIG1	SET	1
SDIG2	SET	3
SCORE:	LOADX	A,SCRE	;SCORE VALUE
	ANI	0FH	;RIGHT DIGIT
	RLC		;*2
	ADI	NUMS	;INDEX OF SUBR IN HL
	MVI	H,0
	MOV	L,A
	MOV	E,M	;SUBR ADDR IN DE
	INX	H
	MOV	D,M
	LDBLX	SDIG2	;PNTR TO DIGIT
	MOV	M,E	;SUBR ADDR IN DISPL FILE
	INX	H
	MOV	M,D
	LOADX	A,SCRE	;SCORE VALUE
	ANI	0F0H	;LEFT DIGIT
	RRC		;JUSTIFY & *2
	RRC
	RRC
	ADI	NUMS
	MVI	H,0
	MOV	L,A
	MOV	E,M
	INX	H
	MOV	D,M
	LDBLX	SDIG1
	MOV	M,E
	INX	H
	MOV	M,D	;LEFT DIG IN DISPL FILE
	RET		;RETURN
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   PROGRAM TO ROTATE SHIPS, INITIATE TORPEDO FIRE,
;   DO HYPERSPACE PROCESSING & CHECK
;   FOR SPENT TORPEDOS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; DON'T CHECK BUTTONS IF ALREADY IN HYPERSPACE
ROT:	LOADX	A,HFLAG
	CPI	0
	JNZ	SPNCK	;CHECK FOR SPENT BULLETS ANYWAY
	LDBLX	BAPNT
	MOV	D,M	;BUTTON WORD
;  CHECK FOR BOTH CW AND CCW,
;  INDICATING HYPERSPACE
	LOADX	A,HYPM	;MASK FOR HYPERSPACE
	MOV	E,A
	ANA	D
	XRA	E
	JNZ	CWCK	;NO - CHECK FOR CW
;  BLANK SHIP
	LXI	D,NULL	;NULL GRAPHICS SUB
	LDBLX	PCPNT	;PNTR TO CALL
	MOV	M,E
	INX	H
	MOV	M,D	;INSERT
;  SCHEDULE SHIP START AFTER HDLY
	LDBLX	PEPNT	;SHIP START ENTRY
	MVI	M,-1
	LDA	TIME
	ADI	HDLY
	INX	H
	MOV	M,A
;  SEE IF WE NEED TO DESTROY SHIP LATER
	MVI	D,1
	SCALL	2	;RANDOM # IN A
	CPI	0	;> ZERO
	JP	NODST	;YES--DON'T DESTRY
	MVI	D,-1	;NO--DESTRY
NODST:	STORX	D,HFLAG	;INDICATE TO SSHIP START PGM
	JMP	SPNCK
;  END OF HYPERSPACE PROCESSING
;  CHECK FOR CW (CLOCKWISE) ROTATION
CWCK:	LOADX	A,CWM	;MASK FOR CW
	ANA	D
	JZ	CCWCK	;CHECK FOR CCW
	LOADX	A,ORENT	;OLD ORIENTATION
	INR	A	;UP BY 1
	ANI	7
	STORX	A,ORENT
;  CHECK FOR CCW (COUNTERCLOCKWISE)
CCWCK:	LOADX	A,CCWM	;MASK FOR CCW
	ANA	D
	JZ	DINS
	LOADX	A,ORENT
	DCR	A	;DOWN BY 1
	ANI	7
	STORX	A,ORENT	;INSERT ORENT IN DISPLAY FILE
DINS:	LOADX	D,ORENT
	LDBLX	PDPNT	;ORENTATION IN DISPLAY
	MOV	A,M
	ANI	0F8H	;STRIP OLD ORENT BITS
	ORA	D	;INSERT NEW
	MOV	M,A
;  CHECK IF FIRE BUTTON ON
FIRCK:	LDBLX	BAPNT	;BUTTON ADDR
	MOV	D,M	;BUTTON WORD
	LOADX	A,FIREM	;FIRE MASK
	ANA	D
	JNZ	INCHK	;SEE IF INHIBIT
	MVI	A,0	;NO FIRE -- CLEAR INH
	STORX	A,FINH
	JMP	SPNCK
INCHK:	LOADX	A,FINH	;CHECK INHIBIT FLG
	CPI	0
	JNZ	SPNCK	;SET
	MVI	A,1	;NOT SET -- SET IT
	STORX	A,FINH
	LDBLX	FIPNT	;SCHEDULE TORPEDO FIRE
	INX	H
	MVI	M,0
;  CHECK FOR SPENT TORPEDOS
SPNCK:	LDBLX	FBPNT	; TORPEDO POINTER
;  FIND CLAIMED TORPEDO WITH TIMEOUT
;  FOR THIS SHIP
	MOV	B,H	;HL -> BC
	MOV	C,L
	LOADX	A,RCNT
	CPI	0	;TEST FOR CLAIMED
	RZ		;NOT CLAIMED
	DCR	A	;DECREMENT TIMER
	STORX	A,RCNT	;RESTORE IN BLOCK
	RNZ		;NOT ZERO YET
	LDBLX	INPNT
	MVI	M,0	;BLANK TORPEDO
	RET
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   KEYBOARD DECODE PROGRAM
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CTLC	EQU	'C'
KBDCD:	MOV	C,A	;SAVE	CHAR
	CPI	CTLC	;"C"?
	RNZ		;RETURN IF NOT
	LXI	H,IENT1+1	;SCHED INIT1
	MVI	M,0
	LXI	H,IENT2+1	;SCHED INIT2
	MVI	M,0
	RET
;
	END
