/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/Statbar.c 32    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\
  MITS Altair Emulator
  Status bar support code

  Copyright 1996 Paul Yao (from Windows 95 Programming book)
  Copyright (c) 2000-2016 Richard A. Cini (Altair32 modifications)

Change Log:
  2001/01/17  RAC -- Initial modifications
  2001/01/24  RAC -- Clean compile - works
  2001/08/19  RAC -- RELEASE MARKER -- v2.0
  2001/12/14  RAC -- RELEASE MARKER -- v2.1
  2002/01/31  RAC -- RELEASE MARKER -- v2.2
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2002/02/21  JJF -- Added extra panel for connection status
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/03/09  RAC -- Diff'ed more changes from FJS (Fred J. Scipione)
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2004/09/17  RAC -- Modifications to add "Devices" main menu item
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/08/08  RAC -- Added status bar part for joystick
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/
#define _CRT_SECURE_NO_WARNINGS			// BAD thing to do
#include <windows.h>	// required for all Windows applications
#include <commctrl.h>	// Windows common controls
#include "altair32.h"	// includes "resource.h" and exports from other major modules
#include "comcthlp.h"	// common control macros


typedef struct tagPOPUPSTRING{
	HMENU hMenu;
	UINT uiString;
} POPUPSTRING;

#define MAX_MENUS 6
#define IDM_ST_GETBORDERS 1
#define IDM_ST_GETPARTS   2
#define IDM_ST_SETTEXT    3
#define IDM_ST_SIMPLE     4
#define STATBAR_GUID	  2

static POPUPSTRING popstr[MAX_MENUS];

DWORD dwStatusBarStyles = WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | CCS_BOTTOM;


/***********************************************************************\
*  Initialize status bar
*  Called in WM_CREATE handler in MainWndProc
\***********************************************************************/
HWND InitStatusBar(HWND hwndParent)
{

    HLOCAL	hloc; 
	HWND	hwndSB;
	int		nParts = 7;	// status bar parts
    LPINT	lpParts; 
    RECT	rcClient; 

	// Initialize values for WM_MENUSELECT message handling
    HMENU hMenu = GetMenu(hwndParent);		//file
    HMENU hMenuAA = GetSubMenu(hMenu, 1);	//devices
	HMENU hMenuAB = GetSubMenu(hMenu, 2);	//tools
	HMENU hMenuAC = GetSubMenu(hMenu, 3);	//help
	popstr[0].hMenu    = 0;
	popstr[0].uiString = 0;
	popstr[1].hMenu    = hMenu;
	popstr[1].uiString = IDS_FILEMENU;
	popstr[2].hMenu    = hMenuAA;
	popstr[2].uiString = IDS_DEVICEMENU;
	popstr[3].hMenu    = hMenuAB;
    popstr[3].uiString = IDS_TOOLSMENU;
	popstr[4].hMenu    = hMenuAC;
	popstr[4].uiString = IDS_HELPMENU;
	popstr[5].hMenu    = 0;
	popstr[5].uiString = 0;

	// Create the status window
    hwndSB = CreateStatusWindow(dwStatusBarStyles, "Ready", hwndParent, STATBAR_GUID);
	 
	// Get the coordinates of the parent window's client area. 
	GetClientRect(hwndParent, &rcClient); 
 
	// Allocate an array for holding the right edge coordinates. 
	hloc = LocalAlloc(LHND, sizeof(int) * nParts); 
	lpParts = LocalLock(hloc); 
 
	// Calculate the right edge coordinate for each part, and 
	// copy the coordinates to the array. 
	lpParts[0] = rcClient.right - 350;		// "Ready" part
	lpParts[1] = rcClient.right - 310;		// CPU part	
	lpParts[2] = rcClient.right - 260;		// LPR part
 	lpParts[3] = rcClient.right - 175;		// disk drive part
	lpParts[4] = rcClient.right - 110;		// PTP part
	lpParts[5] = rcClient.right - 50;		// Connection type
	lpParts[6] = rcClient.right ;			// Joystick
	
	// Tell the status bar to create the window parts. 
	SendMessage(hwndSB, SB_SETPARTS, (WPARAM) nParts, (LPARAM) lpParts); 
 
	// Free the array, and return. 
	LocalUnlock(hloc); 
	LocalFree(hloc); 

	// Set default text items for each part
	Status_SetText(hwndSB, STATBAR_CPU, 0, "");					// CPU
	Status_SetText(hwndSB, STATBAR_LPR, 0, "LPR Off");			// printer
	Status_SetText(hwndSB, STATBAR_DISK, 0, "0 disks loaded");	// disks
	Status_SetText(hwndSB, STATBAR_CASS, 0, "Cass Off");		// cassette
	Status_SetText(hwndSB, STATBAR_CONS, 0, "");				// console
	Status_SetText(hwndSB, STATBAR_JOY, 0, "NoJoy");			// joystick
	return hwndSB;
}


/***********************************************************************\
*  Rebuild status bar
*  
\***********************************************************************/
HWND RebuildStatusBar(HWND hwndParent, WORD wFlag)
{
     HWND hwndSB;
     RECT r;

	 // wFlag based on settings in menu program that this code came from
     hwndSB = InitStatusBar(hwndParent);

     // Post parent a WM_SIZE message to resize children
     GetClientRect(hwndParent, &r);
     PostMessage(hwndParent, WM_SIZE, 0, MAKELPARAM (r.right, r.bottom));
     return hwndSB;
}


/***********************************************************************\
*  Status bar -- MenuSelect
*		Posts message to status bar based on menu item selected; 
*		called from MainWndProc.
\***********************************************************************/
LRESULT Statusbar_MenuSelect(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
     UINT fuFlags = (UINT) HIWORD(wParam);
     HMENU hMainMenu = NULL;
     int iMenu = 0;

     // Handle non-system popup menu descriptions.
     if ((fuFlags & MF_POPUP) &&
         (!(fuFlags & MF_SYSMENU)))
          {
          for (iMenu = 1; iMenu < MAX_MENUS; iMenu++)
               {
               if ((HMENU)lParam == popstr[iMenu].hMenu)
                    {
                    hMainMenu = (HMENU)lParam;
                    break;
                    }
               }
          }

     // Display helpful text in status bar
     MenuHelp(WM_MENUSELECT, wParam, lParam, hMainMenu, winstate.hInst, 
               hwndStatusBar, (UINT *) &popstr[iMenu]);

     return 0;
}
/* end of file: statbar.c */
