/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/windbg_sub.h 29    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\
  MITS Altair Emulator
  Integrated debugger subordinate window header
  No changes required for use with Altair32
 
  Copyright (c) 2000-2001 Jim Battle (Solace emulator project)
  Copyright (c) 2000-2016 Richard A. Cini

Change Log:
  2001/10/17  RAC -- Initial modificiations
  2001/12/14  RAC -- RELEASE MARKER -- v2.1
  2002/01/02  RAC -- Synched with Solace 3.0
  2002/01/31  RAC -- RELEASE MARKER -- v2.2
  2002/05/17  RAC -- Synched with Solace v3.1
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/01/20  RAC -- Diff'ed changes from FJS (Fred J. Scipione)
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/

#ifndef _WINDBGSUB_H_
#define _WINDBGSUB_H_

// typedef unsigned char uint8; <-- GCC CHANGE
// typedef unsigned int  uint32; <-- GCC CHANGE
// typedef unsigned char byte; <-- GCC CHANGE
// typedef signed char offset;   <-- GCC CHANGE


// types shared between windebug.c and its subordinate windows.

typedef struct tagDBGSTATE {

    BOOL active;			// FALSE=disabled
    BOOL valid_position;	// window size and position are known
    RECT position;			// window RECT
    int  xClient, yClient;	// client area
    HCURSOR hSplitCursor;	// handle to splitter cursor
    int  splitcursor;		// flag indicating if the new cursor is active
    RECT splitbar;			// location of splitter bar
    RECT splitrange;		// splitbar must remain inside this area
    int  splitpos;			// y client location of dragged split bar
    int  splitflag;			// TRUE if dragging the split bar
    int  splitpercent;		// dasm/log split is kept as a percentage

    HWND hRegWnd;		// register display window
    HWND hDasmWnd;		// disassembled output window
    HWND hMemWnd;		// memory display output window
    HWND hCmdWnd;		// command input window
    HWND hLogWnd;		// command output window

    // we attempt to use courier font, but failing that, we use
    // ANSI_FIXED_FONT.  thus, fixed_font is always defined, but
    // cour_font may or may not be.
    HFONT cour_font;	// courier new
    HFONT fixed_font;	// chosen fixed font
    int   fix_x;	// chosen font width (fixed pitch)
    int   fix_y;	// chosen font height (fixed pitch)
} dbgstate_t;

extern dbgstate_t dbgstate;


// scrollable window behaviors--
typedef enum tagWINACTION {
    WA_INIT,		// initialize window
    WA_DISABLE,		// disable the window
    WA_ENABLE,		// enable the window
    WA_LINEUP,		// go up one instruction
    WA_LINEDOWN,	// go down one instruction
    WA_PAGEUP,		// go up one page
    WA_PAGEDOWN,	// go down one page
    WA_GOTO,		// go to a specific line
    WA_DASMREFRESH,	// special for DASM window
} win_action_t;


// -------- function prototypes --------

// stuff exported by container window
void GrayOutWindow(HWND hwnd, HDC hdc);
void handle_fkey(UINT key);

// function prototypes and types exported by debug command edit subwindow
HWND CreateCmdWindow(HWND hwnd);
void RegisterCmdClass(void);
void InitEditHist(void);
void windbg_cmd_fwdchar(WPARAM wParam, LPARAM lParam);

// function prototypes and types exported by debug register window
void RegisterRegClass();
HWND CreateRegWindow(HWND hwnd);

// function prototypes and types exported by debug memory (stack) subwindow
void RegisterMemClass(void);
HWND CreateMemWindow(HWND hwnd);
void MemWindowAction(win_action_t action, word addr);

// function prototypes and types exported by debug window logging subwindow.
void RegisterLogClass(void);
HWND CreateLogWindow(HWND hwnd);
void LogWindowAction(win_action_t action, int line);

// function prototypes and types exported by debug disassembler window
void RegisterDasmClass();
HWND CreateDasmWindow(HWND hwnd);
void DasmWindowAction(win_action_t action, word addr);
void RecomputeHScrollbarDasm(void);

#endif
/* end of file: windbg_sub.h */
