; 
; DISPLAY PROCESSOR MODULE
; 
; INITIALIZATION
; 
STACK	EQU	0FFH		;STACK ADDR
CINTC	EQU	0FFFBH		;RTC CONTROL ADDR
GSTRT	EQU	100H		;START ADDR
KINTC	EQU	0FFC0H		;KBRD INT CONTROL ADDR
TIME	EQU	3FH		;SYSTEM TIME
TOP	EQU	40H		;DISPLAY FILE START ADDR
XYOUT	EQU	0FFFCH		;CRT OUTPUT ADDR
; 
	ORG	GSTRT
INIT:	LXI	D,0		;ZERO XY (IN DE ALWAYS)
	LXI	H,TABLE
	SHLD	INCPT		;INIT INCR PTR
	LXI	SP,STACK		;INIT STACK PTR
	MVI	A,10H
	STA	KINTC		;TURN ON KB INT
	MVI	A,80H	
	STA	CINTC		;TURN ON RTC INT
	EI
	LHLD	TOP
	SHLD	PNTR		;INIT INSTRUCTION PTR
; 
; OPCODE DECODING
; 
MLOOP:	LHLD	PNTR		;ADDR OF OPCODE
	MOV	C,M
	MVI	B,0		;OPCODE IN BC
	LXI	H,JMTAB		;BASE OF JUMP TABLE
	DAD	B		;ADD OPCODE
	MOV	C,M	
	INX	H
	MOV	H,M
	MOV	L,C		;ADDR OF ROUTINE IN HL
	PCHL			;JUMP TO IT
; 
; JUMP TABLE FOR OPCODE PROCESSING
; 
JMTAB:	DW	MBEAM		;0
	DW	MDISP		;2
	DW	LVEC		;4
	DW	SVEC		;6
	DW	PARAM		;8
	DW	JUMP		;A
	DW	JUMPS		;C
	DW	RETS		;E
	DW	EXEC		;10H
	DW	SYNC		;12H
; 
; MOVE BEAM - DON'T DIPLAY POINT
; 
MBEAM:	LHLD	PNTR
	INX	H
	MOV	D,M		;GET X COORD
	INX	H
	MOV	E,M		;GET Y COORD
	INX	H
	SHLD	PNTR		;RESTORE PTR
	JMP	MLOOP		;GET ANOTHER INSTRUCTION
; 
; MOVE BEAM AND DISPLAY POINT
; 
MDISP:	LHLD	PNTR
	INX	H
	MOV	D,M
	INX	H
	MOV	E,M
	INX	H
	SHLD	PNTR
	XCHG			;XY TO HL
	SHLD	XYOUT		;WRITE TO CRT
	XCHG			;XY TO DE
	JMP	MLOOP
; 
; SET ORIENTATION AND SCALE
; 
PARAM:	LHLD	PNTR
	INX	H
	MOV	C,M
	INX	H
	SHLD	PNTR
	MOV	L,C		;NEW ORIENT & SCALE IN HL
	MVI	H,0
	LXI	B,TABLE		;ADDR OF INCR TABLE
	DAD	B		;ADD ORIENT & SCALE
	SHLD	INCPT		;STORE IN INCR PTR
	JMP	MLOOP		;GET ANOTHER INSTRUCTION
; 
; JUMP TO A NEW LOCATION IN DISPLAY FILE
; 
JUMP:	LHLD	PNTR
	INX	H
	MOV	A,M		;LSB OF ADDR
	INX	H
	MOV	H,M		;MSB OF ADDR
	MOV	L,A
	SHLD	PNTR		;STORE IN INSTRUCTION PTR
	JMP	MLOOP
; 
; JUMP TO SUBROUTINE
; 
JUMPS:	LHLD	PNTR
	INX	H
	MOV	C,M	
	INX	H
	MOV	B,M		;NEW ADDR IN BC
	INX	H
	PUSH	H		;STORE OLD PTR ON STACK
	MOV	H,B
	MOV	L,C
	SHLD	PNTR		;ADDR IN INSTRUCTION PTR
	JMP	MLOOP
; 
; RETURN FROM SUBROUTINE
; 
RETS:	POP	H		;RESTORE PTR FROM STACK
	SHLD	PNTR
	JMP	MLOOP
; 
; SHORT VECTOR MODE
; 
SVEC:	LHLD	PNTR		;CURRENT INSTR INDEX
	INX	H
NEXT:	MOV	B,M		;SHORT VECTOR INSTRUCTION
	INX	H
	SHLD	PNTR		;RESTORE PTR
	MOV	A,B
	ANI	7H		;MASK DIRECTION BITS
	MOV	C,A		;OFFSET IN C
	MOV	A,B		;ORIG INSTR IN A
	MVI	B,0		;ZERO IN B
	LHLD	INCPT		;INCR PTR
	DAD	B		;ADD DIRECTION OFFSET
	MOV	B,M		;X INCREMENT
	INX	H
	INX	H
	MOV	C,M		;Y INCREMENT
	XCHG			;XY IN HL
	MOV	E,A		;ORIGINAL INSTR
	ANI	70H		;LENGTH BITS
	RRC
	RRC
	RRC
	RRC			;SHIFT RIGHT 4
	MOV	D,A		;IN D
	MOV	A,E		;ORIGINAL INSTR
	ANI	8H		;ON/OFF BIT
	JNZ	FLOOP		;JUMP IF "OFF"
	SHLD	XYOUT		;INITIAL DOT TO CRT
NLOOP:	MOV	A,B		;X INCREMENT
	ADD	H
	MOV	H,A
	MOV	A,C
	ADD	L
	MOV	L,A		;NEW XY IN HL
	SHLD	XYOUT		;WRITE TO CRT
	DCR	D
	JNZ	NLOOP		;LOOP IF NOT DONE
	JMP	CKESC		;CHECK "ESCAPE"
FLOOP:	MOV	A,B		;X INCREMENT
	ADD	H		;ADD TO X
	MOV	H,A
	MOV	A,C		;Y INCREMENT
	ADD	L
	MOV	L,A		;NEW XY IN HL
	DCR	D
	JNZ	FLOOP		;LOOP IF NOT DONE
CKESC:	MOV	A,E		;ORIGINAL INSTR
	XCHG			;XY TO DE
	RLC			;SET CARRY IF "ESCAPE"
	JC	MLOOP		;MAIN LOOP IF SO
	LHLD	PNTR
	JMP	NEXT		;GET MORE DATA IF NOT
; 
; LONG VECTOR MODE
; 
LVEC:	LHLD	PNTR
	INX	H
	MOV	B,M		;NEW X POS
	INX	H
	MOV	A,M		;NEW Y POS
	INX	H
	SHLD	PNTR	
; 
	MVI	C,0F8H		;SPECIAL MASK FOR -
	SUB	E		;DEL Y IN A 
	JC	PLUSY		;TEST SIGN OF DEL
	MVI	C,0		;SPECIAL MASK FOR +
PLUSY:	RLC
	RLC
	RLC			;DIVIDE BY 32
	MOV	H,A		;SAVE IN H
	ANI	0F8H		;SAVE 1ST 5 BITS
	MOV	L,A		;L.O. Y INC
	MOV	A,H		;RESTORE
	ANI	7		;SAVE LAST 3 BITS
	XRA	C		;XOR SPECIAL MASK
	MOV	H,A		;H.O. Y INC
	SHLD	YINC		;STORE
; 
	MOV	A,B		;X POS
	MVI	C,0F8H
	SUB	D		;DEL X IN A
	JC	PLUSX
	MVI	C,0
PLUSX:	RLC
	RLC
	RLC
	MOV	H,A
	ANI	0F8H
	MOV	L,A		;L.O. X INCR
	MOV	A,H
	ANI	7
	XRA	C
	MOV	H,A		;H.O. X INCR
	SHLD	XINC
; 
	MOV	B,D		;X IN BC (H.O.)
	MVI	C,0
	MOV	D,E		;Y IN DE (H.O.)
	MVI	E,0
	MVI	A,20H		;32 POINTS IN VECT
; 
LLOOP:	LHLD	YINC
	DAD	D
	XCHG			;NEW Y IN DE
	LHLD	XINC
	DAD	B
	MOV	B,H		;NEW X IN BC
	MOV	C,L
	MOV	L,D		;XY IN HL (H.O.)
	SHLD	XYOUT		;WRITE TO CRT
	DCR	A
	JNZ	LLOOP
; 
	XCHG			;RESTORE XY TO DE
	JMP	MLOOP
; 
; TRANSFER CONTROL TO EXECUTIVE
; 
EXEC:	LHLD	PNTR		;BUMP PTR
	INX	H
	SHLD	PNTR
	MVI	H,80H		;BEAM TO SCREEN CENTER
	MVI	L,80H
	SHLD	XYOUT
	RST	3		;XFER TO LOC 18H
	JMP	MLOOP		;NEXT INSTRUCTION
; 
; SYNCHRONIZE WITH REAL-TIME CLOCK
; 
SYNC:	LHLD	PNTR		;BUMP PTR
	INX	H
	SHLD	PNTR
	MVI	H,80H		;BEAM TO SCREEN CENTER
	MVI	L,80H
	SHLD	XYOUT
	LXI	H,TIME
	MOV	A,M		;OLD TIME IN A
SLOOP:	CMP	M		;OLD=NEW?
	JZ	SLOOP		;YES - KEEP TRYING
	JMP	MLOOP		;NO - NEXT INSTR
; 
; TABLE FOR VECTOR ORIENTATION AND SCALING
; 
TABLE:	DB	0
	DB	2
	DB	2
	DB	2
	DB	0
	DB	-2
	DB	-2
	DB	-2
	DB	0
	DB	2
	DB	2
	DB	2
	DB	0
	DB	-2
	DB	-2
	DB	-2
	DB	0
	DB	3
	DB	3
	DB	3
	DB	0
	DB	-3
	DB	-3
	DB	-3
	DB	0
	DB	3
	DB	3
	DB	3
	DB	0
	DB	-3
	DB	-3
	DB	-3
	DB	0
	DB	4
	DB	4
	DB	4
	DB	0
	DB	-4
	DB	-4
	DB	-4
	DB	0
	DB	4
	DB	4
	DB	4
	DB	0
	DB	-4
	DB	-4
	DB	-4
	DB	0
; 
; THE FOLLOWING ARE STORAGE CELLS NOT TO BE IN PROM
; WORKING STORAGE
; 
PNTR:	DW	0		;PTR TO NEXT INSTR
XINC:	DW	0		;LVEC ONLY
YINC:	DW	0		;LVEC ONLY
INCPT:	DW	0		;PTR TO INCREMENT IN TABLE
	END
