;  
; NUMERALS MODULE
; COPYRIGHT 1976 D. KRUGLINSKI
;
NSTRT	EQU	480H	;LOAD ADDRESS
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; GRAPHICS MACROS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MBEAM	MACRO	X,Y
	DB	0
	DB	X
	DB	Y
	ENDM
;
MDISP	MACRO	X,Y
	DB	2
	DB	X
	DB	Y
	ENDM
;
LVEC	MACRO	X,Y
	DB	4
	DB	X
	DB	Y
	ENDM
;
SVEC	MACRO
	DB 	6
	ENDM
SV	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4)
	ENDM
SVF	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 8H
	ENDM
SVE	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 80H
	ENDM
SVEF	MACRO	LEN,DIR
	DB	DIR OR (LEN SHL 4) OR 88H
	ENDM
;
PARAM	MACRO	SCL,ORN
	DB	8
	DB	ORN OR (SCL SHL 4)
	ENDM
;
JUMP	MACRO	ADDR
	DB	0AH
	DW	ADDR
	ENDM
;
JUMPS	MACRO	ADDR
	DB	0CH
	DW	ADDR
	ENDM
;
RETS	MACRO
	DB	0EH
	ENDM
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; SYSTEM LINKAGES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ORG	46H
	DW	ZERO
	DW	ONE
	DW	TWO
	DW	THREE
	DW	FOUR
	DW	FIVE
	DW	SIX
	DW	SEVEN
	DW	EIGHT
	DW	NINE
	ORG	NSTRT
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; NUMERALS 0-9
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ZERO:	SVEC
	SV	6,0
	SV	4,2
	SV	6,4
	SV	4,6
	SVEF	6,2
	RETS
ONE:	SVEC
	SVF	4,2
	SV	6,0
	SVF	6,4
	SVEF	2,2
	RETS
TWO:	SVEC
	SVF	6,0
	SV	4,2
	SV	3,4
	SV	4,6
	SV	3,4
	SV	4,2
	SVEF	2,2
	RETS
THREE:	SVEC
	SV	4,2
	SV	6,0
	SV	4,6
	SVF	3,4
	SV	4,2
	SVF	3,4
	SVEF	2,2
	RETS
FOUR:	SVEC
	SVF	4,2
	SVF	3,0
	SV	4,6
	SV	3,0
	SVF	4,2
	SV	6,4
	SVEF	2,2
	RETS
FIVE:	SVEC
	SV	4,2
	SV	3,0
	SV	4,6
	SV	3,0
	SV	4,2
	SVF	6,4
	SVEF	2,2
	RETS
SIX:	SVEC
	SVF	3,0
	SV	4,2
	SV	3,4
	SV	4,6
	SV	6,0
	SV	4,2
	SVF	6,4
	SVEF	2,2
	RETS
SEVEN:	SVEC
	SVF	6,0
	SV	4,2
	SV	6,4
	SVEF	2,2
	RETS
EIGHT:	SVEC
	SV	6,0
	SV	4,2
	SV	6,4
	SV	4,6
	SVF	3,0
	SV	4,2
	SVF	3,4
	SVEF	2,2
	RETS
NINE:	SVEC
	SVF	4,2
	SV	6,0
	SV	4,6
	SV	3,4
	SV	4,2
	SVF	3,4
	SVEF	2,2
	RETS
	END
