/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/Windbg.h 27    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\	
  MITS Altair Emulator
  WinDbg Header File

  Main debugger support for the Solace Sol-20 emulator
  Copyright (c) Jim Battle, 2000-2002

  Modifications for the Altair32 Emulator
  Copyright (c) 2001-2016 Richard A. Cini

Change Log:
  2001/11/08  RAC -- Initial modifications
  2001/12/14  RAC -- RELEASE MARKER -- v2.1
  2002/01/02  RAC -- Synched with Solace 3.0
  2002/01/31  RAC -- RELEASE MARKER -- v2.2
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/

#ifndef _WINDBG_H_
#define _WINDBG_H_


// args for UI_DbgWin (used only by Update)
#define UPDATE_REG	0x0001	// registers subwindow
#define UPDATE_MEM	0x0002	// memory subwindow
#define UPDATE_DASM	0x0004	// dasm subwindow
#define UPDATE_LOG	0x0008	// command log subwindow
#define UPDATE_CMD	0x0010	// command entry subwindow
#define HOME_DASM	0x0100	// recenter dasm around pc
#define HOME_MEM	0x0200	// recenter mem around sp

#define UPDATE_REFRESH (UPDATE_REG | UPDATE_MEM | UPDATE_DASM | UPDATE_LOG | UPDATE_CMD)
#define UPDATE_ALL     (UPDATE_REFRESH | HOME_DASM | HOME_MEM)

// contains a map per byte of whether there is a special
#define BRKPT_ADDR(addr) (brkpt_map[(addr)>>5] & (1 << ((addr) & 31)))
#define BRKPT_IO(port)   (brkpt_iomap[(port)])

// the windows interface notifies the core simulator of certain events
#define DEBUG_KEY      1
#define RUN_KEY        2
#define FORCERUN_KEY   3
#define STEP_KEY       4
#define STEPI_KEY      5
#define CLOSE_WIN      6
#endif

/* end of file: windbg.h */
