/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/hexfile.h 25    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\
  MITS Altair Emulator
  Integrated debugger compatibility layer

  Copyright (c) 2000-2001 Jim Battle (Solace emulator)
  Copyright (c) 2000-2016 Richard A. Cini (Altair32 modifications)

Change Log:
  2002/01/31  RAC -- RELEASE MARKER -- v2.2
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/

#ifndef _HEXFILE_H_
#define _HEXFILE_H_


/*  Actually, none of the members of this struct needs to be visible
 *  outside of hexfile.c, but if there is some way to hide this in C,
 *  I'm ignorant of it.  All the world really needs to know is that
 *  it has a pointer to the struct.
 */
typedef struct tagHFILE {
    unsigned long	magic;		// handle validator
    int				line;		// which line is being read
    char			*filename;	// for informational purposes
    int			 	writeaccess;	// 1=write, 0=read
    int				format;		// 0=ent, 1=intel hex
    FILE			*fp;		// file handle
    char 			*offset;	// parser offset into line buffer
    unsigned long	state;		// used by parser
    char			*buffer;	// line buffer
} hfile_t;

#define HFILE_OK			(0)
#define HFILE_BAD_HANDLE	(1)
#define HFILE_BAD_FORMAT	(2)
#define HFILE_FILE_ERROR	(3)
#define HFILE_EOF			(4)


// --- Routines for hex file manipulation ---
//extern int  parse_hex_line(char *, int [], int *, int *, int *);
extern void hexout ( FILE *, int, int, int );

// determine the type not by the file suffix, but by reading
// the first line of the file and guessing.
// returns 0 if HEX, 1 if ENT, 2 if unknown, -1 if file error.
int hexfile_guessformat(char *filename);

// byte at a time interface, open file for reading or writing.
// format indicates file type: 0=intel hex, 1=sol ent
// *access must be either "r" or "w".
// return NULL on error, otherwise returns a handle.
hfile_t *hexfile_hex_open(char *filename, int format, char *access);

// byte at a time interface, close file
// return 0 on success, something else on failure
int hexfile_hex_close(hfile_t *hf);

// byte at a time interface, read or write one byte
// return 0 on success, something else on failure
int hexfile_hex_write(hfile_t *hf, int  addr, byte  data);
int hexfile_hex_read( hfile_t *hf, int *addr, byte *data);


// read a binary file in either "ENter" or intel "hex" format.
// we determine the type not by the file suffix, but by reading
// the first line of the file and guessing.
int hexfile_read(char *filename, int report, byte *memory);

// write a binary file in either "ENter" or intel "hex" format.
// return 0 on success, something else on failure.
int hexfile_hexdump(char *filename, int format, int start, int end, byte *memory);

// load a hex file and if available, load the source overlay
int hexfile_read_overlay(char *filename, int report, byte *memory);

#endif
/* end of file: hexfile.h */
