/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/i8080.h 42    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\
  MITS Altair Emulator
  i8080 processor emulator header
 
  Copyright (c) 1991-1997 Claus T. Giloi
  Copyright (c) 2000-2016 Richard A. Cini

Change Log:
  2000/08/31  RAC -- Initial modifications
  2000/09/11  RAC -- made Mem[MEMSIZE] extern
  2000/09/19  RAC -- added defs from altair_defs
  2001/05/23  RAC -- Moved macros from i8080.c to .h
  2001/08/19  RAC -- RELEASE MARKER -- v2.0
  2001/08/27  RAC -- Began mods for CoreDump and Registers display.
  2001/11/13  RAC -- Began coding for debugger. Items borrowed from Jim
 						Battle and Marat Fayzullin (CPU structures)
  2001/11/30  RAC -- Added duplicate routines for breakpoint handling.
  2001/12/04  RAC -- Changed clock8080 to take I80Regs as a param.
  2001/12/07  RAC -- Added macros from z80.c. Must undo changes to many
						Solace files to reuse Di80, Rd80, Wr80 macros.
						Also moved more sim variables into simstate.
  2001/12/14  RAC -- RELEASE MARKER -- v2.1
  2001/12/19  RAC -- Some initial changes to support time slicing
  2002/01/31  RAC -- RELEASE MARKER -- v2.2
  2002/05/22  RAC -- Added defs for IRQs and memory-mapped handlers
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/01/20  RAC -- Diff'ed changes from FJS (Fred J. Scipione)
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/19  MWD -- Support interrupts for SIO and 2SIO console ports  
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2015/27/09  RAC -- added alternate address buffer register for IMSAI LEDs
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/
#ifndef _I8080_H_
#define _I8080_H_

/**  Defines  ***************************************************/
#define	ADD			(byte)10
#define	SUBTRACT 	(byte)11
#define	MEMSIZE		65536
#define MAXMEMSIZE  65536
#define	IOSIZE	    256
#define ADDRMASK    (MAXMEMSIZE - 1)
#define	STACK_TOP	0xffff

// Instruction decoding. Some listed in octal.
#define	SRC_MASK	007		// low 3 bits of instruction { sss } 0x07
#define	DST_MASK	070		// bits 3,4,5 of instruction { ddd } 0x38
#define	RP_MASK		0x30	// mask for all word registers
#define	MEMSRC		006		// memory source fields				 0x06
#define	MEMDST		0x30	// memory destination fields
//#define	RST_OP		0307	// opcode for RST...need to OR with vector#
//#define RST_MASK	070		// bits 3,4,5 of instruction is RST vector

/* Processor condition codes */
#define	CY_FLAG		0x01
#define	P_FLAG		0x04
#define	AC_FLAG		0x10
#define	Z_FLAG		0x40
#define	S_FLAG		0x80

/* CPU status bit definitions */
#define	sINT	0x01
#define sINT_BIT	0
#define	WO		0x02
#define WO_BIT	1
#define	STACK	0x04
#define STACK_BIT	2
#define	HLTA	0x08
#define HLTA_BIT	3
#define	pOUT	0x10
#define pOUT_BIT	4
#define	M1		0x20
#define M1_BIT	5
#define	INP		0x40
#define INP_BIT	6
#define	MEMR	0x80
#define MEMR_BIT	7
#define	CPU_CLR		WO | M1			// initial CPU state
#define CPU_INTA	sINT | WO | M1	// interrupt acknowledge

/* Interrupt sources word. This word has a bit position for each possible
    interrupt source in use. Emulated device drivers set/clear their
	interrupt source bit in this word directly. 
	
	The InterruptVects array is not implemented yet, but would be a mechanism 
	for supporting a prioritized interrupt controller: The array
	has an entry corresponding to each interrupt source bit that
	containts the assigned interrupt vector number for the interrupt.
	InterruptSources bits 15-0 (MSB to LSB) correspond to InterruptVects
	entries where the array index is the bit number (e.g., 0-15) */

//#define	NUM_INT_SOURCES	16		// 16 possible interrupt sources
#define	INTSRC_CONSOLE	0x01	// bit 0 - console asserting interrupt
#define	INTSRC_FLOPPY	0x02	// bit 1 - floppy asserting interrupt (not implemented)
#define	INTSRC_RTC		0x04	// bit 2 - real time clock (not implemented)
extern	word	InterruptSources;	
// extern	byte	InterruptVects[NUM_INT_SOURCES];

/* Processor interface macros */
// Di80 is used by the disassembler to read a byte.
#define Di80(Addr)       (*simstate.di80_func)(Addr)
// Op80 is used by the simulator to fetch the first opcode byte.
#define Op80(Addr)       (*simstate.op80_func)(Addr)
// Rd80 is used by the simulator to fetch 2nd-3rd opcode and data bytes
#define Rd80(Addr)       (*simstate.rd80_func)(Addr)
// Wr80 is used by the simulator to write bytes
#define Wr80(Addr,Value) (*simstate.wr80_func)((Addr),(Value))
// In80 is used by the simulator for the IN opcode
#define In80(Addr)       (*simstate.in80_func)(Addr)
// Out80 is used by the simulator for the OUT opcode
#define Out80(Addr,Value) (*simstate.out80_func)((Addr),(Value))

extern  simstate_t simstate;
#ifndef AM_I8080
#define MEMSIZE 65536
extern  I8080   I80Regs;
extern  byte    Mem[MEMSIZE];
extern  byte    PageAccessRights[MEMSIZE];
extern  word    IOPANEL;
extern  word    MBR;   		// buffer register for data bus
extern	word	uABR;		// upper address of ABR for copying 8-bits
extern	word	ABR;		// buffer register for Address Buss
extern  word    Aswitches;	// FJS moved here only
extern  byte    CLK_OP; 	// TBD clock board interrupts

extern  byte    GetMem( word );
extern  byte    GetMem_brkpt( word );
extern  void    SetMem( word , byte );
extern  void    SetMem_brkpt( word , byte );
extern  byte    GetIO( word );
extern  byte    GetIO_brkpt( word );
extern  void    SetIO( word , byte );
extern  void    SetIO_brkpt( word , byte );
extern  byte    clock8080( I8080 * );
extern  byte    clock8080_brkpt( I8080 * );
extern  void    Reset8080( void );

// Used to get and set the emulated CPU speed -
extern  void    SYS_Set8080Speed( speed_t );
// extern  speed_t SYS_Get8080Speed( void ); // not used
extern  void    SYS_SetCPUType( int ); // FJS Z80
// extern	cputype_t	SYS_GetCPUType( void ); // not used

extern  void    CpuPOR( void );
extern  void    LoadBootProm( void );
extern  BOOL    CoreDump( void );
extern  void    report_curstate( void );
extern  void    brkpt_notify( void );
extern  void    simstep( void );
extern  void    simrun( void );
extern  void    simstepover( void );
#endif

#endif
/* end of file: i8080.h */
