/************************************************************************\
 * File Version Information
 * $Header: /Altair32v3/srcdbg.h 22    12/20/13 9:55p Racini $
 ************************************************************************/
/************************************************************************\
  MITS Altair Emulator
  Source-level debugging support header
  
  Source-level debugger support for the Solace Sol-20 emulator
  Copyright (c) Jim Battle, 2000-2002

  Modifications for the Altair32 Emulator
  Copyright (c) 2001-2016Richard A. Cini

Change Log:
  2002/05/17  RAC -- Initial changes
  2002/08/23  RAC -- RELEASE MARKER -- v2.30.10
  2002/11/15  RAC -- RELEASE MARKER -- v2.40.2100
  2003/04/26  RAC -- RELEASE MARKER -- v2.50.2045
  2004/07/30  RAC -- RELEASE MARKER -- v3.00.0135
  2006/05/12  RAC -- RELEASE MARKER -- v3.10.0200
  2006/11/15  RAC -- RELEASE MARKER -- v3.20.0400
  2011/09/17  RAC -- RELEASE MARKER -- v3.30.0800
  2013/02/03  RAC -- RELEASE MARKER -- v3.32.1100
  2013/12/31  RAC -- RELEASE MARKER -- v3.33.2100
  2016/02/20  RAC -- RELEASE MARKER -- v3.34.0900
\************************************************************************/

#ifndef _SRCDBG_H_
#define _SRCDBG_H_


// --- type declarations ---
typedef enum tagOVRSTAT { OVERLAY_BOTH, OVERLAY_ON, OVERLAY_OFF } ovr_stat_t;


// --- interface declarations ---
// return codes used by various Ovl*() routines
#define OVLERR_OK         (0)
#define OVLERR_TOOMANY   (-1)
#define OVLERR_BADID     (-2)
#define OVLERR_FILEOPEN  (-3)
#define OVLERR_MALLOC    (-4)

// called at the dawn of time
void OvlInit(void);

// called at the apocalypse
void OvlCleanup(void);

// this reads in a source file and parses it into an overlay.
// if the file already exists in the overlay table, replace
// the existing entry; otherwise, create a new entry.
// returns OVLERR_OK, or OVLERR_TOOMANY.
int OvlParse(char *filename, int autoloaded);

// set the both/on/off mode associated with an existing entry.
// returns either OVLERR_OK or OVLERR_BADID.
int OvlSetMode(int id, ovr_stat_t status);

// remove the specified entry from the overlay table.
int OvlRemove(int id);

// remove autoloaded overlays that are probably not meaningful.
// the input parameter is the threshold of when overlays get dropped.
void OvlDynamicPruneOverlays(int lower_limit);

// returns the overlay index from the fully qualified filename.
// a return of NULL means error.
char *OvlID2File(int index);

// returns the overlay ID given the filename.
// a return of <0 means error.
int OvlFile2ID(char *filename);

// figure out what is the longest source line in all active overlays
int OvlMaxLineLen(void);

// This is used by the disassembler to know when to use an overlay.
// return values:
enum tagOVLRET { OVLHIT_NO=0, OVLHIT_YES=1, OVLHIT_FLAWED=2 };
int OvlHit(int addr);

// build the table of which ops cover which bytes in memory
void OvlHitInit(void);

// returns a pointer to the multi-line string for the source
// code corresponding to this address.   returns NULL on error.
char *OvlSrc(int addr);

// indicate which type of overlay applies at the supplied address
int OvlMode(int addr);

// indicate how many lines of source correspond to the supplied address
int OvlLines(int addr);

// return 1 if this is an executable op
int OvlOpType(int addr);

// indicate how many bytes this op spans
int OvlOpLen(int addr);

// return the opcode of the first instruction found preceeding
// the one specified.  return -1 on error.
word OvlPreviousOp(word addr);

// these two allow the overlay information to be reported.
// unlike the other external (Ovl*) interfaces, they deal in
// indexes, not id's.
int OvlNumOverlays(void);

// return some information about the chosen overlay
void OvlInfo(int idx, char **fname, int *id, int *autoloaded,
	     ovr_stat_t *status, int *minaddr, int *maxaddr);

#endif
/* end of file: srcdbg.h */
