// plugin interface to application
#include "GFX.h"

//
// local and external data
//

HINSTANCE   hPlugin;            // dll handler
HWND        hwndMain;           // emulator main window

// ---------------------------------------------------------------------------

// these functions are called before GPOpen, 
// during emulator initialization

BOOL APIENTRY DllMain(
    HANDLE  hModule,
    DWORD   dwReasonForCall,
    LPVOID  lpUnknown)
{
    hPlugin = (HINSTANCE)hModule;
    return TRUE;
}

char * CALLBACK IdentPlugin(unsigned long *type)
{
    *type = DOL_PLUG_GFX;

    SET_DOL_PLUG_VER(*type, GFXVER);
    SET_DOL_PLUG_REV(*type, GFXREV);

#ifdef  GFXDEBUG
    return "Dolwin Foo Graphics Engine (D)";
#else
    return "Dolwin Foo Graphics Engine";
#endif
}

// ---------------------------------------------------------------------------

// called every time, when emu start/stop

unsigned long CALLBACK GPStart(HWND hwndParent)
{
    // save main window handler
    hwndMain = hwndParent;

    // default renderer is "dummy"
    gfx = &dummy;

    // renderer initialization step
    return gfx->Open(hwndMain);
}

void CALLBACK GPStop()
{
    // renderer de-initialization step
    gfx->Close(hwndMain);
}
