// all GX hardware here, e.g. internal registers
#include "GFX.h"

// internal registers
CPMemory    cpRegs;
BPMemory    bpRegs;
XFMemory    xfRegs;

// registers load counters
u32         cpLoads, bpLoads, xfLoads;

// ---------------------------------------------------------------------------

// index range = 00..FF
// reg size = 32 bit
void loadCPReg(unsigned idx, u32 value)
{
    cpLoads++;
}

// index range = 00..FF
// reg size = 24 bit (value is already masked)
void loadBPReg(unsigned idx, u32 value)
{
    bpLoads++;
}

// index range = 0000..FFFF
// reg size = 32 bit
void loadXFRegs(unsigned sidx, unsigned amount, u32 *regData)
{
    xfLoads += amount;
}
