// graphics processor internal registers

// ver. 0.1

// ---------------------------------------------------------------------------
// CP Memory Space
// ---------------------------------------------------------------------------

//
// register IDs
//

#define CP_MATINDEX_A_ID            0x30
#define CP_MATINDEX_B_ID            0x40
#define CP_VCD_LO_ID                0x50
#define CP_VCD_HI_ID                0x60
#define CP_VAT_A_ID                 0x70
#define CP_VAT_B_ID                 0x80
#define CP_VAT_C_ID                 0x90
#define CP_ARRAY_BASE_ID            0xa0
#define CP_ARRAY_STRIDE_ID          0xb0

//
// enumerations
//

// attribute type (VCD)
enum
{
    VCD_NONE = 0,
    VCD_DIRECT,
    VCD_INDEX8,
    VCD_INDEX16
};

// components count (VAT)
enum
{
    VAT_POS_XY   = 0,
    VAT_POS_XYZ  = 1,
    VAT_NRM_XYZ  = 0,
    VAT_NRM_NBT  = 1,
    VAT_NRM_NBT3 = 2,
    VAT_CLR_RGB  = 0,
    VAT_CLR_RGBA = 1,
    VAT_TEX_S    = 0,
    VAT_TEX_ST   = 1
};

// components format (VAT)
enum            // vector types
{
    VAT_U8 = 0,
    VAT_S8,
    VAT_U16,
    VAT_S16,
    VAT_F32,
};
enum            // color types
{
    VAT_RGB565 = 0,
    VAT_RGB8,
    VAT_RGBX8,
    VAT_RGBA4,
    VAT_RGBA6,
    VAT_RGBA8,
};

//
// register structure layouts
//

// vertex current descriptor (low part)
typedef union
{
    struct
    {
        unsigned    pmidx : 1;
        unsigned    t0midx : 1;
        unsigned    t1midx : 1;
        unsigned    t2midx : 1;
        unsigned    t3midx : 1;
        unsigned    t4midx : 1;
        unsigned    t5midx : 1;
        unsigned    t6midx : 1;
        unsigned    t7midx : 1;
        unsigned    pos : 2;
        unsigned    nrm : 2;
        unsigned    col0 : 2;
        unsigned    col1 : 2;
    };
    u32     hex;
} VCD_LO;

// vertex current descriptor (high part)
typedef union
{
    struct
    {
        unsigned    tex0 : 2;
        unsigned    tex1 : 2;
        unsigned    tex2 : 2;
        unsigned    tex3 : 2;
        unsigned    tex4 : 2;
        unsigned    tex5 : 2;
        unsigned    tex6 : 2;
        unsigned    tex7 : 2;
    };
    u32     hex;
} VCD_HI;

// vertex attribute table (part A)
typedef union
{
    struct
    {
        unsigned    poscnt : 1;
        unsigned    posfmt : 3;
        unsigned    posshft : 5;
        unsigned    nrmcnt : 1;
        unsigned    nrmfmt : 3;
        unsigned    col0cnt : 1;
        unsigned    col0fmt : 3;
        unsigned    col1cnt : 1;
        unsigned    col1fmt : 3;
        unsigned    tex0cnt : 1;
        unsigned    tex0fmt : 3;
        unsigned    tex0shft : 5;
        unsigned    bytedeq : 1;        // always 1
        unsigned    nrmidx3 : 1;
    };
    u32     hex;
} VAT_A;

// vertex attribute table (part B)
typedef union
{
    struct
    {
        unsigned    tex1cnt : 1;
        unsigned    tex1fmt : 3;
        unsigned    tex1shft : 5;
        unsigned    tex2cnt : 1;
        unsigned    tex2fmt : 3;
        unsigned    tex2shft : 5;
        unsigned    tex3cnt : 1;
        unsigned    tex3fmt : 3;
        unsigned    tex3shft : 5;
        unsigned    tex4cnt : 1;
        unsigned    tex4fmt : 3;
        unsigned    vcache : 1;         // always 1
    };
    u32     hex;
} VAT_B;

// vertex attribute table (part C)
typedef union
{
    struct
    {
        unsigned    tex4shft : 5;
        unsigned    tex5cnt : 1;
        unsigned    tex5fmt : 3;
        unsigned    tex5shft : 5;
        unsigned    tex6cnt : 1;
        unsigned    tex6fmt : 3;
        unsigned    tex6shft : 5;
        unsigned    tex7cnt : 1;
        unsigned    tex7fmt : 3;
        unsigned    tex7shft : 5;
    };
    u32     vatc;
} VAT_C;

// ---------------------------------------------------------------------------
// BP Memory Space
// ---------------------------------------------------------------------------

//
// register IDs
//

#define GEN_MODE_ID                 0x00
#define BU_IMASK_ID                 0x0f
#define SU_LPSIZE_ID                0x22
#define RAS1_TREF0_ID               0x28
#define RAS1_TREF1_ID               0x29
#define RAS1_TREF2_ID               0x2a
#define RAS1_TREF3_ID               0x2b
#define RAS1_TREF4_ID               0x2c
#define RAS1_TREF5_ID               0x2d
#define RAS1_TREF6_ID               0x2e
#define RAS1_TREF7_ID               0x2f
#define SU_SSIZE0_ID                0x30
#define SU_TSIZE0_ID                0x31
#define SU_SSIZE1_ID                0x32
#define SU_TSIZE1_ID                0x33
#define SU_SSIZE2_ID                0x34
#define SU_TSIZE2_ID                0x35
#define SU_SSIZE3_ID                0x36
#define SU_TSIZE3_ID                0x37
#define SU_SSIZE4_ID                0x38
#define SU_TSIZE4_ID                0x39
#define SU_SSIZE5_ID                0x3a
#define SU_TSIZE5_ID                0x3b
#define SU_SSIZE6_ID                0x3c
#define SU_TSIZE6_ID                0x3d
#define SU_SSIZE7_ID                0x3e
#define SU_TSIZE7_ID                0x3f
#define PE_ZMODE_ID                 0x40
#define PE_CMODE0_ID                0x41
#define PE_CMODE1_ID                0x42
#define PE_CONTROL_ID               0x43
#define PE_TOKEN_ID                 0x47
#define PE_TOKEN_INT_ID             0x48
#define TX_LOADTLUT0_ID             0x64
#define TX_LOADTLUT1_ID             0x65
#define TX_SETMODE0_I0_ID           0x80
#define TX_SETMODE0_I1_ID           0x81
#define TX_SETMODE0_I2_ID           0x82
#define TX_SETMODE0_I3_ID           0x83
#define TX_SETMODE1_I0_ID           0x84
#define TX_SETMODE1_I1_ID           0x85
#define TX_SETMODE1_I2_ID           0x86
#define TX_SETMODE1_I3_ID           0x87
#define TX_SETIMAGE0_I0_ID          0x88
#define TX_SETIMAGE0_I1_ID          0x89
#define TX_SETIMAGE0_I2_ID          0x8a
#define TX_SETIMAGE0_I3_ID          0x8b
#define TX_SETIMAGE1_I0_ID          0x8c
#define TX_SETIMAGE1_I1_ID          0x8d
#define TX_SETIMAGE1_I2_ID          0x8e
#define TX_SETIMAGE1_I3_ID          0x8f
#define TX_SETIMAGE2_I0_ID          0x90
#define TX_SETIMAGE2_I1_ID          0x91
#define TX_SETIMAGE2_I2_ID          0x92
#define TX_SETIMAGE2_I3_ID          0x93
#define TX_SETIMAGE3_I0_ID          0x94
#define TX_SETIMAGE3_I1_ID          0x95
#define TX_SETIMAGE3_I2_ID          0x96
#define TX_SETIMAGE3_I3_ID          0x97
#define TX_SETTLUT_I0_ID            0x98
#define TX_SETTLUT_I1_ID            0x99
#define TX_SETTLUT_I2_ID            0x9a
#define TX_SETTLUT_I3_ID            0x9b
#define TX_SETMODE0_I4_ID           0xa0
#define TX_SETMODE0_I5_ID           0xa1
#define TX_SETMODE0_I6_ID           0xa2
#define TX_SETMODE0_I7_ID           0xa3
#define TX_SETMODE1_I4_ID           0xa4
#define TX_SETMODE1_I5_ID           0xa5
#define TX_SETMODE1_I6_ID           0xa6
#define TX_SETMODE1_I7_ID           0xa7
#define TX_SETIMAGE0_I4_ID          0xa8
#define TX_SETIMAGE0_I5_ID          0xa9
#define TX_SETIMAGE0_I6_ID          0xaa
#define TX_SETIMAGE0_I7_ID          0xab
#define TX_SETIMAGE1_I4_ID          0xac
#define TX_SETIMAGE1_I5_ID          0xad
#define TX_SETIMAGE1_I6_ID          0xae
#define TX_SETIMAGE1_I7_ID          0xaf
#define TX_SETIMAGE2_I4_ID          0xb0
#define TX_SETIMAGE2_I5_ID          0xb1
#define TX_SETIMAGE2_I6_ID          0xb2
#define TX_SETIMAGE2_I7_ID          0xb3
#define TX_SETIMAGE3_I4_ID          0xb4
#define TX_SETIMAGE3_I5_ID          0xb5
#define TX_SETIMAGE3_I6_ID          0xb6
#define TX_SETIMAGE3_I7_ID          0xb7
#define TX_SETTLUT_I4_ID            0xb8
#define TX_SETTLUT_I5_ID            0xb9
#define TX_SETTLUT_I6_ID            0xba
#define TX_SETTLUT_I7_ID            0xbb
#define TEV_COLOR_ENV_0_ID          0xc0
#define TEV_ALPHA_ENV_0_ID          0xc1
#define TEV_COLOR_ENV_1_ID          0xc2
#define TEV_ALPHA_ENV_1_ID          0xc3
#define TEV_COLOR_ENV_2_ID          0xc4
#define TEV_ALPHA_ENV_2_ID          0xc5
#define TEV_COLOR_ENV_3_ID          0xc6
#define TEV_ALPHA_ENV_3_ID          0xc7
#define TEV_COLOR_ENV_4_ID          0xc8
#define TEV_ALPHA_ENV_4_ID          0xc9
#define TEV_COLOR_ENV_5_ID          0xca
#define TEV_ALPHA_ENV_5_ID          0xcb
#define TEV_COLOR_ENV_6_ID          0xcc
#define TEV_ALPHA_ENV_6_ID          0xcd
#define TEV_COLOR_ENV_7_ID          0xce
#define TEV_ALPHA_ENV_7_ID          0xcf
#define TEV_COLOR_ENV_8_ID          0xd0
#define TEV_ALPHA_ENV_8_ID          0xd1
#define TEV_COLOR_ENV_9_ID          0xd2
#define TEV_ALPHA_ENV_9_ID          0xd3
#define TEV_COLOR_ENV_A_ID          0xd4
#define TEV_ALPHA_ENV_A_ID          0xd5
#define TEV_COLOR_ENV_B_ID          0xd6
#define TEV_ALPHA_ENV_B_ID          0xd7
#define TEV_COLOR_ENV_C_ID          0xd8
#define TEV_ALPHA_ENV_C_ID          0xd9
#define TEV_COLOR_ENV_D_ID          0xda
#define TEV_ALPHA_ENV_D_ID          0xdb
#define TEV_COLOR_ENV_E_ID          0xdc
#define TEV_ALPHA_ENV_E_ID          0xdd
#define TEV_COLOR_ENV_F_ID          0xde
#define TEV_ALPHA_ENV_F_ID          0xdf
#define TEV_REGISTERL_0_ID          0xe0
#define TEV_REGISTERH_0_ID          0xe1
#define TEV_REGISTERL_1_ID          0xe2
#define TEV_REGISTERH_1_ID          0xe3
#define TEV_REGISTERL_2_ID          0xe4
#define TEV_REGISTERH_2_ID          0xe5
#define TEV_REGISTERL_3_ID          0xe6
#define TEV_REGISTERH_3_ID          0xe7
#define TEV_FOG_PARAM_0_ID          0xee
#define TEV_FOG_PARAM_1_ID          0xef
#define TEV_FOG_PARAM_2_ID          0xf0
#define TEV_FOG_PARAM_3_ID          0xf1
#define TEV_FOG_COLOR_ID            0xf2
#define TEV_ALPHAFUNC_ID            0xf3
#define TEV_Z_ENV_0_ID              0xf4
#define TEV_Z_ENV_1_ID              0xf5
#define TEV_KSEL_0_ID               0xf6
#define TEV_KSEL_1_ID               0xf7
#define TEV_KSEL_2_ID               0xf8
#define TEV_KSEL_3_ID               0xf9
#define TEV_KSEL_4_ID               0xfa
#define TEV_KSEL_5_ID               0xfb
#define TEV_KSEL_6_ID               0xfc
#define TEV_KSEL_7_ID               0xfd

//
// enumerations
//

//
// register structure layouts
//

// ---------------------------------------------------------------------------
// XF Memory Space
// ---------------------------------------------------------------------------

//
// register IDs
//

#define XF_POSMTX_BASE_ID           0x0000
#define XF_NRMMTX_BASE_ID           0x0400
#define XF_DTTMTX_BASE_ID           0x0500
#define XF_LIGHT_BASE_ID            0x0600
#define XF_LIGHT0COLOR_ID           0x0603
#define XF_LIGHT0A0_ID              0x0604
#define XF_LIGHT0A1_ID              0x0605
#define XF_LIGHT0A2_ID              0x0606
#define XF_LIGHT0K0_ID              0x0607
#define XF_LIGHT0K1_ID              0x0608
#define XF_LIGHT0K2_ID              0x0609
#define XF_LIGHT0PX_ID              0x060a
#define XF_LIGHT0PY_ID              0x060b
#define XF_LIGHT0PZ_ID              0x060c
#define XF_LIGHT0DX_ID              0x060d
#define XF_LIGHT0DY_ID              0x060e
#define XF_LIGHT0DZ_ID              0x060f
#define XF_INVTXSPEC_ID             0x1008
#define XF_NUMCOLORS_ID             0x1009
#define XF_AMBIENT0_ID              0x100a
#define XF_AMBIENT1_ID              0x100b
#define XF_MATERIAL0_ID             0x100c
#define XF_MATERIAL1_ID             0x100d
#define XF_COLOR0CNTRL_ID           0x100e
#define XF_COLOR1CNTRL_ID           0x100f
#define XF_ALPHA0CNTRL_ID           0x1010
#define XF_ALPHA1CNTRL_ID           0x1011
#define XF_NUMTEX_ID                0x103f
#define XF_TEX0_ID                  0x1040
#define XF_TEX1_ID                  0x1041
#define XF_TEX2_ID                  0x1042
#define XF_TEX3_ID                  0x1043
#define XF_TEX4_ID                  0x1044
#define XF_TEX5_ID                  0x1045
#define XF_TEX6_ID                  0x1046
#define XF_TEX7_ID                  0x1047
#define XF_DUALTEX0_ID              0x1050
#define XF_DUALTEX1_ID              0x1051
#define XF_DUALTEX2_ID              0x1052
#define XF_DUALTEX3_ID              0x1053
#define XF_DUALTEX4_ID              0x1054
#define XF_DUALTEX5_ID              0x1055
#define XF_DUALTEX6_ID              0x1056
#define XF_DUALTEX7_ID              0x1057

//
// enumerations
//

//
// register structure layouts
//

// ---------------------------------------------------------------------------

// externals for low-level emulator

typedef struct
{
    u32     dummy;
} CPMemory;

typedef struct
{
    u32     dummy;
} BPMemory;

typedef struct
{
    u32     dummy;
} XFMemory;

extern  CPMemory    cpRegs;
extern  BPMemory    bpRegs;
extern  XFMemory    xfRegs;

extern  u32 cpLoads, bpLoads, xfLoads;

// writing data to registers (by fifo commands)
void    loadCPReg(unsigned index, u32 value);
void    loadBPReg(unsigned index, u32 value);
void    loadXFRegs(unsigned startIndex, unsigned amount, u32 *regData);
