//  Dolwin Plugins Specification by ORG.
//
//  VERSION HISTORY :
//  -----------------
//
//  14   03/20/04 org
//  Save-state support was added for all plugins.
//
//  13   02/13/04 org
//  PADSetRumble() was added. PAD state data should NOT be clamped by plug-in.
//  New revision of audio plugin specs.
//
//  12   01/29/04 org
//  DSP renamed to AUDIO with AUD prefix, DVD stuff was removed. 
//  GFX plugin has changed : removed VI and interrupt handling, fifo was
//  simplified back again. GPMakeSnapshot now uses image path as parameter,
//  GPNextFrame renamed to GPFrameDone. AUD temporary disabled.
//  Modified to use with C++.
//
//  11   11/25/03 org
//  DVDOpen replaced to DVDChangeMedia
//
//  10   11/18/03 org
//  GPCallFIFO removed
//
//  9    10/26/03 org
//  Some changes to FIFO interface
//
//  8    10/17/03 org
//  GPWriteFIFO changed to GPCallFIFO (to be compatible with DLs)
//
//  7    9/27/03 org
//  DTK_ changed back to AI_ :). modified GPMakeSnapshot
//
//  6    9/26/03 org
//  DVDOpen now have HWND as parameter.
//
//  5    9/23/03 org
//  Changed manage interface. Changed AI_ to DSP_, removed some DVD API.
//
//  4    9/22/03 org
//  Changed GP interface (GP FIFO, VI access), changed PADConfigure.
//
//  3    9/12/03 org
//  Added GP and AI interrupt callback for proper interrupt handling.
//
//  2    9/12/03 org
//  Added some new DVD API (seek / read).
//
//  1    9/12/03 org
//  Changed PADReadState(), added config / about and version. Fixed GP and AI.
//
//  0    9/12/03 org
//  Initial specs revision.
//

// do not touch this file without major reasons
// you should report Dolwin team, about any modifications

#ifndef __DOLWIN_PLUGIN_SPECS_H__
#define __DOLWIN_PLUGIN_SPECS_H__

// comment out this string, if you're developing plugins.
// used to avoid plugin interface redefinitions
//#define USED_BY_EMULATOR

// return values are always 1 for good, and 0 for bad,
// you may also use BOOL type, defined by Win32

// plugin specification version
#define DOL_PLUG_VER            "0.14"

// plugin types
// plugin may be multi-purposed (types must be ORed)
#define DOL_PLUG_GFX            (1)
#define DOL_PLUG_AUD            (2)
#define DOL_PLUG_PAD            (4)

// plugin type detection
#define IS_DOL_PLUG_GFX(type)   (type & DOL_PLUG_GFX)
#define IS_DOL_PLUG_AUD(type)   (type & DOL_PLUG_AUD)
#define IS_DOL_PLUG_PAD(type)   (type & DOL_PLUG_PAD)

// get plugin version
#define GET_DOL_PLUG_VER(type)  ((type >>  8) & 0xff)
#define GET_DOL_PLUG_REV(type)  ((type >> 16) & 0xff)

// set plugin version
#define SET_DOL_PLUG_VER(type, ver) (type |= ((ver & 0xff) <<  8))
#define SET_DOL_PLUG_REV(type, rev) (type |= ((rev & 0xff) << 16))

// this function return types, supported by plugin
// current plugin version, and plugin name string
#ifdef USED_BY_EMULATOR
    typedef char * (CALLBACK * IDENTPLUGIN)(unsigned long *type);
#else
    char * CALLBACK IdentPlugin(unsigned long *type);
#endif

// ---------------------------------------------------------------------------

// GFX plugin specification

// called, when emu starts / stops
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK * GPSTART)(HWND hwndParent);
    typedef void (CALLBACK *GPSTOP)();
#else
    unsigned long CALLBACK GPStart(HWND hwndParent);
    void CALLBACK GPStop();
#endif

// parse graphics fifo
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *GPCALLFIFO)(unsigned char *fifoPtr, unsigned long count);
#else
    void CALLBACK GPCallFifo(unsigned char *fifoPtr, unsigned long count);    
#endif

// pass your 24MB RAM buffer ptr (for display lists and textures)
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *GPSETRAMPOINTER)(unsigned char *ptr);
#else
    void CALLBACK GPSetRAMPointer(unsigned char *ptr);
#endif

// update picture, swap buffers
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *GPFRAMEDONE)();
#else
    void CALLBACK GPFrameDone();
#endif

// make screen-shot for the current frame
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *GPMAKESNAPSHOT)(char *path);
#else
    void CALLBACK GPMakeSnapshot(char *path);
#endif

// config / about
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *GPCONFIGURE)(HWND hwndParent);
    typedef void (CALLBACK *GPABOUT)(HWND hwndParent);
#else
    void CALLBACK GPConfigure(HWND hwndParent);
    void CALLBACK GPAbout(HWND hwndParent);
#endif

// savestate (flag:0 to load, flag:1 to save)
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *GPSTATEBYTES)();
    typedef void (CALLBACK *GPSAVESTATE)(long flag, unsigned char *buf);
#else
    unsigned long CALLBACK GPStateBytes();
    void CALLBACK GPSaveState(long flag, unsigned char *buf);
#endif

// ---------------------------------------------------------------------------

// audio plugin specification

// control plugin
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *AUDSTART)(HWND hwndParent);
    typedef void (CALLBACK *AUDSTOP)();
#else
    unsigned long CALLBACK AUDStart(HWND hwndParent);
    void CALLBACK AUDStop();
#endif

// set sound buffer (16-bit, pcm, 32 or 48 kHz)
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSETSOUNDBUFFER)(unsigned short *samples, long length);
#else
    void CALLBACK AUDSetSoundBuffer(unsigned short *samples, long length);
#endif

// set streaming buffer (gcadpcm-coded, 48 kHz fixed)
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSETSTREAMBUFFER)(unsigned char *adpcm, long length);
#else
    void CALLBACK AUDSetStreamBuffer(unsigned char *adpcm, long length);
#endif

// number of played stereo samples
#ifdef USED_BY_EMULATOR
    typedef long (CALLBACK *AUDSOUNDPLAYED)();
    typedef long (CALLBACK *AUDSTREAMPLAYED)();
#else
    long CALLBACK AUDSoundPlayed();
    long CALLBACK AUDStreamPlayed();
#endif

// change sound frequency (possible values are 32000, or 48000)
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSETSOUNDFREQ)(long freq);
    typedef void (CALLBACK *AUDSETSTREAMFREQ)(long freq);
#else
    void CALLBACK AUDSetSoundFreq(long freq);
    void CALLBACK AUDSetStreamFreq(long freq);
#endif

// set stream sound volume (range is from 0 (mute) to 255)
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSETVOLUME)(unsigned char left, unsigned char right);
#else
    void CALLBACK AUDSetVolume(unsigned char left, unsigned char right);
#endif

// enable playing sound
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSTARTSOUND)(unsigned long flag);
    typedef void (CALLBACK *AUDSTARTSTREAM)(unsigned long flag);
#else
    void CALLBACK AUDStartSound(unsigned long flag);
    void CALLBACK AUDStartStream(unsigned long flag);
#endif

// dma complete interrupt callback
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDSOUNDCALLBACK)(void (*callback)());
#else
    void CALLBACK AUDSoundCallback(void (*callback)());
#endif

// user stuff
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *AUDCONFIGURE)(HWND hwndParent);
    typedef void (CALLBACK *AUDABOUT)(HWND hwndParent);
#else
    void CALLBACK AUDConfigure(HWND hwndParent);
    void CALLBACK AUDAbout(HWND hwndParent);
#endif 

// savestate (flag:0 to load, flag:1 to save)
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *AUDSTATEBYTES)();
    typedef void (CALLBACK *AUDSAVESTATE)(long flag, unsigned char *buf);
#else
    unsigned long CALLBACK AUDStateBytes();
    void CALLBACK AUDSaveState(long flag, unsigned char *buf);
#endif

// ---------------------------------------------------------------------------

// PAD plugin specification (padnum = 0...3)

#pragma pack(1)     // align structure for byte
typedef struct
{
    unsigned short  button;         // see PAD_BUTTON_ for bit layout
    signed char     stickX;         // -127...127 NOT clamped
    signed char     stickY;
    signed char     substickX;      // -127...127 NOT clamped
    signed char     substickY;
    unsigned char   triggerLeft;    // 0...255 NOT clamped
    unsigned char   triggerRight;
} PADState;
#pragma pack()      // restore old value

// controller buttons
#define PAD_BUTTON_LEFT         (0x0001)
#define PAD_BUTTON_RIGHT        (0x0002)
#define PAD_BUTTON_DOWN         (0x0004)
#define PAD_BUTTON_UP           (0x0008)
#define PAD_TRIGGER_Z           (0x0010)
#define PAD_TRIGGER_R           (0x0020)
#define PAD_TRIGGER_L           (0x0040)
#define PAD_BUTTON_A            (0x0100)
#define PAD_BUTTON_B            (0x0200)
#define PAD_BUTTON_X            (0x0400)
#define PAD_BUTTON_Y            (0x0800)
#define PAD_BUTTON_START        (0x1000)

// called, when emu starts / stops
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *PADSTART)(HWND hwndParent);
    typedef void (CALLBACK *PADSTOP)();
#else
    unsigned long CALLBACK PADStart(HWND hwndParent);
    void CALLBACK PADStop();
#endif

// read controller buttons state. returns 1, if ok, and 0, if PAD not connected
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *PADREADSTATE)(long padnum, PADState *state);
#else
    unsigned long CALLBACK PADReadState(long padnum, PADState *state);
#endif

// controller motor. 0 is returned, if rumble not supported by PAD.
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *PADSETRUMBLE)(long padnum, unsigned long flag);
#else
    unsigned long CALLBACK PADSetRumble(long padnum, unsigned long flag);
#endif

// config / about
#ifdef USED_BY_EMULATOR
    typedef void (CALLBACK *PADCONFIGURE)(long padnum, HWND hwndParent);
    typedef void (CALLBACK *PADABOUT)(HWND hwndParent);
#else
    void CALLBACK PADConfigure(long padnum, HWND hwndParent);
    void CALLBACK PADAbout(HWND hwndParent);
#endif

// savestate (flag:0 to load, flag:1 to save)
#ifdef USED_BY_EMULATOR
    typedef unsigned long (CALLBACK *PADSTATEBYTES)();
    typedef void (CALLBACK *PADSAVESTATE)(long flag, unsigned char *buf);
#else
    unsigned long CALLBACK PADStateBytes();
    void CALLBACK PADSaveState(long flag, unsigned char *buf);
#endif

#endif  // __DOLWIN_PLUGIN_SPECS_H__

// EOF
