// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "exi_01.h"
#include "degub.h"
#include "ini.h"
#include "messages.h"
#include "resource.h"
#include "main.h"
#include <time.h>

/*//From YAGCD
void sram_checksums(unsigned short *buf, unsigned short *c1, unsigned short *c2) {
int i;
*c1 = 0; *c2 = 0;
for (i = 0;i<4;++i)
{
*c1 += buf[12 + i * 2];
*c2 += (buf[12 + i * 2] ^ 0xFFFF);
}
}*/

//from dolphin
// english
unsigned char sram_dump[64] = {
	0x04, 0x6B, 0xFB, 0x91, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x40,
	0x05, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xD2, 0x2B, 0x29, 0xD5, 0xC7, 0xAA, 0x12, 0xCB,
	0x21, 0x27, 0xD1, 0x53, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x86, 0x00, 0xFF, 0x4A, 0x00, 0x00, 0x00, 0x00
};
// german
unsigned char sram_dump_german[64] ={ 
	0x1F, 0x66, 0xE0, 0x96, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0xEA, 0x19, 0x40,
	0x00, 0x00, 0x01, 0x3C, 0x12, 0xD5, 0xEA, 0xD3,
	0x00, 0xFA, 0x2D, 0x33, 0x13, 0x41, 0x26, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x84, 0xFF, 0x00, 0x00, 0x00, 0x00
};

EXIDevice_01::EXIDevice_01(HWND hWnd) : state(S_READY), ansi(0), sjis(0) {
	ZERO_OBJECT(m);
	m.hWnd = hWnd;

	//SRAM incomplete, get proper dump
	//ZeroMemory(sram, 64);
	//MAKE(DWORD, sram[0x0C]) = swapw(time(NULL));
	//the bias should be the build time, but converting from __TIMESTAMP__ is too much work right now
	//sram_checksums((WORD*)sram, (WORD*)sram, (WORD*)(sram + 2));
	memcpy(m.sram, sram_dump, 64);

	//Load IPL fonts
	{
		HRSRC hrsrc;
		HGLOBAL hRes;

		GLE(hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_ANSI), "Binary"));
		GLE(hRes = LoadResource(NULL, hrsrc));
		DEGUB("Loading ANSI font, %i bytes\n", SizeofResource(NULL, hrsrc));
		ansi.resize(SizeofResource(NULL, hrsrc));
		memcpy(ansi, LockResource(hRes), ansi.size());
		GLER(FreeResource(hRes));

		/*GLE(hrsrc = FindResource(NULL, MAKEINTRESOURCE(IDR_SJIS), "Binary"));
		GLE(hRes = LoadResource(NULL, hrsrc));
		DEGUB("Loading SJIS font, %i bytes\n", SizeofResource(NULL, hrsrc));
		sjis.resize(SizeofResource(NULL, hrsrc));
		memcpy(sjis, LockResource(hRes), sjis.size());
		GLER(FreeResource(hRes));*/
	}
}

void EXIDevice_01::notify_deselected() {
	state = S_READY;
	//DEGUB("01 deselected\n");
}

void EXIDevice_01::do_clear() {
	m.uart_clears++;
	if(g::edo_osr) {
		if(m.uart_clears > UART_CLEAR_LIMIT) {
			GLE(PostMessage(m.hWnd, LM_DEBUG, EDO_REPLACE, (LPARAM)m.uart_second_buffer));
			m.uart_second_pos = 0;
		} else {
			GLE(PostMessage(m.hWnd, LM_DEBUG, EDO_CLEAR, 0));
		}	      
	}
	ZERO_ARRAY(m.uart_buffer);
	m.uart_pos = m.uart_buffer[0] = 0;
}

EXIResultValue EXIDevice_01::writeImm(DWORD size, DWORD data) {
	if(state == S_READY) {
		if(size == 4) {
			state = S_COMMAND;
			m.cmd_address = data;
			if(EXI_01_DEGUB_CONDITION)
				DEGUB("01 Command 0x%08X stored\n", m.cmd_address);
			return EXI_HANDLED;
		} else if(size == 2 && data == 0) {
			state = S_ID;
			return EXI_HANDLED;
		}
	} else if(state == S_COMMAND) {
		if(m.cmd_address == 0xA0010000) { //UART write
			MYASSERT(m.uart_pos < sizeof(m.uart_buffer));
			for(size_t i=0; i<size; i++) {
				m.uart_buffer[m.uart_pos++] = *(((char *)&data) + (size - 1) - i);
			}
			EIDEGUB("UART write: size=%i, 0x%08X %s\n", size, data, &data);

			if(m.uart_buffer[m.uart_pos - 1] == 0x0D) {	//End of the line :}
				if(m.uart_pos > 2) {
					DEGUB("OSReport: %s", m.uart_buffer);
					emuDebug(m.uart_buffer);
					/*m.uart_buffer[m.uart_pos - 1] = '\n';
					m.uart_buffer[m.uart_pos] = 0;*/
					//m.uart_buffer[m.uart_pos-1] = 0x0A;
					m.uart_buffer[m.uart_pos++] = 0x0A;
					m.uart_buffer[m.uart_pos] = 0;
					if(g::edo_osr) {
						if(m.uart_clears > UART_CLEAR_LIMIT) {
							memcpy(m.uart_second_buffer + m.uart_second_pos, m.uart_buffer,
								m.uart_pos+1);
							m.uart_second_pos += m.uart_pos;
							/*DUMPINT(m.uart_second_pos);
							DUMPINT(m.uart_pos);
							DEGUB("Second buffer: %s", m.uart_second_buffer);*/
						} else {
							GLE(PostMessage(m.hWnd, LM_DEBUG, EDO_ADD, (LPARAM)m.uart_buffer));
						}
					}
					ZERO_ARRAY(m.uart_buffer);
				}
				m.uart_pos = m.uart_buffer[0] = 0;
			} else if(m.uart_buffer[0] == '\033') { //escape/command byte
				bool error = false;
				switch(m.uart_pos) {
				case 2:
					if(m.uart_buffer[1] == 'c') {
						DEGUB("OSReport terminal reset!\n");
						do_clear();
					} else if(m.uart_buffer[1] != '[') {
						error = true;
					}
					break;
				case 3:
					if(m.uart_buffer[2] == 'H') {
						DEGUB("OSReport terminal home!\n");
						do_clear();
					} else if(!isxdigit(m.uart_buffer[2])) {
						error = true;
					}
					break;
				case 4:
					if(isxdigit(m.uart_buffer[3])) {
						DEGUB("OSReport hex code 0x%c%c\n", m.uart_buffer[2], m.uart_buffer[3]);
						m.uart_buffer[0] = ((m.uart_buffer[2] - '0') << 4) | (m.uart_buffer[3] - '0');
						m.uart_buffer[1] = 0;
						m.uart_pos = 1;
					} else {
						error = true;
					}
					break;
				default:
					error = true;
				}
				/*if(error) {
				DEGUB("Unknown OSReport terminal command: %s\n", m.uart_buffer);
				throw hardware_fatal_exception("Unknown OSReport terminal command!");
				}*/
			}
			return EXI_HANDLED;
		} else if((m.cmd_address & 0xFFFFFF00) == 0xA0000100) {  //SRAM imm write
			BYTE sram_address = (BYTE)m.cmd_address;
			memcpy(m.sram + sram_address, &data, size);
			m.cmd_address += size;
			DEGUB("SRAM Imm write to 0x%02X: size=%i, 0x%08X\n", sram_address, size, data);
			return EXI_HANDLED;
		} else if((m.cmd_address & 0xFFFFFF00) == 0xA0000600) {  //Unknown imm write
			BYTE sram_address = (BYTE)m.cmd_address;
			m.cmd_address += size;
			DEGUB("01 0xA0000600 Imm write(nerfed): 0x%02X | %i | 0x%08X\n",
				sram_address, size, data);
			return EXI_HANDLED;
		}
	}

	DEGUB("Unhandled 01 Imm write: size=%i, 0x%08X\n", size, data);
	if(state == S_COMMAND)
		DEGUB("Command: 0x%08X\n", m.cmd_address);
	//if(g::bouehr)
	throw bouehr_exception("Unhandled 01 Imm write");
	//return EXI_UNHANDLED;
}

EXIResultValue EXIDevice_01::readImm(DWORD size, DWORD &data) {
	if(state == S_ID) {
		data = 0;
		DEGUB("01 device ID request. 0 returned.\n");
		return EXI_HANDLED;
	} else if(state == S_COMMAND) {
		if(m.cmd_address >= 0x20000100 && m.cmd_address + size <= 0x20000100 + 64) {  //SRAM
			DWORD offset = m.cmd_address & 0xFF;
			data = 0;
			memcpy(&data, m.sram + offset, size);
			data = swapw(data); //we have a byteswap problem...
			DEGUB("SRAM Imm read, %i bytes from offset 0x%02X: 0x%0*X\n", size,
				offset, size*2, getbitsw(data, 0, size * 8 - 1));
			m.cmd_address += size;
			return EXI_HANDLED;
		} else if(m.cmd_address == 0x20000000 && size == 4) {	//RTC
			if(g::timing_mode == g::TM_REALTIME) {
				//use mktime with 00:00 01-01-2000 here to get magic value
				/*tm gcbase;
				ZERO_OBJECT(gcbase);
				gcbase.tm_year = 2000-1900;
				gcbase.tm_mday = 1;
				time_t tt_gcbase = mktime(&gcbase);
				if(tt_gcbase == -1)
				throw hardware_fatal_exception("Big Phat RTC error!");*/
				data = DWORD(time(NULL) - 946681200);  //convert C time to GC time
			} else if(g::timing_mode == g::TM_EXACT_FAST) {
				data = m.rtc_exact++;
			} else {
				//throw hardware_fatal_exception("Unimplemented timing mode!");
				data = DWORD(g_capp.getCPU()->getCycles() / BOGOMIPS);
			}
			//if(EXI_01_DEGUB_CONDITION)
			static DWORD last_read; //invalid? fix?
			static DWORD nreads;
			if(last_read == data)
				nreads++;
			if(last_read != data || nreads == 1) {
				DEGUB("RTC Imm read: 0x%08X", data);
				if(nreads > 1) {
					DEGUB(" x%i", nreads);
					nreads = 0;
				}
				DEGUB("\n");
				last_read = data;
			}
			m.cmd_address += size;
			return EXI_HANDLED;
		} else if(m.cmd_address == 0x20010000) {  //UART
			data = 0x03000000;  //unknown, from gcube
			return EXI_HANDLED;
		}
	}

	DEGUB("Unhandled 01 Imm read: size=%i, 0x%08X\n", size, data);
	if(state == S_COMMAND)
		DEGUB("Command: 0x%08X\n", m.cmd_address);
	//if(g::bouehr)
	throw bouehr_exception("Unhandled 01 DMA read");
	//return EXI_UNHANDLED;
}

EXIResultValue EXIDevice_01::writeDMA(DWORD size, DWORD address, MemInterface &) {
	//if(true) {
	//return EXI_HANDLED;
	//} else {
	DEGUB("Unhandled 01 DMA write: size=%i, 0x%08X\n", size, address);
	if(state == S_COMMAND)
		DEGUB("Command: 0x%08X\n", m.cmd_address);
	//if(g::bouehr)
	throw bouehr_exception("Unhandled 01 DMA write");
	//return EXI_UNHANDLED;
	//}
}

EXIResultValue EXIDevice_01::readDMA(DWORD size, DWORD address, MemInterface &mem) {
	bool handled = false;
	if(state == S_COMMAND) {
		if(m.cmd_address == 0x20000100 && size == 64) {	//SRAM
			mem.write_physical(address, size, m.sram);
			DEGUB("SRAM DMA read: %i bytes to 0x%08X\n", size, address);
			handled = true;
		} else if((m.cmd_address & 0xF0000000) == 0) {
			DWORD rom_address = m.cmd_address >> 6;
			DEGUB("01 DMA read: %i bytes from 0x%06X to 0x%08X: ", size,
				rom_address, address);
#define ANSI_BASE 0x001FCF00
#define ANSI_END  0x00200000  //hacky?
			if(rom_address >= ANSI_BASE) {
				handled = true;
				if(rom_address + size <= ANSI_BASE + ansi.size()) {
					DEGUB("ANSI font read\n");
					mem.write_physical(address, size, ansi.p() + (rom_address - ANSI_BASE));
				} else if(rom_address <= ANSI_BASE + ansi.size()) {
					DWORD s, b;
					s = (ANSI_BASE + ansi.size()) - rom_address;
					b = (rom_address - ANSI_BASE);
					DEGUB("ANSI font read (partly out of bounds)(%i, %i)\n", s, b);
					mem.write_physical(address, s, ansi.p() + b);
				} else if(rom_address + size <= ANSI_END) {
					DEGUB("ANSI font read (Out of bounds, nerfed)\n");
				} else
					handled = false;	
			}
			if(!handled) {
				DEGUB("Unhandled!\n");
				throw hardware_fatal_exception("Unhandled Mask ROM read!");
			}
		}
	}
	if(!handled) {
		DEGUB("Unhandled 01 DMA read: %i bytes from 0x%08X to 0x%08X\n",
			size, m.cmd_address, address);
		if(state == S_COMMAND)
			DEGUB("Command: 0x%08X\n", m.cmd_address);
		//if(g::bouehr)
		throw bouehr_exception("Unhandled 01 DMA read");
	}
	return handled ? EXI_HANDLED : EXI_UNHANDLED;
}
