// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "exi_ad16.h"
#include "degub.h"
#include "ini.h"
#include "version.h"
#include <time.h>

EXIDevice_AD16::EXIDevice_AD16() : state(AD16_READY) {}

void EXIDevice_AD16::notify_deselected() {
}

#define MAGIC_WORD 0xC001F00D
#define MAGIC_BYTE 0xEC

EXIResultValue EXIDevice_AD16::writeImm(DWORD size, DWORD data) {
	if(state == AD16_READY) {
		if(size == 4 && data == MAGIC_WORD) {
			DEGUB("AD16 Magic charged.\n");
			state = AD16_MAGIC;
			return EXI_HANDLED;
		} else if(size == 2 && data == 0) {
			DEGUB("AD16 Device ID request\n");
			state = AD16_ID;
			return EXI_HANDLED;
		} else if(size == 1 && data == 0xA0) {
			state = AD16_WRITE;
			return EXI_HANDLED;
		}
	} else if(state == AD16_WRITE && size == 4) {
		DEGUB("AD16 Write: 0x%08X\n", data);
		reg = data;
		state = AD16_READY;
		return EXI_HANDLED;
	} //else if(g::bouehr)
	throw bouehr_exception("Unhandled AD16 Imm write");
}

EXIResultValue EXIDevice_AD16::readImm(DWORD size, DWORD &data) {
	if(state == AD16_MAGIC) {
		if(size != 4)
			throw hardware_fatal_exception(
			"This should teach you to screw around with black magic :P");
		data = (DWORD)MAGIC_BYTE << 24 | RELEASE_NUMBER;
		state = AD16_READY;
	} else if(state == AD16_ID && size == 4) {
		data = EXI_DEVTYPE_AD16;
		state = AD16_READY;
	} else// if(g::bouehr)
		throw bouehr_exception("Unhandled AD16 Imm read");

	DEGUB("AD16 Imm read: size=%i, 0x%08X\n", size, data);

	return EXI_HANDLED;
}

EXIResultValue EXIDevice_AD16::writeDMA(DWORD size, DWORD address, MemInterface &) {
	DEGUB("AD16 DMA write: %i bytes from 0x%08X\n", size, address);
	//if(g::bouehr)
	throw bouehr_exception("AD16 DMA write");
	//return EXI_HANDLED;
}

EXIResultValue EXIDevice_AD16::readDMA(DWORD size, DWORD address, MemInterface &) {
	DEGUB("AD16 DMA read(nerfed): %i bytes to 0x%08X\n", size, address);
	//if(g::bouehr)
	throw bouehr_exception("AD16 DMA read");
	//return EXI_HANDLED;
}
