// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef CPU_H
#define CPU_H

#include "common.h"
#include "memory.h"
#include "registers.h"
#include "array.h"
#include "hardware.h"
#include "container.h"
#include "oparray.h"
#include "corebase.h"
#include <exception>
#include <vector>

using namespace std;

class CPU : public CoreBase {
public:
	CPU(CORE_ARGUMENTS a);
	~CPU() {}
	bool disassemble();
	string getdasma(DWORD address);
	string getdasmo(DWORD cia, DWORD opcode);

	DWORD getNIA() { return nia; }
private:
	bool handle_load();
	bool _run(DWORD runstop, bool degub, QWORD degub_skip, bool dumpmem);
	void degub_changes(bool on, bool all) const;
	bool take_interrupt(DWORD requested_nia);

	typedef void (CPU::*cpu_popf)();
	OpArray<cpu_popf> priarr;

	OPCODES(DECLARE_OPFUNC);
	void _addic_();
	void _stwcx_();
	void __undefined();
	UNIMPLEMENTED_OPCODES(DECLARE_OPFUNC);

	Memory m;
	DWORD cia, nia, opcode;
	DWORD *fetch_pointer;
#define SET_FETCH(address) { nia = (address); fetch_pointer = m.get_fetch(address);\
	if(g::use_map) do_symbol(address); }
	mutable RegistersBase old_registers;
	bool m_run_degub;
	bool error;

	bool last_branch_unconditional;

	/*#include "hle.h"
	bool run_hle();
	int hle_init(DWORD start, DWORD size);

	struct HLE_INTERCEPT {
		DWORD address;
		DWORD index;
	};
	vector<HLE_INTERCEPT> hle_intercept; //Memory addresses for intercept*/
};

#endif //CPU_H
