// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef DEFINECOMMONS_H
#define DEFINECOMMONS_H

#define APP_NAME "WhineCube"

#define MAKE(type, arg) (*(type *)&(arg))
#define MAKEP(type, arg) ((type *)(void *)(arg))

#define STRINGIZE(meh) #meh
#define NOTHING(meh) meh
#define FIRST(a, b) a
#define STRINGIZE_FIRST(a, b) #a
#define SECOND(a, b) b
#define COMMA(meh) ,meh
#define COMMA_STRINGIZE(meh) ,#meh

#define K ((DWORD)1024)
#define M (K*K)
#define G (M*K)
#define I32 (__int64(1<<32))
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX(a, b) ((a) > (b) ? (a) : (b))
#define CLAMPLOW(a, val) (a) = MAX((a), (val))
#define CLAMPHIGH(a, val) (a) = MIN((a), (val))
#define M_PI 3.14159265358979323846
typedef unsigned __int64 QWORD;

#define MAX_PATH_BUFFER_SIZE(nFiles) ((nFiles) * (MAX_PATH + 1) + 1)

#define MASKED_NEQUAL(a, b, mask) (((a) ^ (b)) & (mask))
#define MASKED_EQUAL(a, b, mask) (!MASKED_NEQUAL(a, b, mask))
#define ALL_FLAGS(field, flags) (((field) & (flags)) == (flags))
#define RISE_FLAG(n, o, flag) (((n) & (flag)) && !((o) & (flag)))
#define FALL_FLAG(n, o, flag) (!((n) & (flag)) && ((o) & (flag)))

#define IS_WITHIN(a, start, end) ((a) >= (start) && (a) < (end))
#define MAX_DWORD ((DWORD)-1)
#define MAX_WORD ((WORD)-1)

typedef unsigned int uint;
typedef void* HANDLE;
typedef unsigned long DWORD;
typedef unsigned short WORD;
typedef signed __int64 s64;
typedef unsigned __int64 u64;
typedef signed __int32 s32;
typedef unsigned __int32 u32;
typedef signed __int16 s16;
typedef unsigned __int16 u16;
typedef signed __int8 s8;
typedef unsigned __int8 u8;

#endif	//DEFINECOMMONS_H
