// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.


/*#define PARAM_NAME_NONE none
#define PARAM_NAME_VAL val
#define PARAM_NAME_IMM imm
#define PARAM_NAME_MEM mem
#define PARAM_NAME_STR str
#define PARAM_NAME_REG reg
#define PARAM_NAME_REG08 reg08
#define PARAM_NAME_REG10 reg10
#define PARAM_NAME_REG18 reg18
#define PARAM_NAME_REG19 reg19
#define PARAM_NAME_REG1A reg1a
#define PARAM_NAME_REG1C reg1c
#define PARAM_NAME_ACC acc
#define PARAM_NAME_ACCD accd
#define PARAM_NAME_REF ref
#define PARAM_NAME_PRG prg*/

#define PARAM_TYPE_1 BYTE
#define PARAM_TYPE_2 WORD

#define DEFINE_PARAMS(type, name)\
	DSP##type##_##name(DEFINE_PARAMS_BASE)(type, name)
#define DEFINE_PARAMS_BASE(code, mask, size, nparams)\
	DEFINE_##nparams##_PARAMS

#define DEFINE_0_PARAMS(type, name)
#define DEFINE_1_PARAMS(type, name) DSP##type##_##name##_PARAM1(DEFINE_PARAM)
#define DEFINE_2_PARAMS(type, name) DEFINE_1_PARAMS(type, name)\
	DSP##type##_##name##_PARAM2(DEFINE_PARAM)
#define DEFINE_3_PARAMS(type, name) DEFINE_2_PARAMS(type, name)\
	DSP##type##_##name##_PARAM3(DEFINE_PARAM)

#define DEFINE_PARAM(name, type, size, loc, lshift, mask)\
	PARAM_TYPE_##size p##name = PARAM_TYPE_##size((iRead(m.cpc+loc) & mask) >> lshift);\
	//if(P_##type == P_MEM && size == 1) p##name = (WORD)(char)p##name;

#define DO_SIZE_EXT(code, mask, size, nparams) const bool do_ext = bool(size & P_EXT);\
	m.npc += size & ~P_EXT;

#define START_OPCODE(name)\
	void DSPInterpreter::_##name() { DEFINE_PARAMS(OP, name) DSPOP_##name(DO_SIZE_EXT)
#define END_OPCODE if(do_ext) execute_ext((BYTE)iRead(m.cpc)); }

#define START_EXT_OPCODE(name)\
	void DSPInterpreter::_x##name() { DEFINE_PARAMS(EXT, name)
#define END_EXT_OPCODE }

/*
macro\({:i}\)\\$
START_OPCODE(\1) {\n  throw hardware_fatal_exception("DSP unemulated opcode!");\n} END_OPCODE\n
*/

#pragma warning(disable:4127 4189 4702)
