// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef EXI_01_H
#define EXI_01_H

#include "hw_ei.h"

class EXIDevice_01 : public EXIDevice {
public:
	EXIDevice_01(HWND hwnd);
	EXIResultValue writeImm(DWORD size, DWORD data);
	EXIResultValue writeDMA(DWORD size, DWORD address, MemInterface &mem);
	EXIResultValue readImm(DWORD size, DWORD &data);
	EXIResultValue readDMA(DWORD size, DWORD address, MemInterface &mem);
	void notify_deselected();
private:
	Container<BYTE> ansi, sjis;
	enum State { S_READY, S_COMMAND, S_ID } state;
	struct ZEROABLE {
		DWORD cmd_address;
		BYTE sram[64];
		char uart_buffer[1024], uart_second_buffer[80*40+4];
		size_t uart_pos, uart_second_pos;
		int uart_clears;
		HWND hWnd;
		DWORD rtc_exact;
	} m;
	void do_clear();
};

#define UART_CLEAR_LIMIT 10 //arbitrary

#endif	//EXI_01_H
