// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef EXI_BBA_H
#define EXI_BBA_H

#include "hw_ei.h"

class EXIDevice_BBA : public EXIDevice {
public:
	EXIDevice_BBA(EXIInterruptRaiser& eir);
	~EXIDevice_BBA();

	EXIResultValue writeImm(DWORD size, DWORD data);
	EXIResultValue writeDMA(DWORD size, DWORD address, MemInterface &mem);
	EXIResultValue readImm(DWORD size, DWORD &data);
	EXIResultValue readDMA(DWORD size, DWORD address, MemInterface &mem);
	void notify_deselected();
	bool pause();
	bool resume();
private:
	//Doesn't contain error checks for wraparound writes
	class CyclicBufferWriter {
	public:
		CyclicBufferWriter(BYTE *buffer, size_t cap) : _buffer(buffer), _cap(cap),
			_write(0) {}

		size_t p_write() const { return _write; }
		void reset() { _write = 0; }

		void write(void *src, size_t size);
		void align();	//aligns the write pointer to steps of 0x100, like the real BBA
	private:
		size_t _write;
		size_t _cap;	//capacity
		BYTE *_buffer;
	};

	EXIInterruptRaiser& interrupt;
	//Variable I/O
	//#define MAC_ADDRESS_SIZE 6
	//BYTE mac_address[MAC_ADDRESS_SIZE];
#define BBAMEM_SIZE 0x1000
	BYTE mBbaMem[BBAMEM_SIZE];
	WORD mWriteP, mReadP;	//reset to -1 on deselect
#define INVALID_P 0xFFFF
	bool mExpectVariableLengthImmWrite;
	bool mReadyToSend;

	WriteBuffer mWriteBuffer;
	CyclicBufferWriter mCbw;
#define CB_OFFSET 0x100
#define CB_SIZE (BBAMEM_SIZE - CB_OFFSET)
#define SIZEOF_RECV_DESCRIPTOR 4
	WORD mRBRPP;  //RRP - Receive Buffer Read Page Pointer
	bool mRBEmpty;

	DWORD mPacketsSent, mPacketsRcvd;
	bool mSendIrqRaised, mRecvIrqRaised;

	//Special I/O
	bool mExpectSpecialImmRead;	//reset to false on deselect
	DWORD mSpecialImmData;

	HANDLE mHAdapter, mHRecvEvent, mHReadWait;
	DWORD mMtu;
	OVERLAPPED mReadOverlapped;
	Container<BYTE> mRecvBuffer;
	DWORD mRecvBufferLength;
	volatile bool mWaiting;

	bool activate();
	bool deactivate();
	bool isActivated() const { return mHAdapter != INVALID_HANDLE_VALUE; }
	bool sendPacket(BYTE* etherpckt, size_t size);
	bool startRecv();
	bool handleRecvdPacket();
	bool cbwriteDescriptor(DWORD size);
	void recordSendComplete();
	bool checkRecvBuffer();

	static VOID CALLBACK ReadWaitCallback(PVOID lpParameter,
		BOOLEAN TimerFired);
};

#define BBADEGUB if(g::bba_log) DEGUB

#define BBA_NCRA				0x00		/* Network Control Register A, RW */
#define BBA_NCRA_RESET			(1<<0)	/* RESET */
#define BBA_NCRA_ST0			(1<<1)	/* ST0, Start transmit command/status */
#define BBA_NCRA_ST1			(1<<2)	/* ST1,  " */
#define BBA_NCRA_SR				(1<<3)	/* SR, Start Receive */

#define BBA_NCRB				0x01		/* Network Control Register B, RW */
#define BBA_NCRB_PR				(1<<0)	/* PR, Promiscuous Mode */
#define BBA_NCRB_CA				(1<<1)	/* CA, Capture Effect Mode */
#define BBA_NCRB_PM				(1<<2)	/* PM, Pass Multicast */
#define BBA_NCRB_PB				(1<<3)	/* PB, Pass Bad Frame */
#define BBA_NCRB_AB				(1<<4)	/* AB, Accept Broadcast */
#define BBA_NCRB_HBD			(1<<5)	/* HBD, reserved */
#define BBA_NCRB_RXINTC0		(1<<6)	/* RXINTC, Receive Interrupt Counter */
#define BBA_NCRB_RXINTC1		(1<<7)	/*  " */
#define BBA_NCRB_1_PACKET_PER_INT  (0<<6)	/* 0 0 */
#define BBA_NCRB_2_PACKETS_PER_INT (1<<6)	/* 0 1 */
#define BBA_NCRB_4_PACKETS_PER_INT (2<<6)	/* 1 0 */
#define BBA_NCRB_8_PACKETS_PER_INT (3<<6)	/* 1 1 */

#define BBA_NWAYC 0x30		/* NWAY Configuration Register, RW, 84h */
#define   BBA_NWAYC_FD       (1<<0)	/* FD, Full Duplex Mode */
#define   BBA_NWAYC_PS100    (1<<1)	/* PS100/10, Port Select 100/10 */
#define   BBA_NWAYC_ANE      (1<<2)	/* ANE, Autonegotiation Enable */
#define   BBA_NWAYC_ANS_RA   (1<<3)	/* ANS, Restart Autonegotiation */
#define   BBA_NWAYC_LTE      (1<<7)	/* LTE, Link Test Enable */

#define BBA_NWAYS 0x31
#define   BBA_NWAYS_LS10	 (1<<0)
#define   BBA_NWAYS_LS100	 (1<<1)
#define   BBA_NWAYS_LPNWAY   (1<<2)
#define   BBA_NWAYS_ANCLPT	 (1<<3)
#define   BBA_NWAYS_100TXF	 (1<<4)
#define   BBA_NWAYS_100TXH	 (1<<5)
#define   BBA_NWAYS_10TXF	 (1<<6)
#define   BBA_NWAYS_10TXH	 (1<<7)

#endif	//EXI_BBA_H
