// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef FILE_H
#define FILE_H

#include "defineCommons.h"

//Handles binary files. Uses GLE system.
class ReadOnlyFile {
public:
	ReadOnlyFile();
	~ReadOnlyFile();
	bool open(const char* filename);
	bool isOpen();
	bool close();
	bool read(void* dst, uint size);
	bool size(uint* result);
	bool seek(uint pos);
	bool tell(uint* result);

	bool readbswapw(DWORD* dst, size_t count);
	bool readbswaph(WORD* dst, size_t count);
private:
	ReadOnlyFile(const ReadOnlyFile&);
	ReadOnlyFile& operator=(const ReadOnlyFile&);
protected:
	HANDLE mHandle;
};

class File : public ReadOnlyFile {
public:
	enum OpenMode { OpenExisting, CreateAlways, CreateNew };
	bool open(const char* filename, OpenMode mode);
	bool write(const void* src, uint size);
private:
	bool open(const char* filename);
};

#endif
