// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef GP_TEXTURE_H
#define GP_TEXTURE_H

#include "gp.h"

//Texture formats
enum GXTlutFmt{
	GX_TL_IA8	= 0x0,
	GX_TL_RGB565	= 0x1,
	GX_TL_RGB5A3	= 0x2
};
enum GXTexFmt {
	GX_TF_I4	= 0x0,
	GX_TF_I8	= 0x1,
	GX_TF_IA4	= 0x2,
	GX_TF_IA8	= 0x3,
	GX_TF_RGB565	= 0x4,
	GX_TF_RGB5A3	= 0x5,
	GX_TF_RGBA8	= 0x6,
	GX_TF_C4	= 0x8,
	GX_TF_C8	= 0x9,
	GX_TF_C14	= 0xA,
	GX_TF_CMPR	= 0xE
};
#define TX_ISCI(format) (format >= 8 && format <= 10) //Color Index

void conv_i4_ai8(BYTE *dest, const BYTE *src);
void conv_i8_ai8(BYTE *dest, const BYTE *src);
void conv_ia4_ai8(BYTE *dest, const BYTE *src);
void conv_ia8_ai8(BYTE *dest, const BYTE *src);
void conv_16(BYTE *dest, const BYTE *src);
void conv_rgb5a3_bgra8(BYTE *dest, const BYTE *src);
void conv_rgba8_bgra8(BYTE *dest, const BYTE *src);

void dump_i4(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_i8(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_ia4(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_ia8(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_rgb565(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_rgb5a3(BYTE *color, BYTE *alpha, const BYTE *src);
void dump_rgba8(BYTE *color, BYTE *alpha, const BYTE *src);

void conv_c4(BYTE *dest, const BYTE *src);
void conv_c8(BYTE *dest, const BYTE *src);
void conv_c14(BYTE *dest, const BYTE *src);
void dump_c4(BYTE *color, BYTE *alpha, BYTE *index, const BYTE *src);
void dump_c8(BYTE *color, BYTE *alpha, BYTE *index, const BYTE *src);
void dump_c14(BYTE *color, BYTE *alpha, BYTE *index, const BYTE *src);

enum PixelSize { PS_4, PS_8, PS_16, PS_32, NUM_PS, INVALID_PS };
const struct TXPS {
	size_t bits, tile_width, tile_height;
} txps[NUM_PS] = { {4,8,8}, {8,8,4}, {16,4,4}, {32,4,4} };

enum TargetFormat { TF_AI8, TF_RGB565, TF_ARGB8, TF_P8, TF_I16, NUM_TF, INVALID_TF };
const struct TXTF {
	D3DFORMAT format;
	size_t bytes;
} txtf[NUM_TF] = {
	{D3DFMT_A8L8,2}, {D3DFMT_R5G6B5,2}, {D3DFMT_A8R8G8B8,4}, {D3DFMT_P8,1},
	{D3DFMT_L16,2}
};

const struct TXFC {
	TargetFormat tf;
	void (*dump)(BYTE *, BYTE *, const BYTE *);  //alpha may be unused(NULL)
	size_t dump_color;
	bool dump_alpha;
	void (*conversion)(BYTE *, const BYTE *);
} txfc[] = {
	{TF_AI8, dump_ia8, 1, 1, conv_ia8_ai8},
	{TF_RGB565, dump_rgb565, 3, 0, conv_16},
	{TF_ARGB8, dump_rgb5a3, 3, 1, conv_rgb5a3_bgra8}
};

const struct TXF {
	size_t dump_color;
	bool dump_alpha;
	void (*dump)(BYTE *, BYTE *, const BYTE *);  //alpha may be unused(NULL)
	void (*conversion)(BYTE *, const BYTE *);
	PixelSize pixelsize;
	TargetFormat targetformat;
} txf[] = {
	{1, 0, dump_i4, conv_i4_ai8, PS_4, TF_AI8},
	{1, 0, dump_i8, conv_i8_ai8, PS_8, TF_AI8},
	{1, 1, dump_ia4, conv_ia4_ai8, PS_8, TF_AI8},
	{1, 1, dump_ia8, conv_ia8_ai8, PS_16, TF_AI8},
	{3, 0, dump_rgb565, conv_16, PS_16, TF_RGB565},
	{3, 1, dump_rgb5a3, conv_rgb5a3_bgra8, PS_16, TF_ARGB8},
	{3, 1, dump_rgba8, conv_rgba8_bgra8, PS_32, TF_ARGB8},
	{0, 0, 0, 0, INVALID_PS,INVALID_TF},
	{0, 0, 0, conv_c4, PS_4, INVALID_TF},
	{0, 0, 0, conv_c8, PS_8, INVALID_TF},
	{0, 0, 0, conv_c14, PS_16, INVALID_TF},
	{0, 0, 0, 0, INVALID_PS, INVALID_TF},
	{0, 0, 0, 0, INVALID_PS, INVALID_TF},
	{0, 0, 0, 0, INVALID_PS, INVALID_TF},
	{3, 1, 0, 0, PS_4, TF_ARGB8},	//we should recompress these
	{0, 0, 0, 0, INVALID_PS, INVALID_TF}
};

#endif	//GP_TEXTURE_H
