// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

//This file is meant to be included inside the CoreBase class definition.

struct OOVPA {	//Optimized Offset Value Pair Array
	OVP *array;
	DWORD alen;
	void (CoreBase::* function)();
	char *name;

	//Initialized to INVALID_OOVPA_ADDRESS, this is the physical address
	//of the function whose calls will be intercepted.
	//Maybe we'll use logical addresses instead.
	DWORD paddress;

	DWORD flen; //The length in bytes of the original function
	DWORD crc;  //CRC of the original function
};

void oovpa_do_section(DWORD base_address, DWORD size);
DWORD generic_oovpa_func(DWORD callee_address, DWORD i);

#define OOVPAS(m_first, macro, m_last) \
	m_last(NOOVPAS)
//m_first(CARDUnlock)\

#define DECLARE_OOVPA_FUNCTION(id) void id##_f();
#define NULL_MACRO(id)
#define DECLARE_OOVPA_STRUCT(id) { id##_d, sizeof(id##_d) / sizeof(OVP), id##_f, #id,\
	INVALID_ADDRESS }
#define DECLARE_OOVPA_STRUCT_MIDDLE(id) ,DECLARE_OOVPA_STRUCT(id)

OOVPAS(DECLARE_OOVPA_FUNCTION, DECLARE_OOVPA_FUNCTION, NULL_MACRO)

//These are not to be used. They are only placeholders for NOOVPAS.
#define __E1337_ENUM(id) id
#define __E1337_ENUM_NONLAST(id) id,
enum __noovpas_enum {
	OOVPAS(__E1337_ENUM_NONLAST, __E1337_ENUM_NONLAST, __E1337_ENUM) };

//static OOVPA oovpas[NOOVPAS];
/*
//Designed for inclusion in class CPU, private section

struct HLE {
  const DWORD *code;
  size_t csize;
  cpu_popf function;
  const char *name;
};

bool is_hle_match(DWORD base_address, const HLE &hle);

#define HLES(m_first, macro, m_last) \
  m_first(bdvd1)\
  macro(testdemo21)\
  macro(riptool1)\
  m_last(HLEARR_SIZE)

#define DECLARE_HLE_FUNCTION(id) void id##_f();
#define NULL_MACRO(id)
#define DECLARE_HLE_STRUCT(id) { id##_d, sizeof(id##_d) / sizeof(DWORD), id##_f, #id }
#define DECLARE_HLE_STRUCT_MIDDLE(id) ,DECLARE_HLE_STRUCT(id)

HLES(DECLARE_HLE_FUNCTION, DECLARE_HLE_FUNCTION, NULL_MACRO)

//These are not to be used. They are only placeholders for HLEARR_SIZE.
#define __E1337_ENUM(id) id
#define __E1337_ENUM_NONLAST(id) id,
enum __hlearr_size_enum {
  HLES(__E1337_ENUM_NONLAST, __E1337_ENUM_NONLAST, __E1337_ENUM) };

static const HLE hlearr[HLEARR_SIZE];
*/