// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_AI_H
#define HW_AI_H

#include "hw_internal.h"

#define ARAM_SIZE (16*M)

class HwAI {
public:
	static WORD rh_dma_bl(Hardware *h, WORD offset);
	static WORD rh_mail_dsp_high(Hardware* h, WORD offset);
	static void wh_mail_dsp_high(Hardware *h, WORD offset, WORD data);
	static void wh_mail_dsp_low(Hardware *h, WORD offset, WORD data);
	static WORD rh_mail_cpu_high(Hardware *h, WORD offset);
	static WORD rh_mail_cpu_low(Hardware *h, WORD offset);
	static WORD rh_ar_mode(Hardware *h, WORD offset);
	static void wh_dspcr(Hardware *h, WORD offset, WORD data);
	static void wh_dma_cr(Hardware *h, WORD offset, WORD data);
	static void ww_aicr(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_aicr(Hardware *h, WORD offset);
	static void ww_ar_dma(Hardware *h, WORD offset, DWORD data);
	static void wh_ar_dma_high(Hardware *h, WORD offset, WORD data);
	static void wh_ar_dma_low(Hardware *h, WORD offset, WORD data);
	static DWORD rw_aiscnt(Hardware *h, WORD offset);
	static void ww_aivr(Hardware *h, WORD offset, DWORD data);

	static void assert_dsp_interrupt(Hardware *h);
	//static void do_events(Hardware *h, ULI et);
private:
	//DSP HLE
	static void handle_mail(Hardware *h, WORD high, WORD low);
	static DWORD get_mail(Hardware *h);
	static void set_state(Hardware *h, DWORD crc);

	static void do_aram_dma_transfer(Hardware *h, DWORD data);
	static void assert_aram_interrupt(Hardware *h);
	static DWORD calculateAISCNT(Hardware *h);
	static void ai_dma_interrupt_callback(Hardware *h);
	static void aram_interrupt_callback(Hardware *h);
	static void dsp_interrupt_callback(Hardware *h);
	static void assert_dma_interrupt(Hardware *h);
	static void dma_playing_event(Hardware *h);
	static void dma_buffering_event(Hardware *h);
	static void sci_event(Hardware *h);
};

#define AIDEGUB if(g::log_audio) DEGUB
#define VAIDEGUB if(g::log_audio && g::verbose) DEGUB
#define DSPLOG if(g::dsp_log) DEGUB

#define LENGTH_PER_SECOND ((aicr & AICR_DSR) ? 32000/8 : 48000/8)

//DSP HLE
#define NO_MAIL 0//0x8071FEED//0x80544348//
enum DSPHLEState { DSPS_UNINIT, DSPS_AX, DSPS_CARD, DSPS_UNKNOWN };
enum DSPInitState { DSPIS_1, DSPIS_2, DSPIS_INIT };

#define PR_AICR		0x6C00
#define PR_AIVR		0x6C04
#define PR_AISCNT	0x6C08
#define PR_AIIT		0x6C0C

#define PR_DMBH	0x5000	//to DSP
#define PR_DMBL	0x5002
#define PR_CMBH	0x5004	//to CPU
#define PR_CMBL	0x5006

#define PR_DSPCR 0x500A

#define DSPCR_ON		0x0800
#define DSPCR_DMASTATE		0x0200
#define DSPCR_DSPINTMSK		0x0100
#define DSPCR_DSPINT		0x0080
#define DSPCR_ARINTMSK		0x0040
#define DSPCR_ARINT		0x0020
#define DSPCR_AIDINTMASK	0x0010
#define DSPCR_AIDINT		0x0008
#define DSPCR_HALT		0x0004
#define DSPCR_PIINT		0x0002
#define DSPCR_RESET		0x0001

#define AICR_PSTAT	0x00000001
#define AICR_AFR	0x00000002
#define AICR_AIINTMSK	0x00000004
#define AICR_AIINT	0x00000008
#define AICR_AIINTVLD	0x00000010
#define AICR_SCRESET	0x00000020
#define AICR_DSR	0x00000040

#endif	//HW_AI_H
