// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef HW_SI_H
#define HW_SI_H

#include "hw_internal.h"

class HwSI {
public:
	static void ww_out(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_in(Hardware *h, WORD offset);
	static void ww_cr(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_cr(Hardware *h, WORD offset);
	static void ww_sr(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_sr(Hardware *h, WORD offset);
	static void ww_poll(Hardware *h, WORD offset, DWORD data);
	static DWORD rw_poll(Hardware *h, WORD offset);
	static void ww_exilk(Hardware *h, WORD offset, DWORD data);
};

#define SIPOLL_EN(ch)	makeflagr(7 - ch)

#define SISR_WR		0x80000000
#define SISR_RDST(ch)	makeflagr(29 - ch*8)
#define SISR_WRST(ch)	makeflagr(28 - ch*8)
#define SISR_NOREP(ch)	makeflagr(27 - ch*8)
#define SISR_COLL(ch)	makeflagr(26 - ch*8)
#define SISR_OVRUN(ch)	makeflagr(25 - ch*8)
#define SISR_UNRUN(ch)	makeflagr(24 - ch*8)
#define SI_ALLCHANS(macro) (macro(0) | macro(1) | macro(2) | macro(3))

#define SICR_TCINT	0x80000000
#define SICR_TCINTMSK	0x40000000
#define SICR_COMERR	0x20000000
#define SICR_RDSTINT	0x10000000
#define SICR_RDSTMSK	0x08000000
#define SICR_TSTART	1

#define SI_POLL	0x6430
#define SI_CR	0x6434
#define SI_SR	0x6438
#define SI_EXILK 0x643C

#endif	//HW_SI_H
