// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef INI_H
#define INI_H

//#include "common.h"
#include "memcard.h"
#include <vector>
#include <string>
#define _WIN32_WINNT 0x0500
#include <windows.h>

class IniVariable;
using namespace std;

class IniSystem {
public:
	IniSystem(const string& aFilename);
	~IniSystem();
	bool DoIniFile(); //Call this first. It initializes the INI system.
	bool WriteIniFile();
private:
	const string mFilename;
	std::vector<IniVariable*> mVars;
	IniSystem& operator=(const IniSystem&);
};

struct PAD_SCANCODES {	//change to PAD_SETTINGS
	BYTE a, b, x, y, z, start, l, r, aup, aleft, adown, aright,
		dup, dleft, ddown, dright, cup, cleft, cdown, cright;
};

namespace g {
	//Configuration variables
	extern bool recompiler, hrr, rec_onestep, rec_disasm, hle, degub_msg,
		beep, degub_run, dumpmem, /*dual_run,*/ bouehr,
		dump_rec_bin_asm, lowmem_log, advanced_mode, dump_audio, quiet, verbose,
		log_interrupts, cache_enabled, nerf_sc, gcube, log_audio, autopause,
		gp_dtex, gp_dtexraw, iloop, software_yuyv,
		open_edo_on_load, gp_wireframe, gp_flat, gp_log, use_map, edo_osr, gp_white,
		use_mdvd, frame_limit, disassembly_mode, exi_log, memcard_log, bba_log,
		rec_log, gp_frame_dump, si_log, always_on_top, dsp_log, fifo_log, gp_pixelshader,
		rename_degub, degub_on, dvd_log, gp_dlrec, separate_emudebug_file, wii, dsp_hle;
	extern UINT degub_skip, dual_skip, audio_buffer_min_size_ms;
	extern UINT ip_src, ip_dst_old, ip_dst_new;
	extern BYTE mac_address[6];
	extern std::string mdvd_filename;
	extern MEMCARDSLOT_INFO memcardslot_info[2];

#define TIMING_MODES(macro) macro(REALTIME), macro(EXACT_REAL), macro(EXACT_FAST)
#define TMIZE(id) TM_##id

	enum TimingModes { TIMING_MODES(TMIZE), _TM_NMODES };
	extern TimingModes timing_mode;
	extern const char *str_tm[_TM_NMODES];

#define PAD_NPADS 4 //structuralize
	extern bool pad_on[PAD_NPADS];
	extern PAD_SCANCODES pad_sc[PAD_NPADS];
	extern BYTE pad_half, pad_quarter;  //change to settings for each pad
	extern BYTE reset_button;

	//Global constant that may change from one computer to the next
	//extern LARGE_INTEGER hrpf;
	extern DWORD rtcf; //real-time counter frequency
};

#endif	//INI_H
