// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef MEMCARD_H
#define MEMCARD_H

#include "defineCommons.h"
#include "file.h"
#include <string>

#define MEMCARD_SECTOR_SIZE (8*K)

#define MEMCARD_TYPES_BASE(first, rest) first(MC59) rest(MC123) rest(MC251)\
	rest(MC507) rest(MC1019) rest(MC2043)
#define MEMCARD_TYPES_NOCOMMA(macro) MEMCARD_TYPES_BASE(macro, macro)
#define MEMCARD_TYPES(macro) MEMCARD_TYPES_BASE(macro, COMMA(macro))

enum MemcardType { MEMCARD_TYPES(NOTHING) };
#define MSC_IZE(a) MSC_##a
enum MemcardSlotContent { MSC_Empty, MEMCARD_TYPES(MSC_IZE) };
static const char *str_MSC_long[] = { "Empty", "Memory Card 59", "Memory Card 123",
"Memory Card 251", "Memory Card 507", "Memory Card 1019", "Memory Card 2043" };
static const char *str_MSC_short[] = { "Empty", MEMCARD_TYPES(STRINGIZE) };
static const size_t memcard_sizes[] = { 0, 64, 128, 256, 512, 1024, 2048 };

struct MEMCARDSLOT_INFO {
	MemcardSlotContent content;
	std::string filename;
	bool caching;
};

bool GetMCFileContent(const char* filename, int& content);
bool GetMCFileContent(ReadOnlyFile& file, int& content);

inline MemcardType MSC2MCT(int content) {
	return MemcardType(content - 1);
}
inline MemcardSlotContent MCT2MSC(int type) {
	return MemcardSlotContent(type + 1);
}

#endif	//MEMCARD_H
