// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "degub.h"
#include "memory.h"
#include "ini.h"
#include <crtdbg.h>

Memory::Memory(Hardware &h, RegistersBase &r, InterruptRaiser &i) :
MemInterface(r, i, h, false), error(false) {
}

DWORD *Memory::get_fetch(DWORD address) {	//slow?!?
	if(g::advanced_mode)
		address = translate_i(address);
	if(HARDWARE_READ)
		throw interp_fatal_exception(":P");
	return (DWORD*)getphc(address);
}

/*template<class T> T Memory::tr(DWORD address) {
  TRANSLATE_D_READ(address);
  if(HARDWARE_READ) {
    return h.tr<T>((WORD)address);
  } else {
    if(LOWMEM_LOG) {
      if(!lowmem_status[address & 0x0FFFFFFF]) {
	DEGUB("Lowmem uninit r%c[0x%08X]\n", tname<T>(), address);
	//DEGUB("%I64i cycles\n", getCycles());
      }
      //DEGUB("Lowmem rb @ 0x%08X\n", address);
    }
    T data = tswap(*(T*)gphr(address));
    MDEGUB(p_memdegub, "r%c[%08X]%0*I64X ", tname<T>(), address, sizeof(T)*2,
      (QWORD)data);
    return data;
  }
}
template<class T> void Memory::tw(DWORD address, T data) {
  TRANSLATE_D_WRITE(address);
  MDEGUB(p_memdegub, "w%c[%08X]%0*I64X ", tname<T>(), address, sizeof(T)*2, (QWORD)data);
  if(HARDWARE_WRITE) {
    h.tw<T>((WORD)address, data);
  } else {
    if(LOWMEM_LOG) {
      lowmem_status[address & 0x0FFFFFFF] = 0x01;
      DEGUB("Lowmem w%c[%08X]%0*I64X ", tname<T>(), address, sizeof(T)*2, (QWORD)data);
      //DEGUB("%I64i cycles\n", getCycles());
    }
    *(T*)gphw(address) = tswap(data);
  }
}*/
