// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef MEMORY_H
#define MEMORY_H

#include "common.h"
#include "hardware.h"
#include "container.h"

class Memory : public MemInterface {
public:
	Memory(Hardware &h, RegistersBase &r, InterruptRaiser &i);

	bool is_ok() const { return !error; }
	void reset_error() { error = false; }
	void setDegub(bool on) { mdegub_on = on; }
	bool isDegubOn() { return mdegub_on; }

	DWORD *get_fetch(DWORD address);
private:
	mutable bool error;
};

#endif	//MEMORY_H
