// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef OPCODE_H
#define OPCODE_H

//----------------------------------HELPERS-------------------------------------

//12.1.2 Instruction Fields
//Defines of Declarations of operands :}
#define D_rS DWORD rS = getbitsw(opcode, 6, 10)
#define D_rA DWORD rA = getbitsw(opcode, 11, 15)
#define D_d16 short d = (short)getbitsw(opcode, 16, 31)
#define D_d20 short d = (short)exts(getbitsw(opcode, 20, 31), 20)
#define D_UIMM WORD UIMM = (WORD)getbitsw(opcode, 16, 31)
#define D_SIMM short SIMM = (short)getbitsw(opcode, 16, 31)
#define D_rD DWORD rD = getbitsw(opcode, 6, 10)
#define D_LI int LI = exts(getbitsw(opcode, 6, 29) << 2, 6)
#define D_AA bool AA = getbit(opcode, 30)
#define D_LK bool LK = getbit(opcode, 31)
#define D_BO DWORD BO = getbitsw(opcode, 6, 10)
#define D_BI DWORD BI = getbitsw(opcode, 11, 15)
#define D_rB DWORD rB = getbitsw(opcode, 16, 20)
#define D_spr DWORD spr = getbitsw(opcode, 11, 15) | (getbitsw(opcode, 16, 20) << 5)
#define D_tbr DWORD tbr = getbitsw(opcode, 11, 15) | (getbitsw(opcode, 16, 20) << 5)
#define D_Rc bool Rc = getbit(opcode, 31)
#define D_BD short BD = (short)getbitsw(opcode, 16, 29) << 2
#define D_SH DWORD SH = getbitsw(opcode, 16, 20)
#define D_MB DWORD MB = getbitsw(opcode, 21, 25)
#define D_ME DWORD ME = getbitsw(opcode, 26, 30)
#define D_crfD DWORD crfD = getbitsw(opcode, 6, 8)
#define D_L bool L = getbit(opcode, 10)
#define D_crbD DWORD crbD = getbitsw(opcode, 6, 10)
#define D_crbA DWORD crbA = getbitsw(opcode, 11, 15)
#define D_crbB DWORD crbB = getbitsw(opcode, 16, 20)
#define D_OE bool OE = getbit(opcode, 21)
#define D_frS DWORD frS = getbitsw(opcode, 6, 10)
#define D_frD DWORD frD = getbitsw(opcode, 6, 10)
#define D_frA DWORD frA = getbitsw(opcode, 11, 15)
#define D_frB DWORD frB = getbitsw(opcode, 16, 20)
#define D_frC DWORD frC = getbitsw(opcode, 21, 25)
#define D_FM DWORD FM = getbitsw(opcode, 7, 14)
#define D_crfS DWORD crfS = getbitsw(opcode, 11, 13)
#define D_CRM DWORD CRM = getbitsw(opcode, 12, 19)
#define D_TO DWORD TO = getbitsw(opcode, 6, 10)
#define D_W bool W = getbit(opcode, 16)
#define D_I DWORD I = getbitsw(opcode, 17, 19)
#define D_SR DWORD SR = getbitsw(opcode, 12, 15)
#define D_NB DWORD NB = getbitsw(opcode, 16, 20)

#define rA_0 (rA == 0 ? 0 : r.gpr[rA])
#define rA_0a (rA == 0 ? "" : "r")
#define Rca (Rc ? "." : "")

class Asms {
public:
	Asms();
	const string& getBOasm(DWORD BO) { MYASSERT(BO < 32); return BOasm[BO]; }
	const string& getBIasm(DWORD BI) { MYASSERT(BI < 32); return BIasm[BI]; }
	const string& getcrbasm(DWORD crb) { return getBIasm(crb); }
private:
	string BOasm[32];
	string BIasm[32];
};

extern Asms g_asms;

#endif	//OPCODE_H
