// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "recbase.h"
#include <fstream>

/*DynaRecBlockBase::DynaRecBlockBase(const RecBufBase &recbuf)
: _rcb(recbuf.size()) {
copyRCB(recbuf);
}*/

DynaRecBlockBase::DynaRecBlockBase(const RecBufBase &recbuf, size_t additional_data_size)
: _rcb(recbuf.recbuf_size() + additional_data_size), rcb_size(recbuf.recbuf_size()) {
	copyRCB(recbuf);
}

void DynaRecBlockBase::copyRCB(const RecBufBase &recbuf) {
	memcpy(rcb(), recbuf.rcb(), recbuf.recbuf_size());
	//Fill Call Requests
	for(size_t i=0; i<recbuf.rcv().size(); i++) {
		MYASSERT(recbuf.rcv()[i].pos + 3 < recbuf.recbuf_size());
		MAKE(DWORD, rcb()[recbuf.rcv()[i].pos]) =
			recbuf.rcv()[i].offset - ((DWORD)rcb()) - (recbuf.rcv()[i].pos + 4);
	}
}

void dumpRecBlock(const RecBlockInterface& aBuf, const string& aBasename) {
	DEGUB("block size: %i bytes\n", aBuf.recbuf_size());
	ofstream file((aBasename + ".bin").c_str(), ios_base::binary);
	file.write((char*)aBuf.rcb(), aBuf.recbuf_size());
	file.close();
	DEGUB("Dumped recompiled code.\n");
#ifndef PUBLIC_RELEASE
	if(g::verbose) {
		ostringstream str;
		str << "ndisasmw -o " << size_t(aBuf.rcb()) <<
			" -u " << aBasename << ".bin" << " > " << aBasename << ".asm";
		string s = str.str();
		DEGUB("system(\"%s\")\n", s.c_str());
		int res = system(s.c_str());
		DEGUB("Disassembled recompiled code. Result: %i\n", res);
	}
#endif	//PUBLIC_RELEASE
}
