// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef RECHELPERS_H
#define RECHELPERS_H

#define ADD_BYTE AB
#define ADD_DWORD AD
#define ADD_WORD AW

#define AB(byte) { cur_recbuf->add_byte(BYTE(byte)); }
#define AD(dword) { cur_recbuf->add_dword(DWORD(dword)); }

#define REQUEST_CALL(dword) cur_recbuf->request_call(dword)
#define POS cur_recbuf->recbuf_size()

#define JCC_Z 0x74
#define JCC_NZ 0x75

#define FPR_BASE (&r.fpr[16])
#define ADD_DISP8(address) { MYASSERT(int(address) - int(FPR_BASE) >= -128);\
	MYASSERT(int(address) - int(FPR_BASE) <= 127);\
	AB(DWORD(address) - DWORD(FPR_BASE)) }

#define FLD_PS_D(fr) add_fxx_ps_d(0xD9, 0, fr, false)
#define FADD_PS_D(fr) add_fxx_ps_d(0xD8, 0, fr, false)
#define FSUB_PS_D(fr) add_fxx_ps_d(0xD8, 4, fr, false)
#define FMUL_PS_D(fr) add_fxx_ps_d(0xD8, 1, fr, false)
#define FDIV_PS_D(fr) add_fxx_ps_d(0xD8, 6, fr, false)
#define FCOM_PS_D(fr) add_fxx_ps_d(0xD8, 2, fr, false)
#define FCOMP_PS_D(fr) add_fxx_ps_d(0xD8, 3, fr, false)

#define FLD_PS_D_DISP8(fr) add_fxx_ps_d(0xD9, 0, fr, true)
#define FADD_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 0, fr, true)
#define FSUB_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 4, fr, true)
#define FMUL_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 1, fr, true)
#define FDIV_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 6, fr, true)
#define FCOM_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 2, fr, true)
#define FCOMP_PS_D_DISP8(fr) add_fxx_ps_d(0xD8, 3, fr, true)

#define FSTPD add_fstx_d(true, frD, false)
#define FSTD add_fstx_d(false, frD, false)
#define FSTPD_DISP8 add_fstx_d(true, frD, true)
#define FSTD_DISP8 add_fstx_d(false, frD, true)

#define SET_FPR_SINGLE_DISP8 add_set_fpr_single(frD, true)
#define SET_FPR_SINGLE add_set_fpr_single(frD, false)

#define SET_DISP8 AB(0xBB); AD(FPR_BASE); //mov ebx, FPR_BASE

#endif	//RECHELPERS_H
