// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef RECOPS_H
#define RECOPS_H

#include "rechelpers.h"

#define RECOP_MASK 0x03FFFFFF
#define RECOP_BIT1 (IPO_DYNAREC1 << 26)
#define RECOP_BIT2 (IPO_DYNAREC2 << 26)

inline bool IS_RECOMPILED_OPCODE_TYPE1(DWORD opcode) {
	return (opcode & ~RECOP_MASK) == RECOP_BIT1;
}
inline bool IS_RECOMPILED_OPCODE_TYPE2(DWORD opcode) {
	return (opcode & ~RECOP_MASK) == RECOP_BIT2;
}
inline bool IS_RECOMPILED_OPCODE_ANYTYPE(DWORD opcode) {
	return IS_RECOMPILED_OPCODE_TYPE1(opcode) || IS_RECOMPILED_OPCODE_TYPE2(opcode);
}
inline DWORD GET_DRBINDEX(DWORD opcode) {
	MYASSERT(IS_RECOMPILED_OPCODE_ANYTYPE(opcode));
	return opcode & RECOP_MASK;
}
inline DWORD MAKE_RECOMPILED_OPCODE_TYPE1(DWORD index) {
	MYASSERT(index <= RECOP_MASK);
	return RECOP_BIT1 | index;
}
inline DWORD MAKE_RECOMPILED_OPCODE_TYPE2(DWORD index) {
	MYASSERT(index <= RECOP_MASK);
	return RECOP_BIT2 | index;
}
#define EIA_IS_IN_INDEX(eia, index)\
	((eia) >= drbv[index].start_eia() && (eia) < drbv[index].end_eia())
#define PIA_IS_IN_INDEX(eia, index)\
	((pia) >= drbv[index].start_pia() && (pia) < drbv[index].end_pia())

#define SET_IT_ERROR last_instruction_type = IT_ERROR

#endif	//RECOPS_H
