// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef STRINGCOMMONS_H
#define STRINGCOMMONS_H

#include "container.h"
#include <sstream>
#include <iomanip>
#define _WIN32_WINNT 0x0500
#include <windows.h>

using namespace std;

#define HEX(a) std::hex << std::uppercase << (a) << std::dec
#define HEX0(b, a) std::setw(b) << std::setfill('0') << HEX(a) << std::setw(0)
#define HEX08(a) HEX0(8, a)
#define HEX0x(a) "0x" << HEX(a)
#define HEX0x0(b, a) "0x" << HEX0(b, a)
#define HEX0x08(a) "0x" << HEX08(a)
#define HEx(a) std::hex << std::nouppercase << (a) << std::dec
#define HEx0(b, a) std::setw(b) << std::setfill('0') << HEx(a) << std::setw(0)
#define HEx08(a) HEx0(8, a)
#define HEx0x0(b, a) "0x" << HEx0(b, a)

//new, unused. old ones should be remade to use these wherever possible.
#define HEX0x0x(a) HEX0x0(sizeof(a) * 2, a)
#define HEx0x0x(a) HEx0x0(sizeof(a) * 2, a)

istream& operator>>(istream& aStream, const string& aString);

bool GetWindowText(HWND hWnd, string& s);
bool GetDlgItemText(HWND hDlg, int aDlgItem, string& s);

#define STRING_PLUS_DIGIT(str, dig) (std::string(str) + char('0'+dig))

int sprintf_s(Container<char>& dest, const char* format, ...);

template<class T> string asString(const T& t) {
	ostringstream str;
	str << t;
	return str.str();
}

string make_space3(const string& src);

#endif	//STRINGCOMMONS_H
