#pragma once
#ifndef kpi_deviceH
#define kpi_deviceH

#include "kpi.h"
#include "kpi_decoder.h" //KPI_MEDIAINFO::FORMAT_PCM/FORMAT_DOP

#pragma pack(push, 1) //\̂̃ACg

///////////////////////////////////////////////////////////////////////////////
/*foCXvOC
  DirectSound  waveOut/ASIO/WASAPI ̃foCX PCM óB
  o͐t@CƂ΁AWAVE t@Co̓vOCA`ւ
  Ro[^쐬\B({̂ƑΉȂƎpႭȂ肻)

  foCXvOCGNX|[g֐
  typedef HRESULT (WINAPI *pfn_kpiCreateInstance)(REFIID riid,    //IKpiXXXModule  IID
                                                void **ppvObject, //IKpiXXXModule ̖߂l
                                                IKpiUnknown *pUnknown);
  HRESULT WINAPI kpi_CreateInstance(REFIID riid, void **ppvObject, IKpiUnknown *pUnknown);
  riid  IID_IKpiOutDeviceModule nB
  Kvł pUnknown  IKpiConfig 擾邱ƁB
  kpi_CreateConfig ̃wp[֐Ăԏꍇ kpi.cpp vWFNgɒǉB

  *ppvObject ɃCX^Xnꍇ́AK؂Ȍ^ɃLXg邱ƁB
  Ⴆ΁A

    if(IsEqualIID(riid, IID_IKpiUnArcModule){
        CKpiXXXOutDeviceModule *pModule = new CKpiXXXOutDeviceModule;
        // *ppvObject = pModule; //NG
        *ppvObject = (IKpiOutDeviceModule*)pModule; //OK
    }

  ̂悤ɂ邱ƁBCKpiXXXOutDeviceModule ̃NXhĂꍇA
  K؂ȃ|C^nȂ\B
*/
///////////////////////////////////////////////////////////////////////////////
#define KPI_OUTDEVICE_MODULE_VERSION 9 //dlm莞 100 Ƃ\

class __declspec(uuid("{59AFA38B-17A0-4DDC-952A-3AED1901226D}")) IKpiOutDevice;
class __declspec(uuid("{01CCD9F7-A698-4305-B2D1-8E98D0736471}")) IKpiOutDeviceModule;
class __declspec(uuid("{42C2C87A-96FA-4DE6-8E23-A539F33B6DC5}")) IKpiDeviceEnumerator;

#define IID_IKpiOutDevice        __uuidof(IKpiOutDevice)
#define IID_IKpiOutDeviceModule  __uuidof(IKpiOutDeviceModule)
#define IID_IKpiDeviceEnumerator __uuidof(IKpiDeviceEnumerator)

///////////////////////////////////////////////////////////////////////////////
class IKpiOutDevice : public IKpiUnknown
{
public:
    virtual BOOL   WINAPI Output(BYTE *pOutput, int nSizeSample)=0;
    virtual void   WINAPI Wait(void)=0;
    virtual UINT64 WINAPI GetPosition(void)=0;
    virtual void   WINAPI Stop(void)=0;
    virtual void   WINAPI Pause(void)=0;
    virtual void   WINAPI Restart(void)=0;
    virtual BOOL   WINAPI SetVolume(int nVolume)=0;
    virtual BOOL   WINAPI SetRate(int nRate)=0;
    virtual DWORD  WINAPI UpdateConfig(void *pvReserved)=0;
/*
    BOOL WINAPI Output(BYTE *pOutput, int nSizeSample);
      foCX PCM o

      IKpiOutDeviceModule::Open ɂCX^X쐬A
      nBufferSizeSample  2 {ȏ̃obt@mۂĂƁB
      nSizeSample ̓TvPʂŒʏ nBufferSizeSample ƓB
      nSizeSample < nBufferSizeSample ̏ꍇ̓fR[hIB
      ̏ꍇAnSizeSample 𒴂镔̃obt@ɂ͖ĂB

      o͐foCX Open  cszDeviceName / cszId ɉfoCX
      pOutput ̃obt@TCY Open  nBufferSizeSample * (abs(nBps)/8) * nChannels ɓB
      O Wait Ăяo Output \ɂȂ܂ő҂ĂĂ΂邱Ƃ
      ۏ؂B

       TRUE Ԃ
      foCXɉ̃G[Ďsꍇ FALSE Ԃ
      FALSE ԂꍇA{̂͒ɉt~AȌ Output ĂяoƂ͂Ȃ
    void WINAPI Wait(void);
       Output \ɂȂ܂ő҂B

      Wait ̌ĂяoXbhƂ͈قȂXbh牺L̃\bhĂ΂邱ƂA
      rȂB
      GetPosition/Stop/Pause/Restart/SetVolume/SetRate

      Output ͕K Wait ̌ɁAWait Ƃ͔rIɌĂ΂(XbhĂ΂Ƃ͌Ȃ)

      Output \ɂȂ瑬₩Ƀ^[邱ƁB
      ҂ĂԂ Stop Ă΂ꂽꍇ͑₩Ƀ^[邱ƁB̏ꍇA
       Output Ă΂ꂽĐJnȂ΂ȂȂB

      Output  Wait ̌Ăяo͂ 1  1 ɑΉĂƂ͌ȂB
      Output ̌ĂяoO 2 ȏ Wait Ă΂邱ƂB
      WaitForSingle/MultipleObject(s)  AutoReset ȃCxgIuWFNgw肷ꍇȂǂ
      ӂ邱ƁBi2xڂ̌ĂяoŃfbhbNɂȂȂ悤Ɂj

      AWait  1 xĂ΂ Output Ă΂邱Ƃ͌ĂȂB

    UINT64 WINAPI GetPosition(void);
      foCX̍ĐʒuTvPʂŕԂB
      Stop Ă΂ꂽĐʒu 0 ɖ߂ƁB

      Output  1 Ă΂ĂȂiKł̃\bhĂ΂邱Ƃ͂ȂB

    void WINAPI Stop(void);
      Đ~BWait ̏ɌĂ΂ꂽꍇAWait ͑₩Ƀ^[Ȃ΂ȂȂB
      Stop ̌ Output Ă΂ꂽ炻̎_ōĐĊJ邱ƁB
      Pause  Stop Ă΂邱Ƃ邱ƂɒӁB

    void WINAPI Pause(void);
      ꎞ~BRestart Ă΂܂ōĐꎞ~B
      Pause  Stop Ă΂ꂽĐ~邱ƁB
      Pause  Output Ă΂邱Ƃ͂ȂB
      Pause dɌĂ΂邱Ƃ͂ȂBiŎQƃJEg𐔂Kv͂Ȃj
      Pause  Stop Ă΂邱Ƃ邱ƂɒӁB

    void WINAPI Restart(void);
      ĊJBPause ̌ɂĂ΂ȂB

    BOOL WINAPI SetVolume(int nVolume);
      ʐBPʂ %
      ͖( 0 <= nVolume <= 100)
      Ή̏ꍇ FALSE ԂB({̂ɂă\tgEFAIɏ)

    BOOL WINAPI SetRate(int nRate);//TvO[gϊ
      TvO[gϊBPʂ %
      nRate = 200 : 2 {(200%)ɂ
      nRate = 100 : ύXȂ
      nRate =  50 : (50%) ɂ
      Ή̏ꍇ FALSE ԂB

    DWORD WINAPI UpdateConfig(void *pvReserved);
      ݒ肪ύXꂽ{̂ɂČĂ΂B
      pvReserved ɂ NULL nB
      0 ԂƁB

    e탁\bh͂XbhĂ΂Ƃ͌ȂAWait ȊO
    \bh͖{̂ɂĔrIɌĂ΂邱Ƃۏ؂B
*/
};
///////////////////////////////////////////////////////////////////////////////
class IKpiDeviceEnumerator : public IKpiUnknown
{//foCX񋓂
 //Enumarate JԂĂяo
public:
    virtual void WINAPI Enumerate(const wchar_t *cszDeviceName, const wchar_t *cszId)=0;
};
///////////////////////////////////////////////////////////////////////////////
struct KPI_DEVICE_FORMAT
{
    DWORD cb;//=sizeof(DEVICE_FORMAT
    DWORD dwFormatType;//KPI_MEDIAFORMAT::FORMAT_PCM or FORMAT_DOP
    DWORD dwSampleRate;   //Đg
    INT32 nBitsPerSample; //rbg(̂Ƃfloat)
    DWORD dwChannels;     //`l
    DWORD dwSpeakerConfig;//Ή(0)
    DWORD dwReserved[4];  //\(0)
};
///////////////////////////////////////////////////////////////////////////////
struct KPI_DEVICE_MODULEINFO
{
    enum{
        SUPPORT_FLAG_VOLUME = 0x01,   //ʕύX(SetVolume)ɑΉ
        SUPPORT_FLAG_RATE = 0x01 << 1,//Đ[gϊ(SetRate)ɑΉ
        SUPPORT_FLAG_BITPERFECT = 0x01 << 2,//rbgp[tFNg(WASAPI/ASIO)
        SUPPORT_FLAG_DISKWRITE = 0x01 << 3,//t@Co
    };
    DWORD cb;                //=sizeof(KPI_DEVICE_MODULEINFO)
    DWORD dwModuleVersion;   //=KPI_OUTDEVICE_MODULE_VERSION
    DWORD dwPluginVersion;   //vOC̃o[W
    DWORD dwMultipleInstance;//KPI_MULTINST_INFINITE/ZERO/ONE/UNIQUE
    GUID  guid;              //vOCʎq
    const wchar_t *cszDescription; //\
    const wchar_t *cszCopyright;   //쌠(ꍇ͉s)
    const wchar_t *cszTypeName;    //foCX̎ޖ(DirectSound/waveOut/WASAPI/ASIO etc...)
    DWORD dwSupportConfig;  //IKpiConfig ɂݒ̓ǂݏɖΉȂ 0
    DWORD dwSupportFlags;   //SUPPORT_FLAG_VOLUME/RATE/BITPERFECT ̑gݍ킹
    DWORD dwReserved[4];    //must be 0
};
///////////////////////////////////////////////////////////////////////////////
class IKpiOutDeviceModule : public IKpiUnknown
{//IKpiOutDevice ̃CX^X쐬ƃfoCX̗񋓂sB
public:
    virtual void  WINAPI GetModuleInfo(const KPI_DEVICE_MODULEINFO **ppInfo)=0;
    virtual BOOL  WINAPI Open(const wchar_t *cszDeviceName, //foCX
                              const wchar_t *cszId,         //ʕ
                              const KPI_DEVICE_FORMAT *cpFormat, //Đg
                              int nBufferSizeSample,        //Đobt@TCYiTvPʁj
                              IKpiOutDevice **ppOutDevice)=0;
    virtual void  WINAPI EnumDevices(IKpiDeviceEnumerator *pEnumerator)=0;//foCX̗
    virtual BOOL  WINAPI EnumConfig(IKpiConfigEnumerator *pEnumerator)=0;
    virtual DWORD WINAPI ApplyConfig(const wchar_t *cszSection, //ZNV
                                     const wchar_t *cszKey,     //L[
                                     UINT64 nValue,             //ύX̒l(INT)
                                     double dValue,             //ύX̒l(FLOAT)
                                     const wchar_t *cszValue)=0;//ύX̒l(STR)
/*
    void  WINAPI GetModuleInfo(const KPI_DECODER_MODULEINFO **ppInfo);
      KPI_DEVICE_MODULEINFO  *ppInfo ɐݒ肵ĕԂB
      IKpiDecoderModule::GetModuleInfo(kpi_decoder.h) Ƃقړ߁A
      킹ĎQƂ邱ƁB

    void WINAPI Open(const wchar_t *cszDeviceName, //foCX
                     const wchar_t *cszId, //ʕ
                     const KPI_DEVICE_FORMAT *cpFormat, //Đg
                     int nBufferSizeSample, //Đobt@TCYiTvPʁj
                     IKpiOutDevice **ppOutDevice);
      foCXJ
       IKpiOutDevice ̃CX^X *ppOutDevice ɐݒ肵 TRUE ԂB
      s *ppOutDevice  NULL ɐݒ肵 FALSE Ԃ
      cszDeviceName 󕶎(cszDeviceName = "")̂Ƃ(NULL ͓nȂ)
      Enumerate ɈԍŏɌfoCXƌȂ

    void WINAPI EnumDevices(IKpiDeviceEnumerator *pEnumerator);//foCX̗
      foCX񋓂B
      IKpiDeviceEnumerator::Enumerate JԂĂяoB
      Ăяo͏ɍŐV񋓂邱ƁB

    BOOL WINAPI EnumConfig(IKpiConfigEnumerator *pEnumerator);
      ݒ荀ڂ񋓂B
      {̂񋓂ꂽݒ荀ڂɐݒʂB
      ݒ荀ڂȂꍇ FALSE ԂAꍇ TRUE ԂB
      IKpiDecoderModule::EnumConfig(kpi_decoder.h) Ƃقړ߁A
      킹ĎQƂ邱ƁB

      KPI_CFG_INFO::cszSection = foCX-ʎq ƂȂĂꍇ
      EnumDevices ŗ񋓂ꂽfoCXp̃ZNVƌȂB
      (ݒʂ𐶐ɕKvɉĎőIԂɂ)

    DWORD WINAPI ApplyConfig(const wchar_t *cszSection,//ZNV
                             const wchar_t *cszKey,    //L[
                             INT64  nValue, //ύX̒l(BOOL/INT ̏ꍇ)
                             double dValue, //ύX̒l(FLOAT ̏ꍇ)
                             const wchar_t *cszValue)=0;//ύX̒l()
      cszSection  cszKey ɊYݒ̕ύXuKpv钼OɌĂ΂B
      Ă΂ꂽ_ł͂܂ݒ͕ύXĂȂB
      IKpiDecoderModule::ApplyConfig(kpi_decoder.h) Ƃقړ߁A
      킹ĎQƂ邱ƁB

    EnumDevices  Open ͕̃XbhĂ΂\邪ArI
    Ă΂邱Ƃۏ؂BOpen ͓̏I EnumDevices ɑ
    s\Ǝv邪A{̑ł͂̃\bh͕Kr
    IɌĂяô EnumDevices ̔r͂قڕsvƎvB

    IKpiOutDeviceModule ̃CX^X쐬Ɣj̓vOC[hĂ
    xsȂB

    Kvȏ̓CX^X쐬An̓CX^XjɍsƁB

    {̂̓vOC[h Open ܂ōs킸AŒ̏񂾂擾ɃA[h
    邱ƂBႦ΋NɃvOC߂ĔFꍇ GetModuleInfo
    ĂяoɃA[hBݒʂ̕\AvOCgpłȂ

    GetModuleInfo/EnumConfig/ApplyConfig

    Ă΂AݒʂƂŃA[hB

    vOC̏ɎԂꍇ Open ɏ1xsȂǁA
    vOCœƎɍHvB̍ۂ͖̂܂ IKpiOutDeviceModule j
    ꂽAǂ̃\bhŏɌĂ΂Ăɖ肪NȂ悤ɒӂ邱ƁB
*/
};
///////////////////////////////////////////////////////////////////////////////
//vOCGNX|[g֐
//typedef HRESULT (WINAPI *pfn_kpiCreateInstance)(REFIID riid,      //IKpiXXXModule  IID
//                                                void **ppvObject, //IKpiXXXModule ̖߂l
//                                                IKpiUnknown *pUnknown);
//HRESULT WINAPI kpi_CreateInstance(REFIID riid, void **ppvObject, IKpiUnknown *pUnknown);
//IKpiDecoderModule Ɠ(kpi.h Q)
//riid  IID_IKpiOutDeviceModule n
//Kvł pUnknown  IKpiConfig 擾邱
//kpi_CreateConfig ̃wp[֐Ăԏꍇ kpi.cpp vWFNgɒǉ
///////////////////////////////////////////////////////////////////////////////
extern HRESULT WINAPI kpi_CreateOutDeviceModule(pfn_kpiCreateInstance fnCreateInstance,
                                                IKpiOutDeviceModule **ppModule,
                                                IKpiUnknown *pUnknown);
//vOCgpp̃wp[֐(vOC쐬ɂ͕sv)
//vOCgp(ʏ KbMedia Player)Ăяoꍇ kpi_device.cpp 
//vWFNgɒǉ
///////////////////////////////////////////////////////////////////////////////
#pragma pack(pop) //\̂̃ACg
#endif
