#pragma once
#ifndef kpi_implH
#define kpi_implH

#include "kpi.h"
///////////////////////////////////////////////////////////////////////////////
//IKpiXXX  QueryInterface/AddRef/Release
//yюK{ł͂Ȃ\bh̃ftHg̓NXQ
//vOCJAʓ|Ȃ炱̃NXhΗǂAK{ł͂Ȃ
//
//ɂȂ̂ IKpiUnknown ̔hNXꍇ
//
//class CKpiUnArc : public KbKpiUnknwonImpl<IKpiUnArc>
//{
//};
//܂
//typedef KbKpiUnknwonImpl<IKpiUnArc> CKpiUnArc;
//
//class CKpiPlayer : public KbKpiUnknwonImpl<IKpiPlayer>
//{
//};
//܂
//typedef KbKpiUnknwonImpl<IKpiPlayer> CKpiPlayer;
//
//̂悤ɂ QueryInterface  AddRef/Release ͎IɎ
//
//KbKpiFileImpl ȊO typedef Ă邾Ȃ̂ŁÃ\bh͑SĎ
//KvB
class IKpiDecoder;      //kpi_decoder.h Ɉړ̂őO錾Ă
class IKpiDecoderModule;//kpi_decoder.h Ɉړ̂őO錾Ă
///////////////////////////////////////////////////////////////////////////////
template<class T> class KbKpiUnknownImpl : public T
{
protected:
    LONG m_cRef;
    KbKpiUnknownImpl(void):m_cRef(1){}
    virtual ~KbKpiUnknownImpl(void){}
public:
    //IUnknown h
    HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void **ppvObject);
    ULONG   STDMETHODCALLTYPE AddRef(void);
    ULONG   STDMETHODCALLTYPE Release(void);
};
///////////////////////////////////////////////////////////////////////////////
template<class T>
HRESULT WINAPI KbKpiUnknownImpl<T>::QueryInterface(REFIID riid,
                                                   void **ppvObject)
{
    if (!ppvObject) {
        return E_INVALIDARG;
    }
    else if(IsEqualGUID(riid, __uuidof(T))){
        *ppvObject = (T*)this;
    }
    else if(IsEqualGUID(riid, __uuidof(IKpiUnknown))){
        *ppvObject = (IKpiUnknown*)this;
    }
    //else if(IsEqualGUID(riid, __uuidof(IUnknown))){
    //    *ppvObject = (IUnknown*)this;
    //}
    //typedef IUnknown IKpiUnknown;
    //  IUnknown == IKpiUnknown Ȃ̂ŕKvȂ
    else{
        *ppvObject = NULL;
        return E_NOINTERFACE;
    }
    AddRef();
    return S_OK;
}
///////////////////////////////////////////////////////////////////////////////
template<class T>
ULONG WINAPI KbKpiUnknownImpl<T>::AddRef(void)
{
    return InterlockedIncrement(&m_cRef);
}
///////////////////////////////////////////////////////////////////////////////
template<class T>
ULONG WINAPI KbKpiUnknownImpl<T>::Release(void)
{
    ULONG ret = InterlockedDecrement(&m_cRef);
    if(ret == 0){
        delete this;
    }
    return ret;
}
///////////////////////////////////////////////////////////////////////////////
class KbKpiFileImpl : public KbKpiUnknownImpl<IKpiFile>
{//fR[_vOC͎gp̂
 //{(܂̓vOCgp\tg)
 //A[JCuvOCłKv
public:
    //IKpiFile h
    DWORD WINAPI GetFileName(wchar_t *pszName, DWORD dwSize){pszName[0] = 0;return 0;}
    BOOL  WINAPI GetRealFileW(const wchar_t **ppszFileName){*ppszFileName=NULL;return FALSE;}
    BOOL  WINAPI GetRealFileA(const char    **ppszFileName){*ppszFileName=NULL;return FALSE;}
    BOOL  WINAPI GetBuffer(const BYTE **ppBuffer, size_t *pstSize){*ppBuffer=NULL;*pstSize=0;return FALSE;}
    BOOL  WINAPI CreateClone(IKpiFile **ppFile){*ppFile=NULL;return FALSE;}
    BOOL  WINAPI Abort(void){return FALSE;}
/*  ȉ͕KȂ΂ȂȂ
    DWORD  WINAPI Read(void *pBuffer, DWORD dwSize);
    UINT64 WINAPI Seek(INT64 i64Pos, DWORD dwOrigin);
    UINT64 WINAPI GetSize(void);
*/
};
///////////////////////////////////////////////////////////////////////////////
typedef KbKpiUnknownImpl<IKpiFolder> KbKpiFolderImpl;
/*
class KbKpiFolderImpl : public KbKpiUnknownImpl<IKpiFolder>
{//{(܂̓vOCgp\tg)
 //fR[_vOCAA[JCuvOC͎gp݂̂Ŏsv
public:
    IKpiFolder h
    ȉ͕KȂ΂ȂȂ
    DWORD WINAPI GetFolderName(wchar_t *pszName, DWORD dwSize);
    DWORD WINAPI EnumFiles(DWORD dwIndex, wchar_t *pszName, DWORD dwSize, DWORD dwLevel);
    BOOL  WINAPI OpenFile(const wchar_t* cszName, IKpiFile **ppFile);
    BOOL  WINAPI OpenFolder(const wchar_t* cszName, IKpiFolder **ppFolder);
};
*/
///////////////////////////////////////////////////////////////////////////////
class KbKpiNullFolder : public KbKpiFolderImpl
{//IɉȂ IKpiFolder
 //{(܂̓vOCgp\tg)ŕKv()
public:
    //IKpiFolder h
    DWORD WINAPI GetFolderName(wchar_t *pszName, DWORD dwSize){pszName[0] = 0;return 0;}
    DWORD WINAPI EnumFiles(DWORD dwIndex, wchar_t *pszName, DWORD dwSize, DWORD dwLevel){pszName[0] = 0; return 0;}
    BOOL  WINAPI OpenFile(const wchar_t* cszName, IKpiFile **ppFile){*ppFile=NULL;return FALSE;}
    BOOL  WINAPI OpenFolder(const wchar_t* cszName, IKpiFolder **ppFolder){*ppFolder=NULL;return FALSE;}
};
///////////////////////////////////////////////////////////////////////////////
typedef KbKpiUnknownImpl<IKpiDecoder> KbKpiDecoderImpl;
/*
class KbKpiDecoderImpl : public KbKpiUnknownImpl<IKpiDecoder>
{//fR[_vOCŎKv
public:
    //IKpiDecoder h
    //ȉ͕KȂ΂ȂȂ
    DWORD  WINAPI Select(DWORD dwNumber,                    //Ȕԍ
                         const KPI_MEDIAINFO **ppMediaInfo, //may be NULL
                         IKpiTagInfo *pTagInfo,             //may be NULL
                         DWORD dwTagGetFlags);//ǂ̃tB[h̃^O擾邩̃tO
    DWORD  WINAPI Render(BYTE *pBuffer, DWORD dwSizeSample);
    UINT64 WINAPI Seek(UINT64 qwPosSample, DWORD dwFlag);
    DWORD  WINAPI UpdateConfig(void *pvReserved){return 0;}
    //UpdateConfig ͑̏ꍇsvAŎȂ
    //Ȃ̂ŊĂł͎Ȃ(KvȂRsy)
};
*/
///////////////////////////////////////////////////////////////////////////////
typedef KbKpiUnknownImpl<IKpiDecoderModule> KbKpiDecoderModuleImpl;
/*
class KbKpiDecoderModuleImpl : public KbKpiUnknownImpl<IKpiDecoderModule>
{//fR[_vOCŎKv
public:
    //IKpiDecoderModule h
    //ȉ͕KȂ΂ȂȂ
    void  WINAPI GetModuleInfo(const KPI_DECODER_MODULEINFO **ppInfo);
    DWORD WINAPI Open(const KPI_MEDIAINFO *cpRequest,//Đg̗vl܂܂ꂽ KPI_MEDIAINFO
                              IKpiFile     *pFile,   //yf[^
                              IKpiFolder   *pFolder, //yf[^tH_
                              IKpiDecoder **ppDecoder);
    BOOL  WINAPI EnumConfig(IKpiConfigEnumerator *pEnumerator){return FALSE;}
    DWORD WINAPI ApplyConfig(const wchar_t *cszSection,//ZNV
                             const wchar_t *cszKey,    //L[
                             INT64  nValue, //ύX̒l(BOOL/INT ̏ꍇ)
                             double dValue, //ύX̒l(FLOAT ̏ꍇ)
                             const wchar_t *cszValue){//ύX̒l()
        return KPI_CFGRET_OK;
    }
    //EnumConfig/ApplyConfig ͑̏ꍇsvAŎȂ
    //Ȃ̂ŊĂł͎Ȃ(KvȂRsy)
};
*/
///////////////////////////////////////////////////////////////////////////////
typedef KbKpiUnknownImpl<IKpiTagInfo> KbKpiTagInfoImpl;
/*
class KbKpiTagInfoImpl : public KbKpiUnknownImpl<IKpiTagInfo>
{//{̂
 //fR[_vOC͎gp̂݁Bsv
 //A[JCuvOC͎gpsv
public:
    //IKpiTagInfo h
    //ȉ͕KȂ΂ȂȂ
    void WINAPI aSetValueA(const char    *cszNameA,   int nNameSize,  //Name: Ansi
                           const char    *cszValueA,  int nValueSize);//Value:Ansi
    void WINAPI aSetValueW(const char    *cszNameA,   int nNameSize,  //Name: Ansi
                           const wchar_t *cszValueW,  int nValueSize);//Value: Utf16
    void WINAPI aSetValueU8(const char   *cszNameA,   int nNameSize,  //Name: Ansi
                            const char   *cszValueU8, int nValueSize);//Value: Utf8
    //Name=utf16 
    void WINAPI wSetValueA(const wchar_t  *cszNameW,   int nNameSize,  //Name: utf15
                           const char     *cszValueA,  int nValueSize);//Value; Ansi
    void WINAPI wSetValueW(const wchar_t  *cszNameW,   int nNameSize,  //Name: Utf16
                           const wchar_t  *cszValueW,  int nValueSize);//Value: Utf16
    void WINAPI wSetValueU8(const wchar_t *cszNameW,   int nNameSize,  //Name; utf16
                            const char    *cszValueU8, int nValueSize);//Utf8: utf8
    //Name=utf8 
    void WINAPI u8SetValueA(const char    *cszNameU8,  int nNameSize,  //Name: utf8
                            const char    *cszValueA,  int nValueSize);//Value: Ansi
    void WINAPI u8SetValueW(const char    *cszNameU8,  int nNameSize,  //Name; utf8
                            const wchar_t *cszValueW,  int nValueSize);//Value: Utf16
    void WINAPI u8SetValueU8(const char   *cszNameU8,  int nNameSize,  //Name: utf8
                             const char   *cszValueU8, int nValueSize);//Value: Utf8
};
*/
#endif

