.org 0A600h
;                                 Z80IOPix.asm
;       ** RSX INPUT/OUTPUT PIXEL CPC THROUGH BIOS INTERRUPTION 010H **

; ** Opcodes CpcAlive **
#define LD_AH_A         .db 040h\ .db 052h              ; load the value of the Z80 register A
                                                        ; in the X86 register AH
#define LD_A_AH         .db 040h\ .db 05Bh              ; load the value of the X86 register AH
                                                        ; in the Z80 register A
#define INT(xx)         .db 040h\ .db 048h\ .db xx      ; call Dos interruption number xx


                        ld bc,RsxTb
                        ld hl,Buf
                        jp 0BCD1h               ; RSX INITIALISATIONS

RsxTb                   .dw MnemoTb
                        jp OPix                 ; ** |OPIX - OUTPUT PIXEL THROUGH INT 010H **
                        jp IPix                 ; ** |IPIX - INTPUT PIXEL THROUGH INT 010H **

Buf                     .db 0,0,0,0             ; 4 bytes reserved for kernal

MnemoTb                 .db "OPI"               ; |OPIX
                        .db 058h | 080h         ; "X" or 080h
                        .db "IPI"               ; |IPIX
                        .db 058h | 080h         ; "X" or 080h
                        .db 0


; ** OUTPUT PIXEL THROUGH INT 010H **
; <(IX+0) and (DE) = pen number
;  (IX+2) = y
;  (IX+4) = x

OPix:                   ld d,(IX+3)             ; coordinate y
                        ld e,(IX+2)
                        ld b,(IX+5)             ; coordinate x
                        ld c,(IX+4)
                        ld a,0Ch                ; FUNCTION 0CH = WRITE A GRAPHIC POINT
                        LD_AH_A                 ; load the value of the Z80 register A
                                                ; in the X86 register AH
                        ld a,(IX+0)             ; color requested
                        INT(010h)               ; CALL INTERRUPTION BIOS 010H
                        ret


; ** INPUT PIXEL THROUGH INT 010H **
; <IX+0 and DE = pointer pen number
;  (IX+2) = y
;  (IX+4) = x
; >(IX+0) and (DE) = pen number

IPix:                   push de
                        ld d,(IX+3)             ; coordinate y
                        ld e,(IX+2)
                        ld b,(IX+5)             ; coordinate X
                        ld c,(IX+4)
                        ld a,0Dh                ; FUNCTION 0DH = READ A GRAPHIC POINT
                        LD_AH_A                 ; load the value of the Z80 register A
                                                ; in the X86 register AH
                        INT(010h)               ; CALL INTERRUPTION BIOS 010H
                        pop de
                        ld (de),a               ; pixel color
                        inc de
                        xor a
                        ld (de),a
                        ret

.end
