/*
 * Decompiled with CFR 0.152.
 */
public class OKI6295 {
    public static final int MAX_ADPCM = 16;
    public static final int MAX_OKIM6295 = 2;
    public static final int OKIM6295_VOICES = 4;
    private static final int SAMPLERATE = 44100;
    private static final int FREQUENCY = 7576;
    private static final int MAX_SAMPLE_CHUNK = 1000000;
    private static final int FRAC_BITS = 14;
    private static final int FRAC_ONE = 16384;
    private static final int FRAC_MASK = 16383;
    private int[] okim6295_command;
    private int[][] okim6295_base;
    private static byte num_voices;
    private ADPCMVoice[] adpcm = new ADPCMVoice[16];
    private static int[] index_shift;
    private static int[] diff_lookup;
    private static int[] volume_table;
    private short[] sample_data;
    private byte[] samples;

    OKI6295() {
        int n = 0;
        while (n < 16) {
            this.adpcm[n] = new ADPCMVoice();
            ++n;
        }
        diff_lookup = new int[784];
        volume_table = new int[16];
        this.sample_data = new short[1000000];
        this.okim6295_command = new int[2];
        this.okim6295_base = new int[2][4];
    }

    private final void compute_tables() {
        int[][] nArrayArray = new int[][]{{1, 0, 0, 0}, {1, 0, 0, 1}, {1, 0, 1, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}, {1, 1, 0, 1}, {1, 1, 1, 0}, {1, 1, 1, 1}, {-1, 0, 0, 0}, {-1, 0, 0, 1}, {-1, 0, 1, 0}, {-1, 0, 1, 1}, {-1, 1, 0, 0}, {-1, 1, 0, 1}, {-1, 1, 1, 0}, {-1, 1, 1, 1}};
        int n = 0;
        while (n <= 48) {
            int n2 = (int)Math.floor(16.0 * Math.pow(1.1, n));
            int n3 = 0;
            while (n3 < 16) {
                OKI6295.diff_lookup[n * 16 + n3] = nArrayArray[n3][0] * (n2 * nArrayArray[n3][1] + n2 / 2 * nArrayArray[n3][2] + n2 / 4 * nArrayArray[n3][3] + n2 / 8);
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < 16) {
            double d = 256.0;
            int n4 = n;
            while (n4-- > 0) {
                d /= 1.412537545;
            }
            OKI6295.volume_table[n] = (int)d;
            ++n;
        }
    }

    private final void generate_adpcm(int n, short[] sArray, int n2) {
        int n3 = 0;
        if (this.adpcm[n].playing != 0) {
            byte[] byArray = this.adpcm[n].base;
            int n4 = this.adpcm[n].offset;
            int n5 = this.adpcm[n].sample;
            int n6 = this.adpcm[n].signal;
            int n7 = this.adpcm[n].count;
            int n8 = this.adpcm[n].step;
            while (n2 != 0) {
                int n9 = byArray[n4 + n5 / 2] >> ((n5 & 1) << 2 ^ 4);
                if ((n6 += diff_lookup[n8 * 16 + (n9 & 0xF)]) > 2047) {
                    n6 = 2047;
                } else if (n6 < -2048) {
                    n6 = -2048;
                }
                if ((n8 += index_shift[n9 & 7]) > 48) {
                    n8 = 48;
                } else if (n8 < 0) {
                    n8 = 0;
                }
                sArray[n3++] = (short)(n6 * this.adpcm[n].volume / 16);
                --n2;
                if (++n5 <= n7) continue;
                this.adpcm[n].playing = 0;
                break;
            }
            this.adpcm[n].sample = n5;
            this.adpcm[n].signal = n6;
            this.adpcm[n].step = n8;
        }
        while (n2-- != 0) {
            sArray[n3++] = 0;
        }
    }

    /*
     * Unable to fully structure code
     */
    void adpcm_update(int var1_1, short[] var2_2, int var3_3) {
        var4_4 = this.sample_data;
        var5_5 = this.adpcm[var1_1].last_sample;
        var6_6 = this.adpcm[var1_1].curr_sample;
        var9_7 = 0;
        var10_8 = 0;
        if (this.adpcm[var1_1].source_pos > 0) {
            while (var3_3 > 0 && this.adpcm[var1_1].source_pos < 16384) {
                var2_2[var9_7++] = (short)(var5_5 * (16384 - this.adpcm[var1_1].source_pos) + var6_6 * this.adpcm[var1_1].source_pos >> 14);
                this.adpcm[var1_1].source_pos += this.adpcm[var1_1].source_step;
                --var3_3;
            }
            if (this.adpcm[var1_1].source_pos >= 16384) {
                this.adpcm[var1_1].source_pos -= 16384;
            } else {
                return;
            }
        }
        if ((var8_10 = (var7_9 = this.adpcm[var1_1].source_pos + var3_3 * this.adpcm[var1_1].source_step) + 16384 - 1 >> 14) > 1000000) {
            var8_10 = 1000000;
        }
        this.generate_adpcm(var1_1, this.sample_data, var8_10);
        var5_5 = var6_6;
        var6_6 = var4_4[var10_8++];
        ** GOTO lbl31
        {
            var2_2[var9_7++] = (short)(var5_5 * (16384 - this.adpcm[var1_1].source_pos) + var6_6 * this.adpcm[var1_1].source_pos >> 14);
            this.adpcm[var1_1].source_pos += this.adpcm[var1_1].source_step;
            --var3_3;
            do {
                if (var3_3 > 0 && this.adpcm[var1_1].source_pos < 16384) continue block1;
                if (this.adpcm[var1_1].source_pos < 16384) continue;
                this.adpcm[var1_1].source_pos -= 16384;
                var5_5 = var6_6;
                var6_6 = var4_4[var10_8++];
lbl31:
                // 3 sources

            } while (var3_3 > 0);
        }
        this.adpcm[var1_1].last_sample = var5_5;
        this.adpcm[var1_1].curr_sample = var6_6;
    }

    public final int ADPCM_sh_start(byte[] byArray) {
        num_voices = 1;
        this.compute_tables();
        int n = 0;
        while (n < num_voices) {
            this.adpcm[n] = new ADPCMVoice();
            this.adpcm[n].stream = 1;
            if (this.adpcm[n].stream == -1) {
                return 1;
            }
            this.adpcm[n].region_base = byArray;
            this.adpcm[n].volume = 255;
            this.adpcm[n].signal = -2;
            this.adpcm[n].source_step = 2814;
            ++n;
        }
        return 0;
    }

    void ADPCM_sh_stop() {
    }

    void ADPCM_sh_update() {
    }

    void ADPCM_play(int n, int n2, int n3) {
        ADPCMVoice aDPCMVoice = this.adpcm[n];
        if (n >= num_voices) {
            return;
        }
        aDPCMVoice.playing = 1;
        aDPCMVoice.base = aDPCMVoice.region_base;
        aDPCMVoice.offset = n2;
        aDPCMVoice.sample = 0;
        aDPCMVoice.count = n3;
        aDPCMVoice.signal = -2;
        aDPCMVoice.step = 0;
    }

    void ADPCM_stop(int n) {
        ADPCMVoice aDPCMVoice = this.adpcm[n];
    }

    void ADPCM_setvol(int n, int n2) {
        ADPCMVoice aDPCMVoice = this.adpcm[n];
        if (n >= num_voices) {
            return;
        }
        aDPCMVoice.volume = n2;
    }

    int ADPCM_playing(int n) {
        ADPCMVoice aDPCMVoice = this.adpcm[n];
        if (n >= num_voices) {
            return 0;
        }
        return aDPCMVoice.playing;
    }

    int OKIM6295_sh_start(byte[] byArray) {
        this.samples = byArray;
        num_voices = (byte)4;
        this.compute_tables();
        int n = 0;
        while (n < num_voices) {
            int n2 = n / 4;
            int n3 = n % 4;
            this.okim6295_command[n2] = -1;
            this.okim6295_base[n2][n3] = 0;
            this.adpcm[n].stream = 1;
            if (this.adpcm[n].stream == -1) {
                return 1;
            }
            this.adpcm[n].region_base = this.samples;
            this.adpcm[n].volume = 255;
            this.adpcm[n].signal = -2;
            this.adpcm[n].source_step = 2814;
            ++n;
        }
        return 0;
    }

    void OKIM6295_sh_stop() {
    }

    void OKIM6295_sh_update() {
    }

    void OKIM6295_set_bank_base(int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            ADPCMVoice aDPCMVoice = this.adpcm[n * 4 + n3];
            this.okim6295_base[n][n3] = n2;
            ++n3;
        }
    }

    void OKIM6295_set_frequency(int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            ADPCMVoice aDPCMVoice = this.adpcm[n * 4 + n3];
            aDPCMVoice.source_step = (int)((double)n2 * 16384.0 / 44100.0);
            ++n3;
        }
    }

    int OKIM6295_status_r(int n) {
        if (n > num_voices / 4) {
            return 255;
        }
        int n2 = 240;
        int n3 = 0;
        while (n3 < 4) {
            ADPCMVoice aDPCMVoice = this.adpcm[n * 4 + n3];
            if (aDPCMVoice.playing != 0) {
                n2 |= 1 << n3;
            }
            ++n3;
        }
        return n2;
    }

    void OKIM6295_data_w(int n, int n2) {
        if (n >= num_voices / 4) {
            return;
        }
        if (this.okim6295_command[n] != -1) {
            int n3 = n2 >> 4;
            int n4 = 0;
            while (n4 < 4) {
                if ((n3 & 1) != 0) {
                    ADPCMVoice aDPCMVoice = this.adpcm[n * 4 + n4];
                    byte[] byArray = aDPCMVoice.region_base;
                    int n5 = this.okim6295_base[n][n4] + this.okim6295_command[n] * 8;
                    int n6 = ((byArray[n5 + 0] & 0xFF) << 16) + ((byArray[n5 + 1] & 0xFF) << 8) + (byArray[n5 + 2] & 0xFF);
                    int n7 = ((byArray[n5 + 3] & 0xFF) << 16) + ((byArray[n5 + 4] & 0xFF) << 8) + (byArray[n5 + 5] & 0xFF);
                    if (n6 < 262144 && n7 < 262144) {
                        aDPCMVoice.playing = 1;
                        aDPCMVoice.base = aDPCMVoice.region_base;
                        aDPCMVoice.offset = this.okim6295_base[n][n4] + n6;
                        if (aDPCMVoice.offset < 0) {
                            System.out.println("Neg offset " + this.okim6295_base[n][n4] + " " + n6);
                        }
                        aDPCMVoice.sample = 0;
                        aDPCMVoice.count = 2 * (n7 - n6 + 1);
                        aDPCMVoice.signal = -2;
                        aDPCMVoice.step = 0;
                        aDPCMVoice.volume = volume_table[n2 & 0xF];
                    } else {
                        aDPCMVoice.playing = 0;
                    }
                }
                ++n4;
                n3 >>= 1;
            }
            this.okim6295_command[n] = -1;
        } else if ((n2 & 0x80) != 0) {
            this.okim6295_command[n] = n2 & 0x7F;
        } else {
            int n8 = n2 >> 3;
            int n9 = 0;
            while (n9 < 4) {
                if ((n8 & 1) != 0) {
                    ADPCMVoice aDPCMVoice = this.adpcm[n * 4 + n9];
                    aDPCMVoice.playing = 0;
                }
                ++n9;
                n8 >>= 1;
            }
        }
    }

    static {
        index_shift = new int[]{-1, -1, -1, -1, 2, 4, 6, 8};
    }
}

