/*
 * Decompiled with CFR 0.152.
 */
public class SoundMemory
implements Memory {
    public byte[] rom;
    public byte[] ram;
    public byte[] samples;
    public YM2151 ym2151;
    public OKI6295 oki6295;
    private int YM2151reg;
    private byte[] rom_bank;
    private int sound_latch;
    private Z80 z80;

    SoundMemory(byte[] byArray, byte[] byArray2, YM2151 yM2151, OKI6295 oKI6295) {
        this.rom = byArray;
        System.out.println("program rom sizes " + byArray.length + " bytes");
        System.out.println("samples rom sizes " + byArray2.length + " bytes");
        this.samples = byArray2;
        this.ym2151 = yM2151;
        this.oki6295 = oKI6295;
        this.ram = new byte[2048];
        this.rom_bank = new byte[16384];
        oKI6295.OKIM6295_sh_start(byArray2);
    }

    public void reset() {
        this.z80.reset();
        this.ym2151.ResetChip();
    }

    public void setZ80(Z80 z80) {
        this.z80 = z80;
    }

    public void writeToSoundLatch(int n) {
        this.sound_latch = n;
        this.z80.PendingIRQ(0);
    }

    public void writeByte(int n, int n2) {
        if (n >= 53248 && n < 55296) {
            this.ram[n & 0x7FF] = (byte)n2;
        } else if (n == 61440) {
            this.YM2151reg = n2;
        } else if (n == 61441) {
            this.ym2151.WriteReg(this.YM2151reg, n2 & 0xFF);
        } else if (n == 61442) {
            this.oki6295.OKIM6295_data_w(0, n2 & 0xFF);
        } else if (n == 61444) {
            int n3 = 0;
            while (n3 < 16384) {
                this.rom_bank[n3] = this.rom[32768 + (n2 & 1) * 16384 + n3];
                ++n3;
            }
        }
    }

    public int readByte(int n) {
        if (n == 61441) {
            return this.ym2151.YM2151ReadStatus();
        }
        if (n == 61442) {
            return this.oki6295.OKIM6295_status_r(0);
        }
        if (n == 61448) {
            return this.sound_latch;
        }
        if (n == 61450) {
            return 0;
        }
        if (n >= 53248 && n < 55296) {
            return this.ram[n & 0x7FF] & 0xFF;
        }
        if (n >= 32768 && n < 49152) {
            return this.rom_bank[n & 0x3FFF] & 0xFF;
        }
        if (n < 32768) {
            return this.rom[n & Short.MAX_VALUE] & 0xFF;
        }
        return 0;
    }
}

