/*
 * Decompiled with CFR 0.152.
 */
public class YM2151 {
    OscilRec[] Oscils;
    YM2151Handlers handlers;
    int[] PAN;
    int LFOphase;
    int LFOfrq;
    int LFOwave;
    int PMD;
    int AMD;
    int LFA;
    int LFP;
    int test;
    int CT;
    int noise;
    int noiseRNG;
    int noise_p;
    int noise_f;
    int CSMreq;
    int IRQenable;
    int status;
    int TimA;
    int TimB;
    int TimAVal;
    int TimBVal;
    int[] TimerA;
    int[] TimerB;
    int TimAIndex;
    int TimBIndex;
    int TimAOldIndex;
    int TimBOldIndex;
    int[] freq;
    int[] DT1freq;
    int[] EG_tab;
    int[] LFOfreq;
    int[] noise_tab;
    int clock;
    int sampfreq;
    private static final int SAMPLE_BITS = 16;
    private static final int FREQ_SH = 16;
    private static final int ENV_SH = 16;
    private static final int LFO_SH = 23;
    private static final int TIMER_SH = 16;
    private static final int ENV_BITS = 10;
    private static final int ENV_LEN = 1024;
    private static final int FREQ_MASK = 65535;
    private static final int ENV_MASK = 65535;
    private static final double ENV_STEP = 0.125;
    private static final int ENV_QUIET = 832;
    private static final int MAX_ATT_INDEX = 0x3FFFFFF;
    private static final int MIN_ATT_INDEX = 65535;
    private static final int EG_OFF = 0;
    private static final int EG_REL = 1;
    private static final int EG_SUS = 2;
    private static final int EG_DEC = 3;
    private static final int EG_ATT = 4;
    private static final int SIN_BITS = 10;
    private static final int SIN_LEN = 1024;
    private static final int SIN_MASK = 1023;
    private static final int TL_RES_LEN = 256;
    private static final int LFO_BITS = 9;
    private static final int LFO_LEN = 512;
    private static final int LFO_MASK = 511;
    private static final int FINAL_SH = 0;
    private static final int TL_TAB_LEN = 6656;
    private static int[] TL_TAB;
    private static int[] lfo_tab;
    private static int[] sin_tab;
    private static int[] lfo_md_tab;
    private static int[] D1L_tab;
    private static int[][] chanout;
    private static int[] c1;
    private static int[] m2;
    private static int[] c2;
    private static final int[] DT2_tab;
    private static final byte[] DT1_tab;
    private static final short[] phaseinc_rom;
    private static final double PI = Math.PI;

    YM2151(int n, int n2) {
        c1 = new int[1];
        c2 = new int[1];
        m2 = new int[1];
        this.PAN = new int[16];
        this.TimerA = new int[1024];
        this.TimerB = new int[256];
        this.freq = new int[8448];
        this.DT1freq = new int[256];
        this.EG_tab = new int[128];
        this.LFOfreq = new int[256];
        this.noise_tab = new int[32];
        TL_TAB = new int[6656];
        sin_tab = new int[1024];
        lfo_tab = new int[4096];
        lfo_md_tab = new int[128];
        D1L_tab = new int[16];
        chanout = new int[8][1];
        this.Oscils = new OscilRec[32];
        int n3 = 0;
        while (n3 < 32) {
            this.Oscils[n3] = new OscilRec();
            ++n3;
        }
        this.handlers = null;
        YM2151.init_tables();
        this.clock = n;
        this.sampfreq = n2 != 0 ? n2 : 44100;
        this.init_chip_tables();
        this.TimA = 0;
        this.TimB = 0;
        this.ResetChip();
    }

    private static void init_tables() {
        double d;
        int n;
        int n2;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < 256) {
            d2 = 65536.0 / Math.pow(2.0, (double)(n3 + 1) * 0.03125 / 8.0);
            d2 = Math.floor(d2);
            n2 = (int)d2;
            n2 = ((n2 >>= 4) & 1) != 0 ? (n2 >> 1) + 1 : (n2 >>= 1);
            YM2151.TL_TAB[n3 * 2 + 0] = n2 <<= 2;
            YM2151.TL_TAB[n3 * 2 + 1] = -TL_TAB[n3 * 2 + 0];
            n = 1;
            while (n < 13) {
                YM2151.TL_TAB[n3 * 2 + 0 + n * 2 * 256] = TL_TAB[n3 * 2 + 0] >> n;
                YM2151.TL_TAB[n3 * 2 + 1 + n * 2 * 256] = -TL_TAB[n3 * 2 + 0 + n * 2 * 256];
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < 1024) {
            d2 = Math.sin((double)(n * 2 + 1) * Math.PI / 1024.0);
            d = d2 > 0.0 ? 8.0 * Math.log(1.0 / d2) / Math.log(2.0) : 8.0 * Math.log(-1.0 / d2) / Math.log(2.0);
            n2 = (int)(2.0 * (d /= 0.03125));
            n2 = (n2 & 1) != 0 ? (n2 >> 1) + 1 : (n2 >>= 1);
            YM2151.sin_tab[n] = n2 * 2 + (d2 >= 0.0 ? 0 : 1);
            ++n;
        }
        n3 = 0;
        while (n3 < 4) {
            n = 0;
            while (n < 512) {
                switch (n3) {
                    case 0: {
                        d2 = 255 - n / 2;
                        break;
                    }
                    case 1: {
                        if (n < 256) {
                            d2 = 255.0;
                            break;
                        }
                        d2 = 0.0;
                        break;
                    }
                    case 2: {
                        if (n < 256) {
                            d2 = 255 - n;
                            break;
                        }
                        d2 = n - 256;
                        break;
                    }
                    case 3: {
                        d2 = (int)(Math.random() * 255.0);
                    }
                }
                d = d2 > 0.0 ? 8.0 * Math.log(255.0 / d2) / Math.log(2.0) : (d2 < 0.0 ? 8.0 * Math.log(-255.0 / d2) / Math.log(2.0) : 8.0 * Math.log(25500.0) / Math.log(2.0));
                n2 = (int)(2.0 * (d /= 0.03125));
                n2 = (n2 & 1) != 0 ? (n2 >> 1) + 1 : (n2 >>= 1);
                YM2151.lfo_tab[n3 * 512 * 2 + n * 2] = YM2151.unsigned(n2 * 2 + (d2 >= 0.0 ? 0 : 1));
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < 128) {
            d2 = n * 2;
            d = d2 > 0.0 ? 8.0 * Math.log(8192.0 / d2) / Math.log(2.0) : 8.0 * Math.log(819200.0) / Math.log(2.0);
            n2 = (int)(2.0 * (d /= 0.03125));
            n2 = (n2 & 1) != 0 ? (n2 >> 1) + 1 : (n2 >>= 1);
            YM2151.lfo_md_tab[n] = n2 * 2;
            ++n;
        }
        n3 = 0;
        while (n3 < 4) {
            n = 0;
            while (n < 512) {
                switch (n3) {
                    case 0: {
                        if (n < 256) {
                            d2 = n / 2;
                            break;
                        }
                        d2 = n / 2 - 256;
                        break;
                    }
                    case 1: {
                        if (n < 256) {
                            d2 = 127.0;
                            break;
                        }
                        d2 = -128.0;
                        break;
                    }
                    case 2: {
                        if (n < 128) {
                            d2 = n;
                            break;
                        }
                        if (n < 384) {
                            d2 = 255 - n;
                            break;
                        }
                        d2 = n - 511;
                        break;
                    }
                    case 3: {
                        d2 = (int)(Math.random() * 255.0 - 128.0);
                    }
                }
                d = d2 > 0.0 ? 8.0 * Math.log(127.0 / d2) / Math.log(2.0) : (d2 < 0.0 ? 8.0 * Math.log(-128.0 / d2) / Math.log(2.0) : 8.0 * Math.log(12700.0) / Math.log(2.0));
                n2 = (int)(2.0 * (d /= 0.03125));
                n2 = (n2 & 1) != 0 ? (n2 >> 1) + 1 : (n2 >>= 1);
                YM2151.lfo_tab[n3 * 512 * 2 + n * 2 + 1] = YM2151.unsigned(n2 * 2 + (d2 >= 0.0 ? 0 : 1));
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < 16) {
            d2 = (n != 15 ? (double)n : (double)(n + 16)) * 32.0;
            YM2151.D1L_tab[n] = (int)(d2 * 65536.0);
            ++n;
        }
    }

    private void init_chip_tables() {
        double d;
        int n;
        double d2;
        double d3;
        double d4 = (double)this.clock / 64.0 / (double)this.sampfreq;
        double d5 = 64.0;
        int n2 = 0;
        while (n2 < 768) {
            d3 = 1000.0;
            d2 = phaseinc_rom[n2];
            this.freq[2304 + n2] = (int)((d2 *= d4) * d5) & 0xFFFFFFC0;
            n = 0;
            while (n < 2) {
                this.freq[768 + n * 768 + n2] = this.freq[2304 + n2] >> 2 - n & 0xFFFFFFC0;
                ++n;
            }
            n = 3;
            while (n < 8) {
                this.freq[768 + n * 768 + n2] = this.freq[2304 + n2] << n - 2;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 768) {
            this.freq[0 + n2] = this.freq[768];
            ++n2;
        }
        n = 8;
        while (n < 10) {
            n2 = 0;
            while (n2 < 768) {
                this.freq[768 + n * 768 + n2] = this.freq[6911];
                ++n2;
            }
            ++n;
        }
        d5 = 65536.0;
        n = 0;
        while (n < 4) {
            n2 = 0;
            while (n2 < 32) {
                d3 = (double)DT1_tab[n * 32 + n2] * ((double)this.clock / 64.0) / 1048576.0;
                d2 = d3 * 1024.0 / (double)this.sampfreq;
                this.DT1freq[(n + 0) * 32 + n2] = (int)(d2 * d5);
                this.DT1freq[(n + 4) * 32 + n2] = -this.DT1freq[(n + 0) * 32 + n2];
                ++n2;
            }
            ++n;
        }
        d5 = 8388608.0;
        double d6 = this.clock;
        n2 = 0;
        while (n2 < 256) {
            n = n2 & 0xF;
            d = Math.abs((float)(d6 / 65536.0 / (double)(1 << n2 / 16) - d6 / 65536.0 / 32.0 / (double)(1 << n2 / 16) * (double)(n + 1)));
            this.LFOfreq[255 - n2] = YM2151.unsigned((int)(d * 512.0 / (double)this.sampfreq * d5));
            ++n2;
        }
        n2 = 0;
        while (n2 < 34) {
            this.EG_tab[n2] = 0;
            ++n2;
        }
        n2 = 2;
        while (n2 < 64) {
            double d7 = (double)this.clock / (double)this.sampfreq;
            if (n2 < 60) {
                d7 *= 1.0 + (double)(n2 & 3) * 0.25;
            }
            d7 *= (double)(1 << (n2 >> 2));
            d7 /= 786432.0;
            this.EG_tab[32 + n2] = YM2151.unsigned((int)(d7 *= 65536.0));
            ++n2;
        }
        n2 = 0;
        while (n2 < 32) {
            this.EG_tab[96 + n2] = this.EG_tab[95];
            ++n2;
        }
        d5 = 65536.0;
        n2 = 0;
        while (n2 < 1024) {
            d = 64.0 * (1024.0 - (double)n2) / (double)this.clock;
            this.TimerA[n2] = (int)(d * (double)this.sampfreq * d5);
            ++n2;
        }
        n2 = 0;
        while (n2 < 256) {
            d = 1024.0 * (256.0 - (double)n2) / (double)this.clock;
            this.TimerB[n2] = (int)(d * (double)this.sampfreq * d5);
            ++n2;
        }
        d4 = (double)this.clock / 64.0 / (double)this.sampfreq;
        n2 = 0;
        while (n2 < 32) {
            n = n2 != 31 ? n2 : 30;
            n = 32 - n;
            n = (int)(65536.0 / ((double)n * 32.0));
            this.noise_tab[n2] = (int)((double)(n * 64) * d4);
            ++n2;
        }
    }

    private final void envelope_KONKOFF(int n, int n2) {
        OscilRec oscilRec = this.Oscils[n];
        if ((n2 & 8) != 0) {
            if (oscilRec.key == 0) {
                oscilRec.key = 1;
                oscilRec.phase = 0;
                oscilRec.state = 4;
            }
        } else if (oscilRec.key != 0) {
            oscilRec.key = 0;
            if (oscilRec.state > 1) {
                oscilRec.state = 1;
            }
        }
        oscilRec = this.Oscils[n += 8];
        if ((n2 & 0x20) != 0) {
            if (oscilRec.key == 0) {
                oscilRec.key = 1;
                oscilRec.phase = 0;
                oscilRec.state = 4;
            }
        } else if (oscilRec.key != 0) {
            oscilRec.key = 0;
            if (oscilRec.state > 1) {
                oscilRec.state = 1;
            }
        }
        oscilRec = this.Oscils[n += 8];
        if ((n2 & 0x10) != 0) {
            if (oscilRec.key == 0) {
                oscilRec.key = 1;
                oscilRec.phase = 0;
                oscilRec.state = 4;
            }
        } else if (oscilRec.key != 0) {
            oscilRec.key = 0;
            if (oscilRec.state > 1) {
                oscilRec.state = 1;
            }
        }
        oscilRec = this.Oscils[n += 8];
        if ((n2 & 0x40) != 0) {
            if (oscilRec.key == 0) {
                oscilRec.key = 1;
                oscilRec.phase = 0;
                oscilRec.state = 4;
            }
        } else if (oscilRec.key != 0) {
            oscilRec.key = 0;
            if (oscilRec.state > 1) {
                oscilRec.state = 1;
            }
        }
    }

    private final void set_connect(int n, int n2, int n3) {
        OscilRec oscilRec = this.Oscils[n];
        OscilRec oscilRec2 = this.Oscils[n + 8];
        OscilRec oscilRec3 = this.Oscils[n + 16];
        switch (n2 & 7) {
            case 0: {
                oscilRec.connect = c1;
                oscilRec3.connect = m2;
                oscilRec2.connect = c2;
                break;
            }
            case 1: {
                oscilRec.connect = m2;
                oscilRec3.connect = m2;
                oscilRec2.connect = c2;
                break;
            }
            case 2: {
                oscilRec.connect = c2;
                oscilRec3.connect = m2;
                oscilRec2.connect = c2;
                break;
            }
            case 3: {
                oscilRec.connect = c1;
                oscilRec3.connect = c2;
                oscilRec2.connect = c2;
                break;
            }
            case 4: {
                oscilRec.connect = c1;
                oscilRec3.connect = chanout[n3];
                oscilRec2.connect = c2;
                break;
            }
            case 5: {
                oscilRec.connect = null;
                oscilRec3.connect = chanout[n3];
                oscilRec2.connect = chanout[n3];
                break;
            }
            case 6: {
                oscilRec.connect = c1;
                oscilRec3.connect = chanout[n3];
                oscilRec2.connect = chanout[n3];
                break;
            }
            case 7: {
                oscilRec.connect = chanout[n3];
                oscilRec3.connect = chanout[n3];
                oscilRec2.connect = chanout[n3];
            }
        }
    }

    private final void refresh_EG(int n) {
        OscilRec oscilRec = this.Oscils[n];
        int n2 = YM2151.unsigned(oscilRec.KC);
        int n3 = YM2151.unsigned(n2 >> oscilRec.KS);
        oscilRec.delta_AR = oscilRec.AR + n3 < 94 ? this.EG_tab[oscilRec.AR + n3] : 0x4000000;
        oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + n3];
        oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + n3];
        oscilRec.delta_RR = this.EG_tab[oscilRec.RR + n3];
        oscilRec = this.Oscils[n += 8];
        n3 = YM2151.unsigned(n2 >> oscilRec.KS);
        oscilRec.delta_AR = oscilRec.AR + n3 < 94 ? this.EG_tab[oscilRec.AR + n3] : 0x4000000;
        oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + n3];
        oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + n3];
        oscilRec.delta_RR = this.EG_tab[oscilRec.RR + n3];
        oscilRec = this.Oscils[n += 8];
        n3 = YM2151.unsigned(n2 >> oscilRec.KS);
        oscilRec.delta_AR = oscilRec.AR + n3 < 94 ? this.EG_tab[oscilRec.AR + n3] : 0x4000000;
        oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + n3];
        oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + n3];
        oscilRec.delta_RR = this.EG_tab[oscilRec.RR + n3];
        oscilRec = this.Oscils[n += 8];
        n3 = YM2151.unsigned(n2 >> oscilRec.KS);
        oscilRec.delta_AR = oscilRec.AR + n3 < 94 ? this.EG_tab[oscilRec.AR + n3] : 0x4000000;
        oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + n3];
        oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + n3];
        oscilRec.delta_RR = this.EG_tab[oscilRec.RR + n3];
    }

    public final void WriteReg(int n, int n2) {
        OscilRec oscilRec = this.Oscils[n & 0x1F];
        n2 &= 0xFF;
        block0 : switch ((n &= 0xFF) & 0xE0) {
            case 0: {
                switch (n) {
                    case 1: {
                        this.test = n2;
                        if ((n2 & 2) == 0) break block0;
                        this.LFOphase = 0;
                        break block0;
                    }
                    case 8: {
                        this.envelope_KONKOFF(n2 & 7, n2);
                        break block0;
                    }
                    case 15: {
                        this.noise = n2;
                        this.noise_f = this.noise_tab[n2 & 0x1F];
                        break block0;
                    }
                    case 16: {
                        this.TimAIndex = this.TimAIndex & 3 | n2 << 2;
                        break block0;
                    }
                    case 17: {
                        this.TimAIndex = this.TimAIndex & 0x3FC | n2 & 3;
                        break block0;
                    }
                    case 18: {
                        this.TimBIndex = n2;
                        break block0;
                    }
                    case 20: {
                        int n3;
                        this.IRQenable = n2;
                        if ((n2 & 0x20) != 0) {
                            n3 = this.status & 3;
                            this.status &= 0xFD;
                            if (n3 == 2 && this.handlers != null) {
                                this.handlers.IrqHandler(0);
                            }
                        }
                        if ((n2 & 0x10) != 0) {
                            n3 = this.status & 3;
                            this.status &= 0xFE;
                            if (n3 == 1 && this.handlers != null) {
                                this.handlers.IrqHandler(0);
                            }
                        }
                        if ((n2 & 2) != 0) {
                            if (this.TimB == 0) {
                                this.TimB = 1;
                                this.TimBVal = this.TimerB[this.TimBIndex];
                            }
                        } else {
                            this.TimB = 0;
                        }
                        if ((n2 & 1) != 0) {
                            if (this.TimA != 0) break block0;
                            this.TimA = 1;
                            this.TimAVal = this.TimerA[this.TimAIndex];
                            break block0;
                        }
                        this.TimA = 0;
                        break block0;
                    }
                    case 24: {
                        this.LFOfrq = this.LFOfreq[n2];
                        break block0;
                    }
                    case 25: {
                        if ((n2 & 0x80) != 0) {
                            this.PMD = lfo_md_tab[n2 & 0x7F] + 512;
                            break block0;
                        }
                        this.AMD = lfo_md_tab[n2 & 0x7F];
                        break block0;
                    }
                    case 27: {
                        this.CT = n2;
                        this.LFOwave = (n2 & 3) * 512 * 2;
                        if (this.handlers == null) break block0;
                        this.handlers.PortWriteHandler(0, this.CT >> 6);
                        break block0;
                    }
                }
                break;
            }
            case 32: {
                oscilRec = this.Oscils[n & 7];
                switch (n & 0x18) {
                    case 0: {
                        oscilRec.FeedBack = (n2 >> 3 & 7) != 0 ? (n2 >> 3 & 7) + 6 : 0;
                        this.PAN[(n & 7) * 2] = (n2 & 0x40) != 0 ? -1 : 0;
                        this.PAN[(n & 7) * 2 + 1] = (n2 & 0x80) != 0 ? -1 : 0;
                        this.set_connect(n & 7, n2, n & 7);
                        break;
                    }
                    case 8: {
                        if ((n2 &= 0x7F) == oscilRec.KC) break;
                        int n4 = YM2151.unsigned((n2 - (n2 >> 2)) * 64);
                        n4 += 768;
                        this.Oscils[(n & 7) + 0].KC = n2;
                        this.Oscils[(n & 7) + 0].KCindex = n4 |= oscilRec.KCindex & 0x3F;
                        this.Oscils[(n & 7) + 8].KC = n2;
                        this.Oscils[(n & 7) + 8].KCindex = n4;
                        this.Oscils[(n & 7) + 16].KC = n2;
                        this.Oscils[(n & 7) + 16].KCindex = n4;
                        this.Oscils[(n & 7) + 24].KC = n2;
                        this.Oscils[(n & 7) + 24].KCindex = n4;
                        int n5 = YM2151.unsigned(n2 >> 2);
                        this.Oscils[(n & 7) + 0].DT1v = this.DT1freq[this.Oscils[(n & 7) + 0].DT1 + n5];
                        this.Oscils[(n & 7) + 0].freq = YM2151.unsigned((this.freq[n4 + this.Oscils[(n & 7) + 0].DT2] + this.Oscils[(n & 7) + 0].DT1v) * this.Oscils[(n & 7) + 0].MUL) >> 1;
                        this.Oscils[(n & 7) + 8].DT1v = this.DT1freq[this.Oscils[(n & 7) + 8].DT1 + n5];
                        this.Oscils[(n & 7) + 8].freq = YM2151.unsigned((this.freq[n4 + this.Oscils[(n & 7) + 8].DT2] + this.Oscils[(n & 7) + 8].DT1v) * this.Oscils[(n & 7) + 8].MUL) >> 1;
                        this.Oscils[(n & 7) + 16].DT1v = this.DT1freq[this.Oscils[(n & 7) + 16].DT1 + n5];
                        this.Oscils[(n & 7) + 16].freq = YM2151.unsigned((this.freq[n4 + this.Oscils[(n & 7) + 16].DT2] + this.Oscils[(n & 7) + 16].DT1v) * this.Oscils[(n & 7) + 16].MUL) >> 1;
                        this.Oscils[(n & 7) + 24].DT1v = this.DT1freq[this.Oscils[(n & 7) + 24].DT1 + n5];
                        this.Oscils[(n & 7) + 24].freq = YM2151.unsigned((this.freq[n4 + this.Oscils[(n & 7) + 24].DT2] + this.Oscils[(n & 7) + 24].DT1v) * this.Oscils[(n & 7) + 24].MUL) >> 1;
                        this.refresh_EG(n & 7);
                        break;
                    }
                    case 16: {
                        if ((n2 >>= 2) == (oscilRec.KCindex & 0x3F)) break;
                        int n6 = n2;
                        this.Oscils[(n & 7) + 0].KCindex = n6 |= oscilRec.KCindex & 0xFFFFFFC0;
                        this.Oscils[(n & 7) + 8].KCindex = n6;
                        this.Oscils[(n & 7) + 16].KCindex = n6;
                        this.Oscils[(n & 7) + 24].KCindex = n6;
                        this.Oscils[(n & 7) + 0].freq = YM2151.unsigned((this.freq[n6 + this.Oscils[(n & 7) + 0].DT2] + this.Oscils[(n & 7) + 0].DT1v) * this.Oscils[(n & 7) + 0].MUL) >> 1;
                        this.Oscils[(n & 7) + 8].freq = YM2151.unsigned((this.freq[n6 + this.Oscils[(n & 7) + 8].DT2] + this.Oscils[(n & 7) + 8].DT1v) * this.Oscils[(n & 7) + 8].MUL) >> 1;
                        this.Oscils[(n & 7) + 16].freq = YM2151.unsigned((this.freq[n6 + this.Oscils[(n & 7) + 16].DT2] + this.Oscils[(n & 7) + 16].DT1v) * this.Oscils[(n & 7) + 16].MUL) >> 1;
                        this.Oscils[(n & 7) + 24].freq = YM2151.unsigned((this.freq[n6 + this.Oscils[(n & 7) + 24].DT2] + this.Oscils[(n & 7) + 24].DT1v) * this.Oscils[(n & 7) + 24].MUL) >> 1;
                        break;
                    }
                    case 24: {
                        oscilRec.PMS = n2 >> 4 & 7;
                        oscilRec.AMS = n2 & 3;
                    }
                }
                break;
            }
            case 64: {
                int n7 = oscilRec.DT1;
                int n8 = oscilRec.MUL;
                oscilRec.DT1 = (n2 & 0x70) << 1;
                int n9 = oscilRec.MUL = (n2 & 0xF) != 0 ? (n2 & 0xF) << 1 : 1;
                if (n7 != oscilRec.DT1) {
                    oscilRec.DT1v = this.DT1freq[oscilRec.DT1 + (oscilRec.KC >> 2)];
                }
                if (n7 == oscilRec.DT1 && n8 == oscilRec.MUL) break;
                oscilRec.freq = (this.freq[oscilRec.KCindex + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
                break;
            }
            case 96: {
                oscilRec.TL = (n2 & 0x7F) << 3;
                break;
            }
            case 128: {
                int n10 = oscilRec.KS;
                int n11 = oscilRec.AR;
                oscilRec.KS = 5 - (n2 >> 6);
                int n12 = oscilRec.AR = (n2 & 0x1F) != 0 ? 32 + ((n2 & 0x1F) << 1) : 0;
                if (oscilRec.AR != n11 || oscilRec.KS != n10) {
                    oscilRec.delta_AR = oscilRec.AR + (oscilRec.KC >> oscilRec.KS) < 94 ? this.EG_tab[oscilRec.AR + (oscilRec.KC >> oscilRec.KS)] : 0x4000000;
                }
                if (oscilRec.KS == n10) break;
                oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + (oscilRec.KC >> oscilRec.KS)];
                oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + (oscilRec.KC >> oscilRec.KS)];
                oscilRec.delta_RR = this.EG_tab[oscilRec.RR + (oscilRec.KC >> oscilRec.KS)];
                break;
            }
            case 160: {
                oscilRec.AMSmask = (n2 & 0x80) != 0 ? -1 : 0;
                oscilRec.D1R = (n2 & 0x1F) != 0 ? 32 + ((n2 & 0x1F) << 1) : 0;
                oscilRec.delta_D1R = this.EG_tab[oscilRec.D1R + (oscilRec.KC >> oscilRec.KS)];
                break;
            }
            case 192: {
                int n13 = oscilRec.DT2;
                oscilRec.DT2 = DT2_tab[n2 >> 6];
                if (oscilRec.DT2 != n13) {
                    oscilRec.freq = (this.freq[oscilRec.KCindex + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
                }
                oscilRec.D2R = (n2 & 0x1F) != 0 ? 32 + ((n2 & 0x1F) << 1) : 0;
                oscilRec.delta_D2R = this.EG_tab[oscilRec.D2R + (oscilRec.KC >> oscilRec.KS)];
                break;
            }
            case 224: {
                oscilRec.D1L = D1L_tab[n2 >> 4];
                oscilRec.RR = 34 + ((n2 & 0xF) << 2);
                oscilRec.delta_RR = this.EG_tab[oscilRec.RR + (oscilRec.KC >> oscilRec.KS)];
            }
        }
    }

    int YM2151ReadStatus() {
        return this.status;
    }

    void Shutdown() {
    }

    void ResetChip() {
        int n = 0;
        while (n < 32) {
            this.Oscils[n].volume = 0x3FFFFFF;
            ++n;
        }
        this.LFOphase = 0;
        this.LFOfrq = 0;
        this.LFOwave = 0;
        this.PMD = lfo_md_tab[0] + 512;
        this.AMD = lfo_md_tab[0];
        this.LFA = 0;
        this.LFP = 0;
        this.test = 0;
        this.IRQenable = 0;
        this.TimA = 0;
        this.TimB = 0;
        this.TimAVal = 0;
        this.TimBVal = 0;
        this.TimAIndex = 0;
        this.TimBIndex = 0;
        this.TimAOldIndex = 0;
        this.TimBOldIndex = 0;
        this.noise = 0;
        this.noiseRNG = 0;
        this.noise_p = 0;
        this.noise_f = this.noise_tab[0];
        this.CSMreq = 0;
        this.status = 0;
        this.WriteReg(27, 0);
        n = 32;
        while (n < 256) {
            this.WriteReg(n, 0);
            ++n;
        }
    }

    private final void lfo_calc() {
        int n;
        if ((this.test & 2) != 0) {
            this.LFOphase = 0;
            n = YM2151.unsigned(this.LFOwave);
        } else {
            n = YM2151.unsigned(this.LFOphase >> 23 & 0x1FF);
            n = YM2151.unsigned(n * 2 + this.LFOwave);
        }
        int n2 = YM2151.unsigned(lfo_tab[n] + this.AMD);
        this.LFA = 0;
        if (n2 < 6656) {
            this.LFA = TL_TAB[n2];
        }
        n2 = YM2151.unsigned(lfo_tab[n + 1] + this.PMD);
        this.LFP = 0;
        if (n2 < 6656) {
            this.LFP = TL_TAB[n2];
        }
    }

    private final void chan7_calc() {
        YM2151.c2[0] = 0;
        YM2151.m2[0] = 0;
        YM2151.c1[0] = 0;
        YM2151.chanout[7][0] = 0;
        int n = 0;
        OscilRec oscilRec = this.Oscils[7];
        if (oscilRec.AMS != 0) {
            n = this.LFA << oscilRec.AMS - 1;
        }
        if (oscilRec.PMS != 0) {
            this.calc_lfo_pm(7);
        }
        int n2 = this.volume_calc(oscilRec, n);
        int n3 = oscilRec.FB0 + oscilRec.FB;
        oscilRec.FB0 = oscilRec.FB;
        if (oscilRec.connect == null) {
            YM2151.m2[0] = YM2151.c2[0] = oscilRec.FB0;
            YM2151.c1[0] = YM2151.c2[0];
        } else {
            oscilRec.connect[0] = oscilRec.FB0;
        }
        oscilRec.FB = 0;
        if (n2 < 832) {
            oscilRec.FB = this.op_calc1(7, n2, n3 << oscilRec.FeedBack);
        }
        if ((n2 = this.volume_calc(oscilRec = this.Oscils[23], n)) < 832) {
            oscilRec.connect[0] = oscilRec.connect[0] + this.op_calc(23, n2, c1[0]);
        }
        if ((n2 = this.volume_calc(oscilRec = this.Oscils[15], n)) < 832) {
            oscilRec.connect[0] = oscilRec.connect[0] + this.op_calc(15, n2, m2[0]);
        }
        oscilRec = this.Oscils[31];
        n2 = this.volume_calc(oscilRec, n);
        if ((this.noise & 0x80) != 0) {
            n3 = 0;
            if (n2 < 1023) {
                n3 = (n2 ^ 0x3FF) * 2;
            }
            int[] nArray = chanout[7];
            nArray[0] = nArray[0] + ((this.noiseRNG & 0x10000) != 0 ? n3 : -1 * n3);
        } else if (n2 < 832) {
            int[] nArray = chanout[7];
            nArray[0] = nArray[0] + this.op_calc(31, n2, c2[0]);
        }
    }

    private final void calc_lfo_pm(int n) {
        OscilRec oscilRec = this.Oscils[n];
        int n2 = this.LFP;
        n2 = oscilRec.PMS < 6 ? (n2 >>= 6 - oscilRec.PMS) : (n2 <<= oscilRec.PMS - 5);
        if (n2 != 0) {
            int n3 = YM2151.unsigned(oscilRec.KCindex + n2);
            int n4 = (this.freq[n3 + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
            oscilRec.phase += n4 - oscilRec.freq;
            oscilRec = this.Oscils[n + 8];
            n4 = (this.freq[n3 + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
            oscilRec.phase += n4 - oscilRec.freq;
            oscilRec = this.Oscils[n + 16];
            n4 = (this.freq[n3 + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
            oscilRec.phase += n4 - oscilRec.freq;
            oscilRec = this.Oscils[n + 24];
            n4 = (this.freq[n3 + oscilRec.DT2] + oscilRec.DT1v) * oscilRec.MUL >> 1;
            oscilRec.phase += n4 - oscilRec.freq;
        }
    }

    private final int op_calc(int n, int n2, int n3) {
        OscilRec oscilRec = this.Oscils[n];
        int n4 = YM2151.unsigned((n2 << 3) + sin_tab[(oscilRec.phase & 0xFFFF0000) + (n3 << 15) >> 16 & 0x3FF]);
        if (n4 >= 6656) {
            return 0;
        }
        return TL_TAB[n4];
    }

    private final int op_calc1(int n, int n2, int n3) {
        OscilRec oscilRec = this.Oscils[n];
        int n4 = (oscilRec.phase & 0xFFFF0000) + n3;
        int n5 = YM2151.unsigned((n2 << 3) + sin_tab[n4 >> 16 & 0x3FF]);
        if (n5 >= 6656) {
            return 0;
        }
        return TL_TAB[n5];
    }

    private static final int unsigned(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    private final int volume_calc(OscilRec oscilRec, int n) {
        return oscilRec.TL + (YM2151.unsigned(oscilRec.volume) >> 16) + (n & oscilRec.AMSmask);
    }

    private final void chan_calc(int n) {
        YM2151.c2[0] = 0;
        YM2151.m2[0] = 0;
        YM2151.c1[0] = 0;
        YM2151.chanout[n][0] = 0;
        int n2 = 0;
        OscilRec oscilRec = this.Oscils[n];
        if (oscilRec.AMS != 0) {
            n2 = YM2151.unsigned(this.LFA << oscilRec.AMS - 1);
        }
        if (oscilRec.PMS != 0) {
            this.calc_lfo_pm(n);
        }
        int n3 = YM2151.unsigned(this.volume_calc(oscilRec, n2));
        int n4 = oscilRec.FB0 + oscilRec.FB;
        oscilRec.FB0 = oscilRec.FB;
        if (oscilRec.connect == null) {
            YM2151.m2[0] = YM2151.c2[0] = oscilRec.FB0;
            YM2151.c1[0] = YM2151.c2[0];
        } else {
            oscilRec.connect[0] = oscilRec.FB0;
        }
        oscilRec.FB = 0;
        if (n3 < 832) {
            oscilRec.FB = this.op_calc1(n, n3, n4 << oscilRec.FeedBack);
        }
        if ((n3 = YM2151.unsigned(this.volume_calc(oscilRec = this.Oscils[n + 16], n2))) < 832) {
            oscilRec.connect[0] = oscilRec.connect[0] + this.op_calc(n + 16, n3, c1[0]);
        }
        if ((n3 = YM2151.unsigned(this.volume_calc(oscilRec = this.Oscils[n + 8], n2))) < 832) {
            oscilRec.connect[0] = oscilRec.connect[0] + this.op_calc(n + 8, n3, m2[0]);
        }
        if ((n3 = YM2151.unsigned(this.volume_calc(oscilRec = this.Oscils[n + 24], n2))) < 832) {
            int[] nArray = chanout[n];
            nArray[0] = nArray[0] + this.op_calc(n + 24, n3, c2[0]);
        }
    }

    private final void advance() {
        OscilRec oscilRec;
        int n;
        if ((this.test & 2) == 0) {
            this.LFOphase += this.LFOfrq;
        }
        this.noise_p += this.noise_f;
        int n2 = this.noise_p >> 16;
        this.noise_p &= 0xFFFF;
        while (n2 != 0) {
            n = YM2151.unsigned((this.noiseRNG ^ this.noiseRNG >> 3) & 1 ^ 1);
            this.noiseRNG = n << 16 | this.noiseRNG >> 1;
            --n2;
        }
        if (this.CSMreq != 0) {
            if (this.CSMreq == 2) {
                oscilRec = this.Oscils[0];
                n2 = 32;
                do {
                    if (oscilRec.key == 0) {
                        oscilRec.phase = 0;
                        oscilRec.state = 4;
                    }
                    if (--n2 == 0) continue;
                    oscilRec = this.Oscils[32 - n2];
                } while (n2 != 0);
                this.CSMreq = 1;
            } else {
                oscilRec = this.Oscils[0];
                n2 = 32;
                do {
                    if (oscilRec.key == 0 && oscilRec.state > 1) {
                        oscilRec.state = 1;
                    }
                    if (--n2 == 0) continue;
                    oscilRec = this.Oscils[32 - n2];
                } while (n2 != 0);
                this.CSMreq = 0;
            }
        }
        oscilRec = this.Oscils[0];
        n2 = 32;
        do {
            oscilRec.phase += oscilRec.freq;
            switch (oscilRec.state) {
                case 4: {
                    n = oscilRec.volume;
                    oscilRec.volume -= oscilRec.delta_AR;
                    n = (n >> 16) - (YM2151.unsigned(oscilRec.volume) >> 16);
                    if (n > 0) {
                        int n3 = oscilRec.volume + (n << 16);
                        while ((n3 = n3 - 65536 - (n3 >> 4 & 0xFFFF0000)) > 65535 && --n != 0) {
                        }
                        oscilRec.volume = n3;
                    }
                    if (oscilRec.volume > 65535) break;
                    if (oscilRec.volume < 0) {
                        oscilRec.volume = 0;
                    }
                    oscilRec.state = 3;
                    break;
                }
                case 3: {
                    if (YM2151.unsigned(oscilRec.volume += oscilRec.delta_D1R) < oscilRec.D1L) break;
                    oscilRec.volume = oscilRec.D1L;
                    oscilRec.state = 2;
                    break;
                }
                case 2: {
                    if ((oscilRec.volume += oscilRec.delta_D2R) <= 0x3FFFFFF) break;
                    oscilRec.state = 0;
                    oscilRec.volume = 0x3FFFFFF;
                    break;
                }
                case 1: {
                    if ((oscilRec.volume += oscilRec.delta_RR) <= 0x3FFFFFF) break;
                    oscilRec.state = 0;
                    oscilRec.volume = 0x3FFFFFF;
                }
            }
            if (--n2 == 0) continue;
            oscilRec = this.Oscils[32 - n2];
        } while (n2 != 0);
    }

    public void update(short[][] sArray, int n) {
        int n2;
        short[] sArray2 = sArray[0];
        short[] sArray3 = sArray[1];
        if (this.TimB != 0) {
            this.TimBVal -= n << 16;
            if (this.TimBVal <= 0) {
                this.TimBVal += this.TimerB[this.TimBIndex];
                if ((this.IRQenable & 8) != 0) {
                    n2 = this.status & 3;
                    this.status |= 2;
                    if (n2 == 0 && this.handlers != null) {
                        this.handlers.IrqHandler(1);
                    }
                }
            }
        }
        int n3 = 0;
        while (n3 < n) {
            this.chan_calc(0);
            this.chan_calc(1);
            this.chan_calc(2);
            this.chan_calc(3);
            this.chan_calc(4);
            this.chan_calc(5);
            this.chan_calc(6);
            this.chan7_calc();
            int n4 = chanout[0][0] & this.PAN[0];
            int n5 = chanout[0][0] & this.PAN[1];
            n4 += chanout[1][0] & this.PAN[2];
            n5 += chanout[1][0] & this.PAN[3];
            n4 += chanout[2][0] & this.PAN[4];
            n5 += chanout[2][0] & this.PAN[5];
            n4 += chanout[3][0] & this.PAN[6];
            n5 += chanout[3][0] & this.PAN[7];
            n4 += chanout[4][0] & this.PAN[8];
            n5 += chanout[4][0] & this.PAN[9];
            n4 += chanout[5][0] & this.PAN[10];
            n5 += chanout[5][0] & this.PAN[11];
            n4 += chanout[6][0] & this.PAN[12];
            n5 += chanout[6][0] & this.PAN[13];
            n5 += chanout[7][0] & this.PAN[15];
            if ((n4 += chanout[7][0] & this.PAN[14]) > Short.MAX_VALUE) {
                n4 = Short.MAX_VALUE;
            } else if (n4 < Short.MIN_VALUE) {
                n4 = Short.MIN_VALUE;
            }
            if (n5 > Short.MAX_VALUE) {
                n5 = Short.MAX_VALUE;
            } else if (n5 < Short.MIN_VALUE) {
                n5 = Short.MIN_VALUE;
            }
            sArray2[n3] = (short)(n4 & 0xFFFF);
            sArray3[n3] = (short)(n5 & 0xFFFF);
            if (this.TimA != 0) {
                this.TimAVal -= 65536;
                if (this.TimAVal <= 0) {
                    this.TimAVal += this.TimerA[this.TimAIndex];
                    if ((this.IRQenable & 4) != 0) {
                        n2 = this.status & 3;
                        this.status |= 1;
                        if (n2 == 0 && this.handlers != null) {
                            this.handlers.IrqHandler(1);
                        }
                    }
                    if ((this.IRQenable & 0x80) != 0) {
                        this.CSMreq = 2;
                    }
                }
            }
            this.lfo_calc();
            this.advance();
            ++n3;
        }
    }

    public final void setHandlers(YM2151Handlers yM2151Handlers) {
        this.handlers = yM2151Handlers;
    }

    static {
        DT2_tab = new int[]{0, 384, 500, 608};
        DT1_tab = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 8, 8, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 16, 16, 16, 16, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 20, 22, 22, 22, 22};
        phaseinc_rom = new short[]{1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1308, 1309, 1310, 1311, 1313, 1314, 1315, 1316, 1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1327, 1328, 1329, 1330, 1332, 1333, 1334, 1335, 1337, 1338, 1339, 1340, 1341, 1342, 1343, 1344, 1346, 1347, 1348, 1349, 1351, 1352, 1353, 1354, 1356, 1357, 1358, 1359, 1361, 1362, 1363, 1364, 1366, 1367, 1368, 1369, 1371, 1372, 1373, 1374, 1376, 1377, 1378, 1379, 1381, 1382, 1383, 1384, 1386, 1387, 1388, 1389, 1391, 1392, 1393, 1394, 1396, 1397, 1398, 1399, 1401, 1402, 1403, 1404, 1406, 1407, 1408, 1409, 1411, 1412, 1413, 1414, 1416, 1417, 1418, 1419, 1421, 1422, 1423, 1424, 1426, 1427, 1429, 1430, 1431, 1432, 1434, 1435, 1437, 1438, 1439, 1440, 1442, 1443, 1444, 1445, 1447, 1448, 1449, 1450, 1452, 1453, 1454, 1455, 1458, 1459, 1460, 1461, 1463, 1464, 1465, 1466, 1468, 1469, 1471, 1472, 1473, 1474, 1476, 1477, 1479, 1480, 1481, 1482, 1484, 1485, 1486, 1487, 1489, 1490, 1492, 1493, 1494, 1495, 1497, 1498, 1501, 1502, 1503, 1504, 1506, 1507, 1509, 1510, 1512, 1513, 1514, 1515, 1517, 1518, 1520, 1521, 1523, 1524, 1525, 1526, 1528, 1529, 1531, 1532, 1534, 1535, 1536, 1537, 1539, 1540, 1542, 1543, 1545, 1546, 1547, 1548, 1550, 1551, 1553, 1554, 1556, 1557, 1558, 1559, 1561, 1562, 1564, 1565, 1567, 1568, 1569, 1570, 1572, 1573, 1575, 1576, 1578, 1579, 1580, 1581, 1583, 1584, 1586, 1587, 1590, 1591, 1592, 1593, 1595, 1596, 1598, 1599, 1601, 1602, 1604, 1605, 1607, 1608, 1609, 1610, 1613, 1614, 1615, 1616, 1618, 1619, 1621, 1622, 1624, 1625, 1627, 1628, 1630, 1631, 1632, 1633, 1637, 1638, 1639, 1640, 1642, 1643, 1645, 1646, 1648, 1649, 1651, 1652, 1654, 1655, 1656, 1657, 1660, 1661, 1663, 1664, 1666, 1667, 1669, 1670, 1672, 1673, 1675, 1676, 1678, 1679, 1681, 1682, 1685, 1686, 1688, 1689, 1691, 1692, 1694, 1695, 1697, 1698, 1700, 1701, 1703, 1704, 1706, 1707, 1709, 1710, 1712, 1713, 1715, 1716, 1718, 1719, 1721, 1722, 1724, 1725, 1727, 1728, 1730, 1731, 1734, 1735, 1737, 1738, 1740, 1741, 1743, 1744, 1746, 1748, 1749, 1751, 1752, 1754, 1755, 1757, 1759, 1760, 1762, 1763, 1765, 1766, 1768, 1769, 1771, 1773, 1774, 1776, 1777, 1779, 1780, 1782, 1785, 1786, 1788, 1789, 1791, 1793, 1794, 1796, 1798, 1799, 1801, 1802, 1804, 1806, 1807, 1809, 1811, 1812, 1814, 1815, 1817, 1819, 1820, 1822, 1824, 1825, 1827, 1828, 1830, 1832, 1833, 1835, 1837, 1838, 1840, 1841, 1843, 1845, 1846, 1848, 1850, 1851, 1853, 1854, 1856, 1858, 1859, 1861, 1864, 1865, 1867, 1868, 1870, 1872, 1873, 1875, 1877, 1879, 1880, 1882, 1884, 1885, 1887, 1888, 1891, 1892, 1894, 1895, 1897, 1899, 1900, 1902, 1904, 1906, 1907, 1909, 1911, 1912, 1914, 1915, 1918, 1919, 1921, 1923, 1925, 1926, 1928, 1930, 1932, 1933, 1935, 1937, 1939, 1940, 1942, 1944, 1946, 1947, 1949, 1951, 1953, 1954, 1956, 1958, 1960, 1961, 1963, 1965, 1967, 1968, 1970, 1972, 1975, 1976, 1978, 1980, 1982, 1983, 1985, 1987, 1989, 1990, 1992, 1994, 1996, 1997, 1999, 2001, 2003, 2004, 2006, 2008, 2010, 2011, 2013, 2015, 2017, 2019, 2021, 2022, 2024, 2026, 2028, 2029, 2032, 2033, 2035, 2037, 2039, 2041, 2043, 2044, 2047, 2048, 2050, 2052, 2054, 2056, 2058, 2059, 2062, 2063, 2065, 2067, 2069, 2071, 2073, 2074, 2077, 2078, 2080, 2082, 2084, 2086, 2088, 2089, 2092, 2093, 2095, 2097, 2099, 2101, 2103, 2104, 2107, 2108, 2110, 2112, 2114, 2116, 2118, 2119, 2122, 2123, 2125, 2127, 2129, 2131, 2133, 2134, 2137, 2139, 2141, 2142, 2145, 2146, 2148, 2150, 2153, 2154, 2156, 2158, 2160, 2162, 2164, 2165, 2168, 2170, 2172, 2173, 2176, 2177, 2179, 2181, 2185, 2186, 2188, 2190, 2192, 2194, 2196, 2197, 2200, 2202, 2204, 2205, 2208, 2209, 2211, 2213, 2216, 2218, 2220, 2222, 2223, 2226, 2227, 2230, 2232, 2234, 2236, 2238, 2239, 2242, 2243, 2246, 2249, 2251, 2253, 2255, 2256, 2259, 2260, 2263, 2265, 2267, 2269, 2271, 2272, 2275, 2276, 2279, 2281, 2283, 2285, 2287, 2288, 2291, 2292, 2295, 2297, 2299, 2301, 2303, 2304, 2307, 2308, 2311, 2315, 2317, 2319, 2321, 2322, 2325, 2326, 2329, 2331, 2333, 2335, 2337, 2338, 2341, 2342, 2345, 2348, 2350, 2352, 2354, 2355, 2358, 2359, 2362, 2364, 2366, 2368, 2370, 2371, 2374, 2375, 2378, 2382, 2384, 2386, 2388, 2389, 2392, 2393, 2396, 2398, 2400, 2402, 2404, 2407, 2410, 2411, 2414, 2417, 2419, 2421, 2423, 2424, 2427, 2428, 2431, 2433, 2435, 2437, 2439, 2442, 2445, 2446, 2449, 2452, 2454, 2456, 2458, 2459, 2462, 2463, 2466, 2468, 2470, 2472, 2474, 2477, 2480, 2481, 2484, 2488, 2490, 2492, 2494, 2495, 2498, 2499, 2502, 2504, 2506, 2508, 2510, 2513, 2516, 2517, 2520, 2524, 2526, 2528, 2530, 2531, 2534, 2535, 2538, 2540, 2542, 2544, 2546, 2549, 2552, 2553, 2556, 2561, 2563, 2565, 2567, 2568, 2571, 2572, 2575, 2577, 2579, 2581, 2583, 2586, 2589, 2590, 2593};
    }

    private final class OscilRec {
        int phase;
        int freq;
        int DT1v;
        int MUL;
        int DT1;
        int DT2;
        int[] connect;
        int FeedBack;
        int FB;
        int FB0;
        int KC;
        int KCindex;
        int PMS;
        int AMS;
        int AMSmask;
        int state;
        int delta_AR;
        int TL;
        int volume;
        int delta_D1R;
        int D1L;
        int delta_D2R;
        int delta_RR;
        int key;
        int KS;
        int AR;
        int D1R;
        int D2R;
        int RR;

        private OscilRec() {
        }
    }
}

