/*
 * Decompiled with CFR 0.152.
 */
public final class Z80
implements Cpu {
    public int AF;
    public int BC;
    public int DE;
    public int HL;
    public int AF2;
    public int BC2;
    public int DE2;
    public int HL2;
    public int IX;
    public int IY;
    public int XY;
    public int PC;
    public int SP;
    public int IFF1;
    public int IFF2;
    public int IM;
    public int word;
    public int addr;
    private int I;
    private int R;
    private int vector;
    private int cyclesToDo;
    int NMIInt;
    int IRQ;
    private boolean intel8080 = false;
    private boolean running = false;
    private static final byte[] PF_Table = new byte[256];
    private int enable;
    private long frequency;
    private boolean halted = false;
    private final int NMI_PC;
    private Ports port;
    private Memory mem;
    private static final int[] cycles_main_opcode = new int[]{4, 10, 7, 6, 4, 4, 7, 4, 4, 11, 7, 6, 4, 4, 7, 4, 10, 10, 7, 6, 4, 4, 7, 4, 12, 11, 7, 6, 4, 4, 7, 4, 7, 10, 16, 6, 4, 4, 7, 4, 7, 11, 16, 6, 4, 4, 7, 4, 7, 10, 13, 6, 11, 11, 10, 4, 7, 11, 13, 6, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4, 5, 10, 10, 10, 10, 11, 7, 11, 5, 10, 10, 0, 10, 17, 7, 11, 5, 10, 10, 11, 10, 11, 7, 11, 5, 4, 10, 11, 10, 0, 7, 11, 5, 10, 10, 19, 10, 11, 7, 11, 5, 4, 10, 4, 10, 0, 7, 11, 5, 10, 10, 4, 10, 11, 7, 11, 5, 6, 10, 4, 10, 0, 7, 11};
    private static final int[] cycles_ed_opcode = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 12, 15, 20, 8, 8, 8, 9, 12, 12, 15, 20, 8, 8, 8, 9, 12, 12, 15, 20, 8, 8, 8, 9, 12, 12, 15, 20, 8, 8, 8, 9, 12, 12, 15, 20, 8, 8, 8, 18, 12, 12, 15, 20, 8, 8, 8, 18, 12, 12, 15, 20, 8, 8, 8, 8, 12, 12, 15, 20, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 16, 16, 8, 8, 8, 8, 16, 16, 16, 16, 8, 8, 8, 8, 16, 16, 16, 16, 8, 8, 8, 8, 16, 16, 16, 16, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] cycles_dd_opcode = new int[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 15, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 15, 4, 4, 4, 4, 4, 4, 4, 14, 20, 10, 8, 8, 11, 4, 4, 15, 20, 10, 8, 8, 11, 4, 4, 4, 4, 4, 23, 23, 19, 4, 4, 15, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 8, 8, 8, 8, 8, 8, 19, 8, 8, 8, 8, 8, 8, 8, 19, 8, 19, 19, 19, 19, 19, 19, 4, 19, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 8, 8, 19, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
    private static final int[] cycles_cb_opcode = new int[]{8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 12, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8, 8, 8, 8, 8, 8, 8, 15, 8};
    private static final int[] cycles_xx_cb_opcode = new int[]{23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23};
    private static final int[] DAATable2 = new int[]{68, 256, 512, 772, 1024, 1284, 1540, 1792, 2056, 2316, 4112, 4372, 4628, 4880, 5140, 5392, 4096, 4356, 4612, 4864, 5124, 5376, 5632, 5892, 6156, 6408, 8240, 8500, 8756, 9008, 9268, 9520, 8224, 8484, 8740, 8992, 9252, 9504, 9760, 10020, 10284, 10536, 12340, 12592, 12848, 13108, 13360, 13620, 12324, 12576, 12832, 13092, 13344, 13604, 13860, 14112, 14376, 14636, 16400, 16660, 16916, 17168, 17428, 17680, 16384, 16644, 16900, 17152, 17412, 17664, 17920, 18180, 18444, 18696, 20500, 20752, 21008, 21268, 21520, 21780, 20484, 20736, 20992, 21252, 21504, 21764, 22020, 22272, 22536, 22796, 24628, 24880, 25136, 25396, 25648, 25908, 24612, 24864, 25120, 25380, 25632, 25892, 26148, 26400, 26664, 26924, 28720, 28980, 29236, 29488, 29748, 30000, 28704, 28964, 29220, 29472, 29732, 29984, 30240, 30500, 30764, 31016, 32912, 33172, 33428, 33680, 33940, 34192, 32896, 33156, 33412, 33664, 33924, 34176, 34432, 34692, 34956, 35208, 37012, 37264, 37520, 37780, 38032, 38292, 36996, 37248, 37504, 37764, 38016, 38276, 38532, 38784, 39048, 39308, 85, 273, 529, 789, 1041, 1301, 69, 257, 513, 773, 1025, 1285, 1541, 1793, 2057, 2317, 4113, 4373, 4629, 4881, 5141, 5393, 4097, 4357, 4613, 4865, 5125, 5377, 5633, 5893, 6157, 6409, 8241, 8501, 8757, 9009, 9269, 9521, 8225, 8485, 8741, 8993, 9253, 9505, 9761, 10021, 10285, 10537, 12341, 12593, 12849, 13109, 13361, 13621, 12325, 12577, 12833, 13093, 13345, 13605, 13861, 14113, 14377, 14637, 16401, 16661, 16917, 17169, 17429, 17681, 16385, 16645, 16901, 17153, 17413, 17665, 17921, 18181, 18445, 18697, 20501, 20753, 21009, 21269, 21521, 21781, 20485, 20737, 20993, 21253, 21505, 21765, 22021, 22273, 22537, 22797, 24629, 24881, 25137, 25397, 25649, 25909, 24613, 24865, 25121, 25381, 25633, 25893, 26149, 26401, 26665, 26925, 28721, 28981, 29237, 29489, 29749, 30001, 28705, 28965, 29221, 29473, 29733, 29985, 30241, 30501, 30765, 31017, 32913, 33173, 33429, 33681, 33941, 34193, 32897, 33157, 33413, 33665, 33925, 34177, 34433, 34693, 34957, 35209, 37013, 37265, 37521, 37781, 38033, 38293, 36997, 37249, 37505, 37765, 38017, 38277, 38533, 38785, 39049, 39309, 41141, 41393, 41649, 41909, 42161, 42421, 41125, 41377, 41633, 41893, 42145, 42405, 42661, 42913, 43177, 43437, 45233, 45493, 45749, 46001, 46261, 46513, 45217, 45477, 45733, 45985, 46245, 46497, 46753, 47013, 47277, 47529, 49301, 49553, 49809, 50069, 50321, 50581, 49285, 49537, 49793, 50053, 50305, 50565, 50821, 51073, 51337, 51597, 53393, 53653, 53909, 54161, 54421, 54673, 53377, 53637, 53893, 54145, 54405, 54657, 54913, 55173, 55437, 55689, 57521, 57781, 58037, 58289, 58549, 58801, 57505, 57765, 58021, 58273, 58533, 58785, 59041, 59301, 59565, 59817, 61621, 61873, 62129, 62389, 62641, 62901, 61605, 61857, 62113, 62373, 62625, 62885, 63141, 63393, 63657, 63917, 85, 273, 529, 789, 1041, 1301, 69, 257, 513, 773, 1025, 1285, 1541, 1793, 2057, 2317, 4113, 4373, 4629, 4881, 5141, 5393, 4097, 4357, 4613, 4865, 5125, 5377, 5633, 5893, 6157, 6409, 8241, 8501, 8757, 9009, 9269, 9521, 8225, 8485, 8741, 8993, 9253, 9505, 9761, 10021, 10285, 10537, 12341, 12593, 12849, 13109, 13361, 13621, 12325, 12577, 12833, 13093, 13345, 13605, 13861, 14113, 14377, 14637, 16401, 16661, 16917, 17169, 17429, 17681, 16385, 16645, 16901, 17153, 17413, 17665, 17921, 18181, 18445, 18697, 20501, 20753, 21009, 21269, 21521, 21781, 20485, 20737, 20993, 21253, 21505, 21765, 22021, 22273, 22537, 22797, 24629, 24881, 25137, 25397, 25649, 25909, 1540, 1792, 2056, 2316, 2572, 2824, 3084, 3336, 3592, 3852, 4112, 4372, 4628, 4880, 5140, 5392, 5632, 5892, 6156, 6408, 6664, 6924, 7176, 7436, 7692, 7944, 8240, 8500, 8756, 9008, 9268, 9520, 9760, 10020, 10284, 10536, 10792, 11052, 11304, 11564, 11820, 12072, 12340, 12592, 12848, 13108, 13360, 13620, 13860, 14112, 14376, 14636, 14892, 15144, 15404, 15656, 15912, 16172, 16400, 16660, 16916, 17168, 17428, 17680, 17920, 18180, 18444, 18696, 18952, 19212, 19464, 19724, 19980, 20232, 20500, 20752, 21008, 21268, 21520, 21780, 22020, 22272, 22536, 22796, 23052, 23304, 23564, 23816, 24072, 24332, 24628, 24880, 25136, 25396, 25648, 25908, 26148, 26400, 26664, 26924, 27180, 27432, 27692, 27944, 28200, 28460, 28720, 28980, 29236, 29488, 29748, 30000, 30240, 30500, 30764, 31016, 31272, 31532, 31784, 32044, 32300, 32552, 32912, 33172, 33428, 33680, 33940, 34192, 34432, 34692, 34956, 35208, 35464, 35724, 35976, 36236, 36492, 36744, 37012, 37264, 37520, 37780, 38032, 38292, 38532, 38784, 39048, 39308, 39564, 39816, 40076, 40328, 40584, 40844, 85, 273, 529, 789, 1041, 1301, 1541, 1793, 2057, 2317, 2573, 2825, 3085, 3337, 3593, 3853, 4113, 4373, 4629, 4881, 5141, 5393, 5633, 5893, 6157, 6409, 6665, 6925, 7177, 7437, 7693, 7945, 8241, 8501, 8757, 9009, 9269, 9521, 9761, 10021, 10285, 10537, 10793, 11053, 11305, 11565, 11821, 12073, 12341, 12593, 12849, 13109, 13361, 13621, 13861, 14113, 14377, 14637, 14893, 15145, 15405, 15657, 15913, 16173, 16401, 16661, 16917, 17169, 17429, 17681, 17921, 18181, 18445, 18697, 18953, 19213, 19465, 19725, 19981, 20233, 20501, 20753, 21009, 21269, 21521, 21781, 22021, 22273, 22537, 22797, 23053, 23305, 23565, 23817, 24073, 24333, 24629, 24881, 25137, 25397, 25649, 25909, 26149, 26401, 26665, 26925, 27181, 27433, 27693, 27945, 28201, 28461, 28721, 28981, 29237, 29489, 29749, 30001, 30241, 30501, 30765, 31017, 31273, 31533, 31785, 32045, 32301, 32553, 32913, 33173, 33429, 33681, 33941, 34193, 34433, 34693, 34957, 35209, 35465, 35725, 35977, 36237, 36493, 36745, 37013, 37265, 37521, 37781, 38033, 38293, 38533, 38785, 39049, 39309, 39565, 39817, 40077, 40329, 40585, 40845, 41141, 41393, 41649, 41909, 42161, 42421, 42661, 42913, 43177, 43437, 43693, 43945, 44205, 44457, 44713, 44973, 45233, 45493, 45749, 46001, 46261, 46513, 46753, 47013, 47277, 47529, 47785, 48045, 48297, 48557, 48813, 49065, 49301, 49553, 49809, 50069, 50321, 50581, 50821, 51073, 51337, 51597, 51853, 52105, 52365, 52617, 52873, 53133, 53393, 53653, 53909, 54161, 54421, 54673, 54913, 55173, 55437, 55689, 55945, 56205, 56457, 56717, 56973, 57225, 57521, 57781, 58037, 58289, 58549, 58801, 59041, 59301, 59565, 59817, 60073, 60333, 60585, 60845, 61101, 61353, 61621, 61873, 62129, 62389, 62641, 62901, 63141, 63393, 63657, 63917, 64173, 64425, 64685, 64937, 65193, 65453, 85, 273, 529, 789, 1041, 1301, 1541, 1793, 2057, 2317, 2573, 2825, 3085, 3337, 3593, 3853, 4113, 4373, 4629, 4881, 5141, 5393, 5633, 5893, 6157, 6409, 6665, 6925, 7177, 7437, 7693, 7945, 8241, 8501, 8757, 9009, 9269, 9521, 9761, 10021, 10285, 10537, 10793, 11053, 11305, 11565, 11821, 12073, 12341, 12593, 12849, 13109, 13361, 13621, 13861, 14113, 14377, 14637, 14893, 15145, 15405, 15657, 15913, 16173, 16401, 16661, 16917, 17169, 17429, 17681, 17921, 18181, 18445, 18697, 18953, 19213, 19465, 19725, 19981, 20233, 20501, 20753, 21009, 21269, 21521, 21781, 22021, 22273, 22537, 22797, 23053, 23305, 23565, 23817, 24073, 24333, 24629, 24881, 25137, 25397, 25649, 25909, 70, 258, 514, 774, 1026, 1286, 1542, 1794, 2058, 2318, 1026, 1286, 1542, 1794, 2058, 2318, 4098, 4358, 4614, 4866, 5126, 5378, 5634, 5894, 6158, 6410, 5126, 5378, 5634, 5894, 6158, 6410, 8226, 8486, 8742, 8994, 9254, 9506, 9762, 10022, 10286, 10538, 9254, 9506, 9762, 10022, 10286, 10538, 12326, 12578, 12834, 13094, 13346, 13606, 13862, 14114, 14378, 14638, 13346, 13606, 13862, 14114, 14378, 14638, 16386, 16646, 16902, 17154, 17414, 17666, 17922, 18182, 18446, 18698, 17414, 17666, 17922, 18182, 18446, 18698, 20486, 20738, 20994, 21254, 21506, 21766, 22022, 22274, 22538, 22798, 21506, 21766, 22022, 22274, 22538, 22798, 24614, 24866, 25122, 25382, 25634, 25894, 26150, 26402, 26666, 26926, 25634, 25894, 26150, 26402, 26666, 26926, 28706, 28966, 29222, 29474, 29734, 29986, 30242, 30502, 30766, 31018, 29734, 29986, 30242, 30502, 30766, 31018, 32898, 33158, 33414, 33666, 33926, 34178, 34434, 34694, 34958, 35210, 33926, 34178, 34434, 34694, 34958, 35210, 36998, 37250, 37506, 37766, 38018, 38278, 38534, 38786, 39050, 39310, 13347, 13607, 13863, 14115, 14379, 14639, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 17415, 17667, 17923, 18183, 18447, 18699, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 21507, 21767, 22023, 22275, 22539, 22799, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 25635, 25895, 26151, 26403, 26667, 26927, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 29735, 29987, 30243, 30503, 30767, 31019, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 33927, 34179, 34435, 34695, 34959, 35211, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 38019, 38279, 38535, 38787, 39051, 39311, 41127, 41379, 41635, 41895, 42147, 42407, 42663, 42915, 43179, 43439, 42147, 42407, 42663, 42915, 43179, 43439, 45219, 45479, 45735, 45987, 46247, 46499, 46755, 47015, 47279, 47531, 46247, 46499, 46755, 47015, 47279, 47531, 49287, 49539, 49795, 50055, 50307, 50567, 50823, 51075, 51339, 51599, 50307, 50567, 50823, 51075, 51339, 51599, 53379, 53639, 53895, 54147, 54407, 54659, 54915, 55175, 55439, 55691, 54407, 54659, 54915, 55175, 55439, 55691, 57507, 57767, 58023, 58275, 58535, 58787, 59043, 59303, 59567, 59819, 58535, 58787, 59043, 59303, 59567, 59819, 61607, 61859, 62115, 62375, 62627, 62887, 63143, 63395, 63659, 63919, 62627, 62887, 63143, 63395, 63659, 63919, 71, 259, 515, 775, 1027, 1287, 1543, 1795, 2059, 2319, 1027, 1287, 1543, 1795, 2059, 2319, 4099, 4359, 4615, 4867, 5127, 5379, 5635, 5895, 6159, 6411, 5127, 5379, 5635, 5895, 6159, 6411, 8227, 8487, 8743, 8995, 9255, 9507, 9763, 10023, 10287, 10539, 9255, 9507, 9763, 10023, 10287, 10539, 12327, 12579, 12835, 13095, 13347, 13607, 13863, 14115, 14379, 14639, 13347, 13607, 13863, 14115, 14379, 14639, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 17415, 17667, 17923, 18183, 18447, 18699, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 21507, 21767, 22023, 22275, 22539, 22799, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 25635, 25895, 26151, 26403, 26667, 26927, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 29735, 29987, 30243, 30503, 30767, 31019, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 33927, 34179, 34435, 34695, 34959, 35211, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 38019, 38279, 38535, 38787, 39051, 39311, 64190, 64442, 64702, 64954, 65210, 65470, 70, 258, 514, 774, 1026, 1286, 1542, 1794, 2058, 2318, 2590, 2842, 3102, 3354, 3610, 3870, 4098, 4358, 4614, 4866, 5126, 5378, 5634, 5894, 6158, 6410, 6682, 6942, 7194, 7454, 7710, 7962, 8226, 8486, 8742, 8994, 9254, 9506, 9762, 10022, 10286, 10538, 10810, 11070, 11322, 11582, 11838, 12090, 12326, 12578, 12834, 13094, 13346, 13606, 13862, 14114, 14378, 14638, 14910, 15162, 15422, 15674, 15930, 16190, 16386, 16646, 16902, 17154, 17414, 17666, 17922, 18182, 18446, 18698, 18970, 19230, 19482, 19742, 19998, 20250, 20486, 20738, 20994, 21254, 21506, 21766, 22022, 22274, 22538, 22798, 23070, 23322, 23582, 23834, 24090, 24350, 24614, 24866, 25122, 25382, 25634, 25894, 26150, 26402, 26666, 26926, 27198, 27450, 27710, 27962, 28218, 28478, 28706, 28966, 29222, 29474, 29734, 29986, 30242, 30502, 30766, 31018, 31290, 31550, 31802, 32062, 32318, 32570, 32898, 33158, 33414, 33666, 33926, 34178, 34434, 34694, 34958, 35210, 35482, 35742, 35994, 36254, 36510, 36762, 36998, 37250, 37506, 37766, 13347, 13607, 13863, 14115, 14379, 14639, 14911, 15163, 15423, 15675, 15931, 16191, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 18971, 19231, 19483, 19743, 19999, 20251, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 23071, 23323, 23583, 23835, 24091, 24351, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 27199, 27451, 27711, 27963, 28219, 28479, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 31291, 31551, 31803, 32063, 32319, 32571, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 35483, 35743, 35995, 36255, 36511, 36763, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311, 39583, 39835, 40095, 40347, 40603, 40863, 41127, 41379, 41635, 41895, 42147, 42407, 42663, 42915, 43179, 43439, 43711, 43963, 44223, 44475, 44731, 44991, 45219, 45479, 45735, 45987, 46247, 46499, 46755, 47015, 47279, 47531, 47803, 48063, 48315, 48575, 48831, 49083, 49287, 49539, 49795, 50055, 50307, 50567, 50823, 51075, 51339, 51599, 51871, 52123, 52383, 52635, 52891, 53151, 53379, 53639, 53895, 54147, 54407, 54659, 54915, 55175, 55439, 55691, 55963, 56223, 56475, 56735, 56991, 57243, 57507, 57767, 58023, 58275, 58535, 58787, 59043, 59303, 59567, 59819, 60091, 60351, 60603, 60863, 61119, 61371, 61607, 61859, 62115, 62375, 62627, 62887, 63143, 63395, 63659, 63919, 64191, 64443, 64703, 64955, 65211, 65471, 71, 259, 515, 775, 1027, 1287, 1543, 1795, 2059, 2319, 2591, 2843, 3103, 3355, 3611, 3871, 4099, 4359, 4615, 4867, 5127, 5379, 5635, 5895, 6159, 6411, 6683, 6943, 7195, 7455, 7711, 7963, 8227, 8487, 8743, 8995, 9255, 9507, 9763, 10023, 10287, 10539, 10811, 11071, 11323, 11583, 11839, 12091, 12327, 12579, 12835, 13095, 13347, 13607, 13863, 14115, 14379, 14639, 14911, 15163, 15423, 15675, 15931, 16191, 16387, 16647, 16903, 17155, 17415, 17667, 17923, 18183, 18447, 18699, 18971, 19231, 19483, 19743, 19999, 20251, 20487, 20739, 20995, 21255, 21507, 21767, 22023, 22275, 22539, 22799, 23071, 23323, 23583, 23835, 24091, 24351, 24615, 24867, 25123, 25383, 25635, 25895, 26151, 26403, 26667, 26927, 27199, 27451, 27711, 27963, 28219, 28479, 28707, 28967, 29223, 29475, 29735, 29987, 30243, 30503, 30767, 31019, 31291, 31551, 31803, 32063, 32319, 32571, 32899, 33159, 33415, 33667, 33927, 34179, 34435, 34695, 34959, 35211, 35483, 35743, 35995, 36255, 36511, 36763, 36999, 37251, 37507, 37767, 38019, 38279, 38535, 38787, 39051, 39311};

    public void setPorts(Ports ports) {
        this.port = ports;
    }

    Z80(Memory memory, Ports ports, boolean bl) {
        this.mem = memory;
        this.port = ports;
        this.frequency = this.frequency;
        this.intel8080 = bl;
        this.NMI_PC = bl ? 16 : 102;
        this.PF_Table_init();
        this.reset();
        this.start();
    }

    public final void start() {
        this.running = true;
    }

    public final void stop() {
        this.running = false;
    }

    public final void reset() {
        this.PC = 0;
        this.SP = 65535;
        this.AF = 64;
        this.HL2 = 0;
        this.DE2 = 0;
        this.BC2 = 0;
        this.HL = 0;
        this.DE = 0;
        this.BC = 0;
        this.AF2 = 0;
        this.NMIInt = 0;
        this.IRQ = 0;
        this.vector = 0;
        this.IM = 0;
        this.IFF2 = 0;
        this.IFF1 = 0;
        this.R = 0;
        this.I = 0;
        this.XY = 65535;
        this.IY = 65535;
        this.IX = 65535;
        this.enable = 0;
        this.cyclesToDo = 0;
    }

    private final void UpdateR() {
        this.R = this.R & 0x80 | this.R + 1 & 0x7F;
    }

    private final void memWriteByte(int n, int n2) {
        this.mem.writeByte(n, n2);
    }

    private final int memReadByte(int n) {
        return this.mem.readByte(n);
    }

    private final void ioWriteByte(int n, int n2) {
        this.port.out(n, n2);
    }

    private final int ioReadByte(int n) {
        return this.port.in(n);
    }

    private final void memWriteWord(int n, int n2) {
        this.memWriteByte(n, n2 & 0xFF);
        this.memWriteByte(n + 1, (n2 & 0xFF00) >> 8);
    }

    private final int memReadWord(int n) {
        return this.memReadByte(n) | this.memReadByte(n + 1) << 8;
    }

    private final void setA(int n) {
        this.AF = this.AF & 0xFF | (n & 0xFF) << 8;
    }

    private final void setF(int n) {
        this.AF = this.AF & 0xFF00 | n & 0xFF;
    }

    private final void setB(int n) {
        this.BC = this.BC & 0xFF | (n & 0xFF) << 8;
    }

    private final void setC(int n) {
        this.BC = this.BC & 0xFF00 | n & 0xFF;
    }

    private final void setD(int n) {
        this.DE = this.DE & 0xFF | (n & 0xFF) << 8;
    }

    private final void setE(int n) {
        this.DE = this.DE & 0xFF00 | n & 0xFF;
    }

    private final void setH(int n) {
        this.HL = this.HL & 0xFF | (n & 0xFF) << 8;
    }

    private final void setL(int n) {
        this.HL = this.HL & 0xFF00 | n & 0xFF;
    }

    private final void setIXL(int n) {
        this.IX = this.IX & 0xFF00 | n & 0xFF;
    }

    private final void setIXH(int n) {
        this.IX = this.IX & 0xFF | (n & 0xFF) << 8;
    }

    private final void setIYL(int n) {
        this.IY = this.IY & 0xFF00 | n & 0xFF;
    }

    private final void setIYH(int n) {
        this.IY = this.IY & 0xFF | (n & 0xFF) << 8;
    }

    private final void setXYL(int n) {
        this.XY = this.XY & 0xFF00 | n & 0xFF;
    }

    private final void setXYH(int n) {
        this.XY = this.XY & 0xFF | (n & 0xFF) << 8;
    }

    private final int getA() {
        return this.AF >> 8 & 0xFF;
    }

    private final int getB() {
        return this.BC >> 8 & 0xFF;
    }

    private final int getC() {
        return this.BC & 0xFF;
    }

    private final int getD() {
        return this.DE >> 8 & 0xFF;
    }

    private final int getE() {
        return this.DE & 0xFF;
    }

    private final int getH() {
        return this.HL >> 8 & 0xFF;
    }

    private final int getL() {
        return this.HL & 0xFF;
    }

    private final int getIXH() {
        return this.IX >> 8 & 0xFF;
    }

    private final int getIXL() {
        return this.IX & 0xFF;
    }

    private final int getIYH() {
        return this.IY >> 8 & 0xFF;
    }

    private final int getIYL() {
        return this.IY & 0xFF;
    }

    private final int getXYH() {
        return this.XY >> 8 & 0xFF;
    }

    private final int getXYL() {
        return this.XY & 0xFF;
    }

    private final void decB() {
        this.setB(this.getB() - 1 & 0xFF);
    }

    private final void ClearCF() {
        this.AF &= 0xFFFE;
    }

    private final void ClearNF() {
        this.AF &= 0xFFFD;
    }

    private final void ClearVF() {
        this.AF &= 0xFFFB;
    }

    private final void ClearHF() {
        this.AF &= 0xFFEF;
    }

    private final void ClearZF() {
        this.AF &= 0xFFBF;
    }

    private final void ClearSF() {
        this.AF &= 0xFF7F;
    }

    private final void SetCF() {
        this.AF |= 1;
    }

    private final void SetNF() {
        this.AF |= 2;
    }

    private final void SetVF() {
        this.AF |= 4;
    }

    private final void SetHF() {
        this.AF |= 0x10;
    }

    private final void SetZF() {
        this.AF |= 0x40;
    }

    private final void SetSF() {
        this.AF |= 0x80;
    }

    private final void YF_XF_FLAGS(int n) {
        this.AF = (n & 8) != 0 ? (this.AF |= 8) : (this.AF &= 0xFFF7);
        this.AF = (n & 0x20) != 0 ? (this.AF |= 0x20) : (this.AF &= 0xFFDF);
    }

    private final void PARI_FLAG(int n) {
        if (PF_Table[n & 0xFF] != 0) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
    }

    private final void SIGN_FLAG(int n, int n2) {
        if ((n & 1 << n2 - 1) != 0) {
            this.SetSF();
        } else {
            this.ClearSF();
        }
    }

    private final void ZERO_FLAG(int n) {
        if (n == 0) {
            this.SetZF();
        } else {
            this.ClearZF();
        }
    }

    private final void HC_FLAG(int n, int n2, int n3) {
        if (((n ^ n2 ^ n3) & 0x10) != 0) {
            this.SetHF();
        } else {
            this.ClearHF();
        }
    }

    private final void CARRY_FLAG(long l, int n) {
        if ((l & (long)(1 << n)) != 0L) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
    }

    private final void OVER_FLAG(int n, int n2, long l, int n3) {
        if (((long)(n2 ^ n ^ 0x80) & ((long)n2 ^ l) & (long)(1 << n3 - 1)) >> 5 != 0L) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
    }

    private final void OVER_FLAG2(int n, int n2, long l, int n3) {
        if (((long)(n2 ^ n) & ((long)n ^ l) & (long)(1 << n3 - 1)) >> 5 != 0L) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
    }

    private final void ADD(int n) {
        int n2 = this.getA() + n;
        this.CARRY_FLAG(n2, 8);
        this.OVER_FLAG(n, this.getA(), n2, 8);
        this.HC_FLAG(n, this.getA(), n2);
        this.setA(n2 &= 0xFF);
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.ClearNF();
    }

    private final void ADC(int n) {
        int n2 = this.getA() + n + (this.AF & 1);
        this.CARRY_FLAG(n2, 8);
        this.OVER_FLAG(n, this.getA(), n2, 8);
        this.HC_FLAG(n, this.getA(), n2);
        this.setA(n2 &= 0xFF);
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.ClearNF();
    }

    private final void SBC(int n) {
        int n2 = this.getA() - n - (this.AF & 1);
        this.CARRY_FLAG(n2, 8);
        this.OVER_FLAG2(n, this.getA(), n2, 8);
        this.HC_FLAG(n, this.getA(), n2);
        this.setA(n2 &= 0xFF);
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.SetNF();
    }

    private final int INC(int n) {
        int n2 = n + 1;
        this.OVER_FLAG(n, 1, n2, 8);
        this.HC_FLAG(n, 1, n2);
        n = n2 & 0xFF;
        this.SIGN_FLAG(n, 8);
        this.ZERO_FLAG(n);
        this.ClearNF();
        return n;
    }

    private final int DEC(int n) {
        int n2 = n - 1;
        this.OVER_FLAG2(n, 1, n2, 8);
        this.HC_FLAG(n, 1, n2);
        n = n2 & 0xFF;
        this.SIGN_FLAG(n, 8);
        this.ZERO_FLAG(n);
        this.SetNF();
        return n;
    }

    private final int SUB8(int n, int n2) {
        int n3 = n - n2;
        this.CARRY_FLAG(n3, 8);
        this.OVER_FLAG2(n, n2, n3, 8);
        this.HC_FLAG(n, n2, n3);
        n = n3 & 0xFF;
        this.SIGN_FLAG(n, 8);
        this.ZERO_FLAG(n);
        this.SetNF();
        return n;
    }

    private final void SUB(int n) {
        this.setA(this.SUB8(this.getA(), n & 0xFF));
    }

    private final void AND(int n) {
        this.setA(this.getA() & (n & 0xFF));
        int n2 = this.getA();
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.PARI_FLAG(n2);
        this.SetHF();
        this.ClearNF();
        this.ClearCF();
    }

    private final void XOR(int n) {
        this.setA(this.getA() ^ n & 0xFF);
        int n2 = this.getA();
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.PARI_FLAG(n2);
        this.ClearHF();
        this.ClearNF();
        this.ClearCF();
    }

    private final void OR(int n) {
        this.setA(this.getA() | n & 0xFF);
        int n2 = this.getA();
        this.SIGN_FLAG(n2, 8);
        this.ZERO_FLAG(n2);
        this.PARI_FLAG(n2);
        this.ClearHF();
        this.ClearNF();
        this.ClearCF();
    }

    private final void CP(int n) {
        this.SUB8(this.getA(), n);
    }

    private final void DAA() {
        int n = this.getA();
        if ((this.AF & 1) != 0) {
            n |= 0x100;
        }
        if ((this.AF & 0x10) != 0) {
            n |= 0x200;
        }
        if ((this.AF & 2) != 0) {
            n |= 0x400;
        }
        this.AF = DAATable2[n];
    }

    private final void CPL() {
        this.setA(~this.getA());
        this.SetHF();
        this.SetNF();
        this.YF_XF_FLAGS(this.getA());
    }

    private final void EXX() {
        this.word = this.BC;
        this.BC = this.BC2;
        this.BC2 = this.word;
        this.word = this.DE;
        this.DE = this.DE2;
        this.DE2 = this.word;
        this.word = this.HL;
        this.HL = this.HL2;
        this.HL2 = this.word;
    }

    private final void SCF() {
        this.ClearHF();
        this.ClearNF();
        this.SetCF();
        this.YF_XF_FLAGS(this.getA());
    }

    private final void NEG() {
        int n = this.getA();
        this.setA(0);
        this.SUB(n);
    }

    private final void CCF() {
        this.ClearNF();
        if ((this.AF & 1) != 0) {
            this.SetHF();
            this.ClearCF();
        } else {
            this.ClearHF();
            this.SetCF();
        }
        this.YF_XF_FLAGS(this.getA());
    }

    private final void PUSH(int n) {
        this.SP -= 2;
        this.SP &= 0xFFFF;
        this.memWriteWord(this.SP, n & 0xFFFF);
    }

    private final int POP() {
        int n = this.memReadWord(this.SP);
        this.SP += 2;
        this.SP &= 0xFFFF;
        return n &= 0xFFFF;
    }

    private final void RST(int n) {
        this.PUSH(this.PC);
        this.PC = n;
    }

    private final void RET() {
        this.PC = this.memReadWord(this.SP);
        this.SP += 2;
        this.SP &= 0xFFFF;
    }

    private final void CALL() {
        this.SP -= 2;
        this.SP &= 0xFFFF;
        this.memWriteWord(this.SP, this.PC + 2);
        this.PC = this.memReadWord(this.PC);
    }

    private final int ADD16(int n, int n2) {
        this.ClearNF();
        int n3 = n + n2;
        if (((n2 ^ n ^ n3) & 0x1000) != 0) {
            this.SetHF();
        } else {
            this.ClearHF();
        }
        this.CARRY_FLAG(n3, 16);
        this.YF_XF_FLAGS(n3 >> 8);
        return n3 & 0xFFFF;
    }

    private final void SBC_HL(int n) {
        this.ClearHF();
        this.SetNF();
        int n2 = this.HL - n - (this.AF & 1);
        this.CARRY_FLAG(n2, 16);
        this.OVER_FLAG2(n, this.HL, n2, 16);
        this.HL = n2 & 0xFFFF;
        this.ZERO_FLAG(this.HL);
        this.SIGN_FLAG(this.HL, 16);
        this.YF_XF_FLAGS(this.HL >> 8);
    }

    private final void ADC_HL(int n) {
        this.ClearNF();
        int n2 = this.HL + n + (this.AF & 1);
        this.CARRY_FLAG(n2, 16);
        this.OVER_FLAG(n, this.HL, n2, 16);
        if (((this.HL ^ n ^ n2) & 0x1000) != 0) {
            this.SetHF();
        } else {
            this.ClearHF();
        }
        this.HL = n2 & 0xFFFF;
        this.ZERO_FLAG(this.HL);
        this.SIGN_FLAG(this.HL, 16);
        this.YF_XF_FLAGS(this.HL >> 8);
    }

    private final int RR(int n) {
        int n2;
        int n3 = n2 = n & 0xFF;
        n3 = (n3 >> 1 | (this.AF & 1) << 7) & 0xFF;
        this.ZERO_FLAG(n3);
        this.SIGN_FLAG(n3, 8);
        this.PARI_FLAG(n3);
        if ((n2 & 1) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n3;
    }

    private final int RL(int n) {
        int n2;
        int n3 = n2 = n & 0xFF;
        n3 = (n3 << 1 | this.AF & 1) & 0xFF;
        this.ZERO_FLAG(n3);
        this.SIGN_FLAG(n3, 8);
        this.PARI_FLAG(n3);
        if ((n2 & 0x80) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n3;
    }

    private final int RRC(int n) {
        int n2;
        int n3 = n2 = n & 0xFF;
        n3 = n3 >> 1 & 0x7F | n3 << 7 & 0x80;
        this.ZERO_FLAG(n3);
        this.SIGN_FLAG(n3, 8);
        this.PARI_FLAG(n3);
        if ((n2 & 1) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n3 & 0xFF;
    }

    private final int RLC(int n) {
        int n2;
        int n3 = n2 = n & 0xFF;
        n3 = n3 << 1 & 0xFE | n3 >> 7 & 1;
        this.ZERO_FLAG(n3);
        this.SIGN_FLAG(n3, 8);
        this.PARI_FLAG(n3);
        if ((n2 & 0x80) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n3;
    }

    private final void RRA() {
        this.setA(this.RR(this.getA()));
    }

    private final void RLA() {
        this.setA(this.RL(this.getA()));
    }

    private final void RRCA() {
        this.setA(this.RRC(this.getA()));
    }

    private final void RLCA() {
        this.setA(this.RLC(this.getA()));
    }

    private final void RLD() {
        int n = this.memReadByte(this.HL);
        int n2 = this.getA();
        int n3 = n2 & 0xF0 | n >> 4;
        int n4 = n << 4 & 0xF0 | n2 & 0xF;
        this.setA(n3 &= 0xFF);
        this.memWriteByte(this.HL, n4 &= 0xFF);
        this.SIGN_FLAG(n3, 8);
        this.ZERO_FLAG(n3);
        this.PARI_FLAG(n3);
        this.ClearHF();
        this.ClearNF();
    }

    private final void RRD() {
        int n = this.memReadByte(this.HL);
        int n2 = this.getA();
        int n3 = n2 & 0xF0 | n & 0xF;
        int n4 = (n2 & 0xF) << 4 | n >> 4 & 0xF;
        this.setA(n3 &= 0xFF);
        this.memWriteByte(this.HL, n4 &= 0xFF);
        this.SIGN_FLAG(n3, 8);
        this.ZERO_FLAG(n3);
        this.PARI_FLAG(n3);
        this.ClearHF();
        this.ClearNF();
    }

    private final int IN() {
        int n = this.ioReadByte(this.BC);
        this.ClearHF();
        this.ClearNF();
        this.SIGN_FLAG(n, 8);
        this.ZERO_FLAG(n);
        this.PARI_FLAG(n);
        this.YF_XF_FLAGS(n);
        return n;
    }

    private final void INI() {
        int n = this.ioReadByte(this.BC) & 0xFF;
        this.memWriteByte(this.HL, n);
        ++this.HL;
        this.HL &= 0xFFFF;
        this.decB();
        this.SIGN_FLAG(this.getB(), 8);
        this.ZERO_FLAG(this.getB());
        if ((n & 0x80) != 0) {
            this.SetNF();
        } else {
            this.ClearNF();
        }
    }

    private final void IND() {
        int n = this.ioReadByte(this.BC) & 0xFF;
        this.memWriteByte(this.HL, n);
        --this.HL;
        this.HL &= 0xFFFF;
        this.decB();
        this.SIGN_FLAG(this.getB(), 8);
        this.ZERO_FLAG(this.getB());
        if ((n & 0x80) != 0) {
            this.SetNF();
        } else {
            this.ClearNF();
        }
    }

    private final void INIR() {
        this.INI();
        if (this.getB() != 0) {
            this.PC -= 2;
        }
    }

    private final void INDR() {
        this.IND();
        if (this.getB() != 0) {
            this.PC -= 2;
        }
    }

    private final void OUTI() {
        int n = this.memReadByte(this.HL);
        this.ioWriteByte(this.BC, n);
        ++this.HL;
        this.HL &= 0xFFFF;
        this.decB();
        this.SIGN_FLAG(this.getB(), 8);
        this.ZERO_FLAG(this.getB());
        if ((n & 0x80) != 0) {
            this.SetNF();
        } else {
            this.ClearNF();
        }
    }

    private final void OUTD() {
        int n = this.memReadByte(this.HL);
        this.ioWriteByte(this.BC, n);
        --this.HL;
        this.HL &= 0xFFFF;
        this.decB();
        this.SIGN_FLAG(this.getB(), 8);
        this.ZERO_FLAG(this.getB());
        if ((n & 0x80) != 0) {
            this.SetNF();
        } else {
            this.ClearNF();
        }
    }

    private final void OUTDR() {
        this.OUTD();
        if (this.getB() != 0) {
            this.PC -= 2;
        }
    }

    private final void OUTIR() {
        this.OUTI();
        if (this.getB() != 0) {
            this.PC -= 2;
        }
    }

    private final void LDI() {
        this.ClearHF();
        this.ClearNF();
        int n = this.memReadByte(this.HL) & 0xFF;
        this.memWriteByte(this.DE, n);
        ++this.DE;
        ++this.HL;
        --this.BC;
        this.DE &= 0xFFFF;
        this.HL &= 0xFFFF;
        this.BC &= 0xFFFF;
        if (this.BC != 0) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
        n += this.getA();
        this.AF = ((n &= 0xFF) & 2) != 0 ? (this.AF |= 0x20) : (this.AF &= 0xFFDF);
        this.AF = (n & 8) != 0 ? (this.AF |= 8) : (this.AF &= 0xFFF7);
        this.UpdateR();
    }

    private final void LDD() {
        this.ClearHF();
        this.ClearNF();
        int n = this.memReadByte(this.HL) & 0xFF;
        this.memWriteByte(this.DE, n);
        --this.DE;
        --this.HL;
        --this.BC;
        this.DE &= 0xFFFF;
        this.HL &= 0xFFFF;
        this.BC &= 0xFFFF;
        if (this.BC != 0) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
        n += this.getA();
        this.AF = ((n &= 0xFF) & 2) != 0 ? (this.AF |= 0x20) : (this.AF &= 0xFFDF);
        this.AF = (n & 8) != 0 ? (this.AF |= 8) : (this.AF &= 0xFFF7);
        this.UpdateR();
    }

    private final void LDIR() {
        this.LDI();
        if (this.BC != 0) {
            this.PC -= 2;
        }
    }

    private final void LDDR() {
        this.LDD();
        if (this.BC != 0) {
            this.PC -= 2;
        }
    }

    private final void CPI() {
        this.SetNF();
        int n = this.memReadByte(this.HL);
        ++this.HL;
        this.HL &= 0xFFFF;
        --this.BC;
        this.BC &= 0xFFFF;
        int n2 = n & 0xFF;
        int n3 = this.getA() - n2;
        this.ZERO_FLAG(n3 &= 0xFF);
        if (((this.getA() ^ n3 ^ n2) & 0x10) != 0) {
            this.SetHF();
        } else {
            this.ClearHF();
        }
        this.SIGN_FLAG(n3, 8);
        this.YF_XF_FLAGS(this.getA() - n - ((this.AF & 0x10) >> 4));
        if (this.BC != 0) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
    }

    private final void CPD() {
        this.SetNF();
        int n = this.memReadByte(this.HL);
        --this.HL;
        this.HL &= 0xFFFF;
        --this.BC;
        this.BC &= 0xFFFF;
        int n2 = n & 0xFF;
        int n3 = this.getA() - n2;
        this.ZERO_FLAG(n3 &= 0xFF);
        if (((this.getA() ^ n3 ^ n2) & 0x10) != 0) {
            this.SetHF();
        } else {
            this.ClearHF();
        }
        this.SIGN_FLAG(n3, 8);
        this.YF_XF_FLAGS(this.getA() - n - ((this.AF & 0x10) >> 4));
        if (this.BC != 0) {
            this.SetVF();
        } else {
            this.ClearVF();
        }
    }

    private final void CPIR() {
        this.CPI();
        if (this.BC != 0 && (this.AF & 0x40) == 0) {
            this.PC -= 2;
        }
    }

    private final void CPDR() {
        this.CPD();
        if (this.BC != 0 && (this.AF & 0x40) == 0) {
            this.PC -= 2;
        }
    }

    private final void BIT(int n, int n2) {
        if ((n2 & 1 << n) != 0) {
            this.ClearZF();
            this.ClearVF();
            switch (n) {
                case 7: {
                    this.SetSF();
                    break;
                }
                case 5: {
                    this.AF |= 0x20;
                    break;
                }
                case 3: {
                    this.AF |= 8;
                }
            }
        } else {
            this.SetZF();
            this.SetVF();
        }
        this.ClearNF();
        this.SetHF();
    }

    private final int RES(int n, int n2) {
        return n2 & ~(1 << n) & 0xFF;
    }

    private final int SET(int n, int n2) {
        return (n2 | 1 << n) & 0xFF;
    }

    private final int SRA(int n) {
        int n2;
        n = n2 = n & 0xFF;
        n = n & 0x80 | n >> 1;
        this.ZERO_FLAG(n &= 0xFF);
        this.SIGN_FLAG(n, 8);
        this.PARI_FLAG(n);
        if ((n2 & 1) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n;
    }

    private final int SRL(int n) {
        int n2;
        n = n2 = n & 0xFF;
        n = n >> 1 & 0xFF;
        this.ZERO_FLAG(n);
        this.SIGN_FLAG(n, 8);
        this.PARI_FLAG(n);
        if ((n2 & 1) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n;
    }

    private final int SLA(int n) {
        int n2;
        n = n2 = n & 0xFF;
        n = n << 1 & 0xFF;
        this.ZERO_FLAG(n);
        this.SIGN_FLAG(n, 8);
        this.PARI_FLAG(n);
        if ((n2 & 0x80) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n;
    }

    private final int SLL(int n) {
        int n2;
        n = n2 = n & 0xFF;
        n = (n << 1 | 1) & 0xFF;
        this.ZERO_FLAG(n);
        this.SIGN_FLAG(n, 8);
        this.PARI_FLAG(n);
        if ((n2 & 0x80) != 0) {
            this.SetCF();
        } else {
            this.ClearCF();
        }
        this.ClearHF();
        this.ClearNF();
        return n;
    }

    private final int LD_RES(int n, int n2) {
        int n3 = n + (byte)this.memReadByte(this.PC++);
        int n4 = this.RES(n2, this.memReadByte(n3 &= 0xFFFF));
        this.memWriteByte(n3, n4);
        return n4;
    }

    private final int LD_SET(int n, int n2) {
        int n3 = n + (byte)this.memReadByte(this.PC++);
        int n4 = this.SET(n2, this.memReadByte(n3 &= 0xFFFF));
        this.memWriteByte(n3, n4);
        return n4;
    }

    private final int LD_RLC(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.RLC(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_RRC(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.RRC(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_RL(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.RL(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_RR(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.RR(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_SRA(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.SRA(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_SLA(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.SLA(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_SRL(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.SRL(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final int LD_SLL(int n) {
        int n2 = n + (byte)this.memReadByte(this.PC++);
        int n3 = this.SLL(this.memReadByte(n2 &= 0xFFFF));
        this.memWriteByte(n2, n3);
        return n3;
    }

    private final void exeOpcode(int n) {
        switch (n) {
            case 203: {
                this.exe_cb_opcode(this.memReadByte(this.PC++));
                break;
            }
            case 237: {
                this.exe_ed_opcode(this.memReadByte(this.PC++));
                break;
            }
            case 221: {
                this.IX = this.exe_dd_opcode(this.IX, this.memReadByte(this.PC++));
                break;
            }
            case 253: {
                this.IY = this.exe_dd_opcode(this.IY, this.memReadByte(this.PC++));
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.BC = this.memReadWord(this.PC);
                this.PC += 2;
                break;
            }
            case 2: {
                this.memWriteByte(this.BC, this.getA());
                break;
            }
            case 3: {
                ++this.BC;
                this.BC &= 0xFFFF;
                break;
            }
            case 4: {
                this.setB(this.INC(this.getB()));
                break;
            }
            case 5: {
                this.setB(this.DEC(this.getB()));
                break;
            }
            case 6: {
                this.setB(this.memReadByte(this.PC++));
                break;
            }
            case 7: {
                this.RLCA();
                break;
            }
            case 8: {
                this.word = this.AF;
                this.AF = this.AF2;
                this.AF2 = this.word;
                break;
            }
            case 9: {
                this.HL = this.ADD16(this.HL, this.BC);
                break;
            }
            case 10: {
                this.setA(this.memReadByte(this.BC));
                break;
            }
            case 11: {
                --this.BC;
                this.BC &= 0xFFFF;
                break;
            }
            case 12: {
                this.setC(this.INC(this.getC()));
                break;
            }
            case 13: {
                this.setC(this.DEC(this.getC()));
                break;
            }
            case 14: {
                this.setC(this.memReadByte(this.PC++));
                break;
            }
            case 15: {
                this.RRCA();
                break;
            }
            case 16: {
                this.decB();
                if (this.getB() != 0) {
                    this.cyclesToDo -= 3;
                    this.PC += 1 + (byte)this.memReadByte(this.PC);
                    break;
                }
                ++this.PC;
                break;
            }
            case 17: {
                this.DE = this.memReadWord(this.PC);
                this.PC += 2;
                break;
            }
            case 18: {
                this.memWriteByte(this.DE, this.getA());
                break;
            }
            case 19: {
                ++this.DE;
                this.DE &= 0xFFFF;
                break;
            }
            case 20: {
                this.setD(this.INC(this.getD()));
                break;
            }
            case 21: {
                this.setD(this.DEC(this.getD()));
                break;
            }
            case 22: {
                this.setD(this.memReadByte(this.PC++));
                break;
            }
            case 23: {
                this.RLA();
                break;
            }
            case 24: {
                this.PC += 1 + (byte)this.memReadByte(this.PC);
                break;
            }
            case 25: {
                this.HL = this.ADD16(this.HL, this.DE);
                break;
            }
            case 26: {
                this.setA(this.memReadByte(this.DE));
                break;
            }
            case 27: {
                --this.DE;
                this.DE &= 0xFFFF;
                break;
            }
            case 28: {
                this.setE(this.INC(this.getE()));
                break;
            }
            case 29: {
                this.setE(this.DEC(this.getE()));
                break;
            }
            case 30: {
                this.setE(this.memReadByte(this.PC++));
                break;
            }
            case 31: {
                this.RRA();
                break;
            }
            case 32: {
                if ((this.AF & 0x40) == 0) {
                    this.cyclesToDo -= 5;
                    this.PC += 1 + (byte)this.memReadByte(this.PC);
                    break;
                }
                ++this.PC;
                break;
            }
            case 33: {
                this.HL = this.memReadWord(this.PC);
                this.PC += 2;
                break;
            }
            case 34: {
                this.memWriteWord(this.memReadWord(this.PC), this.HL);
                this.PC += 2;
                break;
            }
            case 35: {
                ++this.HL;
                this.HL &= 0xFFFF;
                break;
            }
            case 36: {
                this.setH(this.INC(this.getH()));
                break;
            }
            case 37: {
                this.setH(this.DEC(this.getH()));
                break;
            }
            case 38: {
                this.setH(this.memReadByte(this.PC++));
                break;
            }
            case 39: {
                this.DAA();
                break;
            }
            case 40: {
                if ((this.AF & 0x40) != 0) {
                    this.cyclesToDo -= 5;
                    this.PC += 1 + (byte)this.memReadByte(this.PC);
                    break;
                }
                ++this.PC;
                break;
            }
            case 41: {
                this.HL = this.ADD16(this.HL, this.HL);
                break;
            }
            case 42: {
                this.HL = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 43: {
                --this.HL;
                this.HL &= 0xFFFF;
                break;
            }
            case 44: {
                this.setL(this.INC(this.getL()));
                break;
            }
            case 45: {
                this.setL(this.DEC(this.getL()));
                break;
            }
            case 46: {
                this.setL(this.memReadByte(this.PC++));
                break;
            }
            case 47: {
                this.CPL();
                break;
            }
            case 48: {
                if ((this.AF & 1) == 0) {
                    this.cyclesToDo -= 5;
                    this.PC += 1 + (byte)this.memReadByte(this.PC);
                    break;
                }
                ++this.PC;
                break;
            }
            case 49: {
                this.SP = this.memReadWord(this.PC);
                this.PC += 2;
                break;
            }
            case 50: {
                this.memWriteByte(this.memReadWord(this.PC), this.getA());
                this.PC += 2;
                break;
            }
            case 51: {
                ++this.SP;
                this.SP &= 0xFFFF;
                break;
            }
            case 52: {
                this.memWriteByte(this.HL, this.INC(this.memReadByte(this.HL)));
                break;
            }
            case 53: {
                this.memWriteByte(this.HL, this.DEC(this.memReadByte(this.HL)));
                break;
            }
            case 54: {
                this.memWriteByte(this.HL, this.memReadByte(this.PC++));
                break;
            }
            case 55: {
                this.SCF();
                break;
            }
            case 56: {
                if ((this.AF & 1) != 0) {
                    this.cyclesToDo -= 5;
                    this.PC += 1 + (byte)this.memReadByte(this.PC);
                    break;
                }
                ++this.PC;
                break;
            }
            case 57: {
                this.HL = this.ADD16(this.HL, this.SP);
                break;
            }
            case 58: {
                this.setA(this.memReadByte(this.memReadWord(this.PC)));
                this.PC += 2;
                break;
            }
            case 59: {
                --this.SP;
                this.SP &= 0xFFFF;
                break;
            }
            case 60: {
                this.setA(this.INC(this.getA()));
                break;
            }
            case 61: {
                this.setA(this.DEC(this.getA()));
                break;
            }
            case 62: {
                this.setA(this.memReadByte(this.PC++));
                break;
            }
            case 63: {
                this.CCF();
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                this.setB(this.getC());
                break;
            }
            case 66: {
                this.setB(this.getD());
                break;
            }
            case 67: {
                this.setB(this.getE());
                break;
            }
            case 68: {
                this.setB(this.getH());
                break;
            }
            case 69: {
                this.setB(this.getL());
                break;
            }
            case 70: {
                this.setB(this.memReadByte(this.HL));
                break;
            }
            case 71: {
                this.setB(this.getA());
                break;
            }
            case 72: {
                this.setC(this.getB());
                break;
            }
            case 73: {
                break;
            }
            case 74: {
                this.setC(this.getD());
                break;
            }
            case 75: {
                this.setC(this.getE());
                break;
            }
            case 76: {
                this.setC(this.getH());
                break;
            }
            case 77: {
                this.setC(this.getL());
                break;
            }
            case 78: {
                this.setC(this.memReadByte(this.HL));
                break;
            }
            case 79: {
                this.setC(this.getA());
                break;
            }
            case 80: {
                this.setD(this.getB());
                break;
            }
            case 81: {
                this.setD(this.getC());
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                this.setD(this.getE());
                break;
            }
            case 84: {
                this.setD(this.getH());
                break;
            }
            case 85: {
                this.setD(this.getL());
                break;
            }
            case 86: {
                this.setD(this.memReadByte(this.HL));
                break;
            }
            case 87: {
                this.setD(this.getA());
                break;
            }
            case 88: {
                this.setE(this.getB());
                break;
            }
            case 89: {
                this.setE(this.getC());
                break;
            }
            case 90: {
                this.setE(this.getD());
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                this.setE(this.getH());
                break;
            }
            case 93: {
                this.setE(this.getL());
                break;
            }
            case 94: {
                this.setE(this.memReadByte(this.HL));
                break;
            }
            case 95: {
                this.setE(this.getA());
                break;
            }
            case 96: {
                this.setH(this.getB());
                break;
            }
            case 97: {
                this.setH(this.getC());
                break;
            }
            case 98: {
                this.setH(this.getD());
                break;
            }
            case 99: {
                this.setH(this.getE());
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                this.setH(this.getL());
                break;
            }
            case 102: {
                this.setH(this.memReadByte(this.HL));
                break;
            }
            case 103: {
                this.setH(this.getA());
                break;
            }
            case 104: {
                this.setL(this.getB());
                break;
            }
            case 105: {
                this.setL(this.getC());
                break;
            }
            case 106: {
                this.setL(this.getD());
                break;
            }
            case 107: {
                this.setL(this.getE());
                break;
            }
            case 108: {
                this.setL(this.getH());
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                this.setL(this.memReadByte(this.HL));
                break;
            }
            case 111: {
                this.setL(this.getA());
                break;
            }
            case 112: {
                this.memWriteByte(this.HL, this.getB());
                break;
            }
            case 113: {
                this.memWriteByte(this.HL, this.getC());
                break;
            }
            case 114: {
                this.memWriteByte(this.HL, this.getD());
                break;
            }
            case 115: {
                this.memWriteByte(this.HL, this.getE());
                break;
            }
            case 116: {
                this.memWriteByte(this.HL, this.getH());
                break;
            }
            case 117: {
                this.memWriteByte(this.HL, this.getL());
                break;
            }
            case 118: {
                this.halted = true;
                break;
            }
            case 119: {
                this.memWriteByte(this.HL, this.getA());
                break;
            }
            case 120: {
                this.setA(this.getB());
                break;
            }
            case 121: {
                this.setA(this.getC());
                break;
            }
            case 122: {
                this.setA(this.getD());
                break;
            }
            case 123: {
                this.setA(this.getE());
                break;
            }
            case 124: {
                this.setA(this.getH());
                break;
            }
            case 125: {
                this.setA(this.getL());
                break;
            }
            case 126: {
                this.setA(this.memReadByte(this.HL));
                break;
            }
            case 127: {
                break;
            }
            case 128: {
                this.ADD(this.getB());
                break;
            }
            case 129: {
                this.ADD(this.getC());
                break;
            }
            case 130: {
                this.ADD(this.getD());
                break;
            }
            case 131: {
                this.ADD(this.getE());
                break;
            }
            case 132: {
                this.ADD(this.getH());
                break;
            }
            case 133: {
                this.ADD(this.getL());
                break;
            }
            case 134: {
                this.ADD(this.memReadByte(this.HL));
                break;
            }
            case 135: {
                this.ADD(this.getA());
                break;
            }
            case 136: {
                this.ADC(this.getB());
                break;
            }
            case 137: {
                this.ADC(this.getC());
                break;
            }
            case 138: {
                this.ADC(this.getD());
                break;
            }
            case 139: {
                this.ADC(this.getE());
                break;
            }
            case 140: {
                this.ADC(this.getH());
                break;
            }
            case 141: {
                this.ADC(this.getL());
                break;
            }
            case 142: {
                this.ADC(this.memReadByte(this.HL));
                break;
            }
            case 143: {
                this.ADC(this.getA());
                break;
            }
            case 144: {
                this.SUB(this.getB());
                break;
            }
            case 145: {
                this.SUB(this.getC());
                break;
            }
            case 146: {
                this.SUB(this.getD());
                break;
            }
            case 147: {
                this.SUB(this.getE());
                break;
            }
            case 148: {
                this.SUB(this.getH());
                break;
            }
            case 149: {
                this.SUB(this.getL());
                break;
            }
            case 150: {
                this.SUB(this.memReadByte(this.HL));
                break;
            }
            case 151: {
                this.SUB(this.getA());
                break;
            }
            case 152: {
                this.SBC(this.getB());
                break;
            }
            case 153: {
                this.SBC(this.getC());
                break;
            }
            case 154: {
                this.SBC(this.getD());
                break;
            }
            case 155: {
                this.SBC(this.getE());
                break;
            }
            case 156: {
                this.SBC(this.getH());
                break;
            }
            case 157: {
                this.SBC(this.getL());
                break;
            }
            case 158: {
                this.SBC(this.memReadByte(this.HL));
                break;
            }
            case 159: {
                this.SBC(this.getA());
                break;
            }
            case 160: {
                this.AND(this.getB());
                break;
            }
            case 161: {
                this.AND(this.getC());
                break;
            }
            case 162: {
                this.AND(this.getD());
                break;
            }
            case 163: {
                this.AND(this.getE());
                break;
            }
            case 164: {
                this.AND(this.getH());
                break;
            }
            case 165: {
                this.AND(this.getL());
                break;
            }
            case 166: {
                this.AND(this.memReadByte(this.HL));
                break;
            }
            case 167: {
                this.AND(this.getA());
                break;
            }
            case 168: {
                this.XOR(this.getB());
                break;
            }
            case 169: {
                this.XOR(this.getC());
                break;
            }
            case 170: {
                this.XOR(this.getD());
                break;
            }
            case 171: {
                this.XOR(this.getE());
                break;
            }
            case 172: {
                this.XOR(this.getH());
                break;
            }
            case 173: {
                this.XOR(this.getL());
                break;
            }
            case 174: {
                this.XOR(this.memReadByte(this.HL));
                break;
            }
            case 175: {
                this.XOR(this.getA());
                break;
            }
            case 176: {
                this.OR(this.getB());
                break;
            }
            case 177: {
                this.OR(this.getC());
                break;
            }
            case 178: {
                this.OR(this.getD());
                break;
            }
            case 179: {
                this.OR(this.getE());
                break;
            }
            case 180: {
                this.OR(this.getH());
                break;
            }
            case 181: {
                this.OR(this.getL());
                break;
            }
            case 182: {
                this.OR(this.memReadByte(this.HL));
                break;
            }
            case 183: {
                this.OR(this.getA());
                break;
            }
            case 184: {
                this.CP(this.getB());
                break;
            }
            case 185: {
                this.CP(this.getC());
                break;
            }
            case 186: {
                this.CP(this.getD());
                break;
            }
            case 187: {
                this.CP(this.getE());
                break;
            }
            case 188: {
                this.CP(this.getH());
                break;
            }
            case 189: {
                this.CP(this.getL());
                break;
            }
            case 190: {
                this.CP(this.memReadByte(this.HL));
                break;
            }
            case 191: {
                this.CP(this.getA());
                break;
            }
            case 192: {
                if ((this.AF & 0x40) != 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 193: {
                this.BC = this.POP();
                break;
            }
            case 194: {
                if ((this.AF & 0x40) == 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 195: {
                this.PC = this.memReadWord(this.PC);
                break;
            }
            case 196: {
                if ((this.AF & 0x40) == 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 197: {
                this.PUSH(this.BC);
                break;
            }
            case 198: {
                this.ADD(this.memReadByte(this.PC++));
                break;
            }
            case 199: {
                this.RST(0);
                break;
            }
            case 200: {
                if ((this.AF & 0x40) == 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 201: {
                this.RET();
                break;
            }
            case 202: {
                if ((this.AF & 0x40) != 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 204: {
                if ((this.AF & 0x40) != 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 205: {
                this.CALL();
                break;
            }
            case 206: {
                this.ADC(this.memReadByte(this.PC++));
                break;
            }
            case 207: {
                this.RST(8);
                break;
            }
            case 208: {
                if ((this.AF & 1) != 0) break;
                this.RET();
                break;
            }
            case 209: {
                this.DE = this.POP();
                break;
            }
            case 210: {
                if ((this.AF & 1) == 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 211: {
                this.ioWriteByte(this.getA() << 8 | this.memReadByte(this.PC++), this.getA());
                break;
            }
            case 212: {
                if ((this.AF & 1) == 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 213: {
                this.PUSH(this.DE);
                break;
            }
            case 214: {
                this.SUB(this.memReadByte(this.PC++));
                break;
            }
            case 215: {
                this.RST(16);
                break;
            }
            case 216: {
                if ((this.AF & 1) == 0) break;
                this.RET();
                break;
            }
            case 217: {
                this.EXX();
                break;
            }
            case 218: {
                if ((this.AF & 1) != 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 219: {
                this.setA(this.ioReadByte(this.getA() << 8 | this.memReadByte(this.PC++)));
                break;
            }
            case 220: {
                if ((this.AF & 1) != 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 222: {
                this.SBC(this.memReadByte(this.PC++));
                break;
            }
            case 223: {
                this.RST(24);
                break;
            }
            case 224: {
                if ((this.AF & 4) != 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 225: {
                this.HL = this.POP();
                break;
            }
            case 226: {
                if ((this.AF & 4) == 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 227: {
                this.word = this.HL;
                this.HL = this.memReadWord(this.SP);
                this.memWriteWord(this.SP, this.word);
                break;
            }
            case 228: {
                if ((this.AF & 4) == 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 229: {
                this.PUSH(this.HL);
                break;
            }
            case 230: {
                this.AND(this.memReadByte(this.PC++));
                break;
            }
            case 231: {
                this.RST(32);
                break;
            }
            case 232: {
                if ((this.AF & 4) == 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 233: {
                this.PC = this.HL;
                break;
            }
            case 234: {
                if ((this.AF & 4) != 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 235: {
                this.word = this.DE;
                this.DE = this.HL;
                this.HL = this.word;
                break;
            }
            case 236: {
                if ((this.AF & 4) != 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 238: {
                this.XOR(this.memReadByte(this.PC++));
                break;
            }
            case 239: {
                this.RST(40);
                break;
            }
            case 240: {
                if ((this.AF & 0x80) != 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 241: {
                this.AF = this.POP();
                break;
            }
            case 242: {
                if ((this.AF & 0x80) == 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 243: {
                this.IFF2 = 0;
                this.IFF1 = 0;
                break;
            }
            case 244: {
                if ((this.AF & 0x80) == 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 245: {
                this.PUSH(this.AF);
                break;
            }
            case 246: {
                this.OR(this.memReadByte(this.PC++));
                break;
            }
            case 247: {
                this.RST(48);
                break;
            }
            case 248: {
                if ((this.AF & 0x80) == 0) break;
                this.cyclesToDo -= 6;
                this.RET();
                break;
            }
            case 249: {
                this.SP = this.HL;
                break;
            }
            case 250: {
                if ((this.AF & 0x80) != 0) {
                    this.PC = this.memReadWord(this.PC);
                    break;
                }
                this.PC += 2;
                break;
            }
            case 251: {
                this.enable = 1;
                break;
            }
            case 252: {
                if ((this.AF & 0x80) != 0) {
                    this.cyclesToDo -= 7;
                    this.CALL();
                    break;
                }
                this.PC += 2;
                break;
            }
            case 254: {
                this.CP(this.memReadByte(this.PC++));
                break;
            }
            case 255: {
                this.RST(56);
            }
        }
        this.cyclesToDo -= cycles_main_opcode[n];
    }

    private final void exe_ed_opcode(int n) {
        switch (n) {
            case 64: {
                this.setB(this.IN());
                break;
            }
            case 65: {
                this.ioWriteByte(this.BC, this.getB());
                break;
            }
            case 66: {
                this.SBC_HL(this.BC);
                break;
            }
            case 67: {
                this.memWriteWord(this.memReadWord(this.PC), this.BC);
                this.PC += 2;
                break;
            }
            case 68: {
                this.NEG();
                break;
            }
            case 69: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 70: {
                this.IM = 0;
                break;
            }
            case 71: {
                this.I = this.getA();
                break;
            }
            case 72: {
                this.setC(this.IN());
                break;
            }
            case 73: {
                this.ioWriteByte(this.BC, this.getC());
                break;
            }
            case 74: {
                this.ADC_HL(this.BC);
                break;
            }
            case 75: {
                this.BC = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 76: {
                this.NEG();
                break;
            }
            case 77: {
                this.IFF1 = 1;
                this.RET();
                break;
            }
            case 78: {
                this.IM = 0;
                break;
            }
            case 79: {
                this.R = this.getA();
                break;
            }
            case 80: {
                this.setD(this.IN());
                break;
            }
            case 81: {
                this.ioWriteByte(this.BC, this.getD());
                break;
            }
            case 82: {
                this.SBC_HL(this.DE);
                break;
            }
            case 83: {
                this.memWriteWord(this.memReadWord(this.PC), this.DE);
                this.PC += 2;
                break;
            }
            case 84: {
                this.NEG();
                break;
            }
            case 85: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 86: {
                this.IM = 1;
                break;
            }
            case 87: {
                this.setA(this.I);
                if (this.IFF2 != 0) {
                    this.SetVF();
                } else {
                    this.ClearVF();
                }
                this.SIGN_FLAG(this.getA(), 8);
                this.ZERO_FLAG(this.getA());
                this.ClearHF();
                this.YF_XF_FLAGS(this.getA());
                break;
            }
            case 88: {
                this.setE(this.IN());
                break;
            }
            case 89: {
                this.ioWriteByte(this.BC, this.getE());
                break;
            }
            case 90: {
                this.ADC_HL(this.DE);
                break;
            }
            case 91: {
                this.DE = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 92: {
                this.NEG();
                break;
            }
            case 93: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 94: {
                this.IM = 2;
                break;
            }
            case 95: {
                this.setA(this.R);
                if (this.IFF2 != 0) {
                    this.SetVF();
                } else {
                    this.ClearVF();
                }
                this.SIGN_FLAG(this.getA(), 8);
                this.ZERO_FLAG(this.getA());
                this.ClearHF();
                this.YF_XF_FLAGS(this.getA());
                this.ClearNF();
                break;
            }
            case 96: {
                this.setH(this.IN());
                break;
            }
            case 97: {
                this.ioWriteByte(this.BC, this.getH());
                break;
            }
            case 98: {
                this.SBC_HL(this.HL);
                break;
            }
            case 99: {
                this.memWriteWord(this.memReadWord(this.PC), this.HL);
                this.PC += 2;
                break;
            }
            case 100: {
                this.NEG();
                break;
            }
            case 101: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 102: {
                this.IM = 0;
                break;
            }
            case 103: {
                this.RRD();
                break;
            }
            case 104: {
                this.setL(this.IN());
                break;
            }
            case 105: {
                this.ioWriteByte(this.BC, this.getL());
                break;
            }
            case 106: {
                this.ADC_HL(this.HL);
                break;
            }
            case 107: {
                this.HL = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 108: {
                this.NEG();
                break;
            }
            case 109: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 110: {
                this.IM = 0;
                break;
            }
            case 111: {
                this.RLD();
                break;
            }
            case 112: {
                this.IN();
                break;
            }
            case 113: {
                this.ioWriteByte(this.BC, 0);
                break;
            }
            case 114: {
                this.SBC_HL(this.SP);
                break;
            }
            case 115: {
                this.memWriteWord(this.memReadWord(this.PC), this.SP);
                this.PC += 2;
                break;
            }
            case 116: {
                this.NEG();
                break;
            }
            case 117: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 118: {
                this.IM = 2;
                break;
            }
            case 120: {
                this.setA(this.IN());
                break;
            }
            case 121: {
                this.ioWriteByte(this.BC, this.getA());
                break;
            }
            case 122: {
                this.ADC_HL(this.SP);
                break;
            }
            case 123: {
                this.SP = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 124: {
                this.NEG();
                break;
            }
            case 125: {
                this.IFF1 = this.IFF2;
                this.RET();
                this.Interrupt();
                break;
            }
            case 126: {
                this.IM = 2;
                break;
            }
            case 160: {
                this.LDI();
                break;
            }
            case 161: {
                this.CPI();
                break;
            }
            case 162: {
                this.INI();
                break;
            }
            case 163: {
                this.OUTI();
                break;
            }
            case 168: {
                this.LDD();
                break;
            }
            case 169: {
                this.CPD();
                break;
            }
            case 170: {
                this.IND();
                break;
            }
            case 171: {
                this.OUTD();
                break;
            }
            case 176: {
                this.LDIR();
                break;
            }
            case 177: {
                this.CPIR();
                break;
            }
            case 178: {
                this.INIR();
                break;
            }
            case 179: {
                this.OUTIR();
                break;
            }
            case 184: {
                this.LDDR();
                break;
            }
            case 185: {
                this.CPDR();
                break;
            }
            case 186: {
                this.INDR();
                break;
            }
            case 187: {
                this.OUTDR();
                break;
            }
        }
        this.cyclesToDo -= cycles_ed_opcode[n];
    }

    private final void exe_cb_opcode(int n) {
        switch (n) {
            case 0: {
                this.setB(this.RLC(this.getB()));
                break;
            }
            case 1: {
                this.setC(this.RLC(this.getC()));
                break;
            }
            case 2: {
                this.setD(this.RLC(this.getD()));
                break;
            }
            case 3: {
                this.setE(this.RLC(this.getE()));
                break;
            }
            case 4: {
                this.setH(this.RLC(this.getH()));
                break;
            }
            case 5: {
                this.setL(this.RLC(this.getL()));
                break;
            }
            case 6: {
                this.memWriteByte(this.HL, this.RLC(this.memReadByte(this.HL)));
                break;
            }
            case 7: {
                this.setA(this.RLC(this.getA()));
                break;
            }
            case 8: {
                this.setB(this.RRC(this.getB()));
                break;
            }
            case 9: {
                this.setC(this.RRC(this.getC()));
                break;
            }
            case 10: {
                this.setD(this.RRC(this.getD()));
                break;
            }
            case 11: {
                this.setE(this.RRC(this.getE()));
                break;
            }
            case 12: {
                this.setH(this.RRC(this.getH()));
                break;
            }
            case 13: {
                this.setL(this.RRC(this.getL()));
                break;
            }
            case 14: {
                this.memWriteByte(this.HL, this.RRC(this.memReadByte(this.HL)));
                break;
            }
            case 15: {
                this.setA(this.RRC(this.getA()));
                break;
            }
            case 16: {
                this.setB(this.RL(this.getB()));
                break;
            }
            case 17: {
                this.setC(this.RL(this.getC()));
                break;
            }
            case 18: {
                this.setD(this.RL(this.getD()));
                break;
            }
            case 19: {
                this.setE(this.RL(this.getE()));
                break;
            }
            case 20: {
                this.setH(this.RL(this.getH()));
                break;
            }
            case 21: {
                this.setL(this.RL(this.getL()));
                break;
            }
            case 22: {
                this.memWriteByte(this.HL, this.RL(this.memReadByte(this.HL)));
                break;
            }
            case 23: {
                this.setA(this.RL(this.getA()));
                break;
            }
            case 24: {
                this.setB(this.RR(this.getB()));
                break;
            }
            case 25: {
                this.setC(this.RR(this.getC()));
                break;
            }
            case 26: {
                this.setD(this.RR(this.getD()));
                break;
            }
            case 27: {
                this.setE(this.RR(this.getE()));
                break;
            }
            case 28: {
                this.setH(this.RR(this.getH()));
                break;
            }
            case 29: {
                this.setL(this.RR(this.getL()));
                break;
            }
            case 30: {
                this.memWriteByte(this.HL, this.RR(this.memReadByte(this.HL)));
                break;
            }
            case 31: {
                this.setA(this.RR(this.getA()));
                break;
            }
            case 32: {
                this.setB(this.SLA(this.getB()));
                break;
            }
            case 33: {
                this.setC(this.SLA(this.getC()));
                break;
            }
            case 34: {
                this.setD(this.SLA(this.getD()));
                break;
            }
            case 35: {
                this.setE(this.SLA(this.getE()));
                break;
            }
            case 36: {
                this.setH(this.SLA(this.getH()));
                break;
            }
            case 37: {
                this.setL(this.SLA(this.getL()));
                break;
            }
            case 38: {
                this.memWriteByte(this.HL, this.SLA(this.memReadByte(this.HL)));
                break;
            }
            case 39: {
                this.setA(this.SLA(this.getA()));
                break;
            }
            case 40: {
                this.setB(this.SRA(this.getB()));
                break;
            }
            case 41: {
                this.setC(this.SRA(this.getC()));
                break;
            }
            case 42: {
                this.setD(this.SRA(this.getD()));
                break;
            }
            case 43: {
                this.setE(this.SRA(this.getE()));
                break;
            }
            case 44: {
                this.setH(this.SRA(this.getH()));
                break;
            }
            case 45: {
                this.setL(this.SRA(this.getL()));
                break;
            }
            case 46: {
                this.memWriteByte(this.HL, this.SRA(this.memReadByte(this.HL)));
                break;
            }
            case 47: {
                this.setA(this.SRA(this.getA()));
                break;
            }
            case 48: {
                this.setB(this.SLL(this.getB()));
                break;
            }
            case 49: {
                this.setC(this.SLL(this.getC()));
                break;
            }
            case 50: {
                this.setD(this.SLL(this.getD()));
                break;
            }
            case 51: {
                this.setE(this.SLL(this.getE()));
                break;
            }
            case 52: {
                this.setH(this.SLL(this.getH()));
                break;
            }
            case 53: {
                this.setL(this.SLL(this.getL()));
                break;
            }
            case 54: {
                this.memWriteByte(this.HL, this.SLL(this.memReadByte(this.HL)));
                break;
            }
            case 55: {
                this.setA(this.SLL(this.getA()));
                break;
            }
            case 56: {
                this.setB(this.SRL(this.getB()));
                break;
            }
            case 57: {
                this.setC(this.SRL(this.getC()));
                break;
            }
            case 58: {
                this.setD(this.SRL(this.getD()));
                break;
            }
            case 59: {
                this.setE(this.SRL(this.getE()));
                break;
            }
            case 60: {
                this.setH(this.SRL(this.getH()));
                break;
            }
            case 61: {
                this.setL(this.SRL(this.getL()));
                break;
            }
            case 62: {
                this.memWriteByte(this.HL, this.SRL(this.memReadByte(this.HL)));
                break;
            }
            case 63: {
                this.setA(this.SRL(this.getA()));
                break;
            }
            case 64: {
                this.BIT(0, this.getB());
                break;
            }
            case 65: {
                this.BIT(0, this.getC());
                break;
            }
            case 66: {
                this.BIT(0, this.getD());
                break;
            }
            case 67: {
                this.BIT(0, this.getE());
                break;
            }
            case 68: {
                this.BIT(0, this.getH());
                break;
            }
            case 69: {
                this.BIT(0, this.getL());
                break;
            }
            case 70: {
                this.BIT(0, this.memReadByte(this.HL));
                break;
            }
            case 71: {
                this.BIT(0, this.getA());
                break;
            }
            case 72: {
                this.BIT(1, this.getB());
                break;
            }
            case 73: {
                this.BIT(1, this.getC());
                break;
            }
            case 74: {
                this.BIT(1, this.getD());
                break;
            }
            case 75: {
                this.BIT(1, this.getE());
                break;
            }
            case 76: {
                this.BIT(1, this.getH());
                break;
            }
            case 77: {
                this.BIT(1, this.getL());
                break;
            }
            case 78: {
                this.BIT(1, this.memReadByte(this.HL));
                break;
            }
            case 79: {
                this.BIT(1, this.getA());
                break;
            }
            case 80: {
                this.BIT(2, this.getB());
                break;
            }
            case 81: {
                this.BIT(2, this.getC());
                break;
            }
            case 82: {
                this.BIT(2, this.getD());
                break;
            }
            case 83: {
                this.BIT(2, this.getE());
                break;
            }
            case 84: {
                this.BIT(2, this.getH());
                break;
            }
            case 85: {
                this.BIT(2, this.getL());
                break;
            }
            case 86: {
                this.BIT(2, this.memReadByte(this.HL));
                break;
            }
            case 87: {
                this.BIT(2, this.getA());
                break;
            }
            case 88: {
                this.BIT(3, this.getB());
                break;
            }
            case 89: {
                this.BIT(3, this.getC());
                break;
            }
            case 90: {
                this.BIT(3, this.getD());
                break;
            }
            case 91: {
                this.BIT(3, this.getE());
                break;
            }
            case 92: {
                this.BIT(3, this.getH());
                break;
            }
            case 93: {
                this.BIT(3, this.getL());
                break;
            }
            case 94: {
                this.BIT(3, this.memReadByte(this.HL));
                break;
            }
            case 95: {
                this.BIT(3, this.getA());
                break;
            }
            case 96: {
                this.BIT(4, this.getB());
                break;
            }
            case 97: {
                this.BIT(4, this.getC());
                break;
            }
            case 98: {
                this.BIT(4, this.getD());
                break;
            }
            case 99: {
                this.BIT(4, this.getE());
                break;
            }
            case 100: {
                this.BIT(4, this.getH());
                break;
            }
            case 101: {
                this.BIT(4, this.getL());
                break;
            }
            case 102: {
                this.BIT(4, this.memReadByte(this.HL));
                break;
            }
            case 103: {
                this.BIT(4, this.getA());
                break;
            }
            case 104: {
                this.BIT(5, this.getB());
                break;
            }
            case 105: {
                this.BIT(5, this.getC());
                break;
            }
            case 106: {
                this.BIT(5, this.getD());
                break;
            }
            case 107: {
                this.BIT(5, this.getE());
                break;
            }
            case 108: {
                this.BIT(5, this.getH());
                break;
            }
            case 109: {
                this.BIT(5, this.getL());
                break;
            }
            case 110: {
                this.BIT(5, this.memReadByte(this.HL));
                break;
            }
            case 111: {
                this.BIT(5, this.getA());
                break;
            }
            case 112: {
                this.BIT(6, this.getB());
                break;
            }
            case 113: {
                this.BIT(6, this.getC());
                break;
            }
            case 114: {
                this.BIT(6, this.getD());
                break;
            }
            case 115: {
                this.BIT(6, this.getE());
                break;
            }
            case 116: {
                this.BIT(6, this.getH());
                break;
            }
            case 117: {
                this.BIT(6, this.getL());
                break;
            }
            case 118: {
                this.BIT(6, this.memReadByte(this.HL));
                break;
            }
            case 119: {
                this.BIT(6, this.getA());
                break;
            }
            case 120: {
                this.BIT(7, this.getB());
                break;
            }
            case 121: {
                this.BIT(7, this.getC());
                break;
            }
            case 122: {
                this.BIT(7, this.getD());
                break;
            }
            case 123: {
                this.BIT(7, this.getE());
                break;
            }
            case 124: {
                this.BIT(7, this.getH());
                break;
            }
            case 125: {
                this.BIT(7, this.getL());
                break;
            }
            case 126: {
                this.BIT(7, this.memReadByte(this.HL));
                break;
            }
            case 127: {
                this.BIT(7, this.getA());
                break;
            }
            case 128: {
                this.setB(this.RES(0, this.getB()));
                break;
            }
            case 129: {
                this.setC(this.RES(0, this.getC()));
                break;
            }
            case 130: {
                this.setD(this.RES(0, this.getD()));
                break;
            }
            case 131: {
                this.setE(this.RES(0, this.getE()));
                break;
            }
            case 132: {
                this.setH(this.RES(0, this.getH()));
                break;
            }
            case 133: {
                this.setL(this.RES(0, this.getL()));
                break;
            }
            case 134: {
                this.memWriteByte(this.HL, this.RES(0, this.memReadByte(this.HL)));
                break;
            }
            case 135: {
                this.setA(this.RES(0, this.getA()));
                break;
            }
            case 136: {
                this.setB(this.RES(1, this.getB()));
                break;
            }
            case 137: {
                this.setC(this.RES(1, this.getC()));
                break;
            }
            case 138: {
                this.setD(this.RES(1, this.getD()));
                break;
            }
            case 139: {
                this.setE(this.RES(1, this.getE()));
                break;
            }
            case 140: {
                this.setH(this.RES(1, this.getH()));
                break;
            }
            case 141: {
                this.setL(this.RES(1, this.getL()));
                break;
            }
            case 142: {
                this.memWriteByte(this.HL, this.RES(1, this.memReadByte(this.HL)));
                break;
            }
            case 143: {
                this.setA(this.RES(1, this.getA()));
                break;
            }
            case 144: {
                this.setB(this.RES(2, this.getB()));
                break;
            }
            case 145: {
                this.setC(this.RES(2, this.getC()));
                break;
            }
            case 146: {
                this.setD(this.RES(2, this.getD()));
                break;
            }
            case 147: {
                this.setE(this.RES(2, this.getE()));
                break;
            }
            case 148: {
                this.setH(this.RES(2, this.getH()));
                break;
            }
            case 149: {
                this.setL(this.RES(2, this.getL()));
                break;
            }
            case 150: {
                this.memWriteByte(this.HL, this.RES(2, this.memReadByte(this.HL)));
                break;
            }
            case 151: {
                this.setA(this.RES(2, this.getA()));
                break;
            }
            case 152: {
                this.setB(this.RES(3, this.getB()));
                break;
            }
            case 153: {
                this.setC(this.RES(3, this.getC()));
                break;
            }
            case 154: {
                this.setD(this.RES(3, this.getD()));
                break;
            }
            case 155: {
                this.setE(this.RES(3, this.getE()));
                break;
            }
            case 156: {
                this.setH(this.RES(3, this.getH()));
                break;
            }
            case 157: {
                this.setL(this.RES(3, this.getL()));
                break;
            }
            case 158: {
                this.memWriteByte(this.HL, this.RES(3, this.memReadByte(this.HL)));
                break;
            }
            case 159: {
                this.setA(this.RES(3, this.getA()));
                break;
            }
            case 160: {
                this.setB(this.RES(4, this.getB()));
                break;
            }
            case 161: {
                this.setC(this.RES(4, this.getC()));
                break;
            }
            case 162: {
                this.setD(this.RES(4, this.getD()));
                break;
            }
            case 163: {
                this.setE(this.RES(4, this.getE()));
                break;
            }
            case 164: {
                this.setH(this.RES(4, this.getH()));
                break;
            }
            case 165: {
                this.setL(this.RES(4, this.getL()));
                break;
            }
            case 166: {
                this.memWriteByte(this.HL, this.RES(4, this.memReadByte(this.HL)));
                break;
            }
            case 167: {
                this.setA(this.RES(4, this.getA()));
                break;
            }
            case 168: {
                this.setB(this.RES(5, this.getB()));
                break;
            }
            case 169: {
                this.setC(this.RES(5, this.getC()));
                break;
            }
            case 170: {
                this.setD(this.RES(5, this.getD()));
                break;
            }
            case 171: {
                this.setE(this.RES(5, this.getE()));
                break;
            }
            case 172: {
                this.setH(this.RES(5, this.getH()));
                break;
            }
            case 173: {
                this.setL(this.RES(5, this.getL()));
                break;
            }
            case 174: {
                this.memWriteByte(this.HL, this.RES(5, this.memReadByte(this.HL)));
                break;
            }
            case 175: {
                this.setA(this.RES(5, this.getA()));
                break;
            }
            case 176: {
                this.setB(this.RES(6, this.getB()));
                break;
            }
            case 177: {
                this.setC(this.RES(6, this.getC()));
                break;
            }
            case 178: {
                this.setD(this.RES(6, this.getD()));
                break;
            }
            case 179: {
                this.setE(this.RES(6, this.getE()));
                break;
            }
            case 180: {
                this.setH(this.RES(6, this.getH()));
                break;
            }
            case 181: {
                this.setL(this.RES(6, this.getL()));
                break;
            }
            case 182: {
                this.memWriteByte(this.HL, this.RES(6, this.memReadByte(this.HL)));
                break;
            }
            case 183: {
                this.setA(this.RES(6, this.getA()));
                break;
            }
            case 184: {
                this.setB(this.RES(7, this.getB()));
                break;
            }
            case 185: {
                this.setC(this.RES(7, this.getC()));
                break;
            }
            case 186: {
                this.setD(this.RES(7, this.getD()));
                break;
            }
            case 187: {
                this.setE(this.RES(7, this.getE()));
                break;
            }
            case 188: {
                this.setH(this.RES(7, this.getH()));
                break;
            }
            case 189: {
                this.setL(this.RES(7, this.getL()));
                break;
            }
            case 190: {
                this.memWriteByte(this.HL, this.RES(7, this.memReadByte(this.HL)));
                break;
            }
            case 191: {
                this.setA(this.RES(7, this.getA()));
                break;
            }
            case 192: {
                this.setB(this.SET(0, this.getB()));
                break;
            }
            case 193: {
                this.setC(this.SET(0, this.getC()));
                break;
            }
            case 194: {
                this.setD(this.SET(0, this.getD()));
                break;
            }
            case 195: {
                this.setE(this.SET(0, this.getE()));
                break;
            }
            case 196: {
                this.setH(this.SET(0, this.getH()));
                break;
            }
            case 197: {
                this.setL(this.SET(0, this.getL()));
                break;
            }
            case 198: {
                this.memWriteByte(this.HL, this.SET(0, this.memReadByte(this.HL)));
                break;
            }
            case 199: {
                this.setA(this.SET(0, this.getA()));
                break;
            }
            case 200: {
                this.setB(this.SET(1, this.getB()));
                break;
            }
            case 201: {
                this.setC(this.SET(1, this.getC()));
                break;
            }
            case 202: {
                this.setD(this.SET(1, this.getD()));
                break;
            }
            case 203: {
                this.setE(this.SET(1, this.getE()));
                break;
            }
            case 204: {
                this.setH(this.SET(1, this.getH()));
                break;
            }
            case 205: {
                this.setL(this.SET(1, this.getL()));
                break;
            }
            case 206: {
                this.memWriteByte(this.HL, this.SET(1, this.memReadByte(this.HL)));
                break;
            }
            case 207: {
                this.setA(this.SET(1, this.getA()));
                break;
            }
            case 208: {
                this.setB(this.SET(2, this.getB()));
                break;
            }
            case 209: {
                this.setC(this.SET(2, this.getC()));
                break;
            }
            case 210: {
                this.setD(this.SET(2, this.getD()));
                break;
            }
            case 211: {
                this.setE(this.SET(2, this.getE()));
                break;
            }
            case 212: {
                this.setH(this.SET(2, this.getH()));
                break;
            }
            case 213: {
                this.setL(this.SET(2, this.getL()));
                break;
            }
            case 214: {
                this.memWriteByte(this.HL, this.SET(2, this.memReadByte(this.HL)));
                break;
            }
            case 215: {
                this.setA(this.SET(2, this.getA()));
                break;
            }
            case 216: {
                this.setB(this.SET(3, this.getB()));
                break;
            }
            case 217: {
                this.setC(this.SET(3, this.getC()));
                break;
            }
            case 218: {
                this.setD(this.SET(3, this.getD()));
                break;
            }
            case 219: {
                this.setE(this.SET(3, this.getE()));
                break;
            }
            case 220: {
                this.setH(this.SET(3, this.getH()));
                break;
            }
            case 221: {
                this.setL(this.SET(3, this.getL()));
                break;
            }
            case 222: {
                this.memWriteByte(this.HL, this.SET(3, this.memReadByte(this.HL)));
                break;
            }
            case 223: {
                this.setA(this.SET(3, this.getA()));
                break;
            }
            case 224: {
                this.setB(this.SET(4, this.getB()));
                break;
            }
            case 225: {
                this.setC(this.SET(4, this.getC()));
                break;
            }
            case 226: {
                this.setD(this.SET(4, this.getD()));
                break;
            }
            case 227: {
                this.setE(this.SET(4, this.getE()));
                break;
            }
            case 228: {
                this.setH(this.SET(4, this.getH()));
                break;
            }
            case 229: {
                this.setL(this.SET(4, this.getL()));
                break;
            }
            case 230: {
                this.memWriteByte(this.HL, this.SET(4, this.memReadByte(this.HL)));
                break;
            }
            case 231: {
                this.setA(this.SET(4, this.getA()));
                break;
            }
            case 232: {
                this.setB(this.SET(5, this.getB()));
                break;
            }
            case 233: {
                this.setC(this.SET(5, this.getC()));
                break;
            }
            case 234: {
                this.setD(this.SET(5, this.getD()));
                break;
            }
            case 235: {
                this.setE(this.SET(5, this.getE()));
                break;
            }
            case 236: {
                this.setH(this.SET(5, this.getH()));
                break;
            }
            case 237: {
                this.setL(this.SET(5, this.getL()));
                break;
            }
            case 238: {
                this.memWriteByte(this.HL, this.SET(5, this.memReadByte(this.HL)));
                break;
            }
            case 239: {
                this.setA(this.SET(5, this.getA()));
                break;
            }
            case 240: {
                this.setB(this.SET(6, this.getB()));
                break;
            }
            case 241: {
                this.setC(this.SET(6, this.getC()));
                break;
            }
            case 242: {
                this.setD(this.SET(6, this.getD()));
                break;
            }
            case 243: {
                this.setE(this.SET(6, this.getE()));
                break;
            }
            case 244: {
                this.setH(this.SET(6, this.getH()));
                break;
            }
            case 245: {
                this.setL(this.SET(6, this.getL()));
                break;
            }
            case 246: {
                this.memWriteByte(this.HL, this.SET(6, this.memReadByte(this.HL)));
                break;
            }
            case 247: {
                this.setA(this.SET(6, this.getA()));
                break;
            }
            case 248: {
                this.setB(this.SET(7, this.getB()));
                break;
            }
            case 249: {
                this.setC(this.SET(7, this.getC()));
                break;
            }
            case 250: {
                this.setD(this.SET(7, this.getD()));
                break;
            }
            case 251: {
                this.setE(this.SET(7, this.getE()));
                break;
            }
            case 252: {
                this.setH(this.SET(7, this.getH()));
                break;
            }
            case 253: {
                this.setL(this.SET(7, this.getL()));
                break;
            }
            case 254: {
                this.memWriteByte(this.HL, this.SET(7, this.memReadByte(this.HL)));
                break;
            }
            case 255: {
                this.setA(this.SET(7, this.getA()));
            }
        }
        this.cyclesToDo -= cycles_cb_opcode[n];
    }

    private final int exe_dd_opcode(int n, int n2) {
        this.XY = n;
        switch (n2) {
            case 203: {
                this.exe_dd_cb_opcode(this.memReadByte(++this.PC));
                break;
            }
            case 237: {
                this.exe_ed_opcode(this.memReadByte(this.PC++));
                break;
            }
            case 221: {
                this.IX = this.exe_dd_opcode(this.IX, this.memReadByte(this.PC++));
                break;
            }
            case 253: {
                this.IY = this.exe_dd_opcode(this.IY, this.memReadByte(this.PC++));
                break;
            }
            case 9: {
                this.XY = this.ADD16(this.XY, this.BC);
                break;
            }
            case 25: {
                this.XY = this.ADD16(this.XY, this.DE);
                break;
            }
            case 33: {
                this.XY = this.memReadWord(this.PC);
                this.PC += 2;
                break;
            }
            case 34: {
                this.memWriteWord(this.memReadWord(this.PC), this.XY);
                this.PC += 2;
                break;
            }
            case 35: {
                ++this.XY;
                this.XY &= 0xFFFF;
                break;
            }
            case 36: {
                this.setXYH(this.INC(this.getXYH()));
                break;
            }
            case 37: {
                this.setXYH(this.DEC(this.getXYH()));
                break;
            }
            case 38: {
                this.setXYH(this.memReadByte(this.PC++));
                break;
            }
            case 41: {
                this.XY = this.ADD16(this.XY, this.XY);
                break;
            }
            case 42: {
                this.XY = this.memReadWord(this.memReadWord(this.PC));
                this.PC += 2;
                break;
            }
            case 43: {
                --this.XY;
                this.XY &= 0xFFFF;
                break;
            }
            case 44: {
                this.setXYL(this.INC(this.getXYL()));
                break;
            }
            case 45: {
                this.setXYL(this.DEC(this.getXYL()));
                break;
            }
            case 46: {
                this.setXYL(this.memReadByte(this.PC++));
                break;
            }
            case 52: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.INC(this.memReadByte(this.word)));
                break;
            }
            case 53: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.DEC(this.memReadByte(this.word)));
                break;
            }
            case 54: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.memReadByte(this.PC++));
                break;
            }
            case 57: {
                this.XY = this.ADD16(this.XY, this.SP);
                break;
            }
            case 68: {
                this.setB(this.getXYH());
                break;
            }
            case 69: {
                this.setB(this.getXYL());
                break;
            }
            case 70: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setB(this.memReadByte(this.word));
                break;
            }
            case 76: {
                this.setC(this.getXYH());
                break;
            }
            case 77: {
                this.setC(this.getXYL());
                break;
            }
            case 78: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setC(this.memReadByte(this.word));
                break;
            }
            case 84: {
                this.setD(this.getXYH());
                break;
            }
            case 85: {
                this.setD(this.getXYL());
                break;
            }
            case 86: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setD(this.memReadByte(this.word));
                break;
            }
            case 92: {
                this.setE(this.getXYH());
                break;
            }
            case 93: {
                this.setE(this.getXYL());
                break;
            }
            case 94: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setE(this.memReadByte(this.word));
                break;
            }
            case 96: {
                this.setXYH(this.getB());
                break;
            }
            case 97: {
                this.setXYH(this.getC());
                break;
            }
            case 98: {
                this.setXYH(this.getD());
                break;
            }
            case 99: {
                this.setXYH(this.getE());
                break;
            }
            case 100: {
                break;
            }
            case 101: {
                this.setXYH(this.getXYL());
                break;
            }
            case 102: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setH(this.memReadByte(this.word));
                break;
            }
            case 103: {
                this.setXYH(this.getA());
                break;
            }
            case 104: {
                this.setXYL(this.getB());
                break;
            }
            case 105: {
                this.setXYL(this.getC());
                break;
            }
            case 106: {
                this.setXYL(this.getD());
                break;
            }
            case 107: {
                this.setXYL(this.getE());
                break;
            }
            case 108: {
                this.setXYL(this.getXYH());
                break;
            }
            case 109: {
                break;
            }
            case 110: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setL(this.memReadByte(this.word));
                break;
            }
            case 111: {
                this.setXYL(this.getA());
                break;
            }
            case 112: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getB());
                break;
            }
            case 113: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getC());
                break;
            }
            case 114: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getD());
                break;
            }
            case 115: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getE());
                break;
            }
            case 116: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getH());
                break;
            }
            case 117: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getL());
                break;
            }
            case 119: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.memWriteByte(this.word, this.getA());
                break;
            }
            case 124: {
                this.setA(this.getXYH());
                break;
            }
            case 125: {
                this.setA(this.getXYL());
                break;
            }
            case 126: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.setA(this.memReadByte(this.word));
                break;
            }
            case 132: {
                this.ADD(this.getXYH());
                break;
            }
            case 133: {
                this.ADD(this.getXYL());
                break;
            }
            case 134: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.ADD(this.memReadByte(this.word));
                break;
            }
            case 140: {
                this.ADC(this.getXYH());
                break;
            }
            case 141: {
                this.ADC(this.getXYL());
                break;
            }
            case 142: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.ADC(this.memReadByte(this.word));
                break;
            }
            case 148: {
                this.SUB(this.getXYH());
                break;
            }
            case 149: {
                this.SUB(this.getXYL());
                break;
            }
            case 150: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.SUB(this.memReadByte(this.word));
                break;
            }
            case 156: {
                this.SBC(this.getXYH());
                break;
            }
            case 157: {
                this.SBC(this.getXYL());
                break;
            }
            case 158: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.SBC(this.memReadByte(this.word));
                break;
            }
            case 164: {
                this.AND(this.getXYH());
                break;
            }
            case 165: {
                this.AND(this.getXYL());
                break;
            }
            case 166: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.AND(this.memReadByte(this.word));
                break;
            }
            case 172: {
                this.XOR(this.getXYH());
                break;
            }
            case 173: {
                this.XOR(this.getXYL());
                break;
            }
            case 174: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.XOR(this.memReadByte(this.word));
                break;
            }
            case 180: {
                this.OR(this.getXYH());
                break;
            }
            case 181: {
                this.OR(this.getXYL());
                break;
            }
            case 182: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.OR(this.memReadByte(this.word));
                break;
            }
            case 188: {
                this.CP(this.getXYH());
                break;
            }
            case 189: {
                this.CP(this.getXYL());
                break;
            }
            case 190: {
                this.word = this.XY + (byte)this.memReadByte(this.PC++);
                this.word &= 0xFFFF;
                this.CP(this.memReadByte(this.word));
                break;
            }
            case 225: {
                this.XY = this.POP();
                break;
            }
            case 227: {
                this.word = this.memReadWord(this.SP);
                this.memWriteWord(this.SP, this.XY);
                this.XY = this.word;
                break;
            }
            case 229: {
                this.PUSH(this.XY);
                break;
            }
            case 233: {
                this.PC = this.XY;
                break;
            }
            case 249: {
                this.SP = this.XY;
            }
        }
        this.cyclesToDo -= cycles_dd_opcode[n2];
        return this.XY;
    }

    private final void exe_dd_cb_opcode(int n) {
        --this.PC;
        switch (n) {
            case 0: {
                this.setB(this.LD_RLC(this.XY));
                break;
            }
            case 1: {
                this.setC(this.LD_RLC(this.XY));
                break;
            }
            case 2: {
                this.setD(this.LD_RLC(this.XY));
                break;
            }
            case 3: {
                this.setE(this.LD_RLC(this.XY));
                break;
            }
            case 4: {
                this.setH(this.LD_RLC(this.XY));
                break;
            }
            case 5: {
                this.setL(this.LD_RLC(this.XY));
                break;
            }
            case 6: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RLC(this.memReadByte(this.addr)));
                break;
            }
            case 7: {
                this.setA(this.LD_RLC(this.XY));
                break;
            }
            case 8: {
                this.setB(this.LD_RRC(this.XY));
                break;
            }
            case 9: {
                this.setC(this.LD_RRC(this.XY));
                break;
            }
            case 10: {
                this.setD(this.LD_RRC(this.XY));
                break;
            }
            case 11: {
                this.setE(this.LD_RRC(this.XY));
                break;
            }
            case 12: {
                this.setH(this.LD_RRC(this.XY));
                break;
            }
            case 13: {
                this.setL(this.LD_RRC(this.XY));
                break;
            }
            case 14: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RRC(this.memReadByte(this.addr)));
                break;
            }
            case 15: {
                this.setA(this.LD_RRC(this.XY));
                break;
            }
            case 16: {
                this.setB(this.LD_RL(this.XY));
                break;
            }
            case 17: {
                this.setC(this.LD_RL(this.XY));
                break;
            }
            case 18: {
                this.setD(this.LD_RL(this.XY));
                break;
            }
            case 19: {
                this.setE(this.LD_RL(this.XY));
                break;
            }
            case 20: {
                this.setH(this.LD_RL(this.XY));
                break;
            }
            case 21: {
                this.setL(this.LD_RL(this.XY));
                break;
            }
            case 22: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RL(this.memReadByte(this.addr)));
                break;
            }
            case 23: {
                this.setA(this.LD_RL(this.XY));
                break;
            }
            case 24: {
                this.setB(this.LD_RR(this.XY));
                break;
            }
            case 25: {
                this.setC(this.LD_RR(this.XY));
                break;
            }
            case 26: {
                this.setD(this.LD_RR(this.XY));
                break;
            }
            case 27: {
                this.setE(this.LD_RR(this.XY));
                break;
            }
            case 28: {
                this.setH(this.LD_RR(this.XY));
                break;
            }
            case 29: {
                this.setL(this.LD_RR(this.XY));
                break;
            }
            case 30: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RR(this.memReadByte(this.addr)));
                break;
            }
            case 31: {
                this.setA(this.LD_RR(this.XY));
                break;
            }
            case 32: {
                this.setB(this.LD_SLA(this.XY));
                break;
            }
            case 33: {
                this.setC(this.LD_SLA(this.XY));
                break;
            }
            case 34: {
                this.setD(this.LD_SLA(this.XY));
                break;
            }
            case 35: {
                this.setE(this.LD_SLA(this.XY));
                break;
            }
            case 36: {
                this.setH(this.LD_SLA(this.XY));
                break;
            }
            case 37: {
                this.setL(this.LD_SLA(this.XY));
                break;
            }
            case 38: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SLA(this.memReadByte(this.addr)));
                break;
            }
            case 39: {
                this.setA(this.LD_SLA(this.XY));
                break;
            }
            case 40: {
                this.setB(this.LD_SRA(this.XY));
                break;
            }
            case 41: {
                this.setC(this.LD_SRA(this.XY));
                break;
            }
            case 42: {
                this.setD(this.LD_SRA(this.XY));
                break;
            }
            case 43: {
                this.setE(this.LD_SRA(this.XY));
                break;
            }
            case 44: {
                this.setH(this.LD_SRA(this.XY));
                break;
            }
            case 45: {
                this.setL(this.LD_SRA(this.XY));
                break;
            }
            case 46: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SRA(this.memReadByte(this.addr)));
                break;
            }
            case 47: {
                this.setA(this.LD_SRA(this.XY));
                break;
            }
            case 48: {
                this.setB(this.LD_SLL(this.XY));
                break;
            }
            case 49: {
                this.setC(this.LD_SLL(this.XY));
                break;
            }
            case 50: {
                this.setD(this.LD_SLL(this.XY));
                break;
            }
            case 51: {
                this.setE(this.LD_SLL(this.XY));
                break;
            }
            case 52: {
                this.setH(this.LD_SLL(this.XY));
                break;
            }
            case 53: {
                this.setL(this.LD_SLL(this.XY));
                break;
            }
            case 54: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SLL(this.memReadByte(this.addr)));
                break;
            }
            case 55: {
                this.setA(this.LD_SLL(this.XY));
                break;
            }
            case 56: {
                this.setB(this.LD_SRL(this.XY));
                break;
            }
            case 57: {
                this.setC(this.LD_SRL(this.XY));
                break;
            }
            case 58: {
                this.setD(this.LD_SRL(this.XY));
                break;
            }
            case 59: {
                this.setE(this.LD_SRL(this.XY));
                break;
            }
            case 60: {
                this.setH(this.LD_SRL(this.XY));
                break;
            }
            case 61: {
                this.setL(this.LD_SRL(this.XY));
                break;
            }
            case 62: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SRL(this.memReadByte(this.addr)));
                break;
            }
            case 63: {
                this.setA(this.LD_SRL(this.XY));
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                this.BIT(0, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                this.BIT(1, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                this.BIT(2, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.BIT(3, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                this.BIT(4, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                this.BIT(5, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                this.BIT(6, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                this.BIT(7, this.memReadByte(this.XY + (byte)this.memReadByte(this.PC++)));
                break;
            }
            case 128: {
                this.setB(this.LD_RES(this.XY, 0));
                break;
            }
            case 129: {
                this.setC(this.LD_RES(this.XY, 0));
                break;
            }
            case 130: {
                this.setD(this.LD_RES(this.XY, 0));
                break;
            }
            case 131: {
                this.setE(this.LD_RES(this.XY, 0));
                break;
            }
            case 132: {
                this.setH(this.LD_RES(this.XY, 0));
                break;
            }
            case 133: {
                this.setL(this.LD_RES(this.XY, 0));
                break;
            }
            case 134: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(0, this.memReadByte(this.addr)));
                break;
            }
            case 135: {
                this.setA(this.LD_RES(this.XY, 0));
                break;
            }
            case 136: {
                this.setB(this.LD_RES(this.XY, 1));
                break;
            }
            case 137: {
                this.setC(this.LD_RES(this.XY, 1));
                break;
            }
            case 138: {
                this.setD(this.LD_RES(this.XY, 1));
                break;
            }
            case 139: {
                this.setE(this.LD_RES(this.XY, 1));
                break;
            }
            case 140: {
                this.setH(this.LD_RES(this.XY, 1));
                break;
            }
            case 141: {
                this.setL(this.LD_RES(this.XY, 1));
                break;
            }
            case 142: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(1, this.memReadByte(this.addr)));
                break;
            }
            case 143: {
                this.setA(this.LD_RES(this.XY, 1));
                break;
            }
            case 144: {
                this.setB(this.LD_RES(this.XY, 2));
                break;
            }
            case 145: {
                this.setC(this.LD_RES(this.XY, 2));
                break;
            }
            case 146: {
                this.setD(this.LD_RES(this.XY, 2));
                break;
            }
            case 147: {
                this.setE(this.LD_RES(this.XY, 2));
                break;
            }
            case 148: {
                this.setH(this.LD_RES(this.XY, 2));
                break;
            }
            case 149: {
                this.setL(this.LD_RES(this.XY, 2));
                break;
            }
            case 150: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(2, this.memReadByte(this.addr)));
                break;
            }
            case 151: {
                this.setA(this.LD_RES(this.XY, 2));
                break;
            }
            case 152: {
                this.setB(this.LD_RES(this.XY, 3));
                break;
            }
            case 153: {
                this.setC(this.LD_RES(this.XY, 3));
                break;
            }
            case 154: {
                this.setD(this.LD_RES(this.XY, 3));
                break;
            }
            case 155: {
                this.setE(this.LD_RES(this.XY, 3));
                break;
            }
            case 156: {
                this.setH(this.LD_RES(this.XY, 3));
                break;
            }
            case 157: {
                this.setL(this.LD_RES(this.XY, 3));
                break;
            }
            case 158: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(3, this.memReadByte(this.addr)));
                break;
            }
            case 159: {
                this.setA(this.LD_RES(this.XY, 3));
                break;
            }
            case 160: {
                this.setB(this.LD_RES(this.XY, 4));
                break;
            }
            case 161: {
                this.setC(this.LD_RES(this.XY, 4));
                break;
            }
            case 162: {
                this.setD(this.LD_RES(this.XY, 4));
                break;
            }
            case 163: {
                this.setE(this.LD_RES(this.XY, 4));
                break;
            }
            case 164: {
                this.setH(this.LD_RES(this.XY, 4));
                break;
            }
            case 165: {
                this.setL(this.LD_RES(this.XY, 4));
                break;
            }
            case 166: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(4, this.memReadByte(this.addr)));
                break;
            }
            case 167: {
                this.setA(this.LD_RES(this.XY, 4));
                break;
            }
            case 168: {
                this.setB(this.LD_RES(this.XY, 5));
                break;
            }
            case 169: {
                this.setC(this.LD_RES(this.XY, 5));
                break;
            }
            case 170: {
                this.setD(this.LD_RES(this.XY, 5));
                break;
            }
            case 171: {
                this.setE(this.LD_RES(this.XY, 5));
                break;
            }
            case 172: {
                this.setH(this.LD_RES(this.XY, 5));
                break;
            }
            case 173: {
                this.setL(this.LD_RES(this.XY, 5));
                break;
            }
            case 174: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(5, this.memReadByte(this.addr)));
                break;
            }
            case 175: {
                this.setA(this.LD_RES(this.XY, 5));
                break;
            }
            case 176: {
                this.setB(this.LD_RES(this.XY, 6));
                break;
            }
            case 177: {
                this.setC(this.LD_RES(this.XY, 6));
                break;
            }
            case 178: {
                this.setD(this.LD_RES(this.XY, 6));
                break;
            }
            case 179: {
                this.setE(this.LD_RES(this.XY, 6));
                break;
            }
            case 180: {
                this.setH(this.LD_RES(this.XY, 6));
                break;
            }
            case 181: {
                this.setL(this.LD_RES(this.XY, 6));
                break;
            }
            case 182: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(6, this.memReadByte(this.addr)));
                break;
            }
            case 183: {
                this.setA(this.LD_RES(this.XY, 6));
                break;
            }
            case 184: {
                this.setB(this.LD_RES(this.XY, 7));
                break;
            }
            case 185: {
                this.setC(this.LD_RES(this.XY, 7));
                break;
            }
            case 186: {
                this.setD(this.LD_RES(this.XY, 7));
                break;
            }
            case 187: {
                this.setE(this.LD_RES(this.XY, 7));
                break;
            }
            case 188: {
                this.setH(this.LD_RES(this.XY, 7));
                break;
            }
            case 189: {
                this.setL(this.LD_RES(this.XY, 7));
                break;
            }
            case 190: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.RES(7, this.memReadByte(this.addr)));
                break;
            }
            case 191: {
                this.setA(this.LD_RES(this.XY, 7));
                break;
            }
            case 192: {
                this.setB(this.LD_SET(this.XY, 0));
                break;
            }
            case 193: {
                this.setC(this.LD_SET(this.XY, 0));
                break;
            }
            case 194: {
                this.setD(this.LD_SET(this.XY, 0));
                break;
            }
            case 195: {
                this.setE(this.LD_SET(this.XY, 0));
                break;
            }
            case 196: {
                this.setH(this.LD_SET(this.XY, 0));
                break;
            }
            case 197: {
                this.setL(this.LD_SET(this.XY, 0));
                break;
            }
            case 198: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(0, this.memReadByte(this.addr)));
                break;
            }
            case 199: {
                this.setA(this.LD_SET(this.XY, 0));
                break;
            }
            case 200: {
                this.setB(this.LD_SET(this.XY, 1));
                break;
            }
            case 201: {
                this.setC(this.LD_SET(this.XY, 1));
                break;
            }
            case 202: {
                this.setD(this.LD_SET(this.XY, 1));
                break;
            }
            case 203: {
                this.setE(this.LD_SET(this.XY, 1));
                break;
            }
            case 204: {
                this.setH(this.LD_SET(this.XY, 1));
                break;
            }
            case 205: {
                this.setL(this.LD_SET(this.XY, 1));
                break;
            }
            case 206: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(1, this.memReadByte(this.addr)));
                break;
            }
            case 207: {
                this.setA(this.LD_SET(this.XY, 1));
                break;
            }
            case 208: {
                this.setB(this.LD_SET(this.XY, 2));
                break;
            }
            case 209: {
                this.setC(this.LD_SET(this.XY, 2));
                break;
            }
            case 210: {
                this.setD(this.LD_SET(this.XY, 2));
                break;
            }
            case 211: {
                this.setE(this.LD_SET(this.XY, 2));
                break;
            }
            case 212: {
                this.setH(this.LD_SET(this.XY, 2));
                break;
            }
            case 213: {
                this.setL(this.LD_SET(this.XY, 2));
                break;
            }
            case 214: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(2, this.memReadByte(this.addr)));
                break;
            }
            case 215: {
                this.setA(this.LD_SET(this.XY, 2));
                break;
            }
            case 216: {
                this.setB(this.LD_SET(this.XY, 3));
                break;
            }
            case 217: {
                this.setC(this.LD_SET(this.XY, 3));
                break;
            }
            case 218: {
                this.setD(this.LD_SET(this.XY, 3));
                break;
            }
            case 219: {
                this.setE(this.LD_SET(this.XY, 3));
                break;
            }
            case 220: {
                this.setH(this.LD_SET(this.XY, 3));
                break;
            }
            case 221: {
                this.setL(this.LD_SET(this.XY, 3));
                break;
            }
            case 222: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(3, this.memReadByte(this.addr)));
                break;
            }
            case 223: {
                this.setA(this.LD_SET(this.XY, 3));
                break;
            }
            case 224: {
                this.setB(this.LD_SET(this.XY, 4));
                break;
            }
            case 225: {
                this.setC(this.LD_SET(this.XY, 4));
                break;
            }
            case 226: {
                this.setD(this.LD_SET(this.XY, 4));
                break;
            }
            case 227: {
                this.setE(this.LD_SET(this.XY, 4));
                break;
            }
            case 228: {
                this.setH(this.LD_SET(this.XY, 4));
                break;
            }
            case 229: {
                this.setL(this.LD_SET(this.XY, 4));
                break;
            }
            case 230: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(4, this.memReadByte(this.addr)));
                break;
            }
            case 231: {
                this.setA(this.LD_SET(this.XY, 4));
                break;
            }
            case 232: {
                this.setB(this.LD_SET(this.XY, 5));
                break;
            }
            case 233: {
                this.setC(this.LD_SET(this.XY, 5));
                break;
            }
            case 234: {
                this.setD(this.LD_SET(this.XY, 5));
                break;
            }
            case 235: {
                this.setE(this.LD_SET(this.XY, 5));
                break;
            }
            case 236: {
                this.setH(this.LD_SET(this.XY, 5));
                break;
            }
            case 237: {
                this.setL(this.LD_SET(this.XY, 5));
                break;
            }
            case 238: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(5, this.memReadByte(this.addr)));
                break;
            }
            case 239: {
                this.setA(this.LD_SET(this.XY, 5));
                break;
            }
            case 240: {
                this.setB(this.LD_SET(this.XY, 6));
                break;
            }
            case 241: {
                this.setC(this.LD_SET(this.XY, 6));
                break;
            }
            case 242: {
                this.setD(this.LD_SET(this.XY, 6));
                break;
            }
            case 243: {
                this.setE(this.LD_SET(this.XY, 6));
                break;
            }
            case 244: {
                this.setH(this.LD_SET(this.XY, 6));
                break;
            }
            case 245: {
                this.setL(this.LD_SET(this.XY, 6));
                break;
            }
            case 246: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(6, this.memReadByte(this.addr)));
                break;
            }
            case 247: {
                this.setA(this.LD_SET(this.XY, 6));
                break;
            }
            case 248: {
                this.setB(this.LD_SET(this.XY, 7));
                break;
            }
            case 249: {
                this.setC(this.LD_SET(this.XY, 7));
                break;
            }
            case 250: {
                this.setD(this.LD_SET(this.XY, 7));
                break;
            }
            case 251: {
                this.setE(this.LD_SET(this.XY, 7));
                break;
            }
            case 252: {
                this.setH(this.LD_SET(this.XY, 7));
                break;
            }
            case 253: {
                this.setL(this.LD_SET(this.XY, 7));
                break;
            }
            case 254: {
                this.addr = this.XY + (byte)this.memReadByte(this.PC++);
                this.addr &= 0xFFFF;
                this.memWriteByte(this.addr, this.SET(7, this.memReadByte(this.addr)));
                break;
            }
            case 255: {
                this.setA(this.LD_SET(this.XY, 7));
            }
        }
        ++this.PC;
        this.cyclesToDo -= cycles_xx_cb_opcode[n];
    }

    public final void run(int n) {
        this.cyclesToDo += n;
        this.Interrupt();
        while (this.cyclesToDo > 0) {
            this.UpdateR();
            switch (this.enable) {
                case 2: {
                    this.IFF2 = 1;
                    this.IFF1 = 1;
                    this.Interrupt();
                    this.enable = 0;
                    break;
                }
                case 1: {
                    this.enable = 2;
                }
            }
            if (!this.halted) {
                this.exeOpcode(this.memReadByte(this.PC++));
                this.PC &= 0xFFFF;
                continue;
            }
            this.cyclesToDo -= 4;
            this.Interrupt();
        }
    }

    public final void PendingIRQ(int n) {
        this.vector = n;
        this.IRQ = 1;
        if (this.IFF1 != 0) {
            this.CheckIRQ();
        }
    }

    public final void PendingNMI() {
        this.NMIInt = 1;
    }

    public final void CheckIRQ() {
        if (this.IFF1 == 0 || this.IRQ == 0) {
            return;
        }
        this.IFF2 = 0;
        this.IFF1 = 0;
        this.IRQ = 0;
        this.halted = false;
        this.UpdateR();
        switch (this.IM) {
            case 0: {
                this.exeOpcode(this.vector);
                break;
            }
            case 1: {
                this.SP -= 2;
                this.SP &= 0xFFFF;
                this.memWriteWord(this.SP, this.PC);
                this.PC = 56;
                this.cyclesToDo -= 13;
                break;
            }
            case 2: {
                this.SP -= 2;
                this.SP &= 0xFFFF;
                this.memWriteWord(this.SP, this.PC);
                this.PC = this.memReadWord((this.I << 8) + this.vector);
                this.cyclesToDo -= 19;
            }
        }
    }

    private final void PF_Table_init() {
        int n = 0;
        while (n <= 255) {
            byte by = 0;
            int n2 = 0;
            while (n2 <= 7) {
                if ((n & 1 << n2) != 0) {
                    by = (byte)(by ^ 1);
                }
                ++n2;
            }
            Z80.PF_Table[n] = by;
            ++n;
        }
    }

    public final void NMI() {
        this.IFF1 = 0;
        this.NMIInt = 0;
        this.halted = false;
        this.SP -= 2;
        this.SP &= 0xFFFF;
        this.memWriteWord(this.SP, this.PC);
        this.PC = this.NMI_PC;
    }

    public final void Interrupt() {
        if (this.NMIInt != 0) {
            this.NMI();
            this.cyclesToDo -= 11;
            return;
        }
        if (this.IFF1 != 0 && this.IRQ != 0) {
            this.CheckIRQ();
            this.cyclesToDo += 19;
            return;
        }
    }
}

