/*
 * EMU][ Apple ][-class emulator
 * Copyright (C) 2002- 2004 by the EMU][ Project/Dapple ][ Team
 *
 * $Header: /winc/emuiil/source/general.c,v 1.5 2003/08/30 10:22:29 dosius Exp $
 *
 * Component:  General: supporting methods and definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Log: general.c,v $
 * Revision ???
 * Z80 core development
 *
 */


/*----------------------------------------


	general supporting functions


	see general.h for include file


----------------------------------------*/


#ifndef DEF_INC_GENERAL_C
#define DEF_INC_GENERAL_C

#define DEF_DAPPLE
#define DEF_ASMLIB

#include <stdio.h>
#include <stdlib.h>
// also for memset...
#include <strings.h>
#ifdef DEF_ASMLIB
#include "asmlib.h"
#endif
#include "general.h"


#ifdef DEF_DAPPLE
extern	unsigned int	logwindow;
extern	unsigned int	cpuregswindow;
#endif



/*----------------------------------------

	string handling

	int strright (char *tgt, char *src)

----------------------------------------*/


/*----------------------------------------

 int	strright	(char *tgt, char *src)

	compare string at the right end

----------------------------------------*/


      int strright (char *tgt, char *src) {
	register int x;

	x = strlen(src);
	return !stringcomparec(&(tgt[strlen(tgt)-x]), src);
      } // strright






/*----------------------------------------

 error	card8tohex	(card8 value, unsigned char *pstringptr[])

	convert card8 to hexstring

----------------------------------------*/


      unsigned char *card8tohex(card8 value, unsigned char *pstringptr[]) {
	register card8 val8;
	register unsigned char *stringptr;

	stringptr = *pstringptr;
	val8 = (value >> 4) | '0';
	if (val8 > '9') {
	  val8 = val8 + ('A' - '9' - 1);
	}
	*stringptr++ = val8;
	val8 = (value & 0xf) | '0';
	if (val8 > '9') {
	  val8 = val8 + ('A' - '9' - 1);
	}
	*stringptr++ = val8;
	*stringptr   = '\0';

	*pstringptr = stringptr;
	return NULL;

      } // card8tohex






/*----------------------------------------

	error handling

	unsigned char	*taskopen	(void)
	unsigned char	*taskclose	(void)
	void		taskswitch	(void)
	unsigned char	*taskgeterror	(void)
	unsigned char	*taskseterror	(unsigned char *stringptr)
	unsigned char	*taskclearerror	(void)
	unsigned char	*tasklogerror	(unsigned int mode, unsigned char *stringptr)
 	void		tasklogsetchannel(unsigned int channel)
	void		tasklogsetmode	(unsigned int mode)
 	void		tasklogreturn	(unsigned int logmode)
	void		tasklogstring	(unsigned int logmode, unsigned char *stringptr)
	void		tasklogint32	(unsigned int logmode, int32 value)
	void		taskloghex32	(unsigned int logmode, int32 value)

----------------------------------------*/

unsigned char	*tasklasterror;
#ifdef DEF_INC_ASMLIB_H
unsigned int	tasklogchannel;
#endif
FILE		*tasklogfile;
unsigned char	tasklogmode;
unsigned char	tasklogpause;


/*----------------------------------------

 error	taskopen	(void)

	initialize logs etc

----------------------------------------*/

      unsigned char *taskopen(void) {

	tasklasterror	= NULL;
#ifdef DEF_INC_ASMLIB_H
	tasklogchannel	= 0;
#endif
	tasklogfile	= NULL;
	tasklogmode	= LOG_VERBOSE;
	tasklogpause	= 0;

//	tasklogfile = fopen("log.txt", "wb");

	return NULL;

      } // taskopen


/*----------------------------------------

 error	taskclose	(void)

	close logs

----------------------------------------*/

      unsigned char *taskclose(void) {

	tasklasterror	= NULL;
#ifdef DEF_INC_ASMLIB_H
//	tasklogchannel	= NULL;
#endif
	if (tasklogfile != NULL) {
	  fclose(tasklogfile);
	  tasklogfile	= NULL;
	}

	return NULL;

      } // taskclose


/*--------------------------------------

 void	taskswitch	(void)

	switch between several tasks

	You can add handling of the
	OS message pumps here.

---------------------------------------*/


      void taskswitch (void) {


#ifdef DEF_ASMLIB
#ifdef DEF_DAPPLE

// test for close buttons
	if (logwindow) {
	  if (windowgetclose(logwindow)) {
	    windowsetvisibility(logwindow, 0);
	    screenupdate = 1;
	  }
	}
	if (cpuregswindow) {
	  if (windowgetclose(cpuregswindow)) {
	    windowsetvisibility(cpuregswindow, 0);
	    screenupdate = 1;
	  }
	}
#endif

	asmtaskswitch();
#endif

      } // taskswitch


/*----------------------------------------

 error	taskgeterror	(void)

	get error message

----------------------------------------*/

      unsigned char *taskgeterror(void) {

	return tasklasterror;

      } // taskgeterror


/*----------------------------------------

 error	taskseterror	(unsigned char *stringptr)

	store error message for later

----------------------------------------*/

	unsigned char *taskseterror(unsigned char *stringptr) {

#ifdef DEF_INC_ASMLIB_H
	  asmseterror(stringptr);
#endif
	  tasklasterror = stringptr;

// write error to log for debugging purposes
// outcomment this if you like for the final build
	  tasklogstring(LOG_VERBOSE, stringptr);
	  tasklogreturn(LOG_VERBOSE);

	  return stringptr;

	} // taskseterror


/*----------------------------------------

 error	taskclearerror	(void)

	clear error message

----------------------------------------*/

      unsigned char *taskclearerror(void) {

#ifdef DEF_INC_ASMLIB_H
	asmseterror(NULL);
#endif
	tasklasterror = NULL;

	return NULL;

      } // taskclearerror


/*--------------------------------------

 void	tasklogsetchannel	(unsigned int channel)

	set tasklog channel

---------------------------------------*/

#ifdef DEF_INC_ASMLIB_H
      void tasklogsetchannel(unsigned int channel) {

	tasklogchannel = channel;

      } // tasklogsetchannel
#endif


/*--------------------------------------

 void	tasklogsetmode	(unsigned int mode)

	set tasklog mode

---------------------------------------*/

      void tasklogsetmode(unsigned int mode) {

	if (mode <= LOG_BRIEF) {
	  tasklogmode = mode;
	}

      } // tasklogsetmode


/*--------------------------------------

 void	tasklogreturn	(unsigned int mode)

	write OS specific <return> to log

---------------------------------------*/

      void tasklogreturn(unsigned int mode) {
	static unsigned char returnstring[2] = { 0x0a, 0x0d };

	if (!tasklogpause) {
	  if (mode <= tasklogmode) {
#ifdef DEF_INC_ASMLIB_H
	    if (tasklogchannel != 0) {
	      channelout(tasklogchannel, 0x0d);
	      screenupdate = 1;
	    }
#endif

	    if (tasklogfile != NULL) {
// change this to support your OS
	      fwrite(&returnstring[0], sizeof(unsigned char)*2, 1, tasklogfile);	// Windows
//	      fwrite(&returnstring[0], sizeof(unsigned char)*1, 1, tasklogfile);	// Unix
	    }
	  }
	}

      } // tasklogreturn


/*--------------------------------------

 void	tasklogstring	(unsigned int mode, unsigned char *stringptr)

	write a string to log

---------------------------------------*/

      void tasklogstring(unsigned int mode, unsigned char *stringptr) {

	if (!tasklogpause) {
	  if (mode <= tasklogmode) {
#ifdef DEF_INC_ASMLIB_H
	    if (tasklogchannel != 0) {
	      stringwrite(tasklogchannel, stringptr);
	      screenupdate = 1;
	    }
#endif
	    if (tasklogfile != NULL) {
	      for ( ; *stringptr; stringptr++) {
	        fwrite(stringptr, sizeof(unsigned char), 1, tasklogfile);
	      } // for
	    }
	  }
	}

      } // tasklogstring


/*--------------------------------------

 void	tasklogmessage	(unsigned int mode, unsigned char *stringptr)

	write a string to log

---------------------------------------*/

      void tasklogmessage(unsigned int mode, unsigned char *stringptr) {
	unsigned char message[256];

	if (!tasklogpause) {
	  if (mode <= tasklogmode) {
	    stringcopymessage(&message[0], stringptr, 255);
#ifdef DEF_INC_ASMLIB_H
	    if (tasklogchannel != 0) {
	      stringwrite(tasklogchannel, &message[0]);
	      screenupdate = 1;
	    }
#endif
	    if (tasklogfile != NULL) {
	      stringptr = &message[0];
	      for ( ; *stringptr; stringptr++) {
	        fwrite(stringptr, sizeof(unsigned char), 1, tasklogfile);
	      } // for
	    }
	  }
	}

      } // tasklogmessage


/*--------------------------------------

 void	tasklogint32	(unsigned int mode, int32 value)

	write int32 to log

---------------------------------------*/

      void tasklogint32(unsigned int mode, int32 value) {
	unsigned char tempstr[32];

	sprintf(tempstr, "%i", value);
	tasklogstring(mode, tempstr);

      } // tasklogint32


/*--------------------------------------

 void	taskloghex32	(unsigned int mode, int32 value)

	write int32 as hexdigits to log

---------------------------------------*/

      void taskloghex32(unsigned int mode, int32 value) {
	unsigned char tempstr[32];

	sprintf(tempstr, "$%x", value);
	tasklogstring(mode, tempstr);

      } // taskloghex32


/*--------------------------------------

 error	tasklogerror	(unsigned int mode, unsigned char *stringptr)

	write an error message to log

---------------------------------------*/

      unsigned char *tasklogerror(unsigned int mode, unsigned char *stringptr) {

	taskseterror(stringptr);
	tasklogmessage(mode, stringptr);

	return stringptr;

      } // tasklogerror






/*----------------------------------------


	file handling

	unsigned char *fileload(unsigned char *filename, unsigned int numbbytes, unsigned int *bytesread, void *memoryptr)
	unsigned char *filesave(unsigned char *filename, unsigned int numbbytes, unsigned int  *byteswritten, void *memoryptr)
	unsigned char *fileresident(unsigned char *filename, void *fileptr[], unsigned int *size)
	unsigned char *fileloadtext(unsigned char *filepath, unsigned char *textptr[], unsigned int *size)


	Note: 'fileload' and 'filesave' are
	also called by the assembly library!


----------------------------------------*/


/*----------------------------------------

 error	fileload	(unsigned char *filename, unsigned int numbbytes)
			(unsigned int  *bytesread, void *memoryptr)


	load a file with a specified number of bytes

----------------------------------------*/


      unsigned char *fileload(unsigned char *filename, unsigned int numbbytes,
			      unsigned int  *bytesread, void *memoryptr) {
	FILE *file;

	file = fopen(filename,"rb");
	if (file == NULL) {
	  *bytesread = 0;
	  return taskseterror(
"!\
:F;\
GDatei konnte nicht geffnet werden;\r\
EFile could not be opened;\r\
;");

	}
	*bytesread = fread(memoryptr, 1, numbbytes, file);	// read data
	fclose(file);
	return NULL;

      } // fileload


/*----------------------------------------

 error	filesave	(unsigned char *filename, unsigned int numbbytes
 			 unsigned int  *byteswritten, void *memoryptr)

	save a file

----------------------------------------*/


      unsigned char *filesave(unsigned char *filename, unsigned int numbbytes,
			      unsigned int  *byteswritten, void *memoryptr) {
	FILE *file;

	file = fopen(filename,"wb");
	if (file == NULL) {
	  *byteswritten = 0;
	  return taskseterror(
"!\
:F;\
GDatei konnte nicht geffnet werden;\r\
EFile could not be opened;\r\
;");

	}
	*byteswritten = fwrite(memoryptr, 1, numbbytes, file);	// read data
	fclose(file);
	return NULL;

      } // filesave


/*----------------------------------------

 error	fileresident	(unsigned char *filename,
 			 void *fileptr[], unsigned int *size)

	allocate memory depending on file size and load file.

  --------------------------------------*/


      unsigned char *fileresident(unsigned char *filename, void *fileptr[], unsigned int *size) {
	FILE *file;
	register int  filelength;
	register void *tempptr;

	file = fopen(filename,"rb");
	if (file == NULL) {
	  *size	     = 0;
	  fileptr[0] = NULL;
	  return taskseterror(
"!\
GDatei nicht gefunden;\
EFile not found;\
;");
	}
	fseek(file,0,SEEK_END);
	filelength=ftell(file);
	fseek(file,0,SEEK_SET);

	tempptr = malloc(filelength + 1);	// + 1 for \0

	if (tempptr == NULL) {			// not enough memory
	  fclose(file);
	  *size	     = 0;
	  fileptr[0] = NULL;
	  return taskseterror(
"!\
GNicht gengend Speicher vorhanden, um eine Datei zu laden;\
ENot enough memory to load a file;\
;");
	}
	memset(tempptr, 0x00, filelength + 1);	// clear data
	if (fread(tempptr, 1, filelength, file) != filelength) {
	  fclose(file);
	  free(tempptr);
	  *size	     = 0;
	  fileptr[0] = NULL;
	  return taskseterror(
"!\
GFehler beim Lesen einer Datei;\
EError while reading a file;\
;");
	}
	fclose(file);
	*size	   = filelength;
	fileptr[0] = tempptr;
	return NULL;

      } // fileresident



/*----------------------------------------

 error	fileloadtext	(unsigned char *filepath, unsigned char replace,
			 unsigned char *textptr[], unsigned int *size)

	allocate memory depending on file size, load text, then
	replace end of line with character replace.

  --------------------------------------*/


      unsigned char *fileloadtext(unsigned char *filepath, unsigned char replace, unsigned char *textptr[], unsigned int *size) {
	register unsigned char *sourceptr;
	register unsigned char *destptr;
	register unsigned char *error;

	error = fileresident(filepath, (void **)&textptr[0], size);
	if (error) {
	  return error;
	}
	sourceptr = *textptr;
	destptr   = *textptr;
	while (*sourceptr != '\0') {
	  if (*sourceptr == 0x0d) {
	    *destptr = replace;
	    destptr++;
	    sourceptr++;
	    if (*sourceptr == 0x0a) {
	      sourceptr++;
	    }
	  }
	  else {
	    if (*sourceptr == 0x0a) {
	      *destptr = replace;
	      destptr++;
	      sourceptr++;
	      if (*sourceptr == 0x0d) {
	        sourceptr++;
	      }
	    }
	    else {
	      *destptr = *sourceptr;
	      destptr++;
	      sourceptr++;
	    }
	  }
	}
	*destptr = '\0';
	return NULL;		// no error

      } // fileloadtext






/*----------------------------------------


	bmp24 handling

	unsigned char *bmp24_check	(card8 *bmpptr);
	unsigned char *bmp24_getsize	(card8 *bmpptr, unsigned int *xsize, unsigned int *ysize)
asmlib	unsigned char *bmp24_draw	(card8 *bmpptr, unsigned int image, int xcoo, int ycoo)


----------------------------------------*/


/*----------------------------------------

 error	bmp24_check	(card8 *bmpptr)


	check for BMP file

----------------------------------------*/


      unsigned char *bmp24_check(card8 *bmpptr) {

	if (bmpptr == NULL) {
	  return taskseterror(
"!\
:F;\n\
ENo BMP picture present;\n\
GKein BMP-Bild vorhanden;\n\
;");
	}

	if ((*bmpptr == 'B') && (*(bmpptr+1) == 'M')) {
	  return NULL;
	}
	return taskseterror(
"!\
:F;\n\
EBMP format not found;\n\
GBMP-Format nicht gefunden;\n\
;");

      } // bmp24_check


/*----------------------------------------

 error	bmp24_getsize	(card8 *bmpptr,
 			 unsigned int *xsize, unsigned int *ysize)


	get size of bmp

----------------------------------------*/


      unsigned char *bmp24_getsize(card8 *bmpptr, unsigned int *xsize, unsigned int *ysize) {
	register unsigned char *error;

	error = bmp24_check(bmpptr);
	if (error) {
	  *xsize = 0;
	  *ysize = 0;
	  return error;
	}
	*xsize = (*(bmpptr + 18)) | (*(bmpptr + 19) << 8);
	*ysize = (*(bmpptr + 22)) | (*(bmpptr + 23) << 8);
	return NULL;

      } // bmp24_getsize


/*----------------------------------------

 error	bmp24_draw	(card8 *bmpptr, unsigned int image, int xcoo, int ycoo)


	check for BMP file

----------------------------------------*/

#ifdef DEF_INC_ASMLIB_H
      unsigned char *bmp24_draw(card8 *bmpptr, unsigned int image, int xcoo, int ycoo) {
	register unsigned char	*error;
	register unsigned int	xsize;
	register unsigned int	ysize;
	register int		dxcoo;
	register int		dycoo;
	register unsigned int	i;
	register unsigned int	colour;

	error = bmp24_check(bmpptr);
	if (error) {
	  return error;
	}

	xsize = (*(bmpptr + 18)) | (*(bmpptr + 19) << 8);
	ysize = (*(bmpptr + 22)) | (*(bmpptr + 23) << 8);
	dycoo = ycoo;

	bmpptr = bmpptr + ((*(bmpptr + 10)) | (*(bmpptr + 11) << 8) | (*(bmpptr + 12) << 16) | (*(bmpptr + 13) << 24));

	for (; ysize != 0; ysize--) {
	  dxcoo = xcoo;
	  for (i = xsize; i != 0; i--) {
	    colour = *bmpptr++;
	    colour = colour | (*bmpptr << 8);
	    bmpptr++;
	    colour = colour | (*bmpptr << 16);
	    bmpptr++;
	    imageplot(image, dxcoo, dycoo, colour);
	    dxcoo++;
	  } // for i
	  if (xsize & 1) {
	    bmpptr = bmpptr + 3;
	  }
	  dycoo--;

	} // for ysize

	return NULL;
      } // bmp24_draw
// --> #ifdef DEF_INC_ASMLIB_H
#endif


// --> #ifndef DEF_INC_GENERAL_C
#endif
