/*----------------------------------------


	class	cpu6502


	see cpu6502.c for implementation


	(c) by Holger Picker 2004


----------------------------------------*/


#ifndef DEF_INC_CPU6502_H
#define DEF_INC_CPU6502_H


// **** include general libraries concerning definitions

#include "..\libs\general.h"
#include "..\libs\raf.h"
#include "..\libs\asmlib.h"


// **** public constants

#define	CPU_6502	1
#define	CPU_65C02	2
#define	CPU_65SC02	4

#define	CPU_STATEHALT	0x0001
#define CPU_STATERESET	0x0002
#define	CPU_STATEGURU	0x0004
#define CPU_STATEBPT	0x0008
#define CPU_STATEBRK	0x0010
#define CPU_STATETRACE	0x0020
#define CPU_STATECOP	0x0040
#define	CPU_STATEIRQ1	0x0100
#define	CPU_STATEIRQ2	0x0200
#define CPU_STATENMI1	0x1000
#define CPU_STATENMI2	0x2000


// **** public type definitions

void blabla(void);

typedef struct {
	raf		*rafptr;
	card8		areg;
	card8		xreg;
	card8		yreg;
	card8		spreg;
	card32		pcreg;
	card8		nflag;
	card8		vflag;
	card8		bflag;
	card8		dflag;
	card8		iflag;
	card8		zflag;
	card8		cflag;
	card32		cycle;
	card32		step;
	card8		opcode;
	card32		addr;
	card8		data;
	card32		cputype;
	card32		stateflags;
	card32		breakpoint;
} cpu6502;


// **** public functions

unsigned char	*cpu6502init		(cpu6502 *cpuptr, raf *rafptr);
unsigned char	*cpu6502reset		(cpu6502 *cpuptr);
unsigned char	*cpu6502step		(cpu6502 *cpuptr);
unsigned int	cpu6502getstate		(cpu6502 *cpuptr);
void		cpu6502setstate		(cpu6502 *cpuptr, card32 value);
void		cpu6502clearstate	(cpu6502 *cpuptr, card32 value);


// --> ifndef DEF_INC_CPU6502_H
#endif
